/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.operation;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.dtyunxi.cis.pms.biz.export.ExportExcelHelper;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import java.io.InputStream;
import javax.annotation.Resource;

public abstract class AbstractFileOperationCommonService {
    @Resource
    public ExportExcelHelper exportExcelHelper;

    public ExcelImportResult<ImportBaseModeDto> parseExcelDataResult(ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        EasyPoiExportUtil.checkFileInfo(commonReqDto.getUrl());
        InputStream inputStream = ExcelUtils.getInputStream(commonReqDto.getUrl());
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        Class<? extends ImportBaseModeDto> importTemplate = anEnum.getImportTemplate();
        if (anEnum.getImportTemplate() == null) {
            importTemplate = EasyPoiExportUtil.getClassTemplate(anEnum.getKey());
        }
        Integer headRow = anEnum.getHeadRows() > 0 ? anEnum.getHeadRows() - 1 : anEnum.getHeadRows();
        EasyPoiExportUtil.checkExcelHeader(inputStream, importTemplate, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = EasyPoiExportUtil.handlerExcelDataResult(anEnum.getImportTemplate(), commonReqDto.getUrl(), anEnum.getHeadRows());
        if (result.isVerfiyFail()) {
            int index = anEnum.getHeadRows() > 0 ? 1 : 0;
            result.getFailList().forEach(l -> respDto.getErrorMsgs().add(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + index, l.getErrorMsg())));
        }
        return result;
    }

    public abstract Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> var1, ImportFileOperationCommonReqDto var2, ImportFileOperationCommonRespDto var3);

    public abstract String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> var1, ImportFileOperationCommonReqDto var2, ImportFileOperationCommonRespDto var3, Object var4);

    public abstract String exportFileOperationCommon(ExportFileOperationCommonReqDto var1);

    public abstract Integer exportTotal(ExportFileOperationCommonReqDto var1);
}

