/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ChannelChangeFlowVO;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetChannelChangeFlowListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetInTransitChangeFlowListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetLogicalChangeFlowListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetPhysicalChangeFlowPageParams;
import com.dtyunxi.cis.pms.biz.model.GetVirtualChangeFlowPageParams;
import com.dtyunxi.cis.pms.biz.model.LogicalChangeFlowVO;
import com.dtyunxi.cis.pms.biz.model.OutPhysicalChangeFlowVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalChangeFlowVO;
import com.dtyunxi.cis.pms.biz.model.VirtualChangeFlowVO;
import com.dtyunxi.cis.pms.biz.model.inTransitChangeFlowVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterFlowService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.response.EsInventoryOperateLogVO;
import com.dtyunxi.cis.search.api.query.inventory.EsInventoryChannelOperateLogQueryApi;
import com.dtyunxi.cis.search.api.query.inventory.EsInventoryOperateLogQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.EsInventoryOperateLogListPageParams;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.share.IDgInventoryShareOperateLogApi;
import com.yunxi.dg.base.center.report.dto.share.DgInventoryShareOperateLogPageReqDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_physical_flow")
public class InventoryCenterFlowServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements InventoryCenterFlowService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterFlowServiceServiceImpl.class);
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private EsInventoryChannelOperateLogQueryApi esInventoryChannelOperateLogQueryApi;
    @Resource
    private EsInventoryOperateLogQueryApi esInventoryOperateLogQueryApi;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;
    @Autowired
    IDgInventoryShareOperateLogApi dgInventoryShareOperateLogApi;

    @Override
    public RestResponse<PageInfo<ChannelChangeFlowVO>> getChannelFlowListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetChannelChangeFlowListPageParams getChannelChangeFlowListPageParams) {
        DgInventoryShareOperateLogPageReqDto pageReqDto = new DgInventoryShareOperateLogPageReqDto();
        pageReqDto.setSkuCode(getChannelChangeFlowListPageParams.getGoodsLongCode());
        pageReqDto.setSourceNo(getChannelChangeFlowListPageParams.getBusinessOrderNo());
        pageReqDto.setWarehouseCode(getChannelChangeFlowListPageParams.getChannelWarehouseCode());
        pageReqDto.setWarehouseName(getChannelChangeFlowListPageParams.getChannelWarehouseName());
        pageReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.CHANNEL.getCode());
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getInventoryType())) {
            pageReqDto.setChangeType(getChannelChangeFlowListPageParams.getInventoryType());
        }
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getStartTime())) {
            pageReqDto.setGtChangeTime(DateUtil.parse((String)getChannelChangeFlowListPageParams.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getEndTime())) {
            pageReqDto.setLtChangeTime(DateUtil.parse((String)getChannelChangeFlowListPageParams.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        pageReqDto.setSkuName(getChannelChangeFlowListPageParams.getGoodsName());
        pageReqDto.setExternalOrderNo(getChannelChangeFlowListPageParams.getExternalOrderNo());
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getBusinessType())) {
            pageReqDto.setBusinessType(getChannelChangeFlowListPageParams.getBusinessType());
        }
        pageReqDto.setPageNum(getChannelChangeFlowListPageParams.getPageNum());
        pageReqDto.setPageSize(getChannelChangeFlowListPageParams.getPageSize());
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgInventoryShareOperateLogApi.page(pageReqDto));
        if (dtoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list"});
        List list = dtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList channelChangeFlowVOS = new ArrayList(list.size());
        list.forEach(p -> {
            ChannelChangeFlowVO channelChangeFlowVO = DtoExchangeUtils.createDtoBySource(p, ChannelChangeFlowVO.class);
            channelChangeFlowVO.setGoodsLongCode(p.getSkuCode());
            channelChangeFlowVO.setGoodsName(p.getSkuName());
            channelChangeFlowVO.setChannelWarehouseCode(p.getWarehouseCode());
            channelChangeFlowVO.setChannelWarehouseName(p.getWarehouseName());
            channelChangeFlowVO.setBusinessType(p.getSourceType());
            channelChangeFlowVO.setInventoryType(p.getChangeType());
            channelChangeFlowVO.setChangeQuantity(p.getChangeInventory());
            channelChangeFlowVO.setBeforeChangeInventory(p.getBeforeInventory());
            channelChangeFlowVO.setAfterChangeIInventory(p.getAfterInventory());
            channelChangeFlowVO.setBusinessOrderNo(p.getSourceNo());
            channelChangeFlowVO.setChangTime(DateUtil.format((Date)p.getChangeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            channelChangeFlowVO.setExternalOrderNo(p.getExternalOrderNo());
            channelChangeFlowVO.setRemark(p.getRemark());
            channelChangeFlowVOS.add(channelChangeFlowVO);
        });
        pageInfo.setList(channelChangeFlowVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<LogicalChangeFlowVO>> getLogicalFlowListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicalChangeFlowListPageParams getLogicalChangeFlowListPageParams) {
        com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams pageQueryDto = DtoExchangeUtils.createDtoBySource(getLogicalChangeFlowListPageParams, com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams.class);
        pageQueryDto.setItemLongCode(getLogicalChangeFlowListPageParams.getGoodsLongCode());
        pageQueryDto.setItemName(getLogicalChangeFlowListPageParams.getGoodsName());
        pageQueryDto.setSourceNo(getLogicalChangeFlowListPageParams.getBusinessOrderNo());
        pageQueryDto.setWarehouseCode(getLogicalChangeFlowListPageParams.getLogicalWarehouseCode());
        pageQueryDto.setWarehouseName(getLogicalChangeFlowListPageParams.getLogicalWarehouseName());
        pageQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        pageQueryDto.setBatch(getLogicalChangeFlowListPageParams.getBatchNo());
        pageQueryDto.setItemName(getLogicalChangeFlowListPageParams.getGoodsName());
        pageQueryDto.setExternalOrderNo(getLogicalChangeFlowListPageParams.getExternalOrderNo());
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getBusinessType())) {
            pageQueryDto.setBusinessType(getLogicalChangeFlowListPageParams.getBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getInventoryType())) {
            pageQueryDto.setChangeType(getLogicalChangeFlowListPageParams.getInventoryType());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getStartTime())) {
            pageQueryDto.setChangeBeginTime(getLogicalChangeFlowListPageParams.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getEndTime())) {
            pageQueryDto.setChangeEndTime(getLogicalChangeFlowListPageParams.getEndTime());
        }
        if (CollectionUtils.isNotEmpty(getLogicalChangeFlowListPageParams.getInventoryTypeList())) {
            pageQueryDto.setChangeTypeList(getLogicalChangeFlowListPageParams.getInventoryTypeList());
        }
        PageInfo inventoryOperateLogRespDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            logger.info("es\u67e5\u8be2");
            inventoryOperateLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esInventoryChannelOperateLogQueryApi.queryInventoryOperateLogListPage(pageQueryDto));
        } else {
            inventoryOperateLogRespDtoPageInfo = this.reportQuesy(pageQueryDto);
        }
        if (inventoryOperateLogRespDtoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryOperateLogRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = inventoryOperateLogRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList logicalChangeFlowVOS = new ArrayList(list.size());
        list.forEach(p -> {
            LogicalChangeFlowVO logicalChangeFlowVO = DtoExchangeUtils.createDtoBySource(p, LogicalChangeFlowVO.class);
            logicalChangeFlowVO.setGoodsLongCode(p.getItemLongCode());
            logicalChangeFlowVO.setGoodsName(p.getItemName());
            logicalChangeFlowVO.setBatchNo(p.getBatch());
            logicalChangeFlowVO.setBusinessType(p.getSourceType());
            logicalChangeFlowVO.setLogicalWarehouseCode(p.getWarehouseCode());
            logicalChangeFlowVO.setLogicalWarehouseName(p.getWarehouseName());
            logicalChangeFlowVO.setInventoryType(p.getChangeType());
            logicalChangeFlowVO.setChangeQuantity(p.getChangeInventory());
            logicalChangeFlowVO.setBeforeChangeInventory(p.getBeforeInventory());
            logicalChangeFlowVO.setAfterChangeIInventory(p.getAfterInventory());
            logicalChangeFlowVO.setBusinessOrderNo(p.getSourceNo());
            logicalChangeFlowVO.setChangTime(DateUtil.format((Date)p.getChangeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            logicalChangeFlowVO.setExternalOrderNo(p.getExternalOrderNo());
            logicalChangeFlowVO.setRemark(p.getRemark());
            logicalChangeFlowVOS.add(logicalChangeFlowVO);
        });
        pageInfo.setList(logicalChangeFlowVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<inTransitChangeFlowVO>> getinTransitFlowListPage(GetInTransitChangeFlowListPageParams getLogicalChangeFlowListPageParams) {
        com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams pageQueryDto = DtoExchangeUtils.createDtoBySource(getLogicalChangeFlowListPageParams, com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams.class);
        pageQueryDto.setItemLongCode(getLogicalChangeFlowListPageParams.getGoodsLongCode());
        pageQueryDto.setItemName(getLogicalChangeFlowListPageParams.getGoodsName());
        pageQueryDto.setSourceNo(getLogicalChangeFlowListPageParams.getBusinessOrderNo());
        pageQueryDto.setWarehouseCode(getLogicalChangeFlowListPageParams.getLogicalWarehouseCode());
        pageQueryDto.setWarehouseName(getLogicalChangeFlowListPageParams.getLogicalWarehouseName());
        pageQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.IN_TRANSIT.getCode());
        pageQueryDto.setBatch(getLogicalChangeFlowListPageParams.getBatchNo());
        pageQueryDto.setItemName(getLogicalChangeFlowListPageParams.getGoodsName());
        pageQueryDto.setExternalOrderNo(getLogicalChangeFlowListPageParams.getExternalOrderNo());
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getBusinessType())) {
            pageQueryDto.setBusinessType(getLogicalChangeFlowListPageParams.getBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getInventoryType())) {
            pageQueryDto.setChangeType(getLogicalChangeFlowListPageParams.getInventoryType());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getStartTime())) {
            pageQueryDto.setChangeBeginTime(getLogicalChangeFlowListPageParams.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalChangeFlowListPageParams.getEndTime())) {
            pageQueryDto.setChangeEndTime(getLogicalChangeFlowListPageParams.getEndTime());
        }
        if (CollectionUtils.isNotEmpty(getLogicalChangeFlowListPageParams.getInventoryTypeList())) {
            pageQueryDto.setChangeTypeList(getLogicalChangeFlowListPageParams.getInventoryTypeList());
        }
        PageInfo inventoryOperateLogRespDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            logger.info("es\u67e5\u8be2");
            inventoryOperateLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esInventoryChannelOperateLogQueryApi.queryInventoryOperateLogListPage(pageQueryDto));
        } else {
            inventoryOperateLogRespDtoPageInfo = this.reportQuesy(pageQueryDto);
        }
        if (inventoryOperateLogRespDtoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryOperateLogRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = inventoryOperateLogRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList logicalChangeFlowVOS = new ArrayList(list.size());
        list.forEach(p -> {
            inTransitChangeFlowVO logicalChangeFlowVO = DtoExchangeUtils.createDtoBySource(p, inTransitChangeFlowVO.class);
            logicalChangeFlowVO.setGoodsLongCode(p.getItemLongCode());
            logicalChangeFlowVO.setGoodsName(p.getItemName());
            logicalChangeFlowVO.setBatchNo(p.getBatch());
            logicalChangeFlowVO.setBusinessType(p.getSourceType());
            logicalChangeFlowVO.setLogicalWarehouseCode(p.getWarehouseCode());
            logicalChangeFlowVO.setLogicalWarehouseName(p.getWarehouseName());
            logicalChangeFlowVO.setInventoryType(p.getChangeType());
            logicalChangeFlowVO.setChangeQuantity(p.getChangeInventory());
            logicalChangeFlowVO.setBeforeChangeInventory(p.getBeforeInventory());
            logicalChangeFlowVO.setAfterChangeIInventory(p.getAfterInventory());
            logicalChangeFlowVO.setBusinessOrderNo(p.getSourceNo());
            logicalChangeFlowVO.setChangTime(DateUtil.format((Date)p.getChangeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            logicalChangeFlowVO.setExternalOrderNo(p.getExternalOrderNo());
            logicalChangeFlowVO.setRemark(p.getRemark());
            logicalChangeFlowVOS.add(logicalChangeFlowVO);
        });
        pageInfo.setList(logicalChangeFlowVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<PhysicalChangeFlowVO>> getPhysicalFlowListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetPhysicalChangeFlowPageParams getPhysicalChangeFlowPageParams) {
        PageInfo inventoryOperateLogRespDtoPageInfo;
        com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams pageQueryDto = DtoExchangeUtils.createDtoBySource(getPhysicalChangeFlowPageParams, com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams.class);
        pageQueryDto.setItemLongCode(getPhysicalChangeFlowPageParams.getGoodsLongCode());
        pageQueryDto.setSourceNo(getPhysicalChangeFlowPageParams.getBusinessOrderNo());
        pageQueryDto.setWarehouseCode(getPhysicalChangeFlowPageParams.getPhysicalWarehouseCode());
        pageQueryDto.setWarehouseName(getPhysicalChangeFlowPageParams.getPhysicalWarehouseName());
        pageQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        pageQueryDto.setBatch(getPhysicalChangeFlowPageParams.getBatchNo());
        pageQueryDto.setItemName(getPhysicalChangeFlowPageParams.getGoodsName());
        pageQueryDto.setExternalOrderNo(getPhysicalChangeFlowPageParams.getExternalOrderNo());
        if (StringUtils.isNotBlank((CharSequence)getPhysicalChangeFlowPageParams.getInventoryType())) {
            pageQueryDto.setChangeType(getPhysicalChangeFlowPageParams.getInventoryType());
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalChangeFlowPageParams.getBusinessType())) {
            pageQueryDto.setBusinessType(getPhysicalChangeFlowPageParams.getBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalChangeFlowPageParams.getStartTime())) {
            pageQueryDto.setChangeBeginTime(getPhysicalChangeFlowPageParams.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalChangeFlowPageParams.getEndTime())) {
            pageQueryDto.setChangeEndTime(getPhysicalChangeFlowPageParams.getEndTime());
        }
        if (this.esQuery.booleanValue()) {
            logger.info("es\u67e5\u8be2");
            inventoryOperateLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esInventoryChannelOperateLogQueryApi.queryInventoryOperateLogListPage(pageQueryDto));
        } else {
            inventoryOperateLogRespDtoPageInfo = this.reportQuesy(pageQueryDto);
        }
        if (inventoryOperateLogRespDtoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryOperateLogRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = inventoryOperateLogRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList physicalChangeFlowVOS = new ArrayList(list.size());
        list.forEach(p -> {
            PhysicalChangeFlowVO physicalChangeFlowVO = DtoExchangeUtils.createDtoBySource(p, PhysicalChangeFlowVO.class);
            physicalChangeFlowVO.setGoodsLongCode(p.getItemLongCode());
            physicalChangeFlowVO.setGoodsName(p.getItemName());
            physicalChangeFlowVO.setBatchNo(p.getBatch());
            physicalChangeFlowVO.setPhysicalWarehouseCode(p.getWarehouseCode());
            physicalChangeFlowVO.setPhysicalWarehouseName(p.getWarehouseName());
            physicalChangeFlowVO.setBusinessType(p.getBusinessType());
            physicalChangeFlowVO.setInventoryType(p.getChangeType());
            physicalChangeFlowVO.setChangeQuantity(p.getChangeInventory());
            physicalChangeFlowVO.setBeforeChangeInventory(p.getBeforeInventory());
            physicalChangeFlowVO.setAfterChangeIInventory(p.getAfterInventory());
            physicalChangeFlowVO.setBusinessOrderNo(p.getSourceNo());
            physicalChangeFlowVO.setExternalOrderNo(p.getExternalOrderNo());
            physicalChangeFlowVO.setChangTime(DateUtil.format((Date)p.getChangeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            physicalChangeFlowVOS.add(physicalChangeFlowVO);
        });
        pageInfo.setList(physicalChangeFlowVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetPhysicalChangeFlowPageParams params = new GetPhysicalChangeFlowPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetPhysicalChangeFlowPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetPhysicalChangeFlowPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getPhysicalFlowListPage((GetPhysicalChangeFlowPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutPhysicalChangeFlowVO vo = new OutPhysicalChangeFlowVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setInventoryType(Optional.ofNullable(o.getInventoryType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    switch (Type2) {
                        case "available": {
                            return "\u53ef\u7528\u5e93\u5b58";
                        }
                        case "balance": {
                            return "\u5373\u65f6\u5e93\u5b58";
                        }
                        case "preempt": {
                            return "\u9884\u5360\u5e93\u5b58";
                        }
                        case "moveInventory": {
                            return "\u5728\u9014\u5e93\u5b58";
                        }
                        case "received": {
                            return "\u5f85\u6536\u5e93\u5b58";
                        }
                    }
                    return o.getInventoryType();
                }).orElse(""));
                vo.setChangeQuantity(Optional.ofNullable(o.getChangeQuantity()).orElse(BigDecimal.ZERO).intValue());
                vo.setAfterChangeIInventory(Optional.ofNullable(o.getAfterChangeIInventory()).orElse(BigDecimal.ZERO).intValue());
                vo.setBeforeChangeInventory(Optional.ofNullable(o.getBeforeChangeInventory()).orElse(BigDecimal.ZERO).intValue());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutPhysicalChangeFlowVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    @Override
    public RestResponse<PageInfo<VirtualChangeFlowVO>> getVirtualFlowListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetVirtualChangeFlowPageParams getVirtualChangeFlowPageParams) {
        com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams pageQueryDto = DtoExchangeUtils.createDtoBySource(getVirtualChangeFlowPageParams, com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams.class);
        this.getVirtualParams(getVirtualChangeFlowPageParams, pageQueryDto);
        PageInfo inventoryOperateLogRespDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            logger.info("es\u67e5\u8be2");
            inventoryOperateLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esInventoryChannelOperateLogQueryApi.queryInventoryOperateLogListPage(pageQueryDto));
        } else {
            inventoryOperateLogRespDtoPageInfo = this.reportQuesy(pageQueryDto);
        }
        if (inventoryOperateLogRespDtoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryOperateLogRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = inventoryOperateLogRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList virtualChangeFlowVOS = new ArrayList(list.size());
        list.forEach(p -> {
            VirtualChangeFlowVO virtualChangeFlowVO = DtoExchangeUtils.createDtoBySource(p, VirtualChangeFlowVO.class);
            virtualChangeFlowVO.setGoodsLongCode(p.getItemLongCode());
            virtualChangeFlowVO.setGoodsName(p.getItemName());
            virtualChangeFlowVO.setBatchNo(p.getBatch());
            virtualChangeFlowVO.setVirtualWarehouseCode(p.getWarehouseCode());
            virtualChangeFlowVO.setVirtualWarehouseName(p.getWarehouseName());
            virtualChangeFlowVO.setBusinessType(p.getSourceType());
            virtualChangeFlowVO.setInventoryType(p.getChangeType());
            virtualChangeFlowVO.setChangeQuantity(p.getChangeInventory());
            virtualChangeFlowVO.setBeforeChangeInventory(p.getBeforeInventory());
            virtualChangeFlowVO.setAfterChangeIInventory(p.getAfterInventory());
            virtualChangeFlowVO.setBusinessOrderNo(p.getSourceNo());
            virtualChangeFlowVO.setExternalOrderNo(p.getExternalOrderNo());
            virtualChangeFlowVO.setChangTime(DateUtil.format((Date)p.getChangeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            virtualChangeFlowVO.setRemark(p.getRemark());
            virtualChangeFlowVOS.add(virtualChangeFlowVO);
        });
        pageInfo.setList(virtualChangeFlowVOS);
        return new RestResponse((Object)pageInfo);
    }

    private void getChannelFlowParams(GetChannelChangeFlowListPageParams getChannelChangeFlowListPageParams, com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams pageQueryDto) {
        pageQueryDto.setItemLongCode(getChannelChangeFlowListPageParams.getGoodsLongCode());
        pageQueryDto.setSourceNo(getChannelChangeFlowListPageParams.getBusinessOrderNo());
        pageQueryDto.setWarehouseCode(getChannelChangeFlowListPageParams.getChannelWarehouseCode());
        pageQueryDto.setWarehouseName(getChannelChangeFlowListPageParams.getChannelWarehouseName());
        pageQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.CHANNEL.getCode());
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getInventoryType())) {
            pageQueryDto.setChangeType(getChannelChangeFlowListPageParams.getInventoryType());
        }
        pageQueryDto.setChangeTypeList(getChannelChangeFlowListPageParams.getInventoryTypeList());
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getStartTime())) {
            pageQueryDto.setChangeBeginTime(getChannelChangeFlowListPageParams.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getEndTime())) {
            pageQueryDto.setChangeEndTime(getChannelChangeFlowListPageParams.getEndTime());
        }
        pageQueryDto.setItemName(getChannelChangeFlowListPageParams.getGoodsName());
        pageQueryDto.setBatch(getChannelChangeFlowListPageParams.getBatchNo());
        pageQueryDto.setExternalOrderNo(getChannelChangeFlowListPageParams.getExternalOrderNo());
        if (StringUtils.isNotBlank((CharSequence)getChannelChangeFlowListPageParams.getBusinessType())) {
            pageQueryDto.setBusinessType(getChannelChangeFlowListPageParams.getBusinessType());
        }
    }

    private void getVirtualParams(GetVirtualChangeFlowPageParams getVirtualChangeFlowPageParams, com.dtyunxi.cis.search.api.dto.request.EsInventoryOperateLogListPageParams pageQueryDto) {
        pageQueryDto.setItemLongCode(getVirtualChangeFlowPageParams.getGoodsLongCode());
        pageQueryDto.setSourceNo(getVirtualChangeFlowPageParams.getBusinessOrderNo());
        pageQueryDto.setWarehouseCode(getVirtualChangeFlowPageParams.getVirtualWarehouseCode());
        pageQueryDto.setWarehouseName(getVirtualChangeFlowPageParams.getVirtualWarehouseName());
        pageQueryDto.setBatch(getVirtualChangeFlowPageParams.getBatchNo());
        pageQueryDto.setItemName(getVirtualChangeFlowPageParams.getGoodsName());
        pageQueryDto.setExternalOrderNo(getVirtualChangeFlowPageParams.getExternalOrderNo());
        if (StringUtils.isBlank((CharSequence)getVirtualChangeFlowPageParams.getWarehouseClassify())) {
            pageQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.VIRTUAL.getCode());
        } else {
            pageQueryDto.setWarehouseClassify(getVirtualChangeFlowPageParams.getWarehouseClassify());
        }
        if (StringUtils.isNotBlank((CharSequence)getVirtualChangeFlowPageParams.getInventoryType())) {
            pageQueryDto.setChangeType(getVirtualChangeFlowPageParams.getInventoryType());
        }
        if (StringUtils.isNotBlank((CharSequence)getVirtualChangeFlowPageParams.getBusinessType())) {
            pageQueryDto.setBusinessType(getVirtualChangeFlowPageParams.getBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)getVirtualChangeFlowPageParams.getStartTime())) {
            pageQueryDto.setChangeBeginTime(getVirtualChangeFlowPageParams.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)getVirtualChangeFlowPageParams.getEndTime())) {
            pageQueryDto.setChangeEndTime(getVirtualChangeFlowPageParams.getEndTime());
        }
    }

    private PageInfo<EsInventoryOperateLogVO> reportQuesy(Object pageQueryDto) {
        logger.info("\u62a5\u8868\u4e2d\u5fc3\u67e5\u8be2");
        EsInventoryOperateLogListPageParams params = new EsInventoryOperateLogListPageParams();
        BeanUtils.copyProperties((Object)pageQueryDto, (Object)params);
        PageInfo pageInfoRestResponse = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryEsReportQueryApi.queryInventoryOperateLogListPage(params));
        PageInfo inventoryOperateLogRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)inventoryOperateLogRespDtoPageInfo, (Object)pageInfoRestResponse, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList vos = new ArrayList();
        CubeBeanUtils.copyCollection(vos, (Collection)pageInfoRestResponse.getList(), EsInventoryOperateLogVO.class);
        inventoryOperateLogRespDtoPageInfo.setList(vos);
        return inventoryOperateLogRespDtoPageInfo;
    }
}

