/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetLogicalWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutInTransitWarehouseVo;
import com.dtyunxi.cis.pms.biz.service.ExportChannelFlowService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseLogicalWarehouseService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_in_transit_warehouse")
public class ExportInTransitWarehouseServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportChannelFlowService {
    @Resource
    private InventoryCenterBaseWarehouseLogicalWarehouseService service;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetLogicalWarehouseListPageParams params = new GetLogicalWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetLogicalWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetLogicalWarehouseListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            re.setWarehouseClassify("in_transit");
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.service.getLogicalWarehouseListPage((GetLogicalWarehouseListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutInTransitWarehouseVo vo = new OutInTransitWarehouseVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setWarehouseClassify(Optional.ofNullable(o.getWarehouseClassify()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    switch (Type2) {
                        case "physics": {
                            return "\u7269\u7406\u4ed3";
                        }
                        case "logic": {
                            return "\u903b\u8f91\u4ed3";
                        }
                        case "virtual": {
                            return "\u865a\u62df\u4ed3";
                        }
                        case "channel": {
                            return "\u6e20\u9053\u4ed3";
                        }
                        case "in_transit": {
                            return "\u5728\u9014\u4ed3";
                        }
                    }
                    return o.getWarehouseClassify();
                }).orElse(""));
                vo.setWarehouseQuality(Optional.ofNullable(o.getWarehouseQuality()).filter(StringUtils::isNotEmpty).map(r -> {
                    switch (r) {
                        case "wait_inspection": {
                            return "\u5f85\u68c0";
                        }
                        case "un_qualified": {
                            return "\u4e0d\u5408\u683c";
                        }
                        case "qualified": {
                            return "\u5408\u683c";
                        }
                        case "pending": {
                            return "\u5f85\u5904\u7406";
                        }
                        case "other": {
                            return "\u5176\u4ed6";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setSubordinateLogicWarehouseName(o.getSubordinateLogicWarehouseName());
                vo.setWarehouseStatus(Optional.ofNullable(o.getWarehouseStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "disable": {
                            return "\u65e0\u6548";
                        }
                        case "enable": {
                            return "\u6709\u6548";
                        }
                    }
                    return o.getWarehouseStatus();
                }).orElse(""));
                vo.setChannelType(Optional.ofNullable(o.getChannelType()).filter(StringUtils::isNotBlank).map(r -> {
                    switch (r) {
                        case "on_line": {
                            return "\u7ebf\u4e0a";
                        }
                        case "off_line": {
                            return "\u7ebf\u4e0b";
                        }
                    }
                    return o.getChannelType();
                }).orElse(""));
                vo.setWarehouseAttr(Optional.ofNullable(o.getWarehouseAttr()).filter(StringUtils::isNotBlank).map(r -> {
                    switch (r) {
                        case "finished_product": {
                            return "\u4ea7\u6210\u54c1";
                        }
                        case "semi_finished_product": {
                            return "\u534a\u6210\u54c1";
                        }
                        case "shoppe": {
                            return "\u4e13\u67dc";
                        }
                        case "third_party": {
                            return "\u7b2c\u4e09\u65b9";
                        }
                        case "promotionp_boring": {
                            return "\u4fc3\u9500\u7269\u6599";
                        }
                    }
                    return o.getWarehouseAttr();
                }).orElse(""));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutInTransitWarehouseVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }
}

