/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerDataManageMsgVO;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerDataManageVO;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryReportE2VO;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryReportMsgVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_report_center_daily_delivery_report_E2")
public class ImportDailyDeliveryReportE2Impl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportDailyDeliveryReportE2Impl.class);
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportDailyDeliveryReportE2VO.class);
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u7535\u5546\u53552\u5bfc\u5165\u96c6\u5408\uff0clist\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashSet checkRepeatData = Sets.newHashSet();
        Map<String, DailyDeliveryReportDto> respDtoMap = this.getcodesMap(list);
        log.info("respDtoMap=={}", (Object)JSON.toJSONString(respDtoMap));
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        list.forEach(i -> {
            ImportDailyDeliveryReportMsgVO msgDto = new ImportDailyDeliveryReportMsgVO();
            CubeBeanUtils.copyProperties((Object)i, (Object)msgDto, (String[])new String[0]);
            this.checkForm((ImportDailyDeliveryReportE2VO)((Object)i), msgDto);
            this.checkRepeatData(i.getDocumentNo() + i.getE3No(), checkRepeatData, msgDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(i);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u7535\u5546\u53551\u5bfc\u5165\u6210\u529f\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)saveList));
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u7535\u5546\u53551\u5bfc\u5165\u5931\u8d25\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)msgList));
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            log.info("===\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u7535\u5546\u53551\u5bfc\u5165\u6570\u636e===saveList:{}", (Object)JSON.toJSONString((Object)saveList));
            for (ImportDailyDeliveryReportE2VO v : saveList) {
                DailyDeliveryReportDto d = new DailyDeliveryReportDto();
                try {
                    BeanUtils.copyProperties((Object)((Object)v), (Object)d);
                }
                catch (Exception e) {
                    log.error("error:" + e);
                }
                if (d.getDocumentNo() == null) continue;
                DailyDeliveryReportDto demo = (DailyDeliveryReportDto)this.dailyDeliveryReportApi.queryByWMS(d.getDocumentNo()).getData();
                if (demo == null) {
                    this.dailyDeliveryReportApi.addDailyDeliveryReport(d);
                    continue;
                }
                this.dailyDeliveryReportApi.modifyDailyDeliveryReport(d);
            }
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u975e\u7535\u5546\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportDailyDeliveryReportMsgVO.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private Map<String, DailyDeliveryReportDto> getcodesMap(List<ImportDailyDeliveryReportE2VO> list) {
        HashMap codesMap = Maps.newHashMap();
        for (ImportDailyDeliveryReportE2VO vo : list) {
            log.info("vo\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
            String wms = vo.getDocumentNo();
            log.info("vo\u5bf9\u8c61\u7684wms\u51fa\u5e93\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)wms));
            DailyDeliveryReportDto deliveryReport = (DailyDeliveryReportDto)this.dailyDeliveryReportApi.queryByWMS(wms).getData();
            if (deliveryReport == null) continue;
            codesMap.put(wms, deliveryReport);
        }
        return codesMap;
    }

    private void checkCode(ImportCustomerDataManageVO i, Map<String, PCPCustomerRespDto> codesMap, ImportCustomerDataManageMsgVO msgDto) {
        PCPCustomerRespDto pcpCustomerRespDto = codesMap.get(i.getCode());
        if (ObjectUtils.isNotEmpty((Object)pcpCustomerRespDto)) {
            i.setId(pcpCustomerRespDto.getId());
        }
    }

    private void checkEasCode(ImportCustomerDataManageVO i, Map<String, EasCostOrgRespDto> codesMap, ImportCustomerDataManageMsgVO msgDto) {
        EasCostOrgRespDto easCostOrgRespDto;
        if (StringUtils.isNotBlank((CharSequence)i.getThirdParentPartyId()) && ObjectUtils.isEmpty((Object)(easCostOrgRespDto = codesMap.get(i.getThirdParentPartyId())))) {
            msgDto.setErrorMsg("\u6240\u5c5e\u8d22\u52a1\u7f16\u7801\u4e0d\u5b58\u5728");
        }
    }

    private void checkForm(ImportDailyDeliveryReportE2VO i, ImportDailyDeliveryReportMsgVO msgDto) {
        if (i.getE3No() == null || i.getE3No().equals("")) {
            throw new BizException("\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (i.getDocumentNo() == null || i.getDocumentNo().equals("")) {
            throw new BizException("WMS\u51fa\u5e93\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (i.getShippingCompany() == null || i.getShippingCompany().equals("")) {
            msgDto.setErrorMsg("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (i.getShippingCompanyName() == null || i.getShippingCompanyName().equals("")) {
            msgDto.setErrorMsg("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (i.getTransportStyle() == null || i.getTransportStyle().equals("")) {
            msgDto.setErrorMsg("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (i.getReceivingAddressProvince() == null || i.getReceivingAddressProvince().equals("")) {
            msgDto.setErrorMsg("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (i.getReceivingAddressCity() == null || i.getReceivingAddressCity().equals("")) {
            msgDto.setErrorMsg("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (i.getReceivingAddressDistrict() == null || i.getReceivingAddressDistrict().equals("")) {
            msgDto.setErrorMsg("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (i.getReceivingAddressProvince() == null || i.getReceivingAddressProvince().equals("") || i.getReceivingAddressCity() == null || i.getReceivingAddressCity().equals("") || i.getReceivingAddressDistrict() == null || i.getReceivingAddressDistrict().equals("")) {
            msgDto.setErrorMsg("\u7701\u5e02\u533a\u5fc5\u987b\u540c\u65f6\u586b\u5199\u6216\u8005\u90fd\u4e0d\u586b\u5199");
        }
        if (i.getBillingCartons() != null && !i.getBillingCartons().equals("")) {
            msgDto.setErrorMsg(ImportDailyDeliveryReportE2Impl.validateNumber(i.getBillingCartons(), 1));
        }
        if (i.getBillingVolume() != null && !i.getBillingVolume().equals("")) {
            msgDto.setErrorMsg(ImportDailyDeliveryReportE2Impl.validateNumber(i.getBillingVolume(), 0));
        }
        if (i.getBillingWeight() != null && !i.getBillingWeight().equals("")) {
            msgDto.setErrorMsg(ImportDailyDeliveryReportE2Impl.validateNumber(i.getBillingWeight(), 0));
        }
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, ImportDailyDeliveryReportMsgVO msgDto) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(msgDto, "\u6570\u636e\u91cd\u590d");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void setErrorMsg(ImportDailyDeliveryReportMsgVO msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    public static String validateNumber(BigDecimal number, int i) {
        if (i == 1) {
            if (number.signum() <= 0 && number.scale() == 0) {
                return "\u8ba1\u8d39\u7bb1\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570";
            }
        } else {
            String numberStr = number.toPlainString();
            int integerPartLength = numberStr.contains(".") ? numberStr.substring(0, numberStr.indexOf(".")).length() : numberStr.length();
            int scale = number.stripTrailingZeros().scale();
            if (integerPartLength > 9 || scale > 6 || number.signum() <= 0) {
                return "\u5fc5\u987b\u4e3a\u6b63\u6570\u4e14\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e9\u4f4d,\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e6\u4f4d";
            }
        }
        return "";
    }
}

