/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.dto.request.AutoDistributionTaskReqDto;
import com.dtyunxi.cis.pms.biz.service.OrderCenterAutoDistributionTaskService;
import com.dtyunxi.cube.center.source.api.constant.EnableEnum;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueSuitRespDto;
import com.dtyunxi.cube.center.source.api.query.IDistributionClueQueryApi;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SaleOrderAutoPickTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderAutoPickTask.class);
    @Autowired
    ICacheService cacheService;
    @Autowired
    private OrderCenterAutoDistributionTaskService autoDistributionTaskService;
    @Autowired
    private IDistributionClueQueryApi distributionClueQueryApi;

    public void before(TaskMsg taskMsg) {
        log.info("\u9500\u552e\u5355\u81ea\u52a8\u914d\u8d27\u4efb\u52a1\u8c03\u5ea6\u5f00\u59cb={}", (Object)taskMsg.getContent());
    }

    public boolean execute(TaskMsg taskMsg) {
        String content = taskMsg.getContent();
        log.info("\u3010\u8c03\u5ea6\u4efb\u52a1\u3011\u6267\u884c\u53c2\u6570\uff1a{}", (Object)content);
        if (StringUtils.isBlank((CharSequence)content)) {
            return true;
        }
        String reqId = RequestId.createReqId();
        CompletableFuture.runAsync(() -> {
            ServiceContext.getContext().setAttachment("reqId", reqId);
            try {
                this.executor(Long.valueOf(content), reqId);
            }
            catch (Exception e) {
                log.info("\u81ea\u52a8\u914d\u8d27\u4efb\u52a1\u8c03\u5ea6\u5f02\u5e38,{}", (Throwable)e);
            }
        });
        return true;
    }

    private void executor(Long ruleId, String reqId) {
        MDC.put((String)"yes.req.requestId", (String)reqId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        DistributionClueActRespDto clueActRespDto = (DistributionClueActRespDto)RestResponseHelper.extractData((RestResponse)this.distributionClueQueryApi.queryClueDetailById(ruleId));
        if (Objects.isNull(clueActRespDto)) {
            log.info("\u7b56\u7565\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        if (Objects.equals(clueActRespDto.getClueEnableStatus(), EnableEnum.DISABLE.code)) {
            log.info("\u7b56\u7565{}\u672a\u542f\u7528", (Object)clueActRespDto.getClueName());
            return;
        }
        Date nowTime = new Date();
        if (clueActRespDto.getClueEnableStartTime().compareTo(nowTime) > 0 || clueActRespDto.getClueEnableEndTime().compareTo(nowTime) < 0) {
            log.info("\u7b56\u7565{}\u672a\u5728\u542f\u7528\u8303\u56f4\u65f6\u95f4", (Object)clueActRespDto.getClueName());
            return;
        }
        if (Objects.equals(clueActRespDto.getClueSettings(), 0)) {
            log.info("\u7b56\u7565{}\u662f\u7acb\u5373\u914d\u8d27", (Object)clueActRespDto.getClueName());
            return;
        }
        List<Object> customerIdList = Lists.newArrayList();
        List suitCustomerList = clueActRespDto.getSuitCustomerList().stream().filter(dto -> !Objects.equals(dto.getSgSuitKey(), "ALL")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(suitCustomerList)) {
            customerIdList = suitCustomerList.stream().map(DistributionClueSuitRespDto::getSgSuitKey).map(x -> Long.valueOf(x)).collect(Collectors.toList());
        }
        List<Object> organizationIdList = Lists.newArrayList();
        List suitOrganizationList = clueActRespDto.getSuitOrganizationList().stream().filter(dto -> !Objects.equals(dto.getSgSuitKey(), "ALL")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(suitOrganizationList)) {
            organizationIdList = suitOrganizationList.stream().map(DistributionClueSuitRespDto::getSgSuitKey).map(x -> Long.valueOf(x)).collect(Collectors.toList());
        }
        List<Object> orderTypeList = Lists.newArrayList();
        List suitOrderTypeList = clueActRespDto.getSuitOrderTypeList().stream().filter(dto -> !Objects.equals(dto.getSgSuitKey(), "ALL")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(suitOrderTypeList)) {
            orderTypeList = suitOrderTypeList.stream().map(DistributionClueSuitRespDto::getSgSuitKey).collect(Collectors.toList());
        }
        AutoDistributionTaskReqDto autoDistributionTaskReqDto = new AutoDistributionTaskReqDto();
        autoDistributionTaskReqDto.setOrganizationIdList(organizationIdList);
        autoDistributionTaskReqDto.setOrderTypeList(orderTypeList);
        autoDistributionTaskReqDto.setCustomerIdList(customerIdList);
        this.autoDistributionTaskService.autoDistributionTask(autoDistributionTaskReqDto);
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u9500\u552e\u5355\u81ea\u52a8\u914d\u8d27\u4efb\u52a1\u8c03\u5ea6\u7ed3\u675f");
    }
}

