/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightReportListVO;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateLogisticsExportDto;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterLogisticsFreightLogisticsFreightReportListService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IFinLogisticsReportApi;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.util.ParamConverter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_logistic_report_place_export")
public class LogisticsPlaceExportServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsPlaceExportServiceImpl.class);
    @Resource
    private ReportCenterLogisticsFreightLogisticsFreightReportListService inventoryCenterInquiryServiceService;
    @Resource
    private IFinLogisticsReportApi finLogisticsReportApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        log.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5165\u53c2\uff1a{}", (Object)commonReqDto);
        this.getDate(commonReqDto);
        log.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u65e5\u671f\u8f6c\u6362\u540e\u7684\u53c2\u6570\uff1a{}", (Object)commonReqDto);
        LogisticsFreightReportListPageParams getLogicalInventoryListPageParams = new LogisticsFreightReportListPageParams();
        getLogicalInventoryListPageParams = (LogisticsFreightReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), LogisticsFreightReportListPageParams.class);
        log.info("\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u65e5\u671f\u8f6c\u6362\u540e\uff0c\u7c7b\u578b\u8f6c\u6362\u540e\u7684\u53c2\u6570\uff1a{}", (Object)commonReqDto);
        ArrayList<Long> waitPlaceIdList = new ArrayList<Long>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<String> urls = null;
        AtomicReference<String> errorMsg = new AtomicReference<String>("");
        try {
            urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
                PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.inventoryCenterInquiryServiceService.getLogisticsFreightReportListPage((LogisticsFreightReportListPageParams)re));
                PageInfo pageInfo = new PageInfo();
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                ArrayList list = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                    respDtoPageInfo.getList().forEach(o -> {
                        TemplateLogisticsExportDto vo = new TemplateLogisticsExportDto();
                        vo.setId(o.getId());
                        vo.setMergeCode(o.getMergeCode());
                        vo.setBookkeepingDate(o.getBookkeepingDate());
                        vo.setBillingDate(o.getBillingDate());
                        vo.setOutboundTime(o.getOutWarehouseTime());
                        vo.setEasNo(o.getEasNo());
                        vo.setTransportCode(o.getShippingNo());
                        vo.setTransportNo(o.getLogisticsNo());
                        vo.setOutboundCode(o.getDocumentNo());
                        vo.setOutDocumentNo(o.getOutDocumentNo());
                        vo.setOutPhysicsWarehouseName(o.getOutPhysicsWarehouseName());
                        vo.setWmsOutboundCode(o.getWmSDocumentNo());
                        vo.setWmsMergeDocumentNo(o.getWmsMergeDocumentNo());
                        vo.setBusinessType(StringUtils.isNotEmpty((CharSequence)o.getBusinessType()) ? ExpressBusinessTypeEnum.getNameByType(o.getBusinessType()) : "");
                        vo.setBusinessCode(o.getBusinessOrderNo());
                        vo.setWarehouseName(o.getWarehouseName());
                        vo.setLogisticCompany(o.getLogisticsCompany());
                        vo.setTransportType(o.getLogisticsType());
                        vo.setBottle(StringUtils.isNotEmpty((CharSequence)o.getBottlesNumber()) ? new BigDecimal(o.getBottlesNumber()) : null);
                        vo.setBox(StringUtils.isNotEmpty((CharSequence)o.getBoxNum()) ? new BigDecimal(o.getBoxNum()) : null);
                        vo.setVolume(StringUtils.isNotEmpty((CharSequence)o.getVolume()) ? new BigDecimal(o.getVolume()) : null);
                        vo.setWeight(StringUtils.isNotEmpty((CharSequence)o.getWeight()) ? new BigDecimal(o.getWeight()) : null);
                        vo.setTotalBox(StringUtils.isNotEmpty((CharSequence)o.getAllBoxNum()) ? new BigDecimal(o.getAllBoxNum()) : null);
                        vo.setTotalVolume(StringUtils.isNotEmpty((CharSequence)o.getAllVolume()) ? new BigDecimal(o.getAllVolume()) : null);
                        vo.setTotalWeight(StringUtils.isNotEmpty((CharSequence)o.getAllWeight()) ? new BigDecimal(o.getAllWeight()) : null);
                        vo.setChargeMode(o.getBillingMethodName());
                        vo.setCalUnitName(o.getCalUnitName());
                        vo.setTransportPrice(StringUtils.isNotEmpty((CharSequence)o.getFreightPrice()) && !"-".equals(o.getFreightPrice()) ? new BigDecimal(o.getFreightPrice()) : null);
                        vo.setTransportAmount(StringUtils.isNotEmpty((CharSequence)o.getFreightAmount()) && !"-".equals(o.getFreightAmount()) ? new BigDecimal(o.getFreightAmount()) : null);
                        vo.setMinCharge(StringUtils.isNotEmpty((CharSequence)o.getMinimumCharge()) ? new BigDecimal(o.getMinimumCharge()) : null);
                        vo.setDeliveryAmount(StringUtils.isNotEmpty((CharSequence)o.getDeliveryFee()) ? new BigDecimal(o.getDeliveryFee()) : null);
                        vo.setUnloadAmount(StringUtils.isNotEmpty((CharSequence)o.getUnloadingFee()) ? new BigDecimal(o.getUnloadingFee()) : null);
                        vo.setContractOilPrice(o.getContractOilPrice());
                        vo.setLinkOilPrice(o.getLinkOilPrice());
                        vo.setRangeOilPrice(o.getRangeOilPrice());
                        vo.setAdjustOilPrice(o.getAdjustOilPrice());
                        vo.setOilPrice(StringUtils.isNotEmpty((CharSequence)o.getOilPriceLinkage()) ? new BigDecimal(o.getOilPriceLinkage()) : null);
                        vo.setSpecialType(o.getSpecialExpenseType());
                        vo.setSpecialAmount(StringUtils.isNotEmpty((CharSequence)o.getSpecialExpense()) ? new BigDecimal(o.getSpecialExpense()) : null);
                        vo.setTotalTransportAmount(StringUtils.isNotEmpty((CharSequence)o.getTotalFreight()) && !"-".equals(o.getTotalFreight()) ? new BigDecimal(o.getTotalFreight()) : null);
                        vo.setWarehouseOut(o.getTransferIOutWarehouse());
                        vo.setOrganizationOut(o.getOutCargoRightName());
                        vo.setWarehouseEnter(o.getTransferIIntoWarehouse());
                        vo.setOrganizationEnter(o.getInCargoRightName());
                        vo.setAmountAttribution(o.getCostAttribution());
                        vo.setHarvestPeople(o.getConsignee());
                        vo.setProvince(o.getProvince());
                        vo.setCity(o.getAddressInfo());
                        vo.setArea(o.getArea());
                        vo.setCityLevel(o.getCityLevel());
                        vo.setCustomerName(o.getCustomerName());
                        vo.setHarvestAddress(o.getReceiverAddress());
                        vo.setLogisticsTemplateArea(o.getLogisticsTemplateArea());
                        vo.setRemark(o.getRemark());
                        vo.setUpdatePerson(o.getUpdatePerson());
                        try {
                            vo.setUpdateTime(simpleDateFormat.parse(o.getUpdateTime()));
                        }
                        catch (ParseException e) {
                            log.info("\u66f4\u65b0\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff0c\u9ed8\u8ba4\u4f7f\u7528\u5f53\u524d\u65f6\u95f4");
                            vo.setUpdateTime(new Date());
                        }
                        vo.setStatus(o.getAbnormal().equals("1") ? "\u5f02\u5e38" : "\u6b63\u5e38");
                        vo.setAbnormalCauses(o.getAbnormalCauses());
                        list.add(vo);
                    });
                    waitPlaceIdList.addAll(respDtoPageInfo.getList().stream().map(LogisticsFreightReportListVO::getId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                pageInfo.setList((List)list);
                return pageInfo;
            }, getLogicalInventoryListPageParams, TemplateLogisticsExportDto.class, commonReqDto.getFileName());
            AssertUtil.isFalse(CollectionUtils.isEmpty(urls), "\u7269\u6d41\u8d39\u7528\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff0c\u6ca1\u6709\u751f\u6210\u6587\u4ef6\u94fe\u63a5");
        }
        catch (Exception e) {
            errorMsg.set("\u5bfc\u51fa\u6267\u884c\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.placeCallBack(commonReqDto, errorMsg, String.join((CharSequence)",", urls), waitPlaceIdList, list -> {
                try {
                    FeeReportPlaceUpdateReqDto feeReportPlaceUpdateReqDto = new FeeReportPlaceUpdateReqDto();
                    feeReportPlaceUpdateReqDto.setModuleRecordIdList(waitPlaceIdList);
                    feeReportPlaceUpdateReqDto.setPlacedFlag(Integer.valueOf(1));
                    log.info("\u66f4\u65b0\u7269\u6d41\u8d39\u7528\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)waitPlaceIdList.size());
                    this.finLogisticsReportApi.updatePlaceStatus(feeReportPlaceUpdateReqDto);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u7269\u6d41\u8d39\u7528\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    errorMsg.set("\u66f4\u65b0\u7269\u6d41\u8d39\u7528\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        this.getDate(commonReqDto);
        LogisticsFreightReportListPageParams getLogicalInventoryListPageParams = new LogisticsFreightReportListPageParams();
        getLogicalInventoryListPageParams = (LogisticsFreightReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), LogisticsFreightReportListPageParams.class);
        getLogicalInventoryListPageParams.setPageSize(1);
        getLogicalInventoryListPageParams.setPageNum(1);
        RestResponse<PageInfo<LogisticsFreightReportListVO>> pageInfoRestResponse = this.inventoryCenterInquiryServiceService.getLogisticsFreightReportListPage(getLogicalInventoryListPageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }

    private void getDate(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode outerJsonNode = objectMapper.readTree(filter);
            JsonNode paramsNode = outerJsonNode.path("params");
            if (!paramsNode.isTextual()) {
                log.error("params \u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u5b57\u7b26\u4e32");
                return;
            }
            JsonNode innerParamsNode = objectMapper.readTree(paramsNode.asText());
            String time = innerParamsNode.path("placedFlagDate").asText();
            if (time == null || time.trim().isEmpty()) {
                log.error("placedFlagDate\u5b57\u6bb5\u4e0d\u5b58\u5728");
                return;
            }
            ((ObjectNode)outerJsonNode).put("bookkeepingDate", time);
            commonReqDto.setFilter(outerJsonNode.toString());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790JSON\u5931\u8d25", (Throwable)e);
        }
    }
}

