/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.WarehouseTypeEnum;
import com.dtyunxi.cis.pms.biz.model.DeleteLogicalWarningParams;
import com.dtyunxi.cis.pms.biz.model.DeleteVirtualWarningParams;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportLogicalWarning;
import com.dtyunxi.cis.pms.biz.model.GetLogicalInventoryWarningListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetLogicalWarningListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetVirtualInventoryWarningListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetVirtualWarningListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportLogicalWarningDto;
import com.dtyunxi.cis.pms.biz.model.ImportLogicalWarningMsgDto;
import com.dtyunxi.cis.pms.biz.model.LogicalInventoryWarningVO;
import com.dtyunxi.cis.pms.biz.model.LogicalWarningVO;
import com.dtyunxi.cis.pms.biz.model.VirtualInventoryWarningVO;
import com.dtyunxi.cis.pms.biz.model.VirtualWarningVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterWarnningService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cis.search.api.query.inventory.EsLogicInventoryQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.ICsInventoryWarningApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.ICsInventoryWarningQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventoryWarningAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventoryWarningQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_logical_warning")
public class InventoryCenterWarnningServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements InventoryCenterWarnningService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterWarnningServiceServiceImpl.class);
    @Resource
    private ICsInventoryWarningApi csInventoryWarningApi;
    @Resource
    private ICsInventoryWarningQueryApi csInventoryWarningQueryApi;
    @Resource
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Resource
    private EsLogicInventoryQueryApi esLogicInventoryQueryApi;
    @Resource
    private IItemExtQueryApi itemExtQueryApi;
    @Resource
    private IVirtualInventoryApi iVirtualInventoryQueryApi;
    @Resource
    private ICsLogicInventoryQueryApi iCsLogicInventoryQueryApi;
    @Resource
    private ICsLogicWarehouseQueryApi iCsLogicWarehouseQueryApi;

    @Override
    public RestResponse<Object> deleteLogicalWarning(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteLogicalWarningParams deleteLogicalWarningParams) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInventoryWarningApi.delete(ParamConverter.convertToLong((Object)deleteLogicalWarningParams.getId()))));
    }

    @Override
    public RestResponse<Object> deleteVirtualWarning(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteVirtualWarningParams deleteVirtualWarningParams) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInventoryWarningApi.delete(ParamConverter.convertToLong((Object)deleteVirtualWarningParams.getId()))));
    }

    @Override
    public RestResponse<PageInfo<LogicalInventoryWarningVO>> getLogicalInventoryWarningListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicalInventoryWarningListPageParams getLogicalInventoryWarningListPageParams) {
        CsInventoryWarningQueryDto queryDto = new CsInventoryWarningQueryDto();
        BeanUtils.copyProperties((Object)getLogicalInventoryWarningListPageParams, (Object)queryDto);
        queryDto.setWarehouseClassify(WarehouseTypeEnum.LOGIC.getCode());
        queryDto.setSkuCode(getLogicalInventoryWarningListPageParams.getGoodsLongCode());
        queryDto.setWarehouseCode(getLogicalInventoryWarningListPageParams.getWarehouseCode());
        queryDto.setWarehouseType(getLogicalInventoryWarningListPageParams.getSaleType());
        queryDto.setSkuName(getLogicalInventoryWarningListPageParams.getGoodsName());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryWarningQueryApi.warningSettingPage(queryDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            LogicalInventoryWarningVO vo = new LogicalInventoryWarningVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setSaleType(o.getWarehouseType());
            vo.setWarehouseType(o.getWarehouseClassify());
            vo.setGoodsLongCode(o.getSkuCode());
            vo.setGoodsName(o.getSkuName());
            vo.setWarningQuantity(o.getWarningInventory());
            vo.setAvailableInventory(o.getAvailable());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<LogicalWarningVO>> getLogicalWarningListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicalWarningListPageParams getLogicalWarningListPageParams) {
        CsInventoryWarningQueryDto queryDto = new CsInventoryWarningQueryDto();
        this.getParams(getLogicalWarningListPageParams, queryDto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryWarningQueryApi.warningSettingPage(queryDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            LogicalWarningVO vo = new LogicalWarningVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setSaleType(o.getWarehouseType());
            vo.setWarehouseType(o.getWarehouseClassify());
            vo.setGoodsLongCode(o.getSkuCode());
            vo.setGoodsName(o.getSkuName());
            vo.setWarningQuantity(o.getWarningInventory());
            if (o.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    private void getParams(GetLogicalWarningListPageParams getLogicalWarningListPageParams, CsInventoryWarningQueryDto queryDto) {
        BeanUtils.copyProperties((Object)getLogicalWarningListPageParams, (Object)queryDto);
        queryDto.setWarehouseClassify(WarehouseTypeEnum.LOGIC.getCode());
        queryDto.setSkuCode(getLogicalWarningListPageParams.getGoodsLongCode());
        queryDto.setWarehouseCode(getLogicalWarningListPageParams.getWarehouseCode());
        queryDto.setWarehouseType(getLogicalWarningListPageParams.getSaleType());
        queryDto.setSkuName(getLogicalWarningListPageParams.getGoodsName());
    }

    @Override
    public RestResponse<PageInfo<VirtualInventoryWarningVO>> getVirtualInventoryWarningListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetVirtualInventoryWarningListPageParams getVirtualInventoryWarningListPageParams) {
        CsInventoryWarningQueryDto queryDto = new CsInventoryWarningQueryDto();
        BeanUtils.copyProperties((Object)getVirtualInventoryWarningListPageParams, (Object)queryDto);
        queryDto.setWarehouseClassify(WarehouseTypeEnum.VIRTUAL.getCode());
        queryDto.setSkuCode(getVirtualInventoryWarningListPageParams.getGoodsLongCode());
        queryDto.setWarehouseCode(getVirtualInventoryWarningListPageParams.getWarehouseCode());
        queryDto.setWarehouseType(getVirtualInventoryWarningListPageParams.getSaleType());
        queryDto.setSkuName(getVirtualInventoryWarningListPageParams.getGoodsName());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryWarningQueryApi.warningSettingPage(queryDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            VirtualInventoryWarningVO vo = new VirtualInventoryWarningVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setSaleType(o.getWarehouseType());
            vo.setWarehouseType(o.getWarehouseClassify());
            vo.setGoodsLongCode(o.getSkuCode());
            vo.setGoodsName(o.getSkuName());
            vo.setWarningQuantity(o.getWarningInventory());
            vo.setAvailableInventory(o.getAvailable());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<VirtualWarningVO>> getVirtualWarningListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetVirtualWarningListPageParams getVirtualWarningListPageParams) {
        CsInventoryWarningQueryDto queryDto = new CsInventoryWarningQueryDto();
        BeanUtils.copyProperties((Object)getVirtualWarningListPageParams, (Object)queryDto);
        queryDto.setWarehouseClassify(WarehouseTypeEnum.VIRTUAL.getCode());
        queryDto.setSkuCode(getVirtualWarningListPageParams.getGoodsLongCode());
        queryDto.setWarehouseCode(getVirtualWarningListPageParams.getWarehouseCode());
        queryDto.setSkuName(getVirtualWarningListPageParams.getGoodsName());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryWarningQueryApi.warningSettingPage(queryDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            VirtualWarningVO vo = new VirtualWarningVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsLongCode(o.getSkuCode());
            vo.setGoodsName(o.getSkuName());
            vo.setWarningQuantity(o.getWarningInventory());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportLogicalWarningDto.class);
        HashSet warehouseCodes = Sets.newHashSet();
        HashSet goodsLongCodes = Sets.newHashSet();
        HashSet warningQuantitys = Sets.newHashSet();
        HashMap dataMap = Maps.newHashMap();
        HashSet codeSet = Sets.newHashSet();
        list.forEach(i -> {
            warehouseCodes.add(i.getWarehouseCode());
            goodsLongCodes.add(i.getGoodsLongCode());
            warningQuantitys.add(i.getWarningQuantity());
            String code = String.format("%s_%s_%s", i.getWarehouseCode(), i.getGoodsLongCode(), i.getWarningQuantity());
            if (dataMap.containsKey(code)) {
                codeSet.add(code);
            } else {
                dataMap.put(code, i);
            }
        });
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        Map<String, CsLogicWarehouseRespDto> warehouseCodeMap = this.getWarehouseCodeMap(warehouseCodes);
        Map<String, ItemRespDto> goodsLongCodeMap = this.getGoodsLongCodeMap(goodsLongCodes);
        Map<String, CsLogicInventoryRespDto> virtualMap = this.getVirtualMap(goodsLongCodes);
        list.stream().forEach(i -> {
            warehouseCodes.add(i.getWarehouseCode());
            goodsLongCodes.add(i.getGoodsLongCode());
            warningQuantitys.add(i.getWarningQuantity());
            ImportLogicalWarningMsgDto msgDto = new ImportLogicalWarningMsgDto();
            CsInventoryWarningAddReqDto saveDto = new CsInventoryWarningAddReqDto();
            String code = String.format("%s_%s_%s", i.getWarehouseCode(), i.getGoodsLongCode(), i.getWarningQuantity());
            BeanUtils.copyProperties((Object)i, (Object)((Object)msgDto));
            String warehouseCode = i.getWarehouseCode();
            String goodsLongCode = i.getGoodsLongCode();
            String warningQuantity = i.getWarningQuantity();
            if (codeSet.contains(code)) {
                msgDto.setMsg("\u6570\u636e\u91cd\u590d");
            }
            if (!warehouseCodeMap.containsKey(warehouseCode)) {
                msgDto.setMsg("\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                saveDto.setWarehouseCode(warehouseCode);
                saveDto.setWarehouseName(((CsLogicWarehouseRespDto)warehouseCodeMap.get(warehouseCode)).getWarehouseName());
            }
            if (!goodsLongCodeMap.containsKey(goodsLongCode)) {
                msgDto.setMsg("\u5546\u54c1SKU\u4e0d\u5b58\u5728");
            }
            if (!virtualMap.containsKey(goodsLongCode)) {
                msgDto.setMsg("\u5546\u54c1\u6ca1\u6709\u5173\u8054\u8be5\u4ed3\u5e93");
            } else {
                saveDto.setSkuCode(goodsLongCode);
                saveDto.setSkuName(((CsLogicInventoryRespDto)virtualMap.get(goodsLongCode)).getCargoName());
            }
            if (!warningQuantity.matches("^[0-9]*[1-9][0-9]*$")) {
                msgDto.setMsg("\u5e93\u5b58\u9884\u8b66\u503c\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            }
            saveDto.setWarningInventory(new BigDecimal(warningQuantity));
            saveDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            logger.info("\u5bfc\u5165msgDto:{},,\u5bfc\u5165saveDto:{}", (Object)JSON.toJSONString((Object)((Object)msgDto)), (Object)JSON.toJSONString((Object)saveDto));
            if (StringUtils.isNotBlank((CharSequence)msgDto.getMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(saveDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    private Map<String, CsLogicInventoryRespDto> getVirtualMap(Set<String> goodsLongCodes) {
        CsLogicInventoryQueryDto pageParams = new CsLogicInventoryQueryDto();
        pageParams.setCargoCodeList(new ArrayList<String>(goodsLongCodes));
        List list = (List)RestResponseHelper.extractData((RestResponse)this.iCsLogicInventoryQueryApi.queryByParam(pageParams));
        logger.info("\u67e5\u8be2esLogicInventoryVOPageInfo:{}", (Object)JSON.toJSONString((Object)list));
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().collect(Collectors.toMap(CsLogicInventoryRespDto::getCargoCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsLogicWarehouseRespDto> getWarehouseCodeMap(Set<String> warehouseCodes) {
        CsLogicWarehouseQueryDto pageParams = new CsLogicWarehouseQueryDto();
        pageParams.setWarehouseCodeList(new ArrayList<String>(warehouseCodes));
        List list = (List)RestResponseHelper.extractData((RestResponse)this.iCsLogicWarehouseQueryApi.queryByParam(pageParams));
        logger.info("\u67e5\u8be2esLogicInventoryVOPageInfo:{}", (Object)JSON.toJSONString((Object)list));
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, ItemRespDto> getGoodsLongCodeMap(Set<String> goodsLongCodes) {
        logger.info("\u67e5\u8be2goodsLongCodes:{}", (Object)JSON.toJSONString(goodsLongCodes));
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtQueryApi.batchQueryItem((List)Lists.newArrayList(goodsLongCodes)));
        logger.info("\u67e5\u8be2itemRespDtos:{}", (Object)JSON.toJSONString((Object)itemRespDtos));
        if (CollectionUtil.isEmpty((Collection)itemRespDtos)) {
            return null;
        }
        return itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getCode, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.csInventoryWarningApi.batchInsert(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5b9e\u7269\u4ed3\u9884\u8b66\u8bbe\u7f6e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportLogicalWarningMsgDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetLogicalWarningListPageParams params = new GetLogicalWarningListPageParams();
        CsInventoryWarningQueryDto queryDto = new CsInventoryWarningQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetLogicalWarningListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetLogicalWarningListPageParams.class);
            this.getParams(params, queryDto);
        }
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryWarningQueryApi.warningSettingPage(queryDto));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetLogicalWarningListPageParams params = new GetLogicalWarningListPageParams();
        CsInventoryWarningQueryDto queryDto = new CsInventoryWarningQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetLogicalWarningListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetLogicalWarningListPageParams.class);
            this.getParams(params, queryDto);
        }
        queryDto.setPageSize(commonReqDto.getPageSize());
        queryDto.setPageNum(commonReqDto.getPageNum());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryWarningQueryApi.warningSettingPage(queryDto));
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(o -> {
                ExportLogicalWarning vo = new ExportLogicalWarning();
                vo.setGoodsLongCode(o.getSkuCode());
                vo.setGoodsName(o.getSkuName());
                vo.setWarehouseCode(o.getWarehouseCode());
                vo.setWarehouseName(o.getWarehouseName());
                vo.setSaleType(o.getWarehouseType());
                vo.setWarningQuantity(o.getWarningInventory().setScale(0));
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }
}

