/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportReportCenterSaleOrderContrastVO;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderContrastListPageParams;
import com.dtyunxi.cis.pms.biz.model.SaleOrderContrastVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSaleOrderContrastService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.request.SaleOrderContrastPageParams;
import com.dtyunxi.cis.search.api.query.trade.EsSaleOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_sale_order_contrast")
public class ReportCenterSaleOrderContrastServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterSaleOrderContrastService {
    private static final Logger log = LoggerFactory.getLogger(ReportCenterSaleOrderContrastServiceServiceImpl.class);
    @Resource
    private EsSaleOrderQueryApi esSaleOrderQueryApi;

    @Override
    public RestResponse<PageInfo<SaleOrderContrastVO>> getSaleOrderContrastListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleOrderContrastListPageParams getSaleOrderContrastListPageParams) {
        SaleOrderContrastPageParams params = new SaleOrderContrastPageParams();
        params.setOrderNo(getSaleOrderContrastListPageParams.getOrderNo());
        params.setOrderStatus(getSaleOrderContrastListPageParams.getOrderStatus());
        params.setItemCode(getSaleOrderContrastListPageParams.getGoodsCode());
        params.setStartDifferenceNum(getSaleOrderContrastListPageParams.getDiffNumStart());
        params.setEndDifferenceNum(getSaleOrderContrastListPageParams.getDiffNumEnd());
        params.setItemName(getSaleOrderContrastListPageParams.getGoodsName());
        params.setStartItemNum(getSaleOrderContrastListPageParams.getPlatformOrderGoodsNumStart());
        params.setEndItemNum(getSaleOrderContrastListPageParams.getPlatformOrderGoodsNumEnd());
        params.setStartOutItemNum(getSaleOrderContrastListPageParams.getWmsDeliveryNumStart());
        params.setEndOutItemNum(getSaleOrderContrastListPageParams.getWmsDeliveryNumEnd());
        params.setPageNum(getSaleOrderContrastListPageParams.getPageNum());
        params.setPageSize(getSaleOrderContrastListPageParams.getPageSize());
        params.setSaleOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode()}));
        PageInfo respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esSaleOrderQueryApi.querySaleOrderContrast(params));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respVoPageInfo.getList().stream().map(o -> {
            SaleOrderContrastVO vo = new SaleOrderContrastVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setPlatformOrderNo(o.getPlatformOrderNo());
            vo.setSaleOrderNo(o.getSaleOrderNo());
            vo.setOrderStatus(o.getOrderStatus());
            vo.setGoodsCode(o.getSkuCode());
            vo.setGoodsName(o.getItemName());
            vo.setWmsDeliveryNum(o.getOutItemNum());
            vo.setPlatformOrderGoodsNum(o.getItemNum());
            vo.setDiffNum(o.getDifferenceNum());
            vo.setId(o.getId());
            vo.setCreatePerson(o.getCreatePerson());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setPlatformOrderId(ParamConverter.convertToString((Object)o.getPlatformOrderId()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetSaleOrderContrastListPageParams params = new GetSaleOrderContrastListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSaleOrderContrastListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderContrastListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getSaleOrderContrastListPage((GetSaleOrderContrastListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                ExportReportCenterSaleOrderContrastVO vo = new ExportReportCenterSaleOrderContrastVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setPlatformOrderNo(o.getPlatformOrderNo());
                vo.setSaleOrderNo(o.getSaleOrderNo());
                vo.setOrderStatus(Optional.ofNullable(o.getOrderStatus()).filter(StringUtils::isNotBlank).map(r -> {
                    switch (r) {
                        case "RECEIVED": {
                            return "\u5df2\u7b7e\u6536";
                        }
                        case "COMPLETE": {
                            return "\u5df2\u5b8c\u6210";
                        }
                    }
                    return r;
                }).orElse(""));
                vo.setGoodsCode(o.getGoodsCode());
                vo.setGoodsName(o.getGoodsName());
                vo.setWmsDeliveryNum(o.getWmsDeliveryNum());
                vo.setPlatformOrderGoodsNum(o.getPlatformOrderGoodsNum());
                vo.setDiffNum(o.getDiffNum());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportReportCenterSaleOrderContrastVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    private void getParams(GetSaleOrderContrastListPageParams params, SaleOrderContrastPageParams query) {
        BeanUtils.copyProperties((Object)params, (Object)query);
        query.setOrderNo(params.getOrderNo());
        query.setOrderStatus(params.getOrderStatus());
        query.setItemCode(params.getGoodsCode());
        query.setStartDifferenceNum(params.getDiffNumStart());
        query.setEndDifferenceNum(params.getDiffNumEnd());
        query.setItemName(params.getGoodsName());
        query.setStartItemNum(params.getPlatformOrderGoodsNumStart());
        query.setEndItemNum(params.getPlatformOrderGoodsNumEnd());
        query.setStartOutItemNum(params.getWmsDeliveryNumStart());
        query.setEndOutItemNum(params.getWmsDeliveryNumEnd());
    }
}

