/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.biz;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.Constants;
import com.dtyunxi.cis.pms.biz.utils.CronCreateUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@Scope(value="prototype")
public class BizAutoDistribution {
    private final Logger logger = LoggerFactory.getLogger(BizAutoDistribution.class);
    @Resource
    private ITaskApi iTaskApi;
    @Value(value="${scheduler.client.order.distrbution.appBizCode:saleOrderAutoPickTask}")
    private String grantAppBizCode;
    @Value(value="${scheduler.client.app_code:cis-pms-mgmt-application}")
    private String appCode;

    public List<Long> createTasks(Integer longTime, Long clueId) {
        ArrayList taskIdList = Lists.newArrayList();
        List<String> cronList = CronCreateUtil.createCron(longTime);
        for (String corn : cronList) {
            TaskAndBizCreateReqDto task = new TaskAndBizCreateReqDto();
            task.setBizName("\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u5b9a\u65f6\u4efb\u52a1_" + clueId);
            task.setAppCode(this.appCode);
            task.setBizCode(this.grantAppBizCode);
            task.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
            task.setScheduleExpression(corn);
            task.setShardType("SINGLE");
            task.setTenantId(Constants.CONNECTOR_TENANT_ID);
            task.setTaskName("\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u5b9a\u65f6\u4efb\u52a1_" + System.currentTimeMillis());
            task.setParams(ObjectUtils.isEmpty((Object)clueId) ? null : clueId.toString());
            task.setTaskCode(String.valueOf(System.currentTimeMillis()));
            this.logger.info("\u3010\u4efb\u52a1\u8c03\u5ea6\u3011\u5f00\u59cb\u521b\u5efa\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u5b9a\u65f6\u4efb\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)task));
            try {
                RestResponse restResponse = this.iTaskApi.addWithBiz(task);
                if (null != restResponse && String.valueOf(0).equals(restResponse.getResultCode())) {
                    RequestDto requestDto = new RequestDto();
                    requestDto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
                    requestDto.setTenantId(Constants.CONNECTOR_TENANT_ID);
                    this.iTaskApi.enableById((Long)restResponse.getData(), ObjectHelper.bean2Json((Object)requestDto));
                }
                taskIdList.add(restResponse.getData());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return taskIdList;
    }
}

