/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.export.IExportExcelHelper;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportSaleOrderMonitorReportVO;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderCountParams;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderDetailReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.SaleOrderCountVO;
import com.dtyunxi.cis.pms.biz.model.SaleOrderMonitorReportVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSaleOrderMonitorReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.request.SaleOrderContrastPageParams;
import com.dtyunxi.cis.search.api.query.trade.EsSaleOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderCountRespDto;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_sale_order_monitor")
public class ReportCenterSaleOrderMonitorReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterSaleOrderMonitorReportService {
    private static Logger logger = LoggerFactory.getLogger(ReportCenterSaleOrderMonitorReportServiceServiceImpl.class);
    @Resource
    private EsSaleOrderQueryApi esSaleOrderQueryApi;
    @Resource
    private IExportExcelHelper exportExcelHelper;
    @Resource
    private TradeEsReportQueryApi tradeEsReportQueryApi;

    @Override
    public RestResponse<PageInfo<SaleOrderMonitorReportVO>> getSaleOrderMonitorReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleOrderDetailReportListPageParams getSaleOrderDetailReportListPageParams) {
        SaleOrderContrastPageParams params = new SaleOrderContrastPageParams();
        params.setOrderNo(getSaleOrderDetailReportListPageParams.getOrderNo());
        params.setOrderStatus(getSaleOrderDetailReportListPageParams.getOrderStatus());
        params.setOrderSource(getSaleOrderDetailReportListPageParams.getOrderSource());
        params.setBatchNo(getSaleOrderDetailReportListPageParams.getBatchNo());
        params.setOrganizationCode(getSaleOrderDetailReportListPageParams.getCargoRightCode());
        params.setItemCode(getSaleOrderDetailReportListPageParams.getGoodsCode());
        params.setWarehouseCode(getSaleOrderDetailReportListPageParams.getDeliveryPhysicalWarehouse());
        params.setStartItemNum(getSaleOrderDetailReportListPageParams.getGoodsTotalNumStart());
        params.setEndItemNum(getSaleOrderDetailReportListPageParams.getGoodsTotalNumEnd());
        params.setStartOutItemNum(getSaleOrderDetailReportListPageParams.getOutWarehouseNumStart());
        params.setEndOutItemNum(getSaleOrderDetailReportListPageParams.getOutWarehouseNumEnd());
        params.setStartVolumeSum(getSaleOrderDetailReportListPageParams.getVolumeStart());
        params.setEndVolumeSum(getSaleOrderDetailReportListPageParams.getVolumeEnd());
        params.setLogicalWarehouse(getSaleOrderDetailReportListPageParams.getLogicalWarehouseName());
        params.setStartSalePrice(getSaleOrderDetailReportListPageParams.getTaxPriceStart());
        params.setEndSalePrice(getSaleOrderDetailReportListPageParams.getTaxPriceEnd());
        params.setStartLineAmount(getSaleOrderDetailReportListPageParams.getTaxTotalAmountStart());
        params.setEndLineAmount(getSaleOrderDetailReportListPageParams.getTaxTotalAmountEnd());
        params.setDeliveryName(getSaleOrderDetailReportListPageParams.getDeliveryName());
        params.setDeliveryPhone(getSaleOrderDetailReportListPageParams.getDeliveryPhone());
        params.setCustomerName(getSaleOrderDetailReportListPageParams.getCustomerName());
        params.setStartTime(getSaleOrderDetailReportListPageParams.getCreateTimeStart());
        params.setEndTime(getSaleOrderDetailReportListPageParams.getCreateTimeEnd());
        params.setUpdatePerson(getSaleOrderDetailReportListPageParams.getUpdatePerson());
        params.setPageNum(getSaleOrderDetailReportListPageParams.getPageNum());
        params.setPageSize(getSaleOrderDetailReportListPageParams.getPageSize());
        params.setSaleOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode(), SaleOrderStatusEnum.OBSOLETE.getCode()}));
        PageInfo respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esSaleOrderQueryApi.querySaleOrderContrast(params));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respVoPageInfo.getList().stream().map(o -> {
            SaleOrderMonitorReportVO vo = new SaleOrderMonitorReportVO();
            BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetSaleOrderListPageEsParams params = new GetSaleOrderListPageEsParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSaleOrderListPageEsParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderListPageEsParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getSaleOrderMonitorReportPage((GetSaleOrderListPageEsParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                ExportSaleOrderMonitorReportVO vo = new ExportSaleOrderMonitorReportVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setOrderSource(SaleOrderSourceEnum.enumOf((Integer)Integer.valueOf(o.getOrderSource())).getDesc());
                vo.setDetailAddress(o.getOrderAddress().getDetailAddress());
                vo.setChannelName(o.getOrderChannelName());
                vo.setGoodsTotalNum(o.getGoodsTotalNum() == null ? null : Integer.valueOf(o.getGoodsTotalNum().intValue()));
                if (Objects.nonNull(o.getPreemptionStockFalg())) {
                    vo.setPreemptionStockFalgStr(o.getPreemptionStockFalg().equals(0) ? "\u5426" : "\u662f");
                }
                try {
                    vo.setOrderStatus(SaleOrderStatusEnum.forCode((String)o.getSaleOrderStatus()).getDesc());
                }
                catch (Exception e) {
                    logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                    vo.setOrderStatus(o.getSaleOrderStatus());
                }
                try {
                    vo.setOrderType(SaleOrderTypeEnum.enumOf((String)o.getOrderType()).getDesc());
                }
                catch (Exception e) {
                    logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                    vo.setOrderType(o.getOrderType());
                }
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportSaleOrderMonitorReportVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    @Override
    public RestResponse<PageInfo<SaleOrderMonitorReportVO>> getSaleOrderMonitorReportPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleOrderListPageEsParams params) {
        PageInfo respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.querySaleOrderMonitorPage(params));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respVoPageInfo.getList().stream().map(o -> {
            SaleOrderMonitorReportVO vo = new SaleOrderMonitorReportVO();
            BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<SaleOrderCountVO> querySaleOrderMonitorCount(@Valid GetSaleOrderCountParams getSaleOrderCountParams) {
        String[] orderNos;
        String[] split;
        SaleOrderReqDto reqDto = new SaleOrderReqDto();
        BeanUtils.copyProperties((Object)getSaleOrderCountParams, (Object)reqDto, (String[])new String[]{"orderLevelList"});
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getSaleOrderCreateTimeStart())) {
            reqDto.setSaleOrderCreateTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getSaleOrderCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getSaleOrderCreateTimeEnd())) {
            reqDto.setSaleOrderCreateTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getSaleOrderCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getDeliveryTimeEnd())) {
            reqDto.setDeliveryTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getDeliveryTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getDeliveryTimeStart())) {
            reqDto.setDeliveryTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getDeliveryTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getUpdateTimeStart())) {
            reqDto.setUpdateTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getUpdateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getUpdateTimeEnd())) {
            reqDto.setUpdateTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getUpdateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getBizDateStart())) {
            reqDto.setBizDateStart(DateUtil.parse((String)(getSaleOrderCountParams.getBizDateStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getBizDateEnd())) {
            reqDto.setBizDateEnd(DateUtil.parse((String)(getSaleOrderCountParams.getBizDateEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getSaleOrderCountParams.getSaleOrderStatus())) {
            split = getSaleOrderCountParams.getSaleOrderStatus().split(",");
            List<String> saleOrderStatusList = Arrays.asList(split);
            reqDto.setSaleOrderStatus(null);
            reqDto.setSaleOrderStatusList(saleOrderStatusList);
        }
        if (StringUtils.isNotEmpty((CharSequence)getSaleOrderCountParams.getOrderSource())) {
            split = getSaleOrderCountParams.getOrderSource().split(",");
            List orderSourceList = Arrays.asList(split).stream().map(x -> Integer.valueOf(x)).collect(Collectors.toList());
            reqDto.setOrderSource(null);
            reqDto.setOrderSourceList(orderSourceList);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo()) && (orderNos = RptUtil.regExSplit((String)reqDto.getOrderNo())).length > 1) {
            reqDto.setOrderNoList(Arrays.asList(orderNos));
            reqDto.setOrderNo(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getEasOrderNo()) && (orderNos = RptUtil.regExSplit((String)reqDto.getEasOrderNo())).length > 1) {
            reqDto.setEasOrderNoList(Arrays.asList(orderNos));
            reqDto.setEasOrderNo(null);
        }
        reqDto.setOrderLevelList(getSaleOrderCountParams.getOrderLevelList());
        reqDto.setStringCodeResultList(getSaleOrderCountParams.getStringCodeResultList());
        reqDto.setEasVerifyStatusList(getSaleOrderCountParams.getEasVerifyStatusList());
        reqDto.setTagCodeList(getSaleOrderCountParams.getTagCodeList());
        SaleOrderCountRespDto respDto = (SaleOrderCountRespDto)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.querySaleOrderMonitorCount(reqDto));
        SaleOrderCountVO vo = new SaleOrderCountVO();
        if (respDto != null) {
            BeanUtils.copyProperties((Object)respDto, (Object)vo);
        }
        return new RestResponse((Object)vo);
    }
}

