/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.SaleOrderMergeDataMonitorReportVo;
import com.dtyunxi.cis.pms.biz.service.ISaleOrderMergeService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ISaleOrderMergeDataApi;
import com.dtyunxi.tcbj.api.dto.SaleOrderMergeDataDto;
import com.dtyunxi.tcbj.api.dto.SaleOrderMergeDataMonitorDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderResultOfFinanceDetailRespDto;
import com.dtyunxi.tcbj.api.query.IDeliveryResultOrderQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalPsiApi;
import com.dtyunxi.tcbj.center.openapi.common.psi.dto.PSIOrderDto;
import com.dtyunxi.tcbj.center.openapi.common.psi.dto.PSIOrderItemDto;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerOrgPartnerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerOrgPartnerQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_sale_order_merge_monitor")
public class SaleOrderMergeServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ISaleOrderMergeService {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderMergeServiceImpl.class);
    @Resource
    private ISaleOrderMergeDataApi saleOrderMergeDataApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ICustomerOrgPartnerQueryApi customerOrgPartnerQueryApi;
    @Resource
    private IDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;
    @Resource
    private IExternalPsiApi externalPsiApi;

    @Override
    public void pushJXCByPlatformOrder(List<String> platformOrderList) {
        log.info("\u6839\u636e\u5e73\u53f0\u5355\u53f7\u63a8\u9001\u5408\u5355\u636e\u7ed9\u7ecf\u9500\u5b58\uff1a{}", (Object)JSON.toJSONString(platformOrderList));
        SaleOrderMergeDataDto dto = new SaleOrderMergeDataDto();
        dto.setPlatformOrderList(platformOrderList);
        List saleOrderMergeDataDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderMergeDataApi.querySaleOrderMergeDataList(dto));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)saleOrderMergeDataDtoList), "\u65e0\u5408\u5355\u6570\u636e");
        saleOrderMergeDataDtoList.forEach(data -> {
            SaleOrderMergeDataDto pushDto = new SaleOrderMergeDataDto();
            pushDto.setMergeOrder(data.getMergeOrder());
            this.pushJXC(pushDto);
        });
    }

    @Override
    public void pushJXC(SaleOrderMergeDataDto dto) {
        CustomerOrgPartnerRespDto customerOrgChildDto;
        log.info("\u63a8\u9001\u5408\u5355\u636e\u7ed9\u7ecf\u9500\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtil.isFalse(StringUtils.isBlank((CharSequence)dto.getMergeOrder()) && ObjectUtil.isEmpty((Object)dto.getId()), "\u5408\u5355\u5355\u53f7\u4e0eid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.saleOrderMergeDataApi.queryPage(dto));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)pageInfo.getList()), "\u627e\u4e0d\u5230\u5408\u5355\u6570\u636e");
        SaleOrderMergeDataDto saleOrderMergeDataDto = (SaleOrderMergeDataDto)pageInfo.getList().get(0);
        log.info("\u67e5\u8be2\u5408\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderMergeDataDto));
        ArrayList saleOrderRespDtoList = new ArrayList();
        List<String> saleOrderNoList = Arrays.asList(saleOrderMergeDataDto.getSaleOrder().split(","));
        saleOrderNoList.forEach(saleOrderNo -> {
            BizSaleOrderRespDto saleOrder = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(saleOrderNo));
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)saleOrder), "\u627e\u4e0d\u5230\u9500\u552e\u5355\u4fe1\u606f\uff1a" + saleOrderNo);
            saleOrderRespDtoList.add(saleOrder);
        });
        List saleOrderNos = saleOrderRespDtoList.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.toList());
        BizSaleOrderRespDto saleOrder = (BizSaleOrderRespDto)saleOrderRespDtoList.get(0);
        SaleOrderAddrRespDto orderAddr = saleOrder.getOrderAddrRespDto();
        CustomerOrgPartnerRespDto customerOrgDto = null;
        String thirdPartyId = saleOrder.getOrderType().equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType()) ? this.getExtensionValue(saleOrder.getExtension(), "thirdPartyActualId") : this.getExtensionValue(saleOrder.getExtension(), "thirdPartyId");
        if (StringUtils.isBlank((CharSequence)thirdPartyId)) {
            customerOrgDto = (CustomerOrgPartnerRespDto)RestResponseHelper.extractData((RestResponse)this.customerOrgPartnerQueryApi.queryByPartnerId(thirdPartyId));
        }
        String subTenantId = "";
        String disDelearId = this.getExtensionValue(saleOrder.getExtension(), "disDelearId");
        if (StringUtils.isNotBlank((CharSequence)disDelearId) && ObjectUtil.isNotEmpty((Object)(customerOrgChildDto = (CustomerOrgPartnerRespDto)RestResponseHelper.extractData((RestResponse)this.customerOrgPartnerQueryApi.queryByPartnerId(disDelearId))))) {
            subTenantId = customerOrgChildDto.getOrgId();
        }
        PSIOrderDto psiOrderDto = new PSIOrderDto();
        psiOrderDto.setOrderType(saleOrder.getOrderType());
        psiOrderDto.setOtherNumber(saleOrderMergeDataDto.getSaleOrder());
        psiOrderDto.setYxyNumber(saleOrderMergeDataDto.getPlatformOrder());
        psiOrderDto.setOpertime(ObjectUtil.isNotEmpty((Object)saleOrderMergeDataDto.getCreateTime()) ? DateUtils.format((Date)saleOrderMergeDataDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss") : "");
        psiOrderDto.setTenantId(ObjectUtil.isNotEmpty((Object)customerOrgDto) ? customerOrgDto.getOrgId() : null);
        psiOrderDto.setSubTenantId(subTenantId);
        psiOrderDto.setOrganId(this.getExtensionValue(saleOrder.getExtension(), "thirdOrgID"));
        psiOrderDto.setApplyerId(thirdPartyId);
        psiOrderDto.setLessGoodsNumber(saleOrderMergeDataDto.getPlatformOrder());
        psiOrderDto.setCarryNo(saleOrderMergeDataDto.getConsignmentNo());
        psiOrderDto.setRecvContact(orderAddr.getReceiveName());
        psiOrderDto.setRecvTel(orderAddr.getReceivePhone());
        psiOrderDto.setRecvAddr(orderAddr.getReceiveAddress());
        psiOrderDto.setRemark(saleOrder.getSellerRemark());
        psiOrderDto.setEasSaleOrderNo(saleOrder.getEasOrderNo());
        List detailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.queryOrderDetailApportionBySaleOrderNo(saleOrderNos));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)detailRespDtoList), "\u65e0\u5206\u644a\u4fe1\u606f");
        List apportionSaleOrder = detailRespDtoList.stream().map(SaleOrderResultOfFinanceDetailRespDto::getOrderNo).distinct().collect(Collectors.toList());
        AssertUtil.isFalse(apportionSaleOrder.size() != saleOrderNos.size(), "\u5206\u644a\u5355\u636e\u4fe1\u606f\u4e0d\u9f50\u5168");
        Map<String, List<SaleOrderResultOfFinanceDetailRespDto>> groupingDetailMap = detailRespDtoList.stream().collect(Collectors.groupingBy(g -> g.getLongCode() + g.getBatch() + g.getIfGift()));
        ArrayList itemDtoList = new ArrayList();
        groupingDetailMap.forEach((s, list) -> {
            SaleOrderResultOfFinanceDetailRespDto item = (SaleOrderResultOfFinanceDetailRespDto)list.get(0);
            PSIOrderItemDto itemDto = new PSIOrderItemDto();
            itemDto.setId(ObjectUtil.isNotEmpty((Object)item.getDetailItemId()) ? item.getDetailItemId().toString() : null);
            itemDto.setMaterialNo(item.getLongCode());
            itemDto.setHelpCode(item.getCargoCode());
            itemDto.setLot(item.getBatch());
            itemDto.setOperNumber(String.valueOf(list.stream().mapToInt(SaleOrderResultOfFinanceDetailRespDto::getQuantity).sum()));
            itemDto.setMfg(ObjectUtil.isNotEmpty((Object)item.getProduceTime()) ? DateUtils.format((Date)item.getProduceTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
            itemDto.setExp(ObjectUtil.isNotEmpty((Object)item.getExpireTime()) ? DateUtils.format((Date)item.getExpireTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
            itemDto.setTaxRate(ObjectUtil.isNotEmpty((Object)item.getTaxRate()) ? item.getTaxRate().toString() : null);
            itemDto.setTaxPrice(ObjectUtil.isNotEmpty((Object)item.getSalePrice()) ? item.getSalePrice().toString() : null);
            itemDto.setTaxLastMoney(ObjectUtil.isNotEmpty((Object)item.getPayableAmount()) ? list.stream().map(SaleOrderResultOfFinanceDetailRespDto::getPayableAmount).reduce(BigDecimal.ZERO, BigDecimal::add).toString() : null);
            itemDto.setActualTaxPrice(ObjectUtil.isNotEmpty((Object)item.getTransactionPrice()) ? item.getTransactionPrice().toString() : null);
            itemDto.setActualTotalPrice(ObjectUtil.isNotEmpty((Object)item.getActuallyAmount()) ? list.stream().map(SaleOrderResultOfFinanceDetailRespDto::getActuallyAmount).reduce(BigDecimal.ZERO, BigDecimal::add).toString() : null);
            itemDto.setDiscountAmount(ObjectUtil.isNotEmpty((Object)item.getDiscountAmount()) ? list.stream().map(SaleOrderResultOfFinanceDetailRespDto::getDiscountAmount).reduce(BigDecimal.ZERO, BigDecimal::add).toString() : null);
            itemDtoList.add(itemDto);
        });
        psiOrderDto.setItemList(itemDtoList);
        RestResponseHelper.extractData((RestResponse)this.externalPsiApi.createOrder(psiOrderDto));
    }

    @Override
    public PageInfo<SaleOrderMergeDataMonitorDto> queryMonitorPageInfo(SaleOrderMergeDataMonitorDto dto) {
        log.info("\u67e5\u8be2\u9500\u552e\u5408\u5e76\u63a8\u9001\u76d1\u63a7\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.saleOrderMergeDataApi.queryMonitorPageInfo(dto));
        pageInfo.getList().forEach(dataMonitorDto -> {
            if (StringUtils.isNotBlank((CharSequence)dataMonitorDto.getOrderStatus()) && ObjectUtil.isNotEmpty((Object)SaleOrderStatusEnum.forCode((String)dataMonitorDto.getOrderStatus()))) {
                SaleOrderStatusEnum saleOrderStatusEnum = SaleOrderStatusEnum.forCode((String)dataMonitorDto.getOrderStatus());
                dataMonitorDto.setOrderStatus(saleOrderStatusEnum.getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)dataMonitorDto.getOrderType()) && SaleOrderTypeEnum.enumOf((String)dataMonitorDto.getOrderType()) != null) {
                SaleOrderTypeEnum saleOrderTypeEnum = SaleOrderTypeEnum.enumOf((String)dataMonitorDto.getOrderType());
                dataMonitorDto.setOrderType(saleOrderTypeEnum.getDesc());
            }
        });
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.saleOrderMergeDataApi.queryMonitorPageInfo(dto));
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        SaleOrderMergeDataMonitorDto dto = new SaleOrderMergeDataMonitorDto();
        dto = (SaleOrderMergeDataMonitorDto)JSON.parseObject((String)commonReqDto.getFilter(), SaleOrderMergeDataMonitorDto.class);
        dto.setPageNum(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(1));
        PageInfo<SaleOrderMergeDataMonitorDto> pageInfo = this.queryMonitorPageInfo(dto);
        return ParamConverter.convertToInteger((Object)pageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        SaleOrderMergeDataMonitorDto dto = new SaleOrderMergeDataMonitorDto();
        dto = (SaleOrderMergeDataMonitorDto)JSONObject.parseObject((String)commonReqDto.getFilter(), SaleOrderMergeDataMonitorDto.class);
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo<SaleOrderMergeDataMonitorDto> pageInfo = this.queryMonitorPageInfo((SaleOrderMergeDataMonitorDto)re);
            PageInfo reportVoPageInfo = new PageInfo();
            BeanUtils.copyProperties(pageInfo, (Object)reportVoPageInfo);
            if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
                return reportVoPageInfo;
            }
            List reportVoList = BeanUtil.copyToList((Collection)pageInfo.getList(), SaleOrderMergeDataMonitorReportVo.class);
            reportVoList.forEach(reportVo -> {
                if (ObjectUtil.isNotEmpty((Object)reportVo.getCreateTime())) {
                    reportVo.setCreateTimeStr(DateUtil.format((Date)reportVo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (StringUtils.isNotBlank((CharSequence)reportVo.getOrderType()) && SaleOrderTypeEnum.enumOf((String)reportVo.getOrderType()) != null) {
                    reportVo.setOrderType(SaleOrderTypeEnum.enumOf((String)reportVo.getOrderType()).getDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)reportVo.getOrderStatus()) && SaleOrderStatusEnum.forCode((String)reportVo.getOrderStatus()) != null) {
                    reportVo.setOrderStatus(SaleOrderStatusEnum.forCode((String)reportVo.getOrderStatus()).getDesc());
                }
            });
            reportVoPageInfo.setList(reportVoList);
            return reportVoPageInfo;
        }, dto, SaleOrderMergeDataMonitorReportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    private String getExtensionValue(String extension, String key) {
        Map map;
        Object obj;
        log.info("\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5\u6307\u5b9a\u5185\u5bb9\uff1a{}=={}", (Object)key, (Object)JSON.toJSONString((Object)extension));
        if (StringUtils.isNotBlank((CharSequence)extension) && ObjectUtil.isNotEmpty(obj = (map = (Map)JSON.parseObject((String)extension, Map.class)).get(key))) {
            return obj.toString();
        }
        return "";
    }
}

