/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.model.OverChargeRatioVO;
import com.dtyunxi.cis.pms.biz.service.StrategyManagementOverChargeService;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.enums.DictEnum;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class StrategyManagementOverChargeServiceServiceImpl
implements StrategyManagementOverChargeService {
    @Resource
    private IPcpDictApi pcpDictApi;

    @Override
    public RestResponse<Object> addOverchargeRatio(@ApiParam(value="") @Valid @RequestBody(required=false) OverChargeRatioVO overChargeRatioVO) {
        if (Objects.isNull(overChargeRatioVO.getOutsourcedOrderRatio()) && Objects.isNull(overChargeRatioVO.getProductionOrderRatio()) && Objects.isNull(overChargeRatioVO.getPurchaseOrderRatio())) {
            throw new BizException("\u8d85\u6536\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.nonNull(overChargeRatioVO.getOutsourcedOrderRatio())) {
            this.saveDict(DictEnum.OUT_SOURCED_ORDER_RATIO, overChargeRatioVO.getOutsourcedOrderRatio());
        }
        if (Objects.nonNull(overChargeRatioVO.getProductionOrderRatio())) {
            this.saveDict(DictEnum.PRODUCTION_ORDER_RATIO, overChargeRatioVO.getProductionOrderRatio());
        }
        if (Objects.nonNull(overChargeRatioVO.getPurchaseOrderRatio())) {
            this.saveDict(DictEnum.PURCHASE_ORDER_RATIO, overChargeRatioVO.getPurchaseOrderRatio());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<OverChargeRatioVO> getOverchargeRatio(@ApiParam(value="") @Valid @RequestBody(required=false) Object body) {
        OverChargeRatioVO overChargeRatioVO = new OverChargeRatioVO();
        List dictList = (List)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCode("OVER_CHARGE"));
        dictList.stream().forEach(dict -> {
            DictEnum dictEnum = DictEnum.getByDict((DictDto)dict);
            if (Objects.isNull(dict.getValue())) {
                return;
            }
            if (DictEnum.OUT_SOURCED_ORDER_RATIO.equals((Object)dictEnum)) {
                overChargeRatioVO.setOutsourcedOrderRatio(Integer.parseInt(dict.getValue()));
            }
            if (DictEnum.PRODUCTION_ORDER_RATIO.equals((Object)dictEnum)) {
                overChargeRatioVO.setProductionOrderRatio(Integer.parseInt(dict.getValue()));
            }
            if (DictEnum.PURCHASE_ORDER_RATIO.equals((Object)dictEnum)) {
                overChargeRatioVO.setPurchaseOrderRatio(Integer.parseInt(dict.getValue()));
            }
        });
        return new RestResponse((Object)overChargeRatioVO);
    }

    private void saveDict(DictEnum dictEnum, Object val) {
        this.pcpDictApi.saveDict(dictEnum.getGroupCode(), dictEnum.getCode(), val.toString());
    }
}

