/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.EnableEnum;
import com.dtyunxi.cis.pms.biz.export.IExportExcelHelper;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportReportCenterSaleOrderDetailReportVO;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderDetailReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.SaleOrderDetailReportVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSaleOrderDetailReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.request.SaleOrderContrastPageParams;
import com.dtyunxi.cis.search.api.dto.response.SaleOrderCountVo;
import com.dtyunxi.cis.search.api.dto.response.SaleOrderItemRespVo;
import com.dtyunxi.cis.search.api.query.trade.EsSaleOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.SaleOrderContrastPageEsParams;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_sale_order_detail")
public class ReportCenterSaleOrderDetailReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterSaleOrderDetailReportService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterSaleOrderDetailReportServiceServiceImpl.class);
    @Resource
    private EsSaleOrderQueryApi esSaleOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private IExportExcelHelper exportExcelHelper;
    @Resource
    private TradeEsReportQueryApi tradeEsReportQueryApi;

    @Override
    public RestResponse<PageInfo<SaleOrderDetailReportVO>> getSaleOrderDetailReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleOrderDetailReportListPageParams getSaleOrderDetailReportListPageParams) {
        PageInfo reportPage;
        SaleOrderContrastPageEsParams saleOrderContrastPageEsParams;
        SaleOrderContrastPageParams params = new SaleOrderContrastPageParams();
        CubeBeanUtils.copyProperties((Object)params, (Object)getSaleOrderDetailReportListPageParams, (String[])new String[0]);
        params.setOrderNo(getSaleOrderDetailReportListPageParams.getOrderNo());
        params.setOrderStatus(getSaleOrderDetailReportListPageParams.getOrderStatus());
        params.setOrderSource(getSaleOrderDetailReportListPageParams.getOrderSource());
        params.setBatchNo(getSaleOrderDetailReportListPageParams.getBatchNo());
        params.setOrganizationCode(getSaleOrderDetailReportListPageParams.getCargoRightCode());
        params.setItemCode(getSaleOrderDetailReportListPageParams.getGoodsCode());
        params.setWarehouseCode(getSaleOrderDetailReportListPageParams.getDeliveryPhysicalWarehouse());
        params.setStartItemNum(getSaleOrderDetailReportListPageParams.getGoodsTotalNumStart());
        params.setEndItemNum(getSaleOrderDetailReportListPageParams.getGoodsTotalNumEnd());
        params.setStartOutItemNum(getSaleOrderDetailReportListPageParams.getOutWarehouseNumStart());
        params.setEndOutItemNum(getSaleOrderDetailReportListPageParams.getOutWarehouseNumEnd());
        params.setStartVolumeSum(getSaleOrderDetailReportListPageParams.getVolumeStart());
        params.setEndVolumeSum(getSaleOrderDetailReportListPageParams.getVolumeEnd());
        params.setLogicalWarehouse(getSaleOrderDetailReportListPageParams.getLogicalWarehouseName());
        params.setStartSalePrice(getSaleOrderDetailReportListPageParams.getTaxPriceStart());
        params.setEndSalePrice(getSaleOrderDetailReportListPageParams.getTaxPriceEnd());
        params.setStartLineAmount(getSaleOrderDetailReportListPageParams.getTaxTotalAmountStart());
        params.setEndLineAmount(getSaleOrderDetailReportListPageParams.getTaxTotalAmountEnd());
        params.setOrderTypeList(getSaleOrderDetailReportListPageParams.getOrderTypeList());
        params.setOrganizationCodeList(getSaleOrderDetailReportListPageParams.getOrganizationCodeList());
        params.setStartTime(getSaleOrderDetailReportListPageParams.getCreateTimeStart());
        params.setEndTime(getSaleOrderDetailReportListPageParams.getCreateTimeEnd());
        params.setUpdatePerson(getSaleOrderDetailReportListPageParams.getUpdatePerson());
        params.setPageNum(getSaleOrderDetailReportListPageParams.getPageNum());
        params.setPageSize(getSaleOrderDetailReportListPageParams.getPageSize());
        params.setCustomerName(getSaleOrderDetailReportListPageParams.getCustomerName());
        PageInfo respVoPageInfo = new PageInfo();
        if (Objects.equals(getSaleOrderDetailReportListPageParams.getDeliveryStauts(), "delivered")) {
            saleOrderContrastPageEsParams = new SaleOrderContrastPageEsParams();
            CubeBeanUtils.copyProperties((Object)saleOrderContrastPageEsParams, (Object)params, (String[])new String[0]);
            saleOrderContrastPageEsParams.setDeliveryStauts(getSaleOrderDetailReportListPageParams.getDeliveryStauts());
            if (Objects.nonNull(params.getOrderNo())) {
                String[] orderNos = RptUtil.regExSplit((String)params.getOrderNo());
                ArrayList<String> orderNoList = new ArrayList<String>(Arrays.asList(orderNos));
                saleOrderContrastPageEsParams.setOrderNoList(orderNoList);
                saleOrderContrastPageEsParams.setOrderNo(null);
            }
            if (Objects.nonNull(params.getOrderStatus())) {
                String[] orderStatuss = RptUtil.regExSplit((String)params.getOrderStatus());
                ArrayList<String> orderStatusList = new ArrayList<String>(Arrays.asList(orderStatuss));
                saleOrderContrastPageEsParams.setSaleOrderStatusList(orderStatusList);
                saleOrderContrastPageEsParams.setOrderStatus(null);
            }
            if (CollectionUtils.isNotEmpty((Collection)(reportPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.queryOutSaleOrderDetail(saleOrderContrastPageEsParams))).getList())) {
                CubeBeanUtils.copyProperties((Object)respVoPageInfo, (Object)reportPage, (String[])new String[]{"list", "navigatepageNums"});
                List list = reportPage.getList();
                ArrayList itemRespVos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)itemRespVos, (Collection)list, SaleOrderItemRespVo.class);
                respVoPageInfo.setList((List)itemRespVos);
            }
        } else if (this.esQuery.booleanValue()) {
            logger.info("es\u67e5\u8be2");
            respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esSaleOrderQueryApi.querySaleOrderContrast(params));
        } else {
            logger.info("\u62a5\u8868\u67e5\u8be2");
            saleOrderContrastPageEsParams = new SaleOrderContrastPageEsParams();
            CubeBeanUtils.copyProperties((Object)saleOrderContrastPageEsParams, (Object)params, (String[])new String[0]);
            saleOrderContrastPageEsParams.setSaleOrderStatusList(getSaleOrderDetailReportListPageParams.getOrderStatusList());
            saleOrderContrastPageEsParams.setOrderSourceList(getSaleOrderDetailReportListPageParams.getOrderSourceList());
            saleOrderContrastPageEsParams.setOrderLevelList(getSaleOrderDetailReportListPageParams.getOrderLevelList());
            saleOrderContrastPageEsParams.setWarehouseCodeList(getSaleOrderDetailReportListPageParams.getWarehouseCodeList());
            saleOrderContrastPageEsParams.setDeliveryPhysicalWarehouseList(getSaleOrderDetailReportListPageParams.getDeliveryPhysicalWarehouseList());
            saleOrderContrastPageEsParams.setDeliveryTypeList(getSaleOrderDetailReportListPageParams.getDeliveryTypeList());
            saleOrderContrastPageEsParams.setOrganizationCodeList(getSaleOrderDetailReportListPageParams.getOrganizationCodeList());
            reportPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.querySaleOrderDetail(saleOrderContrastPageEsParams));
            if (CollectionUtils.isNotEmpty((Collection)reportPage.getList())) {
                CubeBeanUtils.copyProperties((Object)respVoPageInfo, (Object)reportPage, (String[])new String[]{"list", "navigatepageNums"});
                List list = reportPage.getList();
                ArrayList itemRespVos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)itemRespVos, (Collection)list, SaleOrderItemRespVo.class);
                respVoPageInfo.setList((List)itemRespVos);
            }
        }
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respVoPageInfo.getList().stream().map(o -> {
            SaleOrderDetailReportVO vo = new SaleOrderDetailReportVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setPlatformOrderNo(o.getPlatformOrderNo());
            if (o.getDeliveryTime() != null) {
                vo.setDeliveryTime(o.getDeliveryTime());
            }
            vo.setPlatformOrderId(ParamConverter.convertToString((Object)o.getPlatformOrderId()));
            vo.setSaleOrderNo(o.getSaleOrderNo());
            vo.setOrderStatus(o.getOrderStatus());
            vo.setOrderSource(ParamConverter.convertToString((Object)o.getOrderSource()));
            vo.setCargoRightCode(o.getOrganizationCode());
            vo.setCargoRightName(o.getOrganizationName());
            vo.setDeliveryPhysicalWarehouseName(o.getPhysicsWarehouseName());
            vo.setBatchNo(o.getDeliveryOutBatchNo());
            vo.setGoodsTotalNum(o.getItemNum());
            vo.setVolume(o.getVolume());
            vo.setOutWarehouseNum(o.getOutItemNum());
            vo.setLogicalWarehouseName(o.getLogicalWarehouseName());
            vo.setTaxPrice(o.getSalePrice() == null ? "null" : o.getSalePrice().toString());
            vo.setTaxTotalAmount(o.getLineAmount() == null ? "null" : o.getLineAmount().toString());
            vo.setRemark(o.getRemark());
            vo.setGoodsCode(o.getSkuCode());
            vo.setEasOrderNo(o.getEasOrderNo());
            vo.setGoodsName(o.getItemName());
            vo.setId(o.getId());
            vo.setCreatePerson(o.getCreatePerson());
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (Objects.nonNull(o.getIntegral())) {
                vo.setIsPointGoods(Objects.equals(o.getIntegral(), 1) ? EnableEnum.ENABLE.getCode() : EnableEnum.DISABLE.getCode());
            }
            this.setOrderAddressDto((SaleOrderItemRespVo)o, vo);
            this.setDeliveryAddressDto((SaleOrderItemRespVo)o, vo);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    public void setDeliveryAddressDto(SaleOrderItemRespVo o, SaleOrderDetailReportVO vo) {
        AddressVO deliveryAddress = new AddressVO();
        deliveryAddress.setCity(o.getDeliveryCity());
        deliveryAddress.setCityCode(o.getDeliveryCityCode());
        deliveryAddress.setProvinceCode(o.getDeliveryProvinceCode());
        deliveryAddress.setProvince(o.getDeliveryProvince());
        deliveryAddress.setDistrict(o.getDeliveryDistrict());
        deliveryAddress.setDistrictCode(o.getDeliveryDistrictCode());
        deliveryAddress.setDetailAddress(o.getDeliveryDetailAddress());
        vo.setDeliveryAddress(deliveryAddress);
    }

    public void setOrderAddressDto(SaleOrderItemRespVo o, SaleOrderDetailReportVO vo) {
        AddressVO orderAddress = new AddressVO();
        orderAddress.setCity(o.getCity());
        orderAddress.setCityCode(o.getCityCode());
        orderAddress.setProvinceCode(o.getProvinceCode());
        orderAddress.setProvince(o.getProvince());
        orderAddress.setDistrict(o.getCounty());
        orderAddress.setDistrictCode(o.getCountyCode());
        orderAddress.setDetailAddress(o.getDetailAddress());
        orderAddress.setReceiveName(o.getDeliveryName());
        orderAddress.setReceivePhone(o.getDeliveryPhone());
        vo.setOrderAddress(orderAddress);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetSaleOrderDetailReportListPageParams params = new GetSaleOrderDetailReportListPageParams();
        SaleOrderContrastPageParams query = new SaleOrderContrastPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSaleOrderDetailReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderDetailReportListPageParams.class);
        }
        GetSaleOrderDetailReportListPageParams finalParams = params;
        return this.exportExcelHelper.doBigDataDivideDataExport(req -> {
            PageInfo saleOrderItemRespVoPageInfo = (PageInfo)RestResponseHelper.extractData(this.getSaleOrderDetailReportListPage((GetSaleOrderDetailReportListPageParams)req));
            PageInfo re = new PageInfo();
            BeanUtils.copyProperties((Object)saleOrderItemRespVoPageInfo, (Object)re);
            if (CollectionUtils.isNotEmpty((Collection)saleOrderItemRespVoPageInfo.getList())) {
                re.setList(saleOrderItemRespVoPageInfo.getList().stream().map(o -> {
                    ExportReportCenterSaleOrderDetailReportVO vo = new ExportReportCenterSaleOrderDetailReportVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setSaleOrderNo(o.getSaleOrderNo());
                    try {
                        vo.setOrderStatus(SaleOrderStatusEnum.forCode((String)o.getOrderStatus()).getDesc());
                    }
                    catch (Exception e) {
                        vo.setOrderStatus(o.getOrderStatus());
                    }
                    vo.setOrderSource(SaleOrderSourceEnum.enumOf((Integer)Integer.valueOf(o.getOrderSource())).getDesc());
                    vo.setCargoRightCode(o.getCargoRightCode());
                    vo.setCargoRightName(o.getCargoRightName());
                    vo.setDeliveryPhysicalWarehouseName(o.getDeliveryPhysicalWarehouseName());
                    vo.setItemNum(o.getGoodsTotalNum() == null ? null : o.getGoodsTotalNum().setScale(0, 1));
                    vo.setOutWarehouseNum(o.getOutWarehouseNum() == null ? null : o.getOutWarehouseNum().setScale(0, 1));
                    vo.setLogicalWarehouseName(o.getLogicalWarehouseName());
                    vo.setTaxPrice(o.getTaxPrice() == null ? "" : o.getTaxPrice());
                    vo.setBatchNo(o.getDeliveryOutBatchNo());
                    vo.setCreatePerson(o.getCreatePerson());
                    if (o.getCreateTime() != null) {
                        vo.setCreateTime(o.getCreateTime());
                    }
                    if (o.getUpdateTime() != null) {
                        vo.setUpdateTime(o.getUpdateTime());
                    }
                    if (StringUtils.isNotBlank((CharSequence)o.getOrderType())) {
                        vo.setIsPointGoods(Objects.equals(o.getIntegral(), 1) ? "\u662f" : "\u5426");
                    }
                    vo.setDetailAddress(this.getAddress(o.getOrderAddress()));
                    if (Objects.nonNull(o.getDeliveryAddress())) {
                        vo.setDeliveryCityName(o.getDeliveryAddress().getCity());
                    }
                    if (Objects.nonNull(o.getOrderAddress())) {
                        vo.setOrderProvinceName(o.getOrderAddress().getProvince());
                        vo.setOrderCityName(o.getOrderAddress().getCity());
                    }
                    try {
                        vo.setOrderTypeStr(SaleOrderTypeEnum.enumOf((String)o.getOrderType()).getDesc());
                    }
                    catch (Exception e) {
                        vo.setOrderTypeStr(o.getOrderType());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)finalParams.getIsExportPrice())) {
                        vo.setTaxTotalAmount(finalParams.getIsExportPrice().equals("\u662f") ? o.getTaxTotalAmount().toString() : "0");
                        vo.setTaxPrice(finalParams.getIsExportPrice().equals("\u662f") ? o.getTaxPrice().toString() : "0");
                    }
                    return vo;
                }).collect(Collectors.toList()));
            } else {
                re.setList(new ArrayList(0));
            }
            return re;
        }, params, ExportReportCenterSaleOrderDetailReportVO.class, commonReqDto.getFileName()).stream().collect(Collectors.joining(","));
    }

    private String getAddress(AddressVO o) {
        String province = StringUtils.isNotEmpty((CharSequence)o.getProvince()) ? o.getProvince() : "";
        String city = StringUtils.isNotEmpty((CharSequence)o.getCity()) ? o.getCity() : "";
        String district = StringUtils.isNotEmpty((CharSequence)o.getDistrict()) ? o.getDistrict() : "";
        String detailAddress = StringUtils.isNotEmpty((CharSequence)o.getDetailAddress()) ? o.getDetailAddress() : "";
        return province + city + district + detailAddress;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    private void getParams(GetSaleOrderDetailReportListPageParams params, SaleOrderContrastPageParams query) {
        BeanUtils.copyProperties((Object)params, (Object)query);
        query.setOrderNo(params.getOrderNo());
        query.setOrderStatus(params.getOrderStatus());
        query.setOrderSource(params.getOrderSource());
        query.setBatchNo(params.getBatchNo());
        query.setOrganizationCode(params.getCargoRightCode());
        query.setItemCode(params.getGoodsCode());
        query.setWarehouseCode(params.getDeliveryPhysicalWarehouse());
        query.setStartItemNum(params.getGoodsTotalNumStart());
        query.setEndItemNum(params.getGoodsTotalNumEnd());
        query.setStartOutItemNum(params.getOutWarehouseNumStart());
        query.setEndOutItemNum(params.getOutWarehouseNumEnd());
        query.setStartVolumeSum(params.getVolumeStart());
        query.setEndVolumeSum(params.getVolumeEnd());
        query.setLogicalWarehouse(params.getLogicalWarehouseName());
        query.setStartSalePrice(params.getTaxPriceStart());
        query.setEndSalePrice(params.getTaxPriceEnd());
        query.setStartLineAmount(params.getTaxTotalAmountStart());
        query.setEndLineAmount(params.getTaxTotalAmountEnd());
        query.setOrderTypeList(params.getOrderTypeList());
        query.setStartTime(params.getCreateTimeStart());
        query.setEndTime(params.getCreateTimeEnd());
        query.setUpdatePerson(params.getUpdatePerson());
        query.setPageNum(Integer.valueOf(params.getPageNum() == null ? 1 : params.getPageNum()));
        query.setPageSize(Integer.valueOf(params.getPageSize() == null ? 1 : params.getPageSize()));
    }

    @Override
    public RestResponse<SaleOrderCountVo> querySaleOrderItemByCount(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleOrderDetailReportListPageParams getSaleOrderDetailReportListPageParams) {
        SaleOrderContrastPageParams params = new SaleOrderContrastPageParams();
        CubeBeanUtils.copyProperties((Object)params, (Object)getSaleOrderDetailReportListPageParams, (String[])new String[0]);
        params.setOrderNo(getSaleOrderDetailReportListPageParams.getOrderNo());
        params.setOrderStatus(getSaleOrderDetailReportListPageParams.getOrderStatus());
        params.setOrderSource(getSaleOrderDetailReportListPageParams.getOrderSource());
        params.setBatchNo(getSaleOrderDetailReportListPageParams.getBatchNo());
        params.setOrganizationCode(getSaleOrderDetailReportListPageParams.getCargoRightCode());
        params.setItemCode(getSaleOrderDetailReportListPageParams.getGoodsCode());
        params.setWarehouseCode(getSaleOrderDetailReportListPageParams.getDeliveryPhysicalWarehouse());
        params.setStartItemNum(getSaleOrderDetailReportListPageParams.getGoodsTotalNumStart());
        params.setEndItemNum(getSaleOrderDetailReportListPageParams.getGoodsTotalNumEnd());
        params.setStartOutItemNum(getSaleOrderDetailReportListPageParams.getOutWarehouseNumStart());
        params.setEndOutItemNum(getSaleOrderDetailReportListPageParams.getOutWarehouseNumEnd());
        params.setStartVolumeSum(getSaleOrderDetailReportListPageParams.getVolumeStart());
        params.setEndVolumeSum(getSaleOrderDetailReportListPageParams.getVolumeEnd());
        params.setLogicalWarehouse(getSaleOrderDetailReportListPageParams.getLogicalWarehouseName());
        params.setStartSalePrice(getSaleOrderDetailReportListPageParams.getTaxPriceStart());
        params.setEndSalePrice(getSaleOrderDetailReportListPageParams.getTaxPriceEnd());
        params.setStartLineAmount(getSaleOrderDetailReportListPageParams.getTaxTotalAmountStart());
        params.setEndLineAmount(getSaleOrderDetailReportListPageParams.getTaxTotalAmountEnd());
        params.setOrderTypeList(getSaleOrderDetailReportListPageParams.getOrderTypeList());
        params.setStartTime(getSaleOrderDetailReportListPageParams.getCreateTimeStart());
        params.setEndTime(getSaleOrderDetailReportListPageParams.getCreateTimeEnd());
        params.setUpdatePerson(getSaleOrderDetailReportListPageParams.getUpdatePerson());
        params.setPageNum(getSaleOrderDetailReportListPageParams.getPageNum());
        params.setPageSize(getSaleOrderDetailReportListPageParams.getPageSize());
        SaleOrderCountVo saleOrderCountVo = (SaleOrderCountVo)RestResponseHelper.extractData((RestResponse)this.esSaleOrderQueryApi.querySaleOrderItemByCount(params));
        return new RestResponse((Object)saleOrderCountVo);
    }
}

