/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ApiBillTypeVO;
import com.dtyunxi.cis.pms.biz.model.ApiBusinessTypeVO;
import com.dtyunxi.cis.pms.biz.model.ApiLogVO;
import com.dtyunxi.cis.pms.biz.model.ApiTypeVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetApiLogListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutApiLogVO;
import com.dtyunxi.cis.pms.biz.model.RetryApiParams;
import com.dtyunxi.cis.pms.biz.service.SystemSettingApiLogService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cube.center.track.api.IPcpOpenapiLogApi;
import com.dtyunxi.cube.center.track.api.dto.request.PcpOpenapiLogReqDto;
import com.dtyunxi.cube.center.track.api.dto.request.PcpOpenapiReqDto;
import com.dtyunxi.cube.center.track.api.dto.request.PcpSystemApiLogReqDto;
import com.dtyunxi.cube.center.track.api.dto.response.PcpOpenapiRespDto;
import com.dtyunxi.cube.center.track.api.dto.response.PcpSystemApiLogDataDetailRespDto;
import com.dtyunxi.cube.center.track.api.query.IPcpOpenapiLogQueryApi;
import com.dtyunxi.cube.center.track.api.query.IPcpOpenapiQueryApi;
import com.dtyunxi.cube.component.track.commons.constant.pcp.OpenapiSystemEnum;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_api_log")
public class SystemSettingApiLogServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements SystemSettingApiLogService {
    private static final Logger logger = LoggerFactory.getLogger(SystemSettingApiLogServiceServiceImpl.class);
    @Resource
    private IPcpOpenapiLogApi pcpOpenapiLogApi;
    @Resource
    private IPcpOpenapiLogQueryApi pcpOpenapiLogQueryApi;
    @Resource
    private IPcpOpenapiQueryApi pcpOpenapiQueryApi;

    @Override
    public RestResponse<List<ApiBusinessTypeVO>> getApiBusinessTypeEnum() {
        PcpOpenapiReqDto pcpOpenapiReqDto = new PcpOpenapiReqDto();
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOpenapiQueryApi.queryByPage(JSON.toJSONString((Object)pcpOpenapiReqDto), Integer.valueOf(1), Integer.valueOf(10000)));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            Set set = respDtoPageInfo.getList().stream().map(PcpOpenapiRespDto::getApiBizTypeName).collect(Collectors.toSet());
            List list = set.stream().map(o -> {
                ApiBusinessTypeVO vo = new ApiBusinessTypeVO();
                vo.setBusinessTypeName((String)o);
                return vo;
            }).collect(Collectors.toList());
            return new RestResponse(list);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<ApiLogVO> getApiLogDetail(@ApiParam(value="\u65e5\u5fd7id") @Valid @RequestParam(value="id", required=false) String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PcpSystemApiLogDataDetailRespDto respDto = (PcpSystemApiLogDataDetailRespDto)RestResponseHelper.extractData((RestResponse)this.pcpOpenapiLogQueryApi.queryDataDetailById(Long.valueOf(id)));
        ApiLogVO vo = new ApiLogVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        PcpOpenapiRespDto pcpOpenapiRespDto = respDto.getPcpOpenapiRespDto();
        if (pcpOpenapiRespDto != null) {
            String name = Optional.ofNullable(OpenapiSystemEnum.forCode((String)pcpOpenapiRespDto.getApiSystemCode())).map(OpenapiSystemEnum::getDesc).orElse("");
            vo.setSystemTypeName(name);
            vo.setApiTypeName(pcpOpenapiRespDto.getApiTypeName());
            vo.setBusinessTypeName(pcpOpenapiRespDto.getApiBizTypeName());
            vo.setBillType(pcpOpenapiRespDto.getApiNoType());
            vo.setBillTypeName(pcpOpenapiRespDto.getApiNoTypeName());
            vo.setApiOptType(pcpOpenapiRespDto.getApiOptType());
        }
        vo.setStatusCode(respDto.getHttpCode());
        vo.setLogNo(respDto.getApiBizNo());
        vo.setBillNo(respDto.getApiCode());
        vo.setResult(ParamConverter.convertToString((Object)respDto.getApiStatus()));
        if (respDto.getApiAccessTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getApiAccessTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<ApiLogVO>> getApiLogListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetApiLogListPageParams getApiLogListPageParams) {
        PcpSystemApiLogReqDto reqDto = new PcpSystemApiLogReqDto();
        reqDto.setApiBizNo(getApiLogListPageParams.getBillNo());
        reqDto.setApiSystemCode(getApiLogListPageParams.getSystemType());
        reqDto.setApiBizTypeName(getApiLogListPageParams.getBusinessTypeName());
        reqDto.setApiNoType(getApiLogListPageParams.getBillType());
        reqDto.setApiStatus(ParamConverter.convertToInteger((Object)getApiLogListPageParams.getResult()));
        reqDto.setApiOptType(getApiLogListPageParams.getApiOptType());
        reqDto.setApiThirdBizNo(getApiLogListPageParams.getApiThirdBizNo());
        reqDto.setApiTypeName(getApiLogListPageParams.getApiType());
        if (StringUtils.isNotBlank((CharSequence)getApiLogListPageParams.getCreateTimeStart())) {
            reqDto.setApiAccessTimeStart(DateUtil.parse((String)(getApiLogListPageParams.getCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            reqDto.setApiAccessTimeEnd(DateUtil.parse((String)(getApiLogListPageParams.getCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOpenapiLogQueryApi.queryPcpSystemApiLogPage(JSON.toJSONString((Object)reqDto), getApiLogListPageParams.getPageNum(), getApiLogListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(respDto -> {
            ApiLogVO vo = new ApiLogVO();
            BeanUtils.copyProperties((Object)respDto, (Object)vo);
            PcpOpenapiRespDto pcpOpenapiRespDto = respDto.getPcpOpenapiRespDto();
            if (pcpOpenapiRespDto != null) {
                String name = Optional.ofNullable(OpenapiSystemEnum.forCode((String)pcpOpenapiRespDto.getApiSystemCode())).map(OpenapiSystemEnum::getDesc).orElse("");
                vo.setSystemType(name);
                vo.setSystemTypeName(name);
                vo.setApiTypeName(pcpOpenapiRespDto.getApiTypeName());
                vo.setBillType(pcpOpenapiRespDto.getApiNoType());
                vo.setBillTypeName(pcpOpenapiRespDto.getApiNoTypeName());
                vo.setApiOptType(pcpOpenapiRespDto.getApiOptType());
                vo.setBusinessTypeName(pcpOpenapiRespDto.getApiBizTypeName());
            }
            vo.setLogNo(respDto.getApiCode());
            vo.setBillNo(respDto.getApiBizNo());
            vo.setApiThirdBizNo(respDto.getApiThirdBizNo());
            vo.setResult(ParamConverter.convertToString((Object)respDto.getApiStatus()));
            if (respDto.getApiAccessTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)respDto.getApiAccessTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetApiLogListPageParams params = new GetApiLogListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetApiLogListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetApiLogListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getApiLogListPage((GetApiLogListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                OutApiLogVO vo = new OutApiLogVO();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setApiOptType(Optional.ofNullable(item.getApiOptType()).map(Source -> {
                    switch (Source) {
                        case "REQUESTER": {
                            return "\u63a8\u9001";
                        }
                        case "RECEIVER": {
                            return "\u63a5\u6536";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setResult(Optional.ofNullable(item.getResult()).map(Source -> {
                    switch (Source) {
                        case "1": {
                            return "\u6210\u529f";
                        }
                        case "2": {
                            return "\u5931\u8d25";
                        }
                    }
                    return "";
                }).orElse(""));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutApiLogVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    @Override
    public RestResponse<List<ApiTypeVO>> getApiTypeEnum() {
        PcpOpenapiReqDto pcpOpenapiReqDto = new PcpOpenapiReqDto();
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOpenapiQueryApi.queryByPage(JSON.toJSONString((Object)pcpOpenapiReqDto), Integer.valueOf(1), Integer.valueOf(10000)));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            Set set = respDtoPageInfo.getList().stream().map(PcpOpenapiRespDto::getApiTypeName).collect(Collectors.toSet());
            List list = set.stream().map(o -> {
                ApiTypeVO vo = new ApiTypeVO();
                vo.setApiTypeName((String)o);
                return vo;
            }).collect(Collectors.toList());
            return new RestResponse(list);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<List<ApiBillTypeVO>> getBillTypeEnum() {
        PcpOpenapiReqDto pcpOpenapiReqDto = new PcpOpenapiReqDto();
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOpenapiQueryApi.queryByPage(JSON.toJSONString((Object)pcpOpenapiReqDto), Integer.valueOf(1), Integer.valueOf(10000)));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            Map<String, List<PcpOpenapiRespDto>> listMap = respDtoPageInfo.getList().stream().collect(Collectors.groupingBy(PcpOpenapiRespDto::getApiNoType));
            ArrayList list = new ArrayList();
            listMap.forEach((k, v) -> {
                List billTypeVOS = v.stream().map(o -> {
                    ApiBillTypeVO vo = new ApiBillTypeVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setBillType(o.getApiNoType());
                    vo.setBillTypeName(o.getApiNoTypeName());
                    return vo;
                }).collect(Collectors.toList());
                list.addAll(billTypeVOS);
            });
            return new RestResponse(new ArrayList(list.stream().collect(Collectors.toMap(ApiBillTypeVO::getBillType, Function.identity(), (o, o1) -> o)).values()));
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> retryApi(@ApiParam(value="") @Valid @RequestBody(required=false) RetryApiParams retryApiParams) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pcpOpenapiLogApi.retryPcpOpenapiLog(retryApiParams.getId())));
    }

    @Override
    public RestResponse<Void> ignore(Long id) {
        logger.info("\u5ffd\u7565\u5931\u8d25\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)id));
        PcpSystemApiLogReqDto reqDto = new PcpSystemApiLogReqDto();
        reqDto.setId(id);
        reqDto.setApiStatus(Integer.valueOf(1));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ignore", "yes");
        reqDto.setExtFields(map);
        RestResponseHelper.extractData((RestResponse)this.pcpOpenapiLogApi.modifyPcpOpenapiLog((PcpOpenapiLogReqDto)reqDto));
        return RestResponse.VOID;
    }
}

