/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl.opt;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.OptLogTypeEnum;
import com.dtyunxi.cis.pms.biz.dto.request.OptLogReqDto;
import com.dtyunxi.cis.pms.biz.model.DistributionClueActVo;
import com.dtyunxi.cis.pms.biz.service.IDistributionClueOptService;
import com.dtyunxi.cis.pms.biz.service.opt.AbstractOptLogService;
import com.dtyunxi.cis.pms.biz.service.opt.IOptLogService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributionOptLogServiceImpl
implements AbstractOptLogService {
    private static final Logger logger = LoggerFactory.getLogger(DistributionOptLogServiceImpl.class);
    @Resource
    private IDistributionClueOptService iDistributionClueOptService;
    @Autowired
    private IOptLogService optLogService;

    @Override
    public String getOptLogTypeCode() {
        return OptLogTypeEnum.DISTRIBUTION.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void addOptLog(OptLogReqDto optLogReqDto) {
        String optNo = optLogReqDto.getOptNo();
        if (StringUtils.isEmpty((CharSequence)optNo)) {
            logger.info("\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u65e5\u5fd7\u5355\u636eid\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        DistributionClueActVo sourcingRuleVO = (DistributionClueActVo)((Object)RestResponseHelper.extractData(this.iDistributionClueOptService.queryClueDetailById(Long.valueOf(optNo))));
        if (Objects.isNull((Object)sourcingRuleVO)) {
            logger.info("\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u65e5\u5fd7\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)optNo);
            return;
        }
        optLogReqDto.setSnapshot(JSON.toJSONString((Object)((Object)sourcingRuleVO)));
        this.optLogService.addOptLog(optLogReqDto);
    }
}

