/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportOutOtherReportVo;
import com.dtyunxi.cis.pms.biz.model.GetOtherOutListBody;
import com.dtyunxi.cis.pms.biz.service.ExportOutOtherReportService;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryOtherOutService;
import com.dtyunxi.cis.pms.biz.service.impl.ExportInternalOutOtherDetailReportServiceImpl;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_out_other_report")
public class ExportOutOtherReportServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportOutOtherReportService {
    private static final Logger logger = LoggerFactory.getLogger(ExportInternalOutOtherDetailReportServiceImpl.class);
    @Resource
    private FinishedGoodsInventoryOtherOutService finishedGoodsInventoryOtherOutService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        GetOtherOutListBody params = new GetOtherOutListBody();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetOtherOutListBody)JSON.parseObject((String)commonReqDto.getFilter(), GetOtherOutListBody.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.finishedGoodsInventoryOtherOutService.getOtherOutList((GetOtherOutListBody)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                ExportOutOtherReportVo vo = new ExportOutOtherReportVo();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setTotalCartons(item.getTotalCartons() == null ? "" : item.getTotalCartons().stripTrailingZeros().toPlainString());
                vo.setMergeQuantity(item.getMergeQuantity() == null ? "" : item.getMergeQuantity().stripTrailingZeros().toPlainString());
                vo.setTotalWeight(item.getTotalWeight() == null ? "" : item.getTotalWeight().stripTrailingZeros().toPlainString());
                vo.setTotalVolume(item.getTotalVolume() == null ? "" : item.getTotalVolume().stripTrailingZeros().toPlainString());
                if (ObjectUtil.isNotEmpty((Object)item.getConsigneeAddress())) {
                    vo.setConsigneeAddress(item.getConsigneeAddress().getDetailAddress());
                    vo.setProvince(item.getConsigneeAddress().getProvince());
                    vo.setCity(item.getConsigneeAddress().getCity());
                    vo.setDistrict(item.getConsigneeAddress().getDistrict());
                }
                vo.setTotalOrder(YesOrNoEnum.getDescByCode(item.getTotalOrder()));
                vo.setLogicalWarehouse(item.getLogicalWarehouse().getWarehouseName());
                vo.setBussinessOrderStatus(Optional.ofNullable(item.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_level_one_audit": {
                            return "\u5f85\u4e00\u7ea7\u5ba1\u6838";
                        }
                        case "wait_level_two_audit": {
                            return "\u5f85\u4e8c\u7ea7\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "finish": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "wait_generate_out_notice_order": {
                            return "\u5f85\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355";
                        }
                        case "wait_generate_out_result_order": {
                            return "\u5f85\u751f\u6210\u53d1\u8d27\u7ed3\u679c\u5355";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return "";
                }).orElse(""));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportOutOtherReportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u5bfc\u51fa\u603b\u6570\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        GetOtherOutListBody params = new GetOtherOutListBody();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetOtherOutListBody)JSON.parseObject((String)commonReqDto.getFilter(), GetOtherOutListBody.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.finishedGoodsInventoryOtherOutService.getOtherOutList(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }
}

