/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.model.GetInsuranceCompanyConfigListParams;
import com.dtyunxi.cis.pms.biz.model.InsuranceCompanyConfigVO;
import com.dtyunxi.cis.pms.biz.model.InsuranceCompanyDetailRecordVO;
import com.dtyunxi.cis.pms.biz.model.SumbitInsuranceCompanyConfigParams;
import com.dtyunxi.cis.pms.biz.service.ReportCenterInsuranceCostInsuranceCompanyConfigService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.finance.api.IInsuranceSettingsApi;
import com.dtyunxi.finance.api.dto.request.InsuranceSettingsLogReqDto;
import com.dtyunxi.finance.api.dto.request.InsuranceSettingsReqDto;
import com.dtyunxi.finance.api.dto.response.InsuranceSettingsRespDto;
import com.dtyunxi.finance.api.query.IInsuranceSettingsLogQueryApi;
import com.dtyunxi.finance.api.query.IInsuranceSettingsQueryApi;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class ReportCenterInsuranceCostInsuranceCompanyConfigServiceServiceImpl
implements ReportCenterInsuranceCostInsuranceCompanyConfigService {
    @Resource
    private IInsuranceSettingsApi insuranceSettingsApi;
    @Resource
    private IInsuranceSettingsQueryApi iInsuranceSettingsQueryApi;
    @Resource
    private IInsuranceSettingsLogQueryApi insuranceSettingsLogQueryApi;

    @Override
    public RestResponse<Object> addInsuranceCompanyConfig(@ApiParam(value="") @Valid @RequestBody(required=false) SumbitInsuranceCompanyConfigParams sumbitInsuranceCompanyConfigParams) {
        InsuranceSettingsReqDto insuranceSettingsReqDto = new InsuranceSettingsReqDto();
        insuranceSettingsReqDto.setInsuranceCompanyName(sumbitInsuranceCompanyConfigParams.getInsuranceCompanyName());
        insuranceSettingsReqDto.setRate(sumbitInsuranceCompanyConfigParams.getRate());
        RestResponseHelper.extractData((RestResponse)this.insuranceSettingsApi.addInsuranceSettings(insuranceSettingsReqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> deleteInsuranceCompanyConfig(@ApiParam(value="") @Valid @RequestBody(required=false) GetInsuranceCompanyConfigListParams getInsuranceCompanyConfigListParams) {
        RestResponseHelper.extractData((RestResponse)this.insuranceSettingsApi.removeInsuranceSettings(getInsuranceCompanyConfigListParams.getId()));
        return new RestResponse();
    }

    @Override
    public RestResponse<InsuranceCompanyConfigVO> detailInsuranceCompanyConfig(@NotNull @ApiParam(value="", required=true) @Valid @RequestParam(value="id", required=true) Long id) {
        InsuranceSettingsRespDto insuranceSettingsRespDto = (InsuranceSettingsRespDto)RestResponseHelper.extractData((RestResponse)this.iInsuranceSettingsQueryApi.queryById(id));
        InsuranceCompanyConfigVO insuranceCompanyConfigVO = new InsuranceCompanyConfigVO();
        BeanUtil.copyProperties((Object)insuranceSettingsRespDto, (Object)insuranceCompanyConfigVO, (String[])new String[0]);
        insuranceCompanyConfigVO.setId(insuranceSettingsRespDto.getId());
        insuranceCompanyConfigVO.setInsuranceCompanyName(insuranceSettingsRespDto.getInsuranceName());
        if (insuranceSettingsRespDto.getInsuranceRate() != null) {
            insuranceCompanyConfigVO.setRate(insuranceSettingsRespDto.getInsuranceRate().setScale(3, 1));
        }
        return new RestResponse((Object)insuranceCompanyConfigVO);
    }

    @Override
    public RestResponse<PageInfo<InsuranceCompanyConfigVO>> getInsuranceCompanyConfig(@ApiParam(value="") @Valid @RequestBody(required=false) GetInsuranceCompanyConfigListParams getInsuranceCompanyConfigListParams) {
        InsuranceSettingsReqDto reqDto = new InsuranceSettingsReqDto();
        reqDto.setId(getInsuranceCompanyConfigListParams.getInsuranceCompanyId());
        reqDto.setInsuranceCode(getInsuranceCompanyConfigListParams.getInsuranceCompanyCode());
        reqDto.setInsuranceCompanyName(getInsuranceCompanyConfigListParams.getInsuranceCompanyName());
        PageInfo insuranceSettingsRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iInsuranceSettingsQueryApi.queryByPage(JSONObject.toJSONString((Object)reqDto), getInsuranceCompanyConfigListParams.getPageNum(), getInsuranceCompanyConfigListParams.getPageSize()));
        if (insuranceSettingsRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)insuranceSettingsRespDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)insuranceSettingsRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = insuranceSettingsRespDtoPageInfo.getList().stream().map(o -> {
                InsuranceCompanyConfigVO vo = new InsuranceCompanyConfigVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                if (o.getInsuranceRate() != null) {
                    vo.setRate(o.getInsuranceRate());
                }
                vo.setInsuranceCompanyName(o.getInsuranceName());
                vo.setId(o.getId());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<InsuranceCompanyDetailRecordVO>> getInsuranceCompanyConfigRecord(@ApiParam(value="") @RequestBody(required=false) GetInsuranceCompanyConfigListParams getInsuranceCompanyConfigListParams) {
        InsuranceSettingsLogReqDto reqDto = new InsuranceSettingsLogReqDto();
        reqDto.setSettingsId(getInsuranceCompanyConfigListParams.getId());
        PageInfo InsuranceSettingsLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.insuranceSettingsLogQueryApi.queryByPage(JSONObject.toJSONString((Object)reqDto), getInsuranceCompanyConfigListParams.getPageNum(), getInsuranceCompanyConfigListParams.getPageSize()));
        if (InsuranceSettingsLogRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)InsuranceSettingsLogRespDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)InsuranceSettingsLogRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = InsuranceSettingsLogRespDtoPageInfo.getList().stream().map(o -> {
                InsuranceCompanyDetailRecordVO vo = new InsuranceCompanyDetailRecordVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setUpdateWord(o.getModifyColumn());
                vo.setUpdateBefore(o.getValueBefore());
                vo.setUpdateAfter(o.getValueAfter());
                vo.setUpdatePeason(o.getUpdatePerson());
                vo.setId(o.getId());
                if (o.getUpdateTime() != null) {
                    vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateInsuranceCompanyConfig(@RequestBody GetInsuranceCompanyConfigListParams getInsuranceCompanyConfigListParams) {
        InsuranceSettingsReqDto insuranceSettingsReqDto = new InsuranceSettingsReqDto();
        insuranceSettingsReqDto.setInsuranceCompanyName(getInsuranceCompanyConfigListParams.getInsuranceCompanyName());
        insuranceSettingsReqDto.setRate(getInsuranceCompanyConfigListParams.getRate());
        insuranceSettingsReqDto.setId(getInsuranceCompanyConfigListParams.getId());
        this.insuranceSettingsApi.modifyInsuranceSettings(insuranceSettingsReqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> queryAllInsurance() {
        List dtoList = (List)RestResponseHelper.extractData((RestResponse)this.iInsuranceSettingsQueryApi.queryAllInsurance());
        List VOList = dtoList.stream().map(o -> {
            InsuranceCompanyConfigVO vo = new InsuranceCompanyConfigVO();
            vo.setInsuranceCompanyName(o.getInsuranceName());
            vo.setId(o.getId());
            return vo;
        }).collect(Collectors.toList());
        return new RestResponse(VOList);
    }
}

