/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.LogStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportLockRecordReportVO;
import com.dtyunxi.cis.pms.biz.model.GetLockRecordReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.LockRecordReportVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterInventoryReportLockRecordReportService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LockLogQueryDto;
import com.dtyunxi.tcbj.api.query.ILockOrderQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_lock_record_report")
public class ReportCenterInventoryReportLockRecordReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterInventoryReportLockRecordReportService {
    @Resource
    private ILockOrderQueryApi lockOrderQueryApi;

    @Override
    public RestResponse<PageInfo<LockRecordReportVO>> getLockRecordReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLockRecordReportListPageParams getLockRecordReportListPageParams) {
        LockLogQueryDto dto = new LockLogQueryDto();
        this.getParams(getLockRecordReportListPageParams, dto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.lockOrderQueryApi.queryLogByPage(dto));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            LockRecordReportVO vo = new LockRecordReportVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsName(o.getCargoName());
            vo.setLogicalWarehouseCode(o.getWarehouseCode());
            vo.setLogicalWarehouseName(o.getWarehouseName());
            vo.setCargoRightId(ParamConverter.convertToString((Object)o.getOrganizationId()));
            vo.setCargoRightCode(o.getOrganizationCode());
            vo.setCargoRightName(o.getOrganizationName());
            vo.setOrderType(o.getType());
            vo.setTotalQuantity(o.getCurrentQuantity());
            vo.setLockReason(o.getRemark());
            if (o.getProduceTime() != null) {
                vo.setProduceTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (o.getExpireTime() != null) {
                vo.setExpireTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setStatus(o.getLogStatus());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    private void getParams(GetLockRecordReportListPageParams getLockRecordReportListPageParams, LockLogQueryDto dto) {
        BeanUtils.copyProperties((Object)getLockRecordReportListPageParams, (Object)dto);
        dto.setLongCode(getLockRecordReportListPageParams.getGoodsLongCode());
        dto.setCargoName(getLockRecordReportListPageParams.getGoodsName());
        dto.setWarehouseName(getLockRecordReportListPageParams.getLogicalWarehouseName());
        dto.setOrganizationName(getLockRecordReportListPageParams.getCargoRightName());
        dto.setType(getLockRecordReportListPageParams.getOrderType());
        dto.setBeginCreateTime(getLockRecordReportListPageParams.getCreateTimeStart());
        dto.setEndCreateTime(getLockRecordReportListPageParams.getCreateTimeEnd());
        dto.setLogStatus(getLockRecordReportListPageParams.getStatus());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetLockRecordReportListPageParams params = new GetLockRecordReportListPageParams();
        LockLogQueryDto queryDto = new LockLogQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetLockRecordReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetLockRecordReportListPageParams.class);
            this.getParams(params, queryDto);
        }
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.lockOrderQueryApi.queryLogByPage(queryDto));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetLockRecordReportListPageParams params = new GetLockRecordReportListPageParams();
        LockLogQueryDto queryDto = new LockLogQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetLockRecordReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetLockRecordReportListPageParams.class);
            this.getParams(params, queryDto);
        }
        queryDto.setPageNum(commonReqDto.getPageNum());
        queryDto.setPageSize(commonReqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.lockOrderQueryApi.queryLogByPage(queryDto));
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(o -> {
                ExportLockRecordReportVO vo = new ExportLockRecordReportVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setLogicalWarehouseName(o.getWarehouseName());
                vo.setCargoRightName(o.getOrganizationName());
                vo.setOrderType(o.getType());
                vo.setTotalQuantity(ParamConverter.convertToString((Object)o.getCurrentQuantity()));
                vo.setLockReason(o.getRemark());
                if (o.getProduceTime() != null) {
                    vo.setProduceTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getExpireTime() != null) {
                    vo.setExpireTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getCreateTime() != null) {
                    vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setLogStatus(LogStatusEnum.getStatusByCode(o.getLogStatus()));
                vo.setCreatePerson(o.getCreatePerson());
                vo.setType(Optional.ofNullable(o.getType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    switch (Type2) {
                        case "lock": {
                            return "\u9501\u5b9a\u5e93\u5b58";
                        }
                        case "unlock": {
                            return "\u89e3\u9501\u5e93\u5b58";
                        }
                    }
                    return o.getType();
                }).orElse(""));
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }
}

