/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.enums.BillTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BillGoodsListPageSummaryVO;
import com.dtyunxi.cis.pms.biz.model.GetInventoryBillAbnormalGoodsListParams;
import com.dtyunxi.cis.pms.biz.model.GetInventoryBillGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetInventoryBillGoodsListPageSummaryParams;
import com.dtyunxi.cis.pms.biz.model.InventoryBillGoodsVO;
import com.dtyunxi.cis.pms.biz.model.PostRepairGoodsNumParams;
import com.dtyunxi.cis.pms.biz.model.PutInventoryBillSolveHandUpParams;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsInNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsInResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryDateUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutResultOrderRepairDataDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailQueryDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInNoticeOrderDetailQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInResultOrderDetailQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveNoticeOrderDetailQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveResultOrderDetailQueryDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InventoryCenterBillServiceServiceImpl
implements InventoryCenterBillService {
    private static final Logger log = LoggerFactory.getLogger(InventoryCenterBillServiceServiceImpl.class);
    @Resource
    private ICsDeliveryNoticeOrderQueryApi csDeliveryNoticeOrderQueryApi;
    @Resource
    private ICsDeliveryResultOrderQueryApi csDeliveryResultOrderQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Resource
    private ICsInPlannedOrderApi csInPlannedOrderApi;
    @Resource
    private ICsInPlannedOrderQueryApi csInPlannedOrderQueryApi;
    @Resource
    private ICsInNoticeOrderApi csInNoticeOrderQueryApi;
    @Resource
    private ICsInResultOrderQueryApi csInResultOrderQueryApi;
    @Resource
    private ICsReceiveNoticeOrderQueryApi csReceiveNoticeOrderQueryApi;
    @Resource
    private ICsReceiveResultOrderApi csReceiveResultOrderQueryApi;
    @Resource
    private ICsLogicInventoryExposedApi csLogicInventoryExposedApi;
    @Autowired
    ICsOutResultOrderApi csOutResultOrderApi;

    @Override
    public RestResponse<List<InventoryBillGoodsVO>> getInventoryBillAbnormalGoodsList(GetInventoryBillAbnormalGoodsListParams getInventoryBillAbnormalGoodsListParams) {
        if (StringUtils.isBlank((CharSequence)getInventoryBillAbnormalGoodsListParams.getDocumentNo())) {
            throw new BizException("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List csInResultOrderDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderQueryApi.queryOverchargeDetailByDocumentNo(getInventoryBillAbnormalGoodsListParams.getDocumentNo()));
        if (CollectionUtils.isNotEmpty((Collection)csInResultOrderDetailRespDtos)) {
            List list = csInResultOrderDetailRespDtos.stream().map(o -> {
                InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setBatchNo(o.getBatch());
                vo.setBillGoodsStatus(o.getItemStatus());
                if (CollectionUtils.isNotEmpty((Collection)o.getDetailRespDtoList())) {
                    List<InventoryBillGoodsVO> subList = o.getDetailRespDtoList().stream().map(obj -> {
                        InventoryBillGoodsVO subVo = new InventoryBillGoodsVO();
                        BeanUtils.copyProperties((Object)obj, (Object)subVo);
                        subVo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
                        subVo.setGoodsLongCode(obj.getLongCode());
                        subVo.setGoodsName(obj.getCargoName());
                        subVo.setBatchNo(obj.getBatch());
                        subVo.setBillGoodsStatus(obj.getItemStatus());
                        return subVo;
                    }).collect(Collectors.toList());
                    vo.setList(subList);
                }
                return vo;
            }).collect(Collectors.toList());
            return new RestResponse(list);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<InventoryBillGoodsVO>> getInventoryBillGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInventoryBillGoodsListPageParams getInventoryBillGoodsListPageParams) {
        BillTypeEnum statusByCode = BillTypeEnum.getStatusByCode(getInventoryBillGoodsListPageParams.getType());
        PageInfo pageInfo = new PageInfo();
        switch (statusByCode) {
            case DELIVERY_NOTICE: {
                CsDeliveryNoticeOrderDetailQueryDto queryDto = new CsDeliveryNoticeOrderDetailQueryDto();
                queryDto.setDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo());
                queryDto.setPageNum(getInventoryBillGoodsListPageParams.getPageNum());
                queryDto.setPageSize(getInventoryBillGoodsListPageParams.getPageSize());
                queryDto.setIdentification(getInventoryBillGoodsListPageParams.getIdentification());
                PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csDeliveryNoticeOrderQueryApi.queryDeliveryNoticeOrderDetails(queryDto));
                if (!CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) break;
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List voList = respDtoPageInfo.getList().stream().map(o -> {
                    InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setGoodsLongCode(o.getLongCode());
                    vo.setGoodsId(String.valueOf(o.getCargoId()));
                    vo.setGoodsName(o.getCargoName());
                    vo.setId(o.getId());
                    vo.setBatchNo(o.getBatch());
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(voList);
                break;
            }
            case DELIVERY_RESULT: {
                CsDeliveryResultOrderQueryDto resultOrderQueryDto = new CsDeliveryResultOrderQueryDto();
                resultOrderQueryDto.setDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo());
                resultOrderQueryDto.setPageNum(getInventoryBillGoodsListPageParams.getPageNum());
                resultOrderQueryDto.setPageSize(getInventoryBillGoodsListPageParams.getPageSize());
                resultOrderQueryDto.setIdentification(getInventoryBillGoodsListPageParams.getIdentification());
                PageInfo resultOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryDeliveryResultOrderDetails(resultOrderQueryDto));
                if (!CollectionUtils.isNotEmpty((Collection)resultOrderDetailRespDtoPageInfo.getList())) break;
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)resultOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List voList = resultOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                    InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setGoodsLongCode(o.getLongCode());
                    vo.setGoodsId(String.valueOf(o.getCargoId()));
                    vo.setGoodsName(o.getCargoName());
                    vo.setId(o.getId());
                    vo.setDoneQuantity(o.getQuantity());
                    vo.setBatchNo(o.getBatch());
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(voList);
                break;
            }
            case RECEIVE_NOTICE: {
                CsReceiveNoticeOrderDetailQueryDto csReceiveNoticeOrderDetailQueryDto = new CsReceiveNoticeOrderDetailQueryDto();
                csReceiveNoticeOrderDetailQueryDto.setDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo());
                csReceiveNoticeOrderDetailQueryDto.setPageNum(getInventoryBillGoodsListPageParams.getPageNum());
                csReceiveNoticeOrderDetailQueryDto.setPageSize(getInventoryBillGoodsListPageParams.getPageSize());
                csReceiveNoticeOrderDetailQueryDto.setIdentification(getInventoryBillGoodsListPageParams.getIdentification());
                PageInfo receiveNoticeOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csReceiveNoticeOrderQueryApi.queryReceiveNoticeOrderDetails(csReceiveNoticeOrderDetailQueryDto));
                if (!CollectionUtils.isNotEmpty((Collection)receiveNoticeOrderDetailRespDtoPageInfo.getList())) break;
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)receiveNoticeOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List voList = receiveNoticeOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                    InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setGoodsLongCode(o.getLongCode());
                    vo.setGoodsId(String.valueOf(o.getCargoId()));
                    vo.setGoodsName(o.getCargoName());
                    vo.setBatchNo(o.getBatch());
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(voList);
                break;
            }
            case RECEIVE_RESULT: {
                CsReceiveResultOrderDetailQueryDto csReceiveResultOrderDetailQueryDto = new CsReceiveResultOrderDetailQueryDto();
                csReceiveResultOrderDetailQueryDto.setDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo());
                csReceiveResultOrderDetailQueryDto.setPageNum(getInventoryBillGoodsListPageParams.getPageNum());
                csReceiveResultOrderDetailQueryDto.setPageSize(getInventoryBillGoodsListPageParams.getPageSize());
                csReceiveResultOrderDetailQueryDto.setIdentification(getInventoryBillGoodsListPageParams.getIdentification());
                PageInfo receiveResultOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csReceiveResultOrderQueryApi.queryReceiveResultOrderDetails(csReceiveResultOrderDetailQueryDto));
                if (!CollectionUtils.isNotEmpty((Collection)receiveResultOrderDetailRespDtoPageInfo.getList())) break;
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)receiveResultOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List voList = receiveResultOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                    InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setGoodsLongCode(o.getLongCode());
                    vo.setGoodsId(String.valueOf(o.getCargoId()));
                    vo.setGoodsName(o.getCargoName());
                    vo.setDoneQuantity(o.getQuantity());
                    vo.setBatchNo(o.getBatch());
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(voList);
                break;
            }
            case OUT_NOTICE: {
                CsOutNoticeOrderQueryDto csOutNoticeOrderQueryDto = new CsOutNoticeOrderQueryDto();
                csOutNoticeOrderQueryDto.setDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo());
                csOutNoticeOrderQueryDto.setPageNum(getInventoryBillGoodsListPageParams.getPageNum());
                csOutNoticeOrderQueryDto.setPageSize(getInventoryBillGoodsListPageParams.getPageSize());
                csOutNoticeOrderQueryDto.setIdentification(getInventoryBillGoodsListPageParams.getIdentification());
                PageInfo csOutNoticeOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryDetailByPage(csOutNoticeOrderQueryDto));
                if (!CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderDetailRespDtoPageInfo.getList())) break;
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutNoticeOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List voList = csOutNoticeOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                    InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setGoodsLongCode(o.getLongCode());
                    vo.setGoodsName(o.getCargoName());
                    vo.setId(o.getId());
                    vo.setBatchNo(o.getBatch());
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(voList);
                break;
            }
            case OUT_RESULT: {
                CsOutResultOrderQueryDto csOutResultOrderQueryDto = new CsOutResultOrderQueryDto();
                csOutResultOrderQueryDto.setDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo());
                csOutResultOrderQueryDto.setPageNum(getInventoryBillGoodsListPageParams.getPageNum());
                csOutResultOrderQueryDto.setPageSize(getInventoryBillGoodsListPageParams.getPageSize());
                csOutResultOrderQueryDto.setIdentification(getInventoryBillGoodsListPageParams.getIdentification());
                PageInfo csOutResultOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryDetailByPage(csOutResultOrderQueryDto));
                if (!CollectionUtils.isNotEmpty((Collection)csOutResultOrderDetailRespDtoPageInfo.getList())) break;
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutResultOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                CsOutResultOrderRespDto csOutResultOrderRespDto = (CsOutResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryByDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo()));
                getInventoryBillGoodsListPageParams.setDocumentNo(csOutResultOrderRespDto.getPreOrderNo());
                getInventoryBillGoodsListPageParams.setType("out_notice_order");
                PageInfo info = (PageInfo)RestResponseHelper.extractData(this.getInventoryBillGoodsListPage(getInventoryBillGoodsListPageParams));
                HashMap<String, BigDecimal> goodList = new HashMap<String, BigDecimal>();
                if (CollectionUtils.isNotEmpty((Collection)info.getList())) {
                    Map<String, BigDecimal> map = info.getList().stream().collect(Collectors.toMap(InventoryBillGoodsVO::getBatchNo, InventoryBillGoodsVO::getPlanQuantity, (o1, o2) -> o1));
                    goodList.putAll(map);
                }
                List voList = csOutResultOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                    InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setGoodsLongCode(o.getLongCode());
                    vo.setGoodsId(String.valueOf(o.getCargoId()));
                    vo.setGoodsName(o.getCargoName());
                    vo.setId(o.getId());
                    vo.setDoneQuantity(o.getQuantity());
                    vo.setBatchNo(o.getBatch());
                    vo.setPlanQuantity(goodList.get(o.getBatch()) == null ? new BigDecimal(0) : (BigDecimal)goodList.get(o.getBatch()));
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(voList);
                break;
            }
            case IN_NOTICE: {
                CsInNoticeOrderDetailQueryDto inNoticeOrderDetailQueryDto = new CsInNoticeOrderDetailQueryDto();
                inNoticeOrderDetailQueryDto.setDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo());
                inNoticeOrderDetailQueryDto.setPageNum(getInventoryBillGoodsListPageParams.getPageNum());
                inNoticeOrderDetailQueryDto.setPageSize(getInventoryBillGoodsListPageParams.getPageSize());
                inNoticeOrderDetailQueryDto.setIdentification(getInventoryBillGoodsListPageParams.getIdentification());
                PageInfo inNoticeOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInNoticeOrderQueryApi.queryDetailByPage(inNoticeOrderDetailQueryDto));
                if (!CollectionUtils.isNotEmpty((Collection)inNoticeOrderDetailRespDtoPageInfo.getList())) break;
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inNoticeOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List voList = inNoticeOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                    InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setProduceTime(o.getProduceTime());
                    vo.setExpireTime(o.getExpireTime());
                    vo.setGoodsLongCode(o.getSkuCode());
                    vo.setGoodsName(o.getCargoName());
                    vo.setBatchNo(o.getBatch());
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(voList);
                break;
            }
            case IN_RESULT: {
                CsInResultOrderDetailQueryDto inResultOrderDetailQueryDto = new CsInResultOrderDetailQueryDto();
                inResultOrderDetailQueryDto.setDocumentNo(getInventoryBillGoodsListPageParams.getDocumentNo());
                inResultOrderDetailQueryDto.setPageNum(getInventoryBillGoodsListPageParams.getPageNum());
                inResultOrderDetailQueryDto.setPageSize(getInventoryBillGoodsListPageParams.getPageSize());
                inResultOrderDetailQueryDto.setIdentification(getInventoryBillGoodsListPageParams.getIdentification());
                PageInfo inResultOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInResultOrderQueryApi.queryDetailByPage(inResultOrderDetailQueryDto));
                if (!CollectionUtils.isNotEmpty((Collection)inResultOrderDetailRespDtoPageInfo.getList())) break;
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inResultOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List voList = inResultOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                    InventoryBillGoodsVO vo = new InventoryBillGoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setGoodsLongCode(o.getLongCode());
                    vo.setGoodsId(String.valueOf(o.getCargoId()));
                    vo.setGoodsName(o.getCargoName());
                    vo.setBillGoodsStatus(o.getItemStatus());
                    vo.setBatchNo(o.getBatch());
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(voList);
                break;
            }
        }
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<BillGoodsListPageSummaryVO> getInventoryBillGoodsListPageSummary(@ApiParam(value="") @Valid @RequestBody(required=false) GetInventoryBillGoodsListPageSummaryParams getInventoryBillGoodsListPageSummaryParams) {
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> postRepairGoodsNum(@ApiParam(value="") @Valid @RequestBody(required=false) PostRepairGoodsNumParams postRepairGoodsNumParams) {
        if (StringUtils.isBlank((CharSequence)postRepairGoodsNumParams.getDocumentNo())) {
            throw new BizException("\u5355\u636e\u53f7\u4e0d\u80fd\u4e0d\u7a7a");
        }
        if (CollectionUtils.isEmpty(postRepairGoodsNumParams.getRepairGoodsList())) {
            throw new BizException("\u4fee\u6b63\u4fe1\u606f\u4e0d\u80fd\u4e0d\u7a7a");
        }
        List list = postRepairGoodsNumParams.getRepairGoodsList().stream().map(o -> {
            CsOutResultOrderRepairDataDto detailReqDto = new CsOutResultOrderRepairDataDto();
            detailReqDto.setId(o.getId());
            detailReqDto.setRepairNum(o.getDoneQuantity());
            detailReqDto.setRepairBatch(o.getBatchNo());
            detailReqDto.setExpireTime(o.getExpireTime());
            detailReqDto.setProduceTime(o.getProduceTime());
            return detailReqDto;
        }).collect(Collectors.toList());
        RestResponseHelper.extractData((RestResponse)this.csOutResultOrderApi.repairData(postRepairGoodsNumParams.getDocumentNo(), list));
        RestResponseHelper.extractData((RestResponse)this.csOutResultOrderApi.unhook(postRepairGoodsNumParams.getDocumentNo(), postRepairGoodsNumParams.getRemark()));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> putInventoryBillSolveHandUp(@ApiParam(value="") @Valid @RequestBody(required=false) PutInventoryBillSolveHandUpParams putInventoryBillSolveHandUpParams) {
        if (StringUtils.isBlank((CharSequence)putInventoryBillSolveHandUpParams.getDocumentNo())) {
            throw new BizException("\u5355\u636e\u53f7\u4e0d\u80fd\u4e0d\u7a7a");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOutResultOrderApi.unhook(putInventoryBillSolveHandUpParams.getDocumentNo(), putInventoryBillSolveHandUpParams.getRemark())));
    }

    @Override
    public RestResponse<Boolean> batchUpdateInventoryDate(List<CsInventoryDateUpdateReqDto> inventoryDateUpdateReqDtoList) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csLogicInventoryExposedApi.batchUpdateInventoryDate(inventoryDateUpdateReqDtoList)));
    }
}

