/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.constant.PmsCsShipmentLogisticsTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.LogisticsStatusEnum;
import com.dtyunxi.cis.pms.biz.enums.ReLogisticTypeEnum;
import com.dtyunxi.cis.pms.biz.model.LogisticsCompanyAssociationSettingsListParams;
import com.dtyunxi.cis.pms.biz.model.LogisticsCompanyAssociationSettingsVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterInsuranceCostLogisticsCompanyAssociationSettingsService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.finance.api.ILogisticsSettingsApi;
import com.dtyunxi.finance.api.dto.request.LogisticsSetttingsReqDto;
import com.dtyunxi.finance.api.dto.response.LogisticsSetttingsRespDto;
import com.dtyunxi.finance.api.exception.LogisticRecordStatusEnum;
import com.dtyunxi.finance.api.query.ILogisticsSettingsQueryApi;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ReportCenterInsuranceCostLogisticsCompanyAssociationSettingsServiceServiceImpl
implements ReportCenterInsuranceCostLogisticsCompanyAssociationSettingsService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterInsuranceCostLogisticsCompanyAssociationSettingsServiceServiceImpl.class);
    @Resource
    private ILogisticsSettingsApi logisticsSettingsApi;
    @Resource
    private ILogisticsSettingsQueryApi logisticsSettingsQueryApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;

    @Override
    public RestResponse<PageInfo<Object>> getLogisticsCompanyAssociationSettingsAddPage(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsSetttingsReqDto logisticsSetttingsReqDto) {
        if (StringUtils.isNotBlank((CharSequence)logisticsSetttingsReqDto.getModeOfCarriageCode())) {
            logisticsSetttingsReqDto.setLogisticsTypeName(PmsCsShipmentLogisticsTypeEnum.getDescByType(Integer.valueOf(logisticsSetttingsReqDto.getModeOfCarriageCode())));
        }
        logger.info("\u7269\u6d41\u516c\u53f8\u5173\u8054\u8bbe\u7f6e\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString((Object)logisticsSetttingsReqDto));
        Long result = (Long)RestResponseHelper.extractData((RestResponse)this.logisticsSettingsApi.addLogisticsSetttings(logisticsSetttingsReqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<LogisticsCompanyAssociationSettingsVO> getLogisticsCompanyAssociationSettingsDetailsPage(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsSetttingsReqDto logisticsSetttingsReqDto) {
        LogisticsSetttingsRespDto logisticsSetttingsRespDto = (LogisticsSetttingsRespDto)RestResponseHelper.extractData((RestResponse)this.logisticsSettingsQueryApi.queryById(logisticsSetttingsReqDto.getId()));
        LogisticsCompanyAssociationSettingsVO logisticsCompanyAssociationSettingsVO = new LogisticsCompanyAssociationSettingsVO();
        BeanUtils.copyProperties((Object)logisticsSetttingsRespDto, (Object)logisticsCompanyAssociationSettingsVO);
        logisticsCompanyAssociationSettingsVO.setLogisticsCompany(logisticsSetttingsRespDto.getLogisticsCompany());
        logisticsCompanyAssociationSettingsVO.setLogisticsCode(logisticsSetttingsRespDto.getShipmentEnterpriseCode());
        logisticsCompanyAssociationSettingsVO.setModeOfCarriageType(logisticsSetttingsRespDto.getLogisticsType());
        logisticsCompanyAssociationSettingsVO.setInsuranceCode(logisticsSetttingsRespDto.getInsuranceId().toString());
        logisticsCompanyAssociationSettingsVO.setProductInsuranceDiscount(logisticsSetttingsRespDto.getProductDiscount().toString());
        logisticsCompanyAssociationSettingsVO.setMaterialInsuranceDiscount(logisticsSetttingsRespDto.getMaterialDiscount().toString());
        logisticsCompanyAssociationSettingsVO.setBillQuotaVerify(logisticsSetttingsRespDto.getBillQuotaVerify());
        CsShipmenetEnterpriseRespDto respDto = (CsShipmenetEnterpriseRespDto)this.csShipmenetEnterpriseQueryApi.queryByPrimaryKey(Long.valueOf(logisticsSetttingsRespDto.getShipmentEnterpriseCode())).getData();
        if (respDto != null && respDto.getShipmentEnterpriseName() != null) {
            logisticsCompanyAssociationSettingsVO.setLogisticsCompany(respDto.getShipmentEnterpriseName());
        }
        if (logisticsSetttingsRespDto.getEfffectiveTimeBegin() != null) {
            logisticsCompanyAssociationSettingsVO.setEffectiveStartTime(DateUtil.format((Date)logisticsSetttingsRespDto.getEfffectiveTimeBegin(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (logisticsSetttingsRespDto.getEfffectiveTimeEnd() != null) {
            logisticsCompanyAssociationSettingsVO.setEffectiveEndTime(DateUtil.format((Date)logisticsSetttingsRespDto.getEfffectiveTimeEnd(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (logisticsSetttingsRespDto.getCreateTime() != null) {
            logisticsCompanyAssociationSettingsVO.setCreateTime(DateUtil.format((Date)logisticsSetttingsRespDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (logisticsSetttingsRespDto.getUpdateTime() != null) {
            logisticsCompanyAssociationSettingsVO.setUpdateTime(DateUtil.format((Date)logisticsSetttingsRespDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (logisticsSetttingsRespDto.getInsuranceRate() != null) {
            logisticsCompanyAssociationSettingsVO.setRate(logisticsSetttingsRespDto.getInsuranceRate().toString());
        }
        logisticsCompanyAssociationSettingsVO.setStatus(logisticsSetttingsRespDto.getStatus().toString());
        return new RestResponse((Object)logisticsCompanyAssociationSettingsVO);
    }

    @Override
    public RestResponse<PageInfo<Object>> getLogisticsCompanyAssociationSettingsEditPage(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsSetttingsReqDto logisticsSetttingsReqDto) {
        if (StringUtils.isNotBlank((CharSequence)logisticsSetttingsReqDto.getModeOfCarriageCode())) {
            logisticsSetttingsReqDto.setLogisticsTypeName(PmsCsShipmentLogisticsTypeEnum.getDescByType(Integer.valueOf(logisticsSetttingsReqDto.getModeOfCarriageCode())));
        }
        logger.info("\u7269\u6d41\u516c\u53f8\u5173\u8054\u8bbe\u7f6e\u7f16\u8f91\uff1a{}", (Object)JSON.toJSONString((Object)logisticsSetttingsReqDto));
        RestResponseHelper.extractData((RestResponse)this.logisticsSettingsApi.modifyLogisticsSetttings(logisticsSetttingsReqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<LogisticsCompanyAssociationSettingsVO>> getLogisticsCompanyAssociationSettingsListPage(@ApiParam(value="") @RequestBody(required=false) LogisticsCompanyAssociationSettingsListParams logisticsCompanyAssociationSettingsListParams) {
        LogisticsSetttingsReqDto reqDto = new LogisticsSetttingsReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)logisticsCompanyAssociationSettingsListParams, (String[])new String[0]);
        PageInfo LogisticsSetttingsRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logisticsSettingsQueryApi.queryByPage(JSONObject.toJSONString((Object)reqDto), logisticsCompanyAssociationSettingsListParams.getPageNum(), logisticsCompanyAssociationSettingsListParams.getPageSize()));
        if (LogisticsSetttingsRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)LogisticsSetttingsRespDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)LogisticsSetttingsRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = LogisticsSetttingsRespDtoPageInfo.getList().stream().map(o -> {
                LogisticsCompanyAssociationSettingsVO vo = new LogisticsCompanyAssociationSettingsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                CsShipmenetEnterpriseRespDto respDto = (CsShipmenetEnterpriseRespDto)this.csShipmenetEnterpriseQueryApi.queryByPrimaryKey(Long.valueOf(o.getShipmentEnterpriseCode())).getData();
                if (respDto != null && respDto.getShipmentEnterpriseName() != null) {
                    vo.setLogisticsCompany(respDto.getShipmentEnterpriseName());
                }
                vo.setLogisticsCode(o.getShipmentEnterpriseCode());
                vo.setModeOfCarriageCode(o.getLogisticsType());
                vo.setModeOfCarriageType(ReLogisticTypeEnum.getDescByCode(o.getLogisticsType()));
                vo.setInsuranceCode(o.getInsuranceId().toString());
                vo.setProductInsuranceDiscount(o.getProductDiscount().setScale(3, RoundingMode.DOWN).toString());
                vo.setMaterialInsuranceDiscount(o.getMaterialDiscount().setScale(3, RoundingMode.DOWN).toString());
                if (o.getEfffectiveTimeBegin() != null) {
                    vo.setEffectiveStartTime(DateUtil.format((Date)o.getEfffectiveTimeBegin(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (o.getEfffectiveTimeEnd() != null) {
                    vo.setEffectiveEndTime(DateUtil.format((Date)o.getEfffectiveTimeEnd(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (o.getStatus().equals(LogisticsStatusEnum.INVALID.getStatus())) {
                    vo.setStatus(LogisticRecordStatusEnum.INVALID.getType().toString());
                } else if (o.getEfffectiveTimeBegin() != null && o.getEfffectiveTimeEnd() != null) {
                    vo.setStatus(this.checkStatus(o.getEfffectiveTimeBegin(), o.getEfffectiveTimeEnd()));
                }
                if (o.getInsuranceRate() != null) {
                    vo.setRate(o.getInsuranceRate().toString());
                }
                if (o.getCreateTime() != null) {
                    vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (o.getUpdateTime() != null) {
                    vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setRemark(o.getRemark());
                vo.setModifyRecords(o.getModifyRecords());
                vo.setId(o.getId());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<Object>> getLogisticsCompanyAssociationSettingsTovoidPage(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsSetttingsReqDto logisticsSetttingsReqDto) {
        RestResponseHelper.extractData((RestResponse)this.logisticsSettingsApi.tovoidLogisticsSetttings(logisticsSetttingsReqDto.getId()));
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<Object>> getLogisticsCompanyAssociationSettingsDelete(@Valid LogisticsSetttingsReqDto logisticsSetttingsReqDto) {
        RestResponseHelper.extractData((RestResponse)this.logisticsSettingsApi.removeLogisticsSetttings(logisticsSetttingsReqDto.getId()));
        return new RestResponse();
    }

    private String checkStatus(Date beginTime, Date endTime) {
        Date date = new Date();
        if (date.before(beginTime)) {
            return LogisticRecordStatusEnum.INITIALIZE.getType().toString();
        }
        if (date.after(beginTime) && date.before(endTime)) {
            return LogisticRecordStatusEnum.AMONG.getType().toString();
        }
        return LogisticRecordStatusEnum.FAILURE.getType().toString();
    }
}

