/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.aop;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.annotation.RegenerateTasks;
import com.dtyunxi.cis.pms.biz.dto.request.RegenerateTasksReqDto;
import com.dtyunxi.cis.pms.biz.service.IRegenerateTasksService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RegenerateTasksAop {
    private static final Logger log = LoggerFactory.getLogger(RegenerateTasksAop.class);
    @Resource
    private IRegenerateTasksService tasksService;

    @Pointcut(value="@annotation(com.dtyunxi.cis.pms.biz.annotation.RegenerateTasks)")
    public void regenerateTasks() {
    }

    @Around(value="regenerateTasks()")
    public Object saveTasks(ProceedingJoinPoint joinPoint) {
        Object paramStr;
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        String declaringClassName = targetMethod.getDeclaringClass().getName();
        log.info("\u91cd\u65b0\u751f\u6210\u4efb\u52a1AOP\uff1a{}", (Object)declaringClassName);
        RegenerateTasks annotation = targetMethod.getAnnotation(RegenerateTasks.class);
        RegenerateTasksReqDto tasksReqDto = new RegenerateTasksReqDto();
        tasksReqDto.setClassName(declaringClassName);
        String methodName = joinPoint.getSignature().getName();
        tasksReqDto.setSign(methodName);
        if (Objects.nonNull(annotation)) {
            tasksReqDto.setApiExplained(annotation.apiExplained());
            tasksReqDto.setMenuModule(annotation.menuModule());
        }
        if (Objects.nonNull(args)) {
            paramStr = JSON.toJSONString((Object)args);
            tasksReqDto.setRequestParam((String)paramStr);
        }
        this.save(tasksReqDto);
        try {
            paramStr = joinPoint.proceed();
            return paramStr;
        }
        catch (Throwable throwable) {
            log.error("\u91cd\u65b0\u751f\u6210\u4efb\u52a1\u5f02\u5e38\uff1a" + throwable.getMessage(), throwable);
            throw new BizException("100000", throwable.getMessage());
        }
        finally {
            MDC.remove((String)"regenerate_tasks_id");
        }
    }

    private void save(RegenerateTasksReqDto eo) {
        try {
            Long tasksId = this.tasksService.addRegenerateTasks(eo);
            if (Objects.nonNull(tasksId)) {
                log.info("\u4fdd\u5b58\u4efb\u52a1\u6210\u529f\uff1a{}", (Object)tasksId);
                MDC.put((String)"regenerate_tasks_id", (String)StrUtil.toString((Object)tasksId));
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }
}

