/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.service.IInspectionRegularService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="redisInspectionRegularService")
public class RedisInspectionRegularServiceImpl
implements IInspectionRegularService {
    private static final Logger log = LoggerFactory.getLogger(RedisInspectionRegularServiceImpl.class);
    private final String GROUP = "INSPECTION_REGULAR";
    private final String KEY = "INSPECTION_REGULAR";
    private final String UPDATE_KEY = "INSPECTION_REGULAR_UPDATE";
    private final String SYMBOL = "_SPLIT_";
    @Resource
    private ICacheService cacheService;
    @Resource
    private IContext context;

    @Override
    public List<Long> getAllBeforeInspect() {
        return Optional.ofNullable(this.cacheService.zrange("INSPECTION_REGULAR", "INSPECTION_REGULAR", Long.valueOf(0L), Long.valueOf(-1L))).map(e -> e.stream().map(Long::parseLong).collect(Collectors.toList())).orElse(Lists.newArrayList());
    }

    @Override
    public boolean saveBeforeInspectId(Long id) {
        this.setPerson(id);
        return this.cacheService.zadd("INSPECTION_REGULAR", "INSPECTION_REGULAR", id, String.valueOf(id)) > 0L;
    }

    @Override
    public void batchSaveBeforeInspectIds(List<Long> ids) {
        this.cacheService.zadd("INSPECTION_REGULAR", "INSPECTION_REGULAR", ids.stream().collect(Collectors.toMap(String::valueOf, o -> o)));
        ids.forEach(this::setPerson);
    }

    @Override
    public void setPerson(Long r) {
        log.info("\u4fdd\u5b58\u9884\u653e\u884c\u5f85\u68c0\u8bb0\u5f55id\uff1a{}, \u64cd\u4f5c\u4eba:{}", (Object)r, (Object)this.context.userName());
        this.cacheService.hset("INSPECTION_REGULAR", "INSPECTION_REGULAR_UPDATE", r + "", (Object)(System.currentTimeMillis() + "_SPLIT_" + this.context.userName()));
    }

    @Override
    public Map<Long, TwoTuple<Date, String>> getPersons(List<Long> ids) {
        return ids.stream().map(String::valueOf).collect(Collectors.toMap(Long::parseLong, r -> {
            String update = (String)this.cacheService.hget("INSPECTION_REGULAR", "INSPECTION_REGULAR_UPDATE", r, String.class);
            if (StringUtils.isBlank((CharSequence)update)) {
                return new TwoTuple(null, null);
            }
            String[] split = update.split("_SPLIT_");
            return new TwoTuple((Object)new Date(Long.parseLong(split[0])), (Object)split[1]);
        }));
    }

    @Override
    public Set<Long> getBeforeInspectByIds(List<Long> ids) {
        List<Long> allBeforeInspect = this.getAllBeforeInspect();
        return ids.stream().filter(allBeforeInspect::contains).collect(Collectors.toSet());
    }

    @Override
    public void removeByIds(List<Long> ids) {
        this.cacheService.zrem("INSPECTION_REGULAR", "INSPECTION_REGULAR", ids.stream().map(String::valueOf).collect(Collectors.toList()));
    }

    @Override
    public void removeUpdateByIds(List<Long> ids) {
        this.cacheService.hdel("INSPECTION_REGULAR", "INSPECTION_REGULAR_UPDATE", (String[])ids.stream().map(String::valueOf).toArray(String[]::new));
    }
}

