/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.AreaEnum;
import com.dtyunxi.cis.pms.biz.enums.LevelEnum;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.ExportAreaVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetBaseAreaListPageParams;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterAreaService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ModifyAnnotation;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_area")
public class BasedataCenterAreaServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements BasedataCenterAreaService {
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;

    @Override
    public RestResponse<PageInfo<BaseAreaVO>> getBaseAreaListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetBaseAreaListPageParams getBaseAreaListPageParams) {
        PcpRegionReqDto reqDto = new PcpRegionReqDto();
        if (getBaseAreaListPageParams.getLevel() != null) {
            if (GetBaseAreaListPageParams.LevelEnum.PROVINCE.getValue().equals(getBaseAreaListPageParams.getLevel().getValue())) {
                reqDto.setLevelId(LevelEnum.PROVINCE.getCode());
            }
            if (GetBaseAreaListPageParams.LevelEnum.CITY.getValue().equals(getBaseAreaListPageParams.getLevel().getValue())) {
                reqDto.setLevelId(LevelEnum.CITY.getCode());
            }
            if (GetBaseAreaListPageParams.LevelEnum.DISTRICT.getValue().equals(getBaseAreaListPageParams.getLevel().getValue())) {
                reqDto.setLevelId(LevelEnum.DISTRICT.getCode());
            }
        }
        reqDto.setCode(getBaseAreaListPageParams.getCode());
        reqDto.setName(getBaseAreaListPageParams.getName());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), getBaseAreaListPageParams.getPageNum(), getBaseAreaListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            BaseAreaVO vo = new BaseAreaVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setParentCode(o.getParentCode());
            vo.setLongitude(o.getLocationX());
            vo.setLatitude(o.getLocationY());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<BaseAreaVO>> getBaseAreaTreeByLevel(@ApiParam(value="1:\u7701 2:\u5e02 3:\u533a", required=true) @PathVariable(value="level") String levelStr) {
        List pcpRegionRespDtoList;
        Integer level = 1;
        if (StringUtils.isNumeric((CharSequence)levelStr)) {
            level = Integer.valueOf(levelStr);
        }
        if (CollectionUtils.isNotEmpty((Collection)(pcpRegionRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryAllList())))) {
            List areaEoList = pcpRegionRespDtoList.stream().map(o -> {
                BaseAreaVO vo = new BaseAreaVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setParentCode(o.getParentCode());
                vo.setLongitude(o.getLocationX());
                vo.setLatitude(o.getLocationY());
                return vo;
            }).collect(Collectors.toList());
            ArrayList<BaseAreaVO> areaTreeRespDtoList = new ArrayList<BaseAreaVO>();
            Map<String, List<BaseAreaVO>> areaMap = areaEoList.stream().collect(Collectors.groupingBy(areaEo -> StringUtils.isEmpty((CharSequence)areaEo.getParentCode()) ? "0" : areaEo.getParentCode()));
            CubeBeanUtils.copyCollection(areaTreeRespDtoList, (Collection)areaMap.get("0"), BaseAreaVO.class);
            if (level == 1) {
                return new RestResponse(areaTreeRespDtoList);
            }
            areaMap.remove("0");
            this.getChildArea(areaTreeRespDtoList, areaMap, level > 1 ? level - 1 : 10);
            return new RestResponse(areaTreeRespDtoList);
        }
        return new RestResponse();
    }

    private void getChildArea(List<BaseAreaVO> areaTreeRespDtoList, Map<String, List<BaseAreaVO>> areaMap, Integer level) {
        if (level != 0) {
            areaTreeRespDtoList.forEach(areaTreeDto -> {
                List areaEoList = (List)areaMap.get(areaTreeDto.getCode());
                if (CollectionUtils.isNotEmpty((Collection)areaEoList)) {
                    ArrayList<BaseAreaVO> areaChildrenDtoList = new ArrayList<BaseAreaVO>(areaEoList.size());
                    CubeBeanUtils.copyCollection(areaChildrenDtoList, (Collection)areaEoList, BaseAreaVO.class);
                    areaTreeDto.setChildren(areaChildrenDtoList);
                    areaMap.remove(areaTreeDto.getCode());
                    this.getChildArea(areaChildrenDtoList, areaMap, level - 1);
                }
            });
        }
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetBaseAreaListPageParams getBaseAreaListPageParams = new GetBaseAreaListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            getBaseAreaListPageParams = (GetBaseAreaListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetBaseAreaListPageParams.class);
        }
        PcpRegionReqDto reqDto = new PcpRegionReqDto();
        BeanUtils.copyProperties((Object)getBaseAreaListPageParams, (Object)reqDto);
        if (ModeTypeEnum.AREA_PROVINCE.getKey().equals(commonReqDto.getKey())) {
            reqDto.setLevelId(LevelEnum.PROVINCE.getCode());
        }
        if (ModeTypeEnum.AREA_CITY.getKey().equals(commonReqDto.getKey())) {
            reqDto.setLevelId(LevelEnum.CITY.getCode());
        }
        if (ModeTypeEnum.AREA_DISTRICT.getKey().equals(commonReqDto.getKey())) {
            reqDto.setLevelId(LevelEnum.DISTRICT.getCode());
        }
        ArrayList list = Lists.newArrayList();
        Integer dtoPageSize = commonReqDto.getPageSize();
        Integer dtoPageNum = commonReqDto.getPageNum();
        for (int i = 0; i < dtoPageNum; ++i) {
            Integer pageSize = 10000;
            Integer pageNum = 0 + i * 5;
            if (dtoPageSize <= pageSize) {
                pageNum = 1 + i * 5;
                pageSize = dtoPageSize;
            } else {
                pageNum = dtoPageSize % pageSize > 0 ? Integer.valueOf(dtoPageSize / pageSize + 1 + i * 5) : Integer.valueOf(dtoPageSize / pageSize + i * 5);
            }
            for (int j = 1 + i * 5; j < pageNum + 1; ++j) {
                PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), Integer.valueOf(j), pageSize));
                if (!CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) continue;
                respDtoPageInfo.getList().forEach(o -> {
                    ExportAreaVO vo = new ExportAreaVO();
                    try {
                        ModifyAnnotation.modifyAnnotationName(((Object)((Object)vo)).getClass(), Excel.class, AreaEnum.getFieldByCode(reqDto.getLevelId() * 2), AreaEnum.getDescByCode(reqDto.getLevelId() * 2));
                        ModifyAnnotation.modifyAnnotationName(((Object)((Object)vo)).getClass(), Excel.class, AreaEnum.getFieldByCode(reqDto.getLevelId() * 2 + 1), AreaEnum.getDescByCode(reqDto.getLevelId() * 2 + 1));
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setLongitude(o.getLocationX());
                    vo.setLatitude(o.getLocationY());
                    list.add(vo);
                });
            }
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        PageInfo respDtoPageInfo;
        GetBaseAreaListPageParams getBaseAreaListPageParams = new GetBaseAreaListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            getBaseAreaListPageParams = (GetBaseAreaListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetBaseAreaListPageParams.class);
        }
        PcpRegionReqDto reqDto = new PcpRegionReqDto();
        BeanUtils.copyProperties((Object)getBaseAreaListPageParams, (Object)reqDto);
        if (ModeTypeEnum.AREA_PROVINCE.getKey().equals(commonReqDto.getKey())) {
            reqDto.setLevelId(LevelEnum.PROVINCE.getCode());
        }
        if (ModeTypeEnum.AREA_CITY.getKey().equals(commonReqDto.getKey())) {
            reqDto.setLevelId(LevelEnum.CITY.getCode());
        }
        if (ModeTypeEnum.AREA_DISTRICT.getKey().equals(commonReqDto.getKey())) {
            reqDto.setLevelId(LevelEnum.DISTRICT.getCode());
        }
        if (CollectionUtils.isEmpty((Collection)(respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), Integer.valueOf(1), Integer.valueOf(1)))).getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }

    @Override
    public List<BaseAreaVO> getAreaList() {
        return this.getArea();
    }

    private List<BaseAreaVO> getArea() {
        List pcpRegionRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryAllList());
        if (CollectionUtil.isEmpty((Collection)pcpRegionRespDtoList)) {
            return null;
        }
        List areaEoList = pcpRegionRespDtoList.stream().map(o -> {
            BaseAreaVO vo = new BaseAreaVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setParentCode(o.getParentCode());
            vo.setLongitude(o.getLocationX());
            vo.setLatitude(o.getLocationY());
            return vo;
        }).collect(Collectors.toList());
        ArrayList<BaseAreaVO> areaTreeRespDtoList = new ArrayList<BaseAreaVO>();
        Map<String, List<BaseAreaVO>> areaMap = areaEoList.stream().collect(Collectors.groupingBy(areaEo -> StringUtils.isEmpty((CharSequence)areaEo.getParentCode()) ? "0" : areaEo.getParentCode()));
        CubeBeanUtils.copyCollection(areaTreeRespDtoList, (Collection)areaMap.get("0"), BaseAreaVO.class);
        areaMap.remove("0");
        this.getChildArea(areaTreeRespDtoList, areaMap, 2);
        return areaTreeRespDtoList;
    }
}

