/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportSortingCostChargingReportVO;
import com.dtyunxi.cis.pms.biz.service.ExpressCostOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ISortingExpenseChargingApi;
import com.dtyunxi.tcbj.api.dto.SortingExpenseChargingReportDto;
import com.dtyunxi.tcbj.api.dto.SortingExpenseChargingReportPageReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.util.ParamConverter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_sorting_expense_charging_place_report")
public class ReportSortingExpenseChargingPlaceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExpressCostOrderService {
    private static final Logger log = LoggerFactory.getLogger(ReportSortingExpenseChargingPlaceServiceImpl.class);
    @Resource
    private ISortingExpenseChargingApi sortingExpenseChargingApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        AtomicReference<String> errorMsg = new AtomicReference<String>("");
        ArrayList<Long> waitPlaceIdList = new ArrayList<Long>();
        List<String> urls = null;
        this.getDate(commonReqDto);
        SortingExpenseChargingReportPageReqDto queryDto = new SortingExpenseChargingReportPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            queryDto = (SortingExpenseChargingReportPageReqDto)JSON.parseObject((String)commonReqDto.getFilter(), SortingExpenseChargingReportPageReqDto.class);
        }
        log.info("\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u603b\u6570\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        try {
            urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
                log.info("\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)re));
                PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sortingExpenseChargingApi.page(re));
                log.info("\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u7b2c {} \u9875 {} \u6761\u6570\u636e", (Object)re.getPageNum(), (Object)dtoPageInfo.getSize());
                PageInfo pageInfo = new PageInfo();
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List<Object> list = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
                    list = dtoPageInfo.getList().stream().map(info -> {
                        ExportSortingCostChargingReportVO reportVO = new ExportSortingCostChargingReportVO();
                        this.setExportSortingCostReportVO((SortingExpenseChargingReportDto)info, reportVO);
                        return reportVO;
                    }).collect(Collectors.toList());
                    waitPlaceIdList.addAll(dtoPageInfo.getList().stream().map(BaseDto::getId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                pageInfo.setList(list);
                return pageInfo;
            }, queryDto, ExportSortingCostChargingReportVO.class, commonReqDto.getFileName());
            AssertUtil.isFalse(CollectionUtils.isEmpty(urls), "\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff0c\u6ca1\u6709\u751f\u6210\u6587\u4ef6\u94fe\u63a5");
        }
        catch (Exception e) {
            errorMsg.set("\u5bfc\u51fa\u6267\u884c\u5931\u8d25:" + e.getMessage());
            log.error("\u5bfc\u51fa\u6267\u884c\u5931\u8d25", (Throwable)e);
            throw e;
        }
        finally {
            this.placeCallBack(commonReqDto, errorMsg, String.join((CharSequence)",", urls), waitPlaceIdList, list -> {
                try {
                    FeeReportPlaceUpdateReqDto feeReportPlaceUpdateReqDto = new FeeReportPlaceUpdateReqDto();
                    feeReportPlaceUpdateReqDto.setModuleRecordIdList(waitPlaceIdList);
                    feeReportPlaceUpdateReqDto.setPlacedFlag(Integer.valueOf(1));
                    log.info("\u66f4\u65b0\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)waitPlaceIdList.size());
                    this.sortingExpenseChargingApi.updatePlaceStatus(feeReportPlaceUpdateReqDto);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    errorMsg.set("\u66f4\u65b0\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        return String.join((CharSequence)",", urls);
    }

    private void setExportSortingCostReportVO(SortingExpenseChargingReportDto reportDto, ExportSortingCostChargingReportVO vo) {
        BeanUtils.copyProperties((Object)reportDto, (Object)((Object)vo));
        if (null != reportDto.getAdjustType()) {
            vo.setAdjustType(reportDto.getAdjustType().equals(1L) ? "\u589e\u52a0" : "\u51cf\u5c11");
        }
        vo.setWmsConsignmentNo(Optional.ofNullable(reportDto.getConsignmentNo()).orElse(""));
        vo.setInxId(reportDto.getId());
        if (StringUtils.isNotBlank((CharSequence)reportDto.getBusinessType())) {
            vo.setBusinessType(ExpressBusinessTypeEnum.getNameByType(reportDto.getBusinessType()));
        }
        this.setNumberType(vo, reportDto);
    }

    private void setNumberType(ExportSortingCostChargingReportVO vo, SortingExpenseChargingReportDto o) {
        try {
            vo.setOutQuantity(Long.valueOf(o.getOutQuantity()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setPackageNum(Long.valueOf(o.getPackageNum()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setLargeBox(Long.valueOf(o.getLargeBox()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setSmallBox(Long.valueOf(o.getSmallBox()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setNumber(Long.valueOf(o.getNumber()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setSmallPackageNum(Long.valueOf(o.getSmallPackageNum()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setPlatformAdjustAmount(new BigDecimal(o.getPlatformAdjustAmount()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            vo.setTotalSortingFee(new BigDecimal(o.getTotalSortingFee()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        this.getDate(commonReqDto);
        SortingExpenseChargingReportPageReqDto queryDto = new SortingExpenseChargingReportPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            queryDto = (SortingExpenseChargingReportPageReqDto)JSON.parseObject((String)commonReqDto.getFilter(), SortingExpenseChargingReportPageReqDto.class);
        }
        queryDto.setPageSize(Integer.valueOf(1));
        queryDto.setPageNum(Integer.valueOf(1));
        PageInfo sortingCostReportRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sortingExpenseChargingApi.page(queryDto));
        List list = sortingCostReportRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }

    private void getDate(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode outerJsonNode = objectMapper.readTree(filter);
            JsonNode paramsNode = outerJsonNode.path("params");
            if (!paramsNode.isTextual()) {
                log.error("params \u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u5b57\u7b26\u4e32");
                return;
            }
            JsonNode innerParamsNode = objectMapper.readTree(paramsNode.asText());
            String time = innerParamsNode.path("placedFlagDate").asText();
            if (time == null || time.trim().isEmpty()) {
                log.error("placedFlagDate\u5b57\u6bb5\u4e0d\u5b58\u5728");
                return;
            }
            LocalDate yearMonth = LocalDate.parse(time + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate firstDayOfMonth = yearMonth.withDayOfMonth(1);
            LocalDate lastDayOfMonth = yearMonth.withDayOfMonth(yearMonth.lengthOfMonth());
            ((ObjectNode)outerJsonNode).put("outWarehouseStartTime", String.valueOf(firstDayOfMonth));
            ((ObjectNode)outerJsonNode).put("outWarehouseEndTime", String.valueOf(lastDayOfMonth));
            commonReqDto.setFilter(outerJsonNode.toString());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790JSON\u5931\u8d25", (Throwable)e);
        }
    }
}

