/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.pdf;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.pdf.IDocxToPdfHelper;
import com.dtyunxi.cis.pms.biz.pdf.dto.DocxToPdfReqDto;
import com.dtyunxi.cis.pms.biz.utils.QrUtils;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.util.SpringBeanUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.docx4j.Docx4J;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.finders.ClassFinder;
import org.docx4j.finders.RangeFinder;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class DocxToPdfHelperImpl
implements IDocxToPdfHelper {
    private static final Logger log = LoggerFactory.getLogger(DocxToPdfHelperImpl.class);
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private Environment environment;

    @Override
    public File executeToFile(DocxToPdfReqDto reqDto, InputStream inputStream, String targetFile) throws Exception {
        WordprocessingMLPackage template;
        log.info("\u6267\u884c\u8f6cPDF\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (this.isLocalEnviroment()) {
            String name = this.isFinancialOrder(reqDto.getOrderType()) ? Objects.requireNonNull(DocxToPdfHelperImpl.class.getResource("/TpFinancialOrder.docx")).getPath() : Objects.requireNonNull(DocxToPdfHelperImpl.class.getResource("/TpShippingOrder.docx")).getPath();
            log.info("\u8bfb\u7684\u662f\u672c\u5730\u7684\u6a21\u677f\u6587\u4ef6\uff0c\u975eOSS\u7684\u6a21\u677f\u6587\u4ef6");
            template = this.getTemplate(name);
        } else {
            template = this.getTemplate(inputStream);
        }
        this.executeParams(template, reqDto);
        return this.writeDocxToStream(template, targetFile);
    }

    private boolean isFinancialOrder(Integer orderType) {
        return ObjectUtil.isNotEmpty((Object)orderType) && orderType == 2;
    }

    @Override
    public void executeToFile(DocxToPdfReqDto reqDto, String sourceFile, String targetFile) throws Exception {
        WordprocessingMLPackage template = this.getTemplate(sourceFile);
        this.executeParams(template, reqDto);
        this.writeDocxToStream(template, targetFile);
    }

    private void executeParams(WordprocessingMLPackage mlPackage, DocxToPdfReqDto reqDto) throws Exception {
        DocxToPdfHelperImpl.replaceListDynamic(mlPackage, reqDto);
        this.replacePlaceholder(mlPackage, reqDto.getParams());
        this.replaceLabelBookmark(mlPackage, reqDto.getQrParams(), reqDto.getGzParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertDocxToPDF(WordprocessingMLPackage mlPackage, OutputStream os) throws Exception {
        try {
            IdentityPlusMapper fontMapper = new IdentityPlusMapper();
            if (PhysicalFonts.get((String)"SimSun") == null) {
                log.info("\u6dfb\u52a0SimSun");
                PhysicalFonts.addPhysicalFonts((String)"SimSun", (URL)DocxToPdfHelperImpl.class.getResource("/fonts/simsun.ttc"));
            }
            fontMapper.put("\u96b6\u4e66", PhysicalFonts.get((String)"LiSu"));
            fontMapper.put("\u5b8b\u4f53", PhysicalFonts.get((String)"SimSun"));
            fontMapper.put("\u5fae\u8f6f\u96c5\u9ed1", PhysicalFonts.get((String)"Microsoft Yahei"));
            fontMapper.put("\u9ed1\u4f53", PhysicalFonts.get((String)"SimHei"));
            fontMapper.put("\u6977\u4f53", PhysicalFonts.get((String)"KaiTi"));
            fontMapper.put("\u65b0\u5b8b\u4f53", PhysicalFonts.get((String)"NSimSun"));
            fontMapper.put("\u534e\u6587\u884c\u6977", PhysicalFonts.get((String)"STXingkai"));
            fontMapper.put("\u534e\u6587\u4eff\u5b8b", PhysicalFonts.get((String)"STFangsong"));
            fontMapper.put("\u4eff\u5b8b", PhysicalFonts.get((String)"FangSong"));
            fontMapper.put("\u5e7c\u5706", PhysicalFonts.get((String)"YouYuan"));
            fontMapper.put("\u534e\u6587\u5b8b\u4f53", PhysicalFonts.get((String)"STSong"));
            fontMapper.put("\u534e\u6587\u4e2d\u5b8b", PhysicalFonts.get((String)"STZhongsong"));
            fontMapper.put("\u7b49\u7ebf", PhysicalFonts.get((String)"SimSun"));
            fontMapper.put("\u7b49\u7ebf Light", PhysicalFonts.get((String)"SimSun"));
            fontMapper.put("\u534e\u6587\u7425\u73c0", PhysicalFonts.get((String)"STHupo"));
            fontMapper.put("\u534e\u6587\u96b6\u4e66", PhysicalFonts.get((String)"STLiti"));
            fontMapper.put("\u534e\u6587\u65b0\u9b4f", PhysicalFonts.get((String)"STXinwei"));
            fontMapper.put("\u534e\u6587\u5f69\u4e91", PhysicalFonts.get((String)"STCaiyun"));
            fontMapper.put("\u65b9\u6b63\u59da\u4f53", PhysicalFonts.get((String)"FZYaoti"));
            fontMapper.put("\u65b9\u6b63\u8212\u4f53", PhysicalFonts.get((String)"FZShuTi"));
            fontMapper.put("\u534e\u6587\u7ec6\u9ed1", PhysicalFonts.get((String)"STXihei"));
            fontMapper.put("\u5b8b\u4f53\u6269\u5c55", PhysicalFonts.get((String)"simsun-extB"));
            fontMapper.put("\u4eff\u5b8b_GB2312", PhysicalFonts.get((String)"FangSong_GB2312"));
            fontMapper.put("\u65b0\u7d30\u660e\u9ad4", PhysicalFonts.get((String)"SimSun"));
            PhysicalFonts.put((String)"PMingLiU", (PhysicalFont)PhysicalFonts.get((String)"SimSun"));
            PhysicalFonts.put((String)"\u65b0\u7d30\u660e\u9ad4", (PhysicalFont)PhysicalFonts.get((String)"SimSun"));
            PhysicalFont simsunFont = PhysicalFonts.get((String)"SimSun");
            fontMapper.put("SimSun", simsunFont);
            mlPackage.setFontMapper((Mapper)fontMapper);
            FOSettings foSettings = Docx4J.createFOSettings();
            foSettings.setWmlPackage((OpcPackage)mlPackage);
            Docx4J.save((WordprocessingMLPackage)mlPackage, (OutputStream)os);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    private WordprocessingMLPackage getTemplate(String name) throws Exception {
        return WordprocessingMLPackage.load((InputStream)Files.newInputStream(new File(name).toPath(), new OpenOption[0]));
    }

    private WordprocessingMLPackage getTemplate(InputStream inputStream) throws Exception {
        return WordprocessingMLPackage.load((InputStream)inputStream);
    }

    private File writeDocxToStream(WordprocessingMLPackage template, String target) throws Exception {
        File file = new File(target);
        OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        this.convertDocxToPDF(template, os);
        return file;
    }

    private List<Object> getAllElementFromObject(Object obj, Class<?> toSearch) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (obj instanceof JAXBElement) {
            obj = ((JAXBElement)obj).getValue();
        }
        if (obj.getClass().equals(toSearch)) {
            result.add(obj);
        } else if (obj instanceof ContentAccessor) {
            List children = ((ContentAccessor)obj).getContent();
            for (Object child : children) {
                result.addAll(this.getAllElementFromObject(child, toSearch));
            }
        }
        return result;
    }

    private void replacePlaceholder(WordprocessingMLPackage template, Map<String, String> params) throws Exception {
        DocxToPdfHelperImpl.cleanDocumentPart(template.getMainDocumentPart());
        MainDocumentPart documentPart = template.getMainDocumentPart();
        documentPart.variableReplace(params);
        List sectionWrappers = template.getDocumentModel().getSections();
        HeaderPart headerPart = ((SectionWrapper)sectionWrappers.get(0)).getHeaderFooterPolicy().getDefaultHeader();
        ClassFinder find1 = new ClassFinder(P.class);
        new TraversalUtil((Object)headerPart, (TraversalUtil.Callback)find1);
        List ps = find1.results;
        for (Object o : ps) {
            String textStr;
            String pstr;
            P p = (P)o;
            if (p == null || p.getContent().isEmpty() || !(pstr = p.toString()).contains("$") || !StringUtils.isNotBlank((CharSequence)(textStr = params.get(pstr = pstr.replace("$", "").replace("{", "").replace("}", "")) == null ? "" : params.get(pstr)))) continue;
            ObjectFactory factory = Context.getWmlObjectFactory();
            Text text = factory.createText();
            text.setValue(textStr);
            R r = p.getContent().stream().filter(obj -> obj instanceof R).map(obj -> (R)obj).findFirst().get();
            List objList = p.getContent();
            ArrayList removeObjs = new ArrayList();
            for (Object obj2 : objList) {
                if (obj2 == r) continue;
                removeObjs.add(obj2);
            }
            p.getContent().removeAll(removeObjs);
            r.getContent().remove(0);
            r.getContent().add(text);
        }
    }

    private String cutStr(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && value.contains("{{") && value.contains("}}")) {
            return value.substring(value.indexOf("{{") + 2, value.indexOf("}}"));
        }
        return value;
    }

    public static boolean cleanDocumentPart(MainDocumentPart documentPart) throws Exception {
        if (documentPart == null) {
            return false;
        }
        Document document = (Document)documentPart.getContents();
        String wmlTemplate = XmlUtils.marshaltoString((Object)document, (boolean)true, (boolean)false, (JAXBContext)Context.jc);
        document = (Document)XmlUtils.unwrap((Object)DocxVariableClearUtils.doCleanDocumentPart(wmlTemplate, Context.jc));
        documentPart.setContents((Object)document);
        return true;
    }

    private static void replaceListDynamic(WordprocessingMLPackage template, DocxToPdfReqDto reqDto) throws Exception {
        ClassFinder find = new ClassFinder(Tbl.class);
        new TraversalUtil((Object)template.getMainDocumentPart().getContent(), (TraversalUtil.Callback)find);
        Integer formRetain = reqDto.getFormRetain();
        Tbl table = (Tbl)find.results.get(0);
        Integer formInitial = reqDto.getFormInitial();
        Tr dynamicTr = (Tr)table.getContent().get(formInitial);
        ObjectFactory factory = Context.getWmlObjectFactory();
        ArrayList<Tr> list = new ArrayList<Tr>();
        List<Map<String, String>> mapList = reqDto.getFormParamsList();
        Map<String, List<Map<String, String>>> mergeParams = reqDto.getMergeParams();
        List<String> mergeKeys = reqDto.getMergeKeys();
        for (Map<String, String> map : mapList) {
            String key = map.get("dCode") + map.get("dBatch");
            List<Map<String, String>> mergeTrList = mergeParams.get(key);
            if (CollectionUtils.isNotEmpty(mergeTrList)) {
                map.put("dPro", "-");
                map.put("dExp", "-");
                DocxToPdfHelperImpl.addTr(dynamicTr, factory, list, map, mergeKeys, "restart");
                for (int i = 0; i < mergeTrList.size(); ++i) {
                    Map<String, String> mergeTrParam = mergeTrList.get(i);
                    if (i == mergeTrList.size() - 1) {
                        DocxToPdfHelperImpl.addTr(dynamicTr, factory, list, mergeTrParam, mergeKeys, "close");
                        continue;
                    }
                    DocxToPdfHelperImpl.addTr(dynamicTr, factory, list, mergeTrParam, mergeKeys, "");
                }
                continue;
            }
            DocxToPdfHelperImpl.addTr(dynamicTr, factory, list, map, mergeKeys, null);
        }
        table.getContent().remove(dynamicTr);
        table.getContent().addAll(formInitial, list);
    }

    private static void addTr(Tr dynamicTr, ObjectFactory factory, List<Tr> list, Map<String, String> map, List<String> mergeKeys, String mergeVal) {
        Tr newtr = (Tr)XmlUtils.deepCopy((Object)dynamicTr);
        List cells = newtr.getContent();
        for (int j = 0; j < cells.size(); ++j) {
            JAXBElement jaxbElement = (JAXBElement)cells.get(j);
            Tc tc = (Tc)jaxbElement.getValue();
            P p = (P)tc.getContent().get(0);
            String textStr = p.toString();
            R r = p.getContent().stream().filter(obj -> obj instanceof R).map(obj -> (R)obj).findFirst().get();
            List objList = p.getContent();
            ArrayList removeObjs = new ArrayList();
            for (Object obj2 : objList) {
                if (obj2 == r) continue;
                removeObjs.add(obj2);
            }
            p.getContent().removeAll(removeObjs);
            Text text = factory.createText();
            textStr = textStr.replace("$", "").replace("{", "").replace("}", "");
            String cellStr = map.get(textStr) == null ? "" : map.get(textStr);
            text.setValue(cellStr);
            if (CollectionUtils.isNotEmpty(mergeKeys) && mergeKeys.contains(textStr)) {
                DocxToPdfHelperImpl.setCellVMerge(tc, mergeVal);
            } else {
                DocxToPdfHelperImpl.setCellVMerge(tc, null);
            }
            r.getContent().remove(0);
            r.getContent().add(text);
            jaxbElement.setValue((Object)tc);
            newtr.getContent().set(j, jaxbElement);
        }
        list.add(newtr);
    }

    private static void replaceListPlaceholder(WordprocessingMLPackage template, List<Map<String, String>> mapList, Integer formInitial, Integer formRetain) throws Exception {
        ClassFinder find = new ClassFinder(Tbl.class);
        new TraversalUtil((Object)template.getMainDocumentPart().getContent(), (TraversalUtil.Callback)find);
        Tbl table = (Tbl)find.results.get(1);
        Tr dynamicTr = (Tr)table.getContent().get(formInitial);
        String dynamicTrXml = XmlUtils.marshaltoString((Object)dynamicTr);
        ObjectFactory factory = Context.getWmlObjectFactory();
        for (Map<String, String> dataMap : mapList) {
            Tr newTr = (Tr)XmlUtils.unmarshallFromTemplate((String)dynamicTrXml, dataMap);
            table.getContent().add(newTr);
        }
        table.getContent().remove(dynamicTr);
    }

    public static void setCellVMerge(Tc tableCell, String mergeVal) {
        if (mergeVal != null) {
            TcPr tableCellProperties = tableCell.getTcPr();
            if (tableCellProperties == null) {
                tableCellProperties = new TcPr();
                tableCell.setTcPr(tableCellProperties);
            }
            TcPrInner.VMerge merge = new TcPrInner.VMerge();
            if (!"close".equals(mergeVal)) {
                merge.setVal(mergeVal);
            }
            tableCellProperties.setVMerge(merge);
        }
    }

    private void replaceLabelBookmark(WordprocessingMLPackage template, Map<String, String> qrMap, Map<String, String> gzMap) throws Exception {
        MainDocumentPart main = template.getMainDocumentPart();
        Document doc = (Document)main.getContents();
        Body body = doc.getBody();
        List paragraphs = body.getContent();
        RangeFinder rt = new RangeFinder("CTBookmark", "CTMarkupRange");
        new TraversalUtil((Object)paragraphs, (TraversalUtil.Callback)rt);
        if (CollectionUtil.isEmpty((Collection)rt.getStarts())) {
            log.info("\u65e0\u4e66\u7b7e\u70b9");
            return;
        }
        for (CTBookmark bm : rt.getStarts()) {
            String content = qrMap.get(bm.getName());
            if (!StringUtils.isNotBlank((CharSequence)content) || !bm.getName().equals("qr")) continue;
            log.info("\u5b9a\u4f4d\u4e66\u7b7e\uff1a{}\uff0c{}", (Object)bm.getName(), (Object)content);
            byte[] bytes = QrUtils.createCodeToByte(content, 63, 63);
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)template, (byte[])bytes);
            Inline inline = imagePart.createImageInline(null, null, 0, 1, false, 0);
            ObjectFactory factory = new ObjectFactory();
            Drawing drawing = factory.createDrawing();
            drawing.getAnchorOrInline().add(inline);
            R run = factory.createR();
            run.getContent().add(drawing);
            P p = (P)bm.getParent();
            p.getContent().add(run);
        }
        List sectionWrappers = template.getDocumentModel().getSections();
        HeaderPart hp = ((SectionWrapper)sectionWrappers.get(0)).getHeaderFooterPolicy().getDefaultHeader();
        RangeFinder rt1 = new RangeFinder("CTBookmark", "CTMarkupRange");
        new TraversalUtil((Object)hp, (TraversalUtil.Callback)rt1);
        for (CTBookmark bm : rt1.getStarts()) {
            ByteArrayOutputStream byteArrayOutputStream;
            block19: {
                if (!bm.getName().equals("gz")) continue;
                String bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
                String endpoint = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
                String dir = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.dir");
                String sealUrl = String.format("%s/%s%s/%s", endpoint, dir, "print/seal", gzMap.get("gz"));
                byteArrayOutputStream = new ByteArrayOutputStream();
                if (this.isLocalEnviroment()) {
                    String gzPath = DocxToPdfHelperImpl.class.getResource("/gzimg/" + gzMap.get("gz")).getPath();
                    try (FileInputStream fileInputStream = new FileInputStream(gzPath);){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = fileInputStream.read(buffer)) != -1) {
                            byteArrayOutputStream.write(buffer, 0, len);
                        }
                        break block19;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                OutputStream outputStream = this.objectStorageService.get(sealUrl, bucketName);
                byteArrayOutputStream = (ByteArrayOutputStream)outputStream;
            }
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)template, (Part)hp, (byte[])byteArrayOutputStream.toByteArray());
            Inline inline = imagePart.createImageInline(null, null, 0, 1, false, -10);
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            int targetWidth = -1;
            int targetHeight = 111;
            DocxToPdfHelperImpl.setImgSize(inline, bufferedImage, targetWidth, targetHeight);
            ObjectFactory factory = new ObjectFactory();
            Drawing drawing = factory.createDrawing();
            drawing.getAnchorOrInline().clear();
            drawing.getAnchorOrInline().add(inline);
            R run = factory.createR();
            run.getContent().add(drawing);
            P p = (P)bm.getParent();
            p.getContent().add(run);
        }
    }

    private static void setImgSize(Inline inline, BufferedImage bufferedImage, int targetWidth, int targetHeight) {
        int originalWidth = bufferedImage.getWidth();
        int originalHeight = bufferedImage.getHeight();
        double scale = 1.0;
        if (targetWidth > 0) {
            scale = (double)targetWidth / (double)originalWidth;
        } else if (targetHeight > 0) {
            scale = (double)targetHeight / (double)originalHeight;
        }
        int width = (int)((double)originalWidth * scale);
        int height = (int)((double)originalHeight * scale);
        inline.getExtent().setCx((long)(width * 9525));
        inline.getExtent().setCy((long)(height * 9525));
        inline.getEffectExtent().setT(0L);
        inline.getEffectExtent().setB(0L);
        inline.getEffectExtent().setL(0L);
        inline.getEffectExtent().setR(0L);
        inline.setDistT(Long.valueOf(0L));
        inline.setDistB(Long.valueOf(0L));
    }

    private boolean isLocalEnviroment() {
        return Arrays.asList(this.environment.getActiveProfiles()).contains("local");
    }

    private static class DocxVariableClearUtils {
        private static final Pattern XML_PATTERN = Pattern.compile("<[^>]*>");
        private static final char PREFIX = '$';
        private static final char LEFT_BRACE = '{';
        private static final char RIGHT_BRACE = '}';
        private static final int NONE_START = -1;
        private static final int NONE_START_INDEX = -1;
        private static final int PREFIX_STATUS = 1;
        private static final int LEFT_BRACE_STATUS = 2;
        private static final int RIGHT_BRACE_STATUS = 3;

        private DocxVariableClearUtils() {
        }

        private static Object doCleanDocumentPart(String wmlTemplate, JAXBContext jc) throws JAXBException {
            int curStatus = -1;
            int keyStartIndex = -1;
            int curIndex = 0;
            char[] textCharacters = wmlTemplate.toCharArray();
            StringBuilder documentBuilder = new StringBuilder(textCharacters.length);
            documentBuilder.append(textCharacters);
            StringBuilder newDocumentBuilder = new StringBuilder(textCharacters.length);
            int lastWriteIndex = 0;
            for (char c : textCharacters) {
                switch (c) {
                    case '$': {
                        keyStartIndex = curIndex;
                        curStatus = 1;
                        break;
                    }
                    case '{': {
                        if (curStatus != 1) break;
                        curStatus = 2;
                        break;
                    }
                    case '}': {
                        if (curStatus != 2) break;
                        newDocumentBuilder.append(documentBuilder.substring(lastWriteIndex, keyStartIndex));
                        int keyEndIndex = curIndex + 1;
                        String rawKey = documentBuilder.substring(keyStartIndex, keyEndIndex);
                        String mappingKey = XML_PATTERN.matcher(rawKey).replaceAll("");
                        if (!mappingKey.equals(rawKey)) {
                            char[] rawKeyChars = rawKey.toCharArray();
                            StringBuilder rawStringBuilder = new StringBuilder(rawKey.length());
                            for (char rawChar : rawKeyChars) {
                                if (rawChar == '$' || rawChar == '{' || rawChar == '}') continue;
                                rawStringBuilder.append(rawChar);
                            }
                            String variable = mappingKey.substring(2, mappingKey.length() - 1);
                            int variableStart = rawStringBuilder.indexOf(variable);
                            if (variableStart > 0) {
                                rawStringBuilder = rawStringBuilder.replace(variableStart, variableStart + variable.length(), mappingKey);
                            }
                            newDocumentBuilder.append(rawStringBuilder.toString());
                        } else {
                            newDocumentBuilder.append(mappingKey);
                        }
                        lastWriteIndex = keyEndIndex;
                        curStatus = -1;
                        keyStartIndex = -1;
                    }
                }
                ++curIndex;
            }
            if (lastWriteIndex < documentBuilder.length()) {
                newDocumentBuilder.append(documentBuilder.substring(lastWriteIndex));
            }
            return XmlUtils.unmarshalString((String)newDocumentBuilder.toString(), (JAXBContext)jc);
        }
    }
}

