/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryDetailReportUpdateVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportDetailApi;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailRespDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_report_center_daily_delivery_detail_report_update")
public class ImportDailyDeliveryReportDetailUpdateImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportDailyDeliveryReportDetailUpdateImpl.class);
    @Resource
    private IDailyDeliveryReportDetailApi deliveryReportDetailApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportDailyDeliveryDetailReportUpdateVO.class);
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u660e\u7ec6\u66f4\u65b0\u5bfc\u5165verifyImportFileOperationCommon\uff1a{}", (Object)list);
        List consignmentNoList = list.stream().map(ImportDailyDeliveryDetailReportUpdateVO::getConsignmentNo).collect(Collectors.toList());
        DailyDeliveryReportDetailPageReqDto reqDto = new DailyDeliveryReportDetailPageReqDto();
        reqDto.setConsignmentNoList(consignmentNoList);
        log.info("\u6839\u636e\u6258\u8fd0\u5355\u67e5\u8be2\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(consignmentNoList));
        List detailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.deliveryReportDetailApi.queryListByConsignmentNo(reqDto));
        Map detailRespDtoMap = Optional.ofNullable(detailRespDtoList).map(m -> m.stream().collect(Collectors.groupingBy(g -> g.getConsignmentNo() + "-" + g.getLongCode()))).orElse(new HashMap());
        for (ImportDailyDeliveryDetailReportUpdateVO vo : list) {
            List detailList = (List)detailRespDtoMap.get(vo.getConsignmentNo() + "-" + vo.getLongCode());
            if (CollectionUtil.isEmpty((Collection)detailList)) {
                vo.setErrorMsg("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u660e\u7ec6\u6570\u636e;");
                continue;
            }
            ArrayList<DailyDeliveryReportDetailRespDto> matchDetailList = new ArrayList<DailyDeliveryReportDetailRespDto>();
            for (DailyDeliveryReportDetailRespDto detail : detailList) {
                if (StringUtils.isNotBlank((CharSequence)vo.getOutNoticeNo()) && !vo.getOutNoticeNo().equals(detail.getOutNoticeNo()) || StringUtils.isNotBlank((CharSequence)vo.getTransportNo()) && !vo.getTransportNo().equals(detail.getTransportNo())) continue;
                matchDetailList.add(detail);
            }
            if (CollectionUtil.isEmpty(matchDetailList)) {
                vo.setErrorMsg("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u660e\u7ec6\u6570\u636e;");
            }
            List<Long> ids = matchDetailList.stream().map(BaseDto::getId).collect(Collectors.toList());
            vo.setIds(ids);
        }
        return list;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u660e\u7ec6\u66f4\u65b0\u5bfc\u5165executeImportFileOperationCommon\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        List list = (List)obj;
        for (ImportDailyDeliveryDetailReportUpdateVO vo : list) {
            if (!StringUtils.isBlank((CharSequence)vo.getErrorMsg())) continue;
            try {
                vo.getIds().forEach(id -> {
                    DailyDeliveryReportDetailDto reqDto = (DailyDeliveryReportDetailDto)BeanUtil.copyProperties((Object)((Object)vo), DailyDeliveryReportDetailDto.class, (String[])new String[0]);
                    reqDto.setId(id);
                    RestResponseHelper.extractData((RestResponse)this.deliveryReportDetailApi.updateById(reqDto));
                });
            }
            catch (Exception e) {
                vo.setErrorMsg("\u8bf7\u6c42\u66f4\u65b0\u5f02\u5e38" + e.getMessage());
                log.error("\u8bf7\u6c42\u66f4\u65b0\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)((Object)vo)), (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        String errorMsgUrl = null;
        List errorList = list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorList)) {
            log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u660e\u7ec6\u66f4\u65b0\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString(errorList));
            String excelName = String.format("%s%s", "\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u660e\u7ec6\u66f4\u65b0\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, ImportDailyDeliveryDetailReportUpdateVO.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

