/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ContractVO;
import com.dtyunxi.cis.pms.biz.model.InlineObject5;
import com.dtyunxi.cis.pms.biz.model.StorageContractChangeRecordVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterStorageCostReportContractService;
import com.dtyunxi.finance.api.IStorageContractApi;
import com.dtyunxi.finance.api.dto.request.StorageContractChangeRecordReqDto;
import com.dtyunxi.finance.api.dto.request.StorageContractReqDto;
import com.dtyunxi.finance.api.dto.response.StorageContractChangeRecordRespDto;
import com.dtyunxi.finance.api.dto.response.StorageContractRespDto;
import com.dtyunxi.finance.api.query.IStorageContractChangeRecordQueryApi;
import com.dtyunxi.finance.api.query.IStorageContractDetailQueryApi;
import com.dtyunxi.finance.api.query.IStorageContractQueryApi;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import liquibase.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ReportCenterStorageCostReportContractServiceServiceImpl
implements ReportCenterStorageCostReportContractService {
    private static final Logger log = LoggerFactory.getLogger(ReportCenterStorageCostReportContractServiceServiceImpl.class);
    @Resource
    private IStorageContractQueryApi storageContractQueryApi;
    @Resource
    private IStorageContractApi storageContractApi;
    @Resource
    private IStorageContractDetailQueryApi storageContractDetailQueryApi;
    @Resource
    private IStorageContractChangeRecordQueryApi storageContractChangeRecordQueryApi;

    @Override
    public RestResponse<PageInfo<ContractVO>> getContractListPage(@ApiParam(value="") @Valid @RequestBody(required=false) InlineObject5 inlineObject) {
        List respDtoList;
        StorageContractReqDto storageContractReqDto = new StorageContractReqDto();
        @NotNull Integer pageNum = inlineObject.getPageNum();
        @NotNull Integer pageSize = inlineObject.getPageSize();
        if (StringUtils.isNotEmpty((String)inlineObject.getContractName())) {
            storageContractReqDto.setContractName(inlineObject.getContractName());
        }
        if (StringUtils.isNotEmpty((String)inlineObject.getStatus())) {
            List list = (List)JSON.parseObject((String)inlineObject.getStatus(), new ArrayList().getClass());
            storageContractReqDto.setStateList(list);
        }
        if (StringUtils.isNotEmpty((String)inlineObject.getWarehouseName())) {
            storageContractReqDto.setWarehouseName(inlineObject.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((String)inlineObject.getWarehouseCode())) {
            storageContractReqDto.setWarehouseCode(inlineObject.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((String)inlineObject.getValidYear())) {
            storageContractReqDto.setValidYear(inlineObject.getValidYear());
        }
        if (inlineObject.getChargeMode() != null) {
            storageContractReqDto.setChargeMode(inlineObject.getChargeMode());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd : HH:mm:ss");
        Date startDate = new Date();
        Date endDate = new Date();
        try {
            startDate = dateFormat.parse(inlineObject.getEffectStartTime());
            endDate = dateFormat.parse(inlineObject.getEffectEndTime());
            storageContractReqDto.setValidStartTime(startDate);
            storageContractReqDto.setValidEndTime(endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (NullPointerException exception) {
            exception.printStackTrace();
        }
        String json = JSON.toJSONString((Object)storageContractReqDto);
        RestResponse pageInfoRestResponse = this.storageContractQueryApi.queryByPage(json, pageNum, pageSize);
        if ("0".equals(pageInfoRestResponse.getResultCode()) && (respDtoList = ((PageInfo)pageInfoRestResponse.getData()).getList()).size() > 0 && ((StorageContractRespDto)respDtoList.get(0)).getId() != null) {
            ArrayList<ContractVO> reportVOS = new ArrayList<ContractVO>(respDtoList.size());
            for (StorageContractRespDto respDto : respDtoList) {
                ContractVO vo = new ContractVO();
                vo.setContractName(respDto.getContractName());
                vo.setCreatePerson(respDto.getCreatePerson());
                vo.setEffectTime(dateFormat.format(respDto.getValidStartTime()) + "~" + dateFormat.format(respDto.getValidEndTime()));
                vo.setId(respDto.getId());
                vo.setCreateTime(format.format(respDto.getCreateTime()));
                String status = String.valueOf(respDto.getStatus());
                vo.setStatus(status);
                if (respDto.getContractAverageSupport() != null) {
                    vo.setNum(BigDecimal.valueOf(respDto.getContractAverageSupport().intValue()));
                }
                vo.setUpdatePerson(respDto.getUpdatePerson());
                if (respDto.getUpdateTime() != null) {
                    vo.setUpdateTime(format.format(respDto.getUpdateTime()));
                }
                if (ObjectUtil.isNotEmpty((Object)respDto.getContractCooperativeStartTime())) {
                    vo.setContractCooperativeStartTime(dateFormat.format(respDto.getContractCooperativeStartTime()));
                }
                if (ObjectUtil.isNotEmpty((Object)respDto.getContractCooperativeEndTime())) {
                    vo.setContractCooperativeEndTime(dateFormat.format(respDto.getContractCooperativeEndTime()));
                }
                vo.setWarehouseCode(respDto.getWarehouseCode());
                vo.setWarehouseName(respDto.getWarehouseName());
                vo.setChargeMode(respDto.getChargeMode());
                reportVOS.add(vo);
            }
            PageInfo contractVOPageInfo = new PageInfo(reportVOS);
            return new RestResponse((Object)contractVOPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<StorageContractChangeRecordVO>> getContractChangeRecordListPage(String id, Integer pageSize, Integer pageNum) {
        List respDtoList;
        String json;
        RestResponse pageInfoRestResponse;
        StorageContractChangeRecordReqDto storageContractChangeRecordReqDto = new StorageContractChangeRecordReqDto();
        if (StringUtils.isNotEmpty((String)id)) {
            storageContractChangeRecordReqDto.setContractId(Long.valueOf(id));
        }
        if ("0".equals((pageInfoRestResponse = this.storageContractChangeRecordQueryApi.queryByPage(json = JSON.toJSONString((Object)storageContractChangeRecordReqDto), pageNum, pageSize)).getResultCode()) && (respDtoList = ((PageInfo)pageInfoRestResponse.getData()).getList()).size() > 0) {
            ArrayList<StorageContractChangeRecordVO> reportVOS = new ArrayList<StorageContractChangeRecordVO>(respDtoList.size());
            for (StorageContractChangeRecordRespDto respDto : respDtoList) {
                StorageContractChangeRecordVO storageContractChangeRecordVO = new StorageContractChangeRecordVO();
                storageContractChangeRecordVO.setContractId(respDto.getContractId());
                storageContractChangeRecordVO.setField(respDto.getField());
                storageContractChangeRecordVO.setFieldAfterValue(respDto.getFieldAfterValue());
                storageContractChangeRecordVO.setFieldBeforeValue(respDto.getFieldBeforeValue());
                storageContractChangeRecordVO.setUpdatePerson(respDto.getUpdatePerson());
                storageContractChangeRecordVO.setUpdateTime(respDto.getUpdateTime());
                reportVOS.add(storageContractChangeRecordVO);
            }
            PageInfo storageContractChangeRecordPageInfo = new PageInfo(reportVOS);
            return new RestResponse((Object)storageContractChangeRecordPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<List<StorageContractRespDto>> addStorageContract(@Valid StorageContractReqDto addReqDto) {
        RestResponse response = this.storageContractApi.addStorageContract(addReqDto);
        if (response.getData() == null) {
            response.setResultCode("1000");
            response.setResultMsg("\u53c2\u6570\u9519\u8bef");
        } else if (((List)response.getData()).size() > 0 && ((StorageContractRespDto)((List)response.getData()).get(0)).getStatus() != null) {
            response.setResultCode("1000");
            response.setResultMsg("\u4ed3\u5e93\u5185\u5df2\u5b58\u5728\u672a\u751f\u6548/\u751f\u6548\u4e2d\u7684\u5408\u540c");
        }
        return response;
    }

    @Override
    public RestResponse<List<StorageContractRespDto>> modifyStorageContract(@Valid StorageContractReqDto modifyReqDto) {
        log.info("/v1/report/storageCostReport/contract/update => get requestBody: {}", (Object)modifyReqDto);
        RestResponse response = this.storageContractApi.modifyStorageContract(modifyReqDto);
        if (null != response.getData() && ((List)response.getData()).size() > 0 && ((StorageContractRespDto)((List)response.getData()).get(0)).getStatus() != null) {
            response.setResultCode("1000");
            response.setResultMsg("\u4ed3\u5e93\u5185\u5df2\u5b58\u5728\u672a\u751f\u6548/\u751f\u6548\u4e2d\u7684\u5408\u540c");
        }
        return response;
    }

    @Override
    public RestResponse<Void> modifyStorageContractOfIsCancel(String ids, int isCancel) {
        RestResponse response = this.storageContractApi.modifyStorageContractOfIsCancel(ids, isCancel);
        return response;
    }

    @Override
    public RestResponse<StorageContractRespDto> getStorageContractDetailById(Long id) {
        RestResponse response = this.storageContractQueryApi.queryById(id);
        return response;
    }

    @Override
    public RestResponse<Void> removeStorageContract(Long id) {
        RestResponse response = new RestResponse();
        if (id != null) {
            response = this.storageContractApi.removeStorageContract(String.valueOf(id));
        }
        return response;
    }
}

