/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.enums.CustomerYesEnum;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerDataManageMsgVO;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerDataManageVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.IPcpCustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEasCostOrgQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_customer_data_import")
public class CsAdjustmentOrderImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(CsAdjustmentOrderImpl.class);
    @Resource
    private IPCPCustomerQueryApi ipcpCustomerQueryApi;
    @Resource
    private IPcpCustomerExtApi iPcpCustomerExtApi;
    @Resource
    private IEasCostOrgQueryApi iEasCostOrgQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportCustomerDataManageVO.class);
        log.info("\u5ba2\u6237\u8d44\u6599\u7ba1\u7406\u5bfc\u5165\u96c6\u5408\uff0clist\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashSet checkRepeatData = Sets.newHashSet();
        Map<String, PCPCustomerRespDto> respDtoMap = this.getcodesMap(list);
        log.info("respDtoMap=={}", (Object)JSON.toJSONString(respDtoMap));
        Map<String, EasCostOrgRespDto> easCodesMap = this.getEasCodesMap(list);
        log.info("easCodesMap=={}", (Object)JSON.toJSONString(easCodesMap));
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        list.forEach(i -> {
            ImportCustomerDataManageMsgVO msgDto = new ImportCustomerDataManageMsgVO();
            CubeBeanUtils.copyProperties((Object)msgDto, (Object)i, (String[])new String[0]);
            this.checkForm((ImportCustomerDataManageVO)((Object)i), msgDto);
            this.checkCode((ImportCustomerDataManageVO)((Object)i), respDtoMap, msgDto);
            this.checkEasCode((ImportCustomerDataManageVO)((Object)i), easCodesMap, msgDto);
            this.checkRepeatData(i.getUniqueKey(), checkRepeatData, msgDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(i);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        log.info("\u5ba2\u6237\u8d44\u6599\u7ba1\u7406\u5bfc\u5165\u96c6\u5408\uff0csaveList\uff1a{}", (Object)JSON.toJSONString((Object)saveList));
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        ArrayList msgList = Lists.newArrayList();
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            log.info("===\u5ba2\u6237\u8d44\u6599\u5bfc\u5165\u6570\u636e===saveList:{}", (Object)JSON.toJSONString((Object)saveList));
            Map<String, List<ImportCustomerDataManageVO>> importMap = saveList.stream().collect(Collectors.groupingBy(ImportCustomerDataManageVO::getCode));
            ArrayList dtoList = Lists.newArrayList();
            for (ImportCustomerDataManageVO vo : saveList) {
                CustomerReqExtDto customerReqExtDto = new CustomerReqExtDto();
                customerReqExtDto.setCode(vo.getCode());
                customerReqExtDto.setInformationRemarks(Optional.ofNullable(vo.getInformationRemarks()).orElse(""));
                customerReqExtDto.setName(Optional.ofNullable(vo.getName()).orElse(""));
                customerReqExtDto.setThirdParentPartyId(Optional.ofNullable(vo.getThirdParentPartyId()).orElse(""));
                if (vo.getId() != null) {
                    customerReqExtDto.setId(vo.getId());
                } else {
                    customerReqExtDto.setStatusId(Long.valueOf(1256288005151458333L));
                }
                customerReqExtDto.setExtraMaterial((Integer)Optional.ofNullable(CustomerYesEnum.getDescByCode(vo.getExtraMaterial())).orElse(null));
                customerReqExtDto.setFinancialPrint((Integer)Optional.ofNullable(CustomerYesEnum.getDescByCode(vo.getFinancialPrint())).orElse(null));
                customerReqExtDto.setReportsPrint((Integer)Optional.ofNullable(CustomerYesEnum.getDescByCode(vo.getReportsPrint())).orElse(null));
                customerReqExtDto.setShipmentEnterprise((Integer)Optional.ofNullable(CustomerYesEnum.getDescByCode(vo.getShipmentEnterprise())).orElse(null));
                dtoList.add(customerReqExtDto);
            }
            dtoList.forEach(i -> {
                block2: {
                    try {
                        this.iPcpCustomerExtApi.saveCustomer(i);
                    }
                    catch (Exception e) {
                        String key = String.format("%s", i.getCode());
                        if (!importMap.containsKey(key)) break block2;
                        List importTransferOrderVos = (List)importMap.get(key);
                        ArrayList list = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)list, (Collection)importTransferOrderVos, ImportCustomerDataManageMsgVO.class);
                        list.forEach(j -> j.setErrorMsg(e.getMessage()));
                        msgList.addAll(list);
                    }
                }
            });
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List checkMsgList = (List)msgObj;
            msgList.addAll(checkMsgList);
        }
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = String.format("%s%s", "\u5ba2\u6237\u8d44\u6599\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportCustomerDataManageMsgVO.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private Map<String, PCPCustomerRespDto> getcodesMap(List<ImportCustomerDataManageVO> list) {
        Map<Object, Object> codesMap = Maps.newHashMap();
        List codes = list.stream().map(ImportCustomerDataManageVO::getCode).distinct().collect(Collectors.toList());
        List warehouses = (List)RestResponseHelper.extractData((RestResponse)this.ipcpCustomerQueryApi.queryPCPCustomerDetailByCodes(codes));
        if (CollectionUtil.isNotEmpty((Collection)warehouses)) {
            codesMap = warehouses.stream().collect(Collectors.toMap(PCPCustomerRespDto::getCustomerCode, Function.identity(), (k1, k2) -> k1));
        }
        return codesMap;
    }

    private Map<String, EasCostOrgRespDto> getEasCodesMap(List<ImportCustomerDataManageVO> list) {
        List dtos;
        Map<Object, Object> codesMap = Maps.newHashMap();
        List codes = list.stream().map(ImportCustomerDataManageVO::getThirdParentPartyId).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(codes) && CollectionUtil.isNotEmpty((Collection)(dtos = (List)RestResponseHelper.extractData((RestResponse)this.iEasCostOrgQueryApi.queryListCodes(codes))))) {
            codesMap = dtos.stream().collect(Collectors.toMap(EasCostOrgRespDto::getEasOrgCode, Function.identity(), (k1, k2) -> k1));
        }
        return codesMap;
    }

    private void checkCode(ImportCustomerDataManageVO i, Map<String, PCPCustomerRespDto> codesMap, ImportCustomerDataManageMsgVO msgDto) {
        PCPCustomerRespDto pcpCustomerRespDto = codesMap.get(i.getCode());
        if (ObjectUtils.isNotEmpty((Object)pcpCustomerRespDto)) {
            i.setId(pcpCustomerRespDto.getId());
        }
    }

    private void checkEasCode(ImportCustomerDataManageVO i, Map<String, EasCostOrgRespDto> codesMap, ImportCustomerDataManageMsgVO msgDto) {
        EasCostOrgRespDto easCostOrgRespDto;
        if (StringUtils.isNotBlank((CharSequence)i.getThirdParentPartyId()) && ObjectUtils.isEmpty((Object)(easCostOrgRespDto = codesMap.get(i.getThirdParentPartyId())))) {
            msgDto.setErrorMsg("\u6240\u5c5e\u8d22\u52a1\u7f16\u7801\u4e0d\u5b58\u5728");
        }
    }

    private void checkForm(ImportCustomerDataManageVO i, ImportCustomerDataManageMsgVO msgDto) {
        if (StringUtils.isNotBlank((CharSequence)i.getExtraMaterial()) && !i.getExtraMaterial().equals("\u662f") && !i.getExtraMaterial().equals("\u5426")) {
            msgDto.setErrorMsg("\u662f\u5426\u6709\u989d\u5916\u8d44\u6599\u683c\u5f0f\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)i.getFinancialPrint()) && !i.getFinancialPrint().equals("\u662f") && !i.getFinancialPrint().equals("\u5426")) {
            msgDto.setErrorMsg("\u662f\u5426\u6253\u5370\u91d1\u989d\u8054\u683c\u5f0f\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)i.getReportsPrint()) && !i.getReportsPrint().equals("\u662f") && !i.getReportsPrint().equals("\u5426")) {
            msgDto.setErrorMsg("\u662f\u5426\u6253\u5370\u8d28\u68c0\u62a5\u544a\u683c\u5f0f\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)i.getShipmentEnterprise()) && !i.getShipmentEnterprise().equals("\u662f") && !i.getShipmentEnterprise().equals("\u5426")) {
            msgDto.setErrorMsg("\u662f\u5426\u7269\u6d41\u5546\u683c\u5f0f\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)i.getExtraMaterial()) && i.getExtraMaterial().equals("\u662f") && StringUtils.isBlank((CharSequence)i.getInformationRemarks())) {
            msgDto.setErrorMsg("\u6709\u989d\u5916\u8d44\u6599\u65f6\uff0c\u989d\u5916\u8d44\u6599\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, ImportCustomerDataManageMsgVO msgDto) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(msgDto, "\u6570\u636e\u91cd\u590d");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void setErrorMsg(ImportCustomerDataManageMsgVO msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }
}

