/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.GetSupplierListPageParams;
import com.dtyunxi.cis.pms.biz.model.SupplierVO;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterSupplierService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.ICsInventorySupplierApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventorySupplierReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsInventorySupplierRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class BasedataCenterSupplierServiceServiceImpl
implements BasedataCenterSupplierService {
    @Resource
    private ICsInventorySupplierApi iCsInventorySupplierApi;

    @Override
    public RestResponse<SupplierVO> getSupplierDetail(@ApiParam(value="\u4f9b\u5e94\u5546id") @Valid @RequestParam(value="id", required=false) String id, @ApiParam(value="\u4f9b\u5e94\u5546\u7f16\u7801") @Valid @RequestParam(value="supplierCode", required=false) String supplierCode) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new BizException("\u4f9b\u5e94\u5546\u8d44\u6599\u8be6\u60c5\u53c2\u6570\u6709\u8bef");
        }
        CsInventorySupplierRespDto respDto = (CsInventorySupplierRespDto)RestResponseHelper.extractData((RestResponse)this.iCsInventorySupplierApi.queryById(Long.valueOf(id)));
        if (respDto == null) {
            return new RestResponse();
        }
        SupplierVO supplierVO = new SupplierVO();
        BeanUtils.copyProperties((Object)respDto, (Object)supplierVO);
        supplierVO.setCreditCode(respDto.getCreditCode());
        supplierVO.setStatus(ParamConverter.convertToString((Object)respDto.getStatus()));
        supplierVO.setPostCode(respDto.getPostCode());
        supplierVO.setSupplierUnit(respDto.getSupplierUnit());
        supplierVO.setPhoneNum(respDto.getPhoneNum());
        supplierVO.setLegalName(respDto.getLegalName());
        supplierVO.setOrderFlag(ParamConverter.convertToString((Object)respDto.getOrderFlag()));
        supplierVO.setLinkman(respDto.getLinkman());
        supplierVO.setInspectionReport(ParamConverter.convertToString((Object)respDto.getInspectionReport()));
        AddressVO addressVO = new AddressVO();
        BeanUtils.copyProperties((Object)respDto, (Object)addressVO);
        addressVO.setAddress(respDto.getAddress());
        supplierVO.setAddressInfo(addressVO);
        return new RestResponse((Object)supplierVO);
    }

    @Override
    public RestResponse<PageInfo<SupplierVO>> getSupplierListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSupplierListPageParams getSupplierListPageParams) {
        CsInventorySupplierReqDto reqDto = new CsInventorySupplierReqDto();
        BeanUtils.copyProperties((Object)getSupplierListPageParams, (Object)reqDto);
        reqDto.setSupplierUnit(getSupplierListPageParams.getSimpleSupplierName());
        reqDto.setStatus(ParamConverter.convertToInteger((Object)getSupplierListPageParams.getStatus()));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iCsInventorySupplierApi.queryByPage(JSON.toJSONString((Object)reqDto), getSupplierListPageParams.getPageNum(), getSupplierListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List supplierVOS = respDtoPageInfo.getList().stream().map(o -> {
            SupplierVO supplierVO = new SupplierVO();
            BeanUtils.copyProperties((Object)o, (Object)supplierVO);
            supplierVO.setStatus(ParamConverter.convertToString((Object)o.getStatus()));
            return supplierVO;
        }).collect(Collectors.toList());
        pageInfo.setList(supplierVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Long> saveSupplier(CsInventorySupplierReqDto addReqDto) {
        return this.iCsInventorySupplierApi.addCsInventorySupplier(addReqDto);
    }
}

