/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.CustomerVO;
import com.dtyunxi.cis.pms.biz.model.GetOrderAutoAuditStrategyListParams;
import com.dtyunxi.cis.pms.biz.model.GetOrderAutoAuditStrategyRelevantOrderListParams;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderLogListPageParams;
import com.dtyunxi.cis.pms.biz.model.GoodsVO;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.OrderAutoAuditStrategyRelevantOrderVo;
import com.dtyunxi.cis.pms.biz.model.OrderAutoAuditStrategyResponseVO;
import com.dtyunxi.cis.pms.biz.model.OrderChannelVO;
import com.dtyunxi.cis.pms.biz.model.OrderOperationVO;
import com.dtyunxi.cis.pms.biz.model.SaleOrderLogVO;
import com.dtyunxi.cis.pms.biz.model.SubmitOrderAutoAuditStrategyBody;
import com.dtyunxi.cis.pms.biz.model.SubmitOrderAutoAuditStrategyBodyOldData;
import com.dtyunxi.cis.pms.biz.model.SubmitOrderAutoAuditStrategyRule;
import com.dtyunxi.cis.pms.biz.model.UpdateSellerAutoRemarkRequest;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleOrderService;
import com.dtyunxi.cis.pms.biz.service.StrategyManagementOrderAutoAuditStrategyService;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StrategyAutoCheckRuleReportReqDto;
import com.dtyunxi.tcbj.api.query.IStrategyAutoCheckRuleReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.trade.api.IStrategyAutoCheckRuleApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizStrategyAutoCheckRuleReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ChangeContentItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.StrategyOptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.StrategyAutoCheckRuleDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IStrategyAutoCheckOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IStrategyAutoCheckRuleQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IStrategyOptLogQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class StrategyManagementOrderAutoAuditStrategyServiceServiceImpl
implements StrategyManagementOrderAutoAuditStrategyService {
    private static Logger logger = LoggerFactory.getLogger(StrategyManagementOrderAutoAuditStrategyServiceServiceImpl.class);
    @Resource
    private IStrategyAutoCheckRuleApi strategyAutoCheckRuleApi;
    @Resource
    private IStrategyAutoCheckRuleQueryApi strategyAutoCheckRuleQueryApi;
    @Resource
    private IStrategyAutoCheckRuleReportQueryApi strategyAutoCheckRuleReportQueryApi;
    @Resource
    private IStrategyAutoCheckOrderQueryApi strategyAutoCheckOrderQueryApi;
    @Resource
    private IStrategyOptLogQueryApi strategyOptLogQueryApi;
    @Resource
    private OrderCenterSaleOrderService orderCenterSaleOrderService;

    @Override
    public RestResponse<Object> addOrderAutoAuditStrategy(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitOrderAutoAuditStrategyBody submitOrderAutoAuditStrategyBody) {
        BizStrategyAutoCheckRuleReqDto reqDto = new BizStrategyAutoCheckRuleReqDto();
        if (submitOrderAutoAuditStrategyBody.getNewData() == null) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SubmitOrderAutoAuditStrategyBodyOldData newData = submitOrderAutoAuditStrategyBody.getNewData();
        BeanUtils.copyProperties((Object)newData, (Object)reqDto);
        this.getStrategyAutoCheckRule(newData, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleApi.addStrategyAutoCheckRule(reqDto)));
    }

    private void getStrategyAutoCheckRule(SubmitOrderAutoAuditStrategyBodyOldData newData, BizStrategyAutoCheckRuleReqDto reqDto) {
        ChangeContentItemReqDto changeContentItemReqDto;
        reqDto.setRuleStatus(ParamConverter.convertToInteger((Object)newData.getRuleStatus()));
        reqDto.setPriority(ParamConverter.convertToInteger((Object)newData.getPriority()));
        if (StringUtils.isNotBlank((CharSequence)newData.getActiveStartTime())) {
            reqDto.setActiveStartTime(ParamConverter.convertToDate((String)newData.getActiveStartTime(), (DatePattern)DatePattern.DATETIME_PATTERN));
        }
        if (StringUtils.isNotBlank((CharSequence)newData.getActiveEndTime())) {
            reqDto.setActiveEndTime(ParamConverter.convertToDate((String)newData.getActiveEndTime(), (DatePattern)DatePattern.DATETIME_PATTERN));
        }
        reqDto.setPriority(ParamConverter.convertToInteger((Object)newData.getPriority()));
        reqDto.setIsDelayAudit(ParamConverter.convertToInteger((Object)newData.getIsDelayAudit()));
        reqDto.setDelayAuditType(ParamConverter.convertToString((Object)newData.getDelayAuditType()));
        reqDto.setIsIgnoreRemarkAudit(ParamConverter.convertToInteger((Object)newData.getIsIgnoreRemarkAudit()));
        reqDto.setIsAmountRangeAudit(ParamConverter.convertToInteger((Object)newData.getIsAmountRangeAudit()));
        reqDto.setIsLogicalWarehouseAudit(ParamConverter.convertToInteger((Object)newData.getIsLogicalWarehouseAudit()));
        if (CollectionUtils.isNotEmpty(newData.getLogicalWarehouseOfAudit())) {
            changeContentItemReqDto = new ChangeContentItemReqDto();
            changeContentItemReqDto.setAdd(newData.getLogicalWarehouseOfAudit());
            reqDto.setLogicalWarehouseCodeOfAudit(changeContentItemReqDto);
        }
        reqDto.setIsGoodsAudit(ParamConverter.convertToInteger((Object)newData.getIsGoodsAudit()));
        if (CollectionUtils.isNotEmpty(newData.getGoodsOfAudit())) {
            changeContentItemReqDto = new ChangeContentItemReqDto();
            changeContentItemReqDto.setAdd(newData.getGoodsOfAudit());
            reqDto.setGoodsOfAudit(changeContentItemReqDto);
        }
        reqDto.setIsCustomerAudit(ParamConverter.convertToInteger((Object)newData.getIsCustomerAudit()));
        if (CollectionUtils.isNotEmpty(newData.getCustomerOfAudit())) {
            changeContentItemReqDto = new ChangeContentItemReqDto();
            changeContentItemReqDto.setAdd(newData.getCustomerOfAudit());
            reqDto.setCustomerIdOfAudit(changeContentItemReqDto);
        }
        reqDto.setIsAreaAudit(ParamConverter.convertToInteger((Object)newData.getIsAreaAudit()));
        if (CollectionUtils.isNotEmpty(newData.getAreaOfAudit())) {
            changeContentItemReqDto = new ChangeContentItemReqDto();
            changeContentItemReqDto.setAdd(newData.getAreaOfAudit());
            reqDto.setAreaOfAudit(changeContentItemReqDto);
        }
        reqDto.setChannelSelectedType(newData.getChannelSelectedType());
        if (CollectionUtils.isNotEmpty(newData.getApplyOrderChannels())) {
            changeContentItemReqDto = new ChangeContentItemReqDto();
            changeContentItemReqDto.setAdd(newData.getApplyOrderChannels());
            reqDto.setApplyChannels(changeContentItemReqDto);
        }
        reqDto.setOrderTypeSelectedType(newData.getOrderTypeSelectedType());
        if (CollectionUtils.isNotEmpty(newData.getApplyOrderType())) {
            reqDto.setApplyOrderType(newData.getApplyOrderType());
        }
        reqDto.setIsSellerRemarkAudit(newData.getIsSellerRemarkAudit());
        if (StringUtils.isNotEmpty((CharSequence)newData.getSellerRemarkKeyWords())) {
            changeContentItemReqDto = new ChangeContentItemReqDto();
            changeContentItemReqDto.setAdd((List)Lists.newArrayList((Object[])new String[]{newData.getSellerRemarkKeyWords()}));
            changeContentItemReqDto.setSellerRemarkKeyFlag(newData.getSellerRemarkKeyFlag());
            reqDto.setSellerRemark(changeContentItemReqDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)newData.getSellerAutoRemarkKeyWords())) {
            changeContentItemReqDto = new ChangeContentItemReqDto();
            changeContentItemReqDto.setAdd((List)Lists.newArrayList((Object[])new String[]{newData.getSellerAutoRemarkKeyWords()}));
            changeContentItemReqDto.setSellerRemarkKeyFlag(newData.getSellerAutoRemarkKeyFlag());
            reqDto.setSellerAutoRemark(changeContentItemReqDto);
        }
    }

    @Override
    public RestResponse<Object> changeOrderAutoAuditStrategyStatus(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitOrderAutoAuditStrategyRule submitOrderAutoAuditStrategyRule) {
        if (submitOrderAutoAuditStrategyRule.getId() == null || StringUtils.isBlank((CharSequence)submitOrderAutoAuditStrategyRule.getRuleStatus())) {
            throw new BizException("\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u53c2\u6570\u6709\u8bef");
        }
        RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleApi.modifyStrategyRuleStatus(submitOrderAutoAuditStrategyRule.getId(), ParamConverter.convertToInteger((Object)submitOrderAutoAuditStrategyRule.getRuleStatus())));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> copyOrderAutoAuditStrategy(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitOrderAutoAuditStrategyBody submitOrderAutoAuditStrategyBody) {
        if (Objects.isNull(submitOrderAutoAuditStrategyBody.getNewData()) || StringUtils.isEmpty((CharSequence)submitOrderAutoAuditStrategyBody.getNewData().getRuleId())) {
            throw new BizException("\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u53c2\u6570\u6709\u8bef");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleApi.copyRule(Long.valueOf(submitOrderAutoAuditStrategyBody.getNewData().getRuleId()))));
    }

    @Override
    public RestResponse<Object> deleteOrderAutoAuditStrategy(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new BizException("\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u53c2\u6570\u6709\u8bef");
        }
        RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleApi.removeStrategyAutoCheckRule(id));
        return new RestResponse();
    }

    @Override
    public RestResponse<OrderAutoAuditStrategyResponseVO> getOrderAutoAuditStrategy(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new BizException("\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u53c2\u6570\u6709\u8bef");
        }
        StrategyAutoCheckRuleDetailRespDto respDto = (StrategyAutoCheckRuleDetailRespDto)RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleQueryApi.queryById(Long.valueOf(id)));
        if (respDto == null) {
            return new RestResponse();
        }
        return new RestResponse((Object)this.getOrderAutoAuditStrategyResponseVO(respDto));
    }

    private OrderAutoAuditStrategyResponseVO getOrderAutoAuditStrategyResponseVO(StrategyAutoCheckRuleDetailRespDto respDto) {
        OrderAutoAuditStrategyResponseVO vo = new OrderAutoAuditStrategyResponseVO();
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setRuleId(String.valueOf(respDto.getId()));
        vo.setRuleStatus(ParamConverter.convertToBigDecimal((Object)respDto.getRuleStatus()));
        vo.setPriority(ParamConverter.convertToBigDecimal((Object)respDto.getPriority()));
        vo.setActiveStartTime(DateUtil.format((Date)respDto.getActiveStartTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        vo.setActiveEndTime(DateUtil.format((Date)respDto.getActiveEndTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        vo.setIsDelayAudit(ParamConverter.convertToBigDecimal((Object)respDto.getIsDelayAudit()));
        vo.setDelayAuditType(respDto.getDelayAuditType());
        vo.setIsIgnoreRemarkAudit(ParamConverter.convertToBigDecimal((Object)respDto.getIsIgnoreRemarkAudit()));
        vo.setIsAmountRangeAudit(ParamConverter.convertToBigDecimal((Object)respDto.getIsAmountRangeAudit()));
        vo.setIsLogicalWarehouseAudit(ParamConverter.convertToBigDecimal((Object)respDto.getIsLogicalWarehouseAudit()));
        List logicalWarehouseCodeList = respDto.getLogicalWarehouseCodeList();
        if (CollectionUtils.isNotEmpty((Collection)logicalWarehouseCodeList)) {
            List<LogicalWarehouseVO> logicalWarehouseVOS = logicalWarehouseCodeList.stream().map(o -> {
                LogicalWarehouseVO logicalWarehouseVO = new LogicalWarehouseVO();
                BeanUtils.copyProperties((Object)o, (Object)logicalWarehouseVO);
                logicalWarehouseVO.setWarehouseCode(o.getWarehouseCode());
                logicalWarehouseVO.setWarehouseName(o.getWarehouseName());
                return logicalWarehouseVO;
            }).collect(Collectors.toList());
            vo.setLogicalWarehouseOfAudit(logicalWarehouseVOS);
        }
        vo.setIsGoodsAudit(ParamConverter.convertToBigDecimal((Object)respDto.getIsGoodsAudit()));
        List goodsList = respDto.getGoodsList();
        if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
            List<GoodsVO> goodsVOS = goodsList.stream().map(o -> {
                GoodsVO goodsVO = new GoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)goodsVO);
                goodsVO.setGoodsLongCode(o.getLongCode());
                goodsVO.setGoodsCode(o.getCode());
                goodsVO.setGoodsName(o.getName());
                return goodsVO;
            }).collect(Collectors.toList());
            vo.setGoodsOfAudit(goodsVOS);
        }
        vo.setIsCustomerAudit(ParamConverter.convertToBigDecimal((Object)respDto.getIsCustomerAudit()));
        List customerList = respDto.getCustomerList();
        if (CollectionUtils.isNotEmpty((Collection)customerList)) {
            List<CustomerVO> customerVOS = customerList.stream().map(o -> {
                CustomerVO customerVO = new CustomerVO();
                BeanUtils.copyProperties((Object)o, (Object)customerVO);
                customerVO.setCustomerId(String.valueOf(o.getId()));
                customerVO.setCustomerCode(o.getCode());
                customerVO.setCustomerName(o.getName());
                return customerVO;
            }).collect(Collectors.toList());
            vo.setCustomerOfAudit(customerVOS);
        }
        vo.setIsAreaAudit(ParamConverter.convertToBigDecimal((Object)respDto.getIsAreaAudit()));
        List areaOfAudit = respDto.getAreaOfAudit();
        if (CollectionUtils.isNotEmpty((Collection)areaOfAudit)) {
            List<BaseAreaVO> baseAreaVOS = areaOfAudit.stream().map(o -> {
                BaseAreaVO baseAreaVO = new BaseAreaVO();
                baseAreaVO.setCode(o.getCode());
                baseAreaVO.setName(o.getName());
                return baseAreaVO;
            }).collect(Collectors.toList());
            vo.setAreaOfAudit(baseAreaVOS);
        }
        vo.setApplyOrderType(respDto.getApplyOrderType());
        List applyChannels = respDto.getApplyChannels();
        if (CollectionUtils.isNotEmpty((Collection)applyChannels)) {
            List<OrderChannelVO> orderChannelVOS = applyChannels.stream().map(o -> {
                OrderChannelVO orderChannelVO = new OrderChannelVO();
                BeanUtils.copyProperties((Object)o, (Object)orderChannelVO);
                orderChannelVO.setOrderChannelCode(o.getChannelCode());
                orderChannelVO.setOrderChannelName(o.getChannelName());
                return orderChannelVO;
            }).collect(Collectors.toList());
            vo.setApplyOrderChannels(orderChannelVOS);
        }
        vo.setChannelSelectedType(respDto.getChannelSelectedType());
        if (respDto.getUpdateTime() != null) {
            vo.setUpdateTime(DateUtil.format((Date)respDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setOrderTypeSelectedType(respDto.getOrderTypeSelectedType());
        vo.setApplyOrderType(respDto.getApplyOrderType());
        return vo;
    }

    @Override
    public RestResponse<PageInfo<OrderAutoAuditStrategyResponseVO>> getOrderAutoAuditStrategyListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetOrderAutoAuditStrategyListParams getOrderAutoAuditStrategyListParams) {
        StrategyAutoCheckRuleReportReqDto reqDto = new StrategyAutoCheckRuleReportReqDto();
        BeanUtils.copyProperties((Object)getOrderAutoAuditStrategyListParams, (Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)getOrderAutoAuditStrategyListParams.getCreateStartTime())) {
            reqDto.setCreateStartTime(DateUtil.parse((String)(getOrderAutoAuditStrategyListParams.getCreateStartTime() + " 00:00:00"), (String)com.dtyunxi.cube.utils.enums.DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getOrderAutoAuditStrategyListParams.getCreateEndTime())) {
            reqDto.setCreateEndTime(DateUtil.parse((String)(getOrderAutoAuditStrategyListParams.getCreateEndTime() + " 23:59:59"), (String)com.dtyunxi.cube.utils.enums.DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getOrderAutoAuditStrategyListParams.getUpdateStartTime())) {
            reqDto.setUpdateStartTime(DateUtil.parse((String)(getOrderAutoAuditStrategyListParams.getUpdateStartTime() + " 00:00:00"), (String)com.dtyunxi.cube.utils.enums.DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getOrderAutoAuditStrategyListParams.getUpdateEndTime())) {
            reqDto.setUpdateEndTime(DateUtil.parse((String)(getOrderAutoAuditStrategyListParams.getUpdateEndTime() + " 23:59:59"), (String)com.dtyunxi.cube.utils.enums.DatePattern.DATETIME_PATTERN.getPattern()));
        }
        reqDto.setRuleStatus(ParamConverter.convertToInteger((Object)getOrderAutoAuditStrategyListParams.getRuleStatus()));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleReportQueryApi.queryByPage(reqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            ArrayList<OrderChannelVO> orderChannelVOS = new ArrayList<OrderChannelVO>();
            CubeBeanUtils.copyCollection(orderChannelVOS, (Collection)o.getApplyOrderChannels(), OrderChannelVO.class);
            OrderAutoAuditStrategyResponseVO vo = new OrderAutoAuditStrategyResponseVO();
            BeanUtils.copyProperties((Object)o, (Object)vo, (String[])new String[]{"applyOrderChannels"});
            vo.setApplyOrderChannels(orderChannelVOS);
            vo.setApplyOrderType(o.getApplyOrderType());
            vo.setRuleStatus(ParamConverter.convertToBigDecimal((Object)o.getRuleStatus()));
            vo.setPriority(ParamConverter.convertToBigDecimal((Object)o.getPriority()));
            vo.setCreateTime(this.builderFormatTime(o.getCreateTime()));
            vo.setUpdateTime(this.builderFormatTime(o.getUpdateTime()));
            vo.setActiveStartTime(this.builderFormatTime(o.getActiveStartTime()));
            vo.setActiveEndTime(this.builderFormatTime(o.getActiveEndTime()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateOrderAutoAuditStrategy(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitOrderAutoAuditStrategyBody submitOrderAutoAuditStrategyBody) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new BizException("\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u53c2\u6570\u6709\u8bef");
        }
        BizStrategyAutoCheckRuleReqDto reqDto = new BizStrategyAutoCheckRuleReqDto();
        BeanUtils.copyProperties((Object)submitOrderAutoAuditStrategyBody, (Object)reqDto);
        reqDto.setId(Long.valueOf(id));
        this.setModifyParams(submitOrderAutoAuditStrategyBody, reqDto);
        RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleApi.modifyStrategyAutoCheckRule(reqDto));
        return new RestResponse();
    }

    private void setModifyParams(SubmitOrderAutoAuditStrategyBody submitOrderAutoAuditStrategyBody, BizStrategyAutoCheckRuleReqDto reqDto) {
        SubmitOrderAutoAuditStrategyBodyOldData newData = submitOrderAutoAuditStrategyBody.getNewData();
        SubmitOrderAutoAuditStrategyBodyOldData oldData = submitOrderAutoAuditStrategyBody.getOldData();
        BeanUtils.copyProperties((Object)newData, (Object)reqDto);
        reqDto.setRuleName(newData.getRuleName());
        reqDto.setRuleStatus(ParamConverter.convertToInteger((Object)newData.getRuleStatus()));
        reqDto.setPriority(ParamConverter.convertToInteger((Object)newData.getPriority()));
        if (StringUtils.isNotBlank((CharSequence)newData.getActiveStartTime())) {
            reqDto.setActiveStartTime(ParamConverter.convertToDate((String)newData.getActiveStartTime(), (DatePattern)DatePattern.DATETIME_PATTERN));
        }
        if (StringUtils.isNotBlank((CharSequence)newData.getActiveEndTime())) {
            reqDto.setActiveEndTime(ParamConverter.convertToDate((String)newData.getActiveEndTime(), (DatePattern)DatePattern.DATETIME_PATTERN));
        }
        reqDto.setPriority(ParamConverter.convertToInteger((Object)newData.getPriority()));
        reqDto.setIsDelayAudit(ParamConverter.convertToInteger((Object)newData.getIsDelayAudit()));
        reqDto.setDelayAuditType(ParamConverter.convertToString((Object)newData.getDelayAuditType()));
        reqDto.setDelayAuditValue(newData.getDelayAuditValue());
        reqDto.setIsIgnoreRemarkAudit(ParamConverter.convertToInteger((Object)newData.getIsIgnoreRemarkAudit()));
        reqDto.setIsAmountRangeAudit(ParamConverter.convertToInteger((Object)newData.getIsAmountRangeAudit()));
        reqDto.setAmountRangeMaximum(newData.getAmountRangeMaximum());
        reqDto.setAmountRangeMinimum(newData.getAmountRangeMinimum());
        reqDto.setIsLogicalWarehouseAudit(ParamConverter.convertToInteger((Object)newData.getIsLogicalWarehouseAudit()));
        List<String> newLogicalWarehouseOfAudit = newData.getLogicalWarehouseOfAudit();
        List<String> oldLogicalWarehouseOfAudit = oldData.getLogicalWarehouseOfAudit();
        ChangeContentItemReqDto logicalWarehouseOfAudit = new ChangeContentItemReqDto();
        logicalWarehouseOfAudit.setAdd(CollectionUtil.subtractToList(newLogicalWarehouseOfAudit, oldLogicalWarehouseOfAudit));
        logicalWarehouseOfAudit.setDelete(CollectionUtil.subtractToList(oldLogicalWarehouseOfAudit, newLogicalWarehouseOfAudit));
        reqDto.setLogicalWarehouseCodeOfAudit(logicalWarehouseOfAudit);
        reqDto.setIsGoodsAudit(ParamConverter.convertToInteger((Object)newData.getIsGoodsAudit()));
        List<String> newGoodsOfAudit = newData.getGoodsOfAudit();
        List<String> oldGoodsOfAudit = oldData.getGoodsOfAudit();
        ChangeContentItemReqDto goodsOfAudit = new ChangeContentItemReqDto();
        goodsOfAudit.setAdd(CollectionUtil.subtractToList(newGoodsOfAudit, oldGoodsOfAudit));
        goodsOfAudit.setDelete(CollectionUtil.subtractToList(oldGoodsOfAudit, newGoodsOfAudit));
        reqDto.setGoodsOfAudit(goodsOfAudit);
        reqDto.setIsCustomerAudit(ParamConverter.convertToInteger((Object)newData.getIsCustomerAudit()));
        List<String> newCustomerOfAudit = newData.getCustomerOfAudit();
        List<String> oldCustomerOfAudit = oldData.getCustomerOfAudit();
        ChangeContentItemReqDto customerOfAudit = new ChangeContentItemReqDto();
        customerOfAudit.setAdd(CollectionUtil.subtractToList(newCustomerOfAudit, oldCustomerOfAudit));
        customerOfAudit.setDelete(CollectionUtil.subtractToList(oldCustomerOfAudit, newCustomerOfAudit));
        reqDto.setCustomerIdOfAudit(customerOfAudit);
        reqDto.setIsAreaAudit(ParamConverter.convertToInteger((Object)newData.getIsAreaAudit()));
        List<String> newAreaOfAudit = newData.getAreaOfAudit();
        List<String> oldAreaOfAudit = oldData.getAreaOfAudit();
        ChangeContentItemReqDto areaOfAudit = new ChangeContentItemReqDto();
        areaOfAudit.setAdd(CollectionUtil.subtractToList(newAreaOfAudit, oldAreaOfAudit));
        areaOfAudit.setDelete(CollectionUtil.subtractToList(oldAreaOfAudit, newAreaOfAudit));
        reqDto.setAreaOfAudit(areaOfAudit);
        reqDto.setChannelSelectedType(newData.getChannelSelectedType());
        List<String> newApplyOrderChannels = newData.getApplyOrderChannels();
        List<String> oldApplyOrderChannels = oldData.getApplyOrderChannels();
        ChangeContentItemReqDto applyOrderChannels = new ChangeContentItemReqDto();
        applyOrderChannels.setAdd(CollectionUtil.subtractToList(newApplyOrderChannels, oldApplyOrderChannels));
        applyOrderChannels.setDelete(CollectionUtil.subtractToList(oldApplyOrderChannels, newApplyOrderChannels));
        reqDto.setApplyChannels(applyOrderChannels);
        reqDto.setOrderTypeSelectedType(newData.getOrderTypeSelectedType());
        reqDto.setApplyOrderType(newData.getApplyOrderType());
        reqDto.setIsSellerRemarkAudit(newData.getIsSellerRemarkAudit());
        String newSellerRemarkOfAudit = newData.getSellerRemarkKeyWords();
        String oldSellerRemarkOfAudit = oldData.getSellerRemarkKeyWords();
        ChangeContentItemReqDto changeContentItemReqDto = new ChangeContentItemReqDto();
        changeContentItemReqDto.setAdd((List)Lists.newArrayList((Object[])new String[]{newSellerRemarkOfAudit}));
        changeContentItemReqDto.setDelete((List)Lists.newArrayList((Object[])new String[]{newSellerRemarkOfAudit}));
        changeContentItemReqDto.setSellerRemarkKeyFlag(newData.getSellerRemarkKeyFlag());
        reqDto.setSellerRemark(changeContentItemReqDto);
        ChangeContentItemReqDto itemReqDto = new ChangeContentItemReqDto();
        itemReqDto.setAdd((List)Lists.newArrayList((Object[])new String[]{newData.getSellerAutoRemarkKeyWords()}));
        itemReqDto.setDelete((List)Lists.newArrayList((Object[])new String[]{newData.getSellerAutoRemarkKeyWords()}));
        itemReqDto.setSellerRemarkKeyFlag(newData.getSellerAutoRemarkKeyFlag());
        reqDto.setSellerAutoRemark(itemReqDto);
    }

    private String builderFormatTime(Date date) {
        if (date != null) {
            return DateUtil.format((Date)date, (String)com.dtyunxi.cube.utils.enums.DatePattern.DATETIME_PATTERN.getPattern());
        }
        return null;
    }

    @Override
    public RestResponse<PageInfo<OrderAutoAuditStrategyRelevantOrderVo>> queryOrderAutoAuditStrategyRelevantOrderList(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) GetOrderAutoAuditStrategyRelevantOrderListParams getOrderAutoAuditStrategyRelevantOrderListParams) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new BizException("\u8ba2\u5355\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u53c2\u6570\u6709\u8bef");
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckOrderQueryApi.queryByPage(Long.valueOf(id), getOrderAutoAuditStrategyRelevantOrderListParams.getPageNum(), getOrderAutoAuditStrategyRelevantOrderListParams.getPageSize()));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            OrderAutoAuditStrategyRelevantOrderVo vo = new OrderAutoAuditStrategyRelevantOrderVo();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setSaleOrderNo(o.getSaleOrderNo());
            vo.setSaleOrderId(ParamConverter.convertToString((Object)o.getSaleOrderId()));
            vo.setExternalOrderNo(o.getPlatformOrderNo());
            vo.setExternalOrderId(ParamConverter.convertToString((Object)o.getPlatformOrderId()));
            if (o.getExeTime() != null) {
                vo.setExecuteTime(DateUtil.format((Date)o.getExeTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getHitTime() != null) {
                vo.setMatchTime(DateUtil.format((Date)o.getHitTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderLogVO>> getStrategyOptLog(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleOrderLogListPageParams reqDto) {
        if (reqDto.getId() == null) {
            throw new BizException("\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StrategyOptLogReqDto strategyOptLogReqDto = new StrategyOptLogReqDto();
        strategyOptLogReqDto.setStrategyId(reqDto.getId());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.strategyOptLogQueryApi.queryByPage(JSON.toJSONString((Object)strategyOptLogReqDto), reqDto.getPageNum(), reqDto.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            SaleOrderLogVO vo = new SaleOrderLogVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setOperationType(o.getOptType());
            vo.setOperationContent(o.getOptContent());
            vo.setCreatePerson(o.getOptPerson());
            vo.setUpdatePerson(o.getOptPerson());
            if (o.getOptTime() != null) {
                vo.setOperationTime(DateUtil.format((Date)o.getOptTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateSellerAutoRemarkAndExecuteStrategy(UpdateSellerAutoRemarkRequest updateSellerAutoRemarkRequest) {
        logger.info("\u5f00\u59cb\u4fee\u6539\u5546\u5bb6\u81ea\u52a8\u5ba1\u6838\u5173\u952e\u8bcd\u5e76\u6267\u884c\u7b56\u7565\u5ba1\u6838\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)updateSellerAutoRemarkRequest));
        Long id = updateSellerAutoRemarkRequest.getRuleId();
        try {
            if (Objects.isNull(id)) {
                throw new BizException("\u7b56\u7565ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (updateSellerAutoRemarkRequest == null) {
                throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            StrategyAutoCheckRuleDetailRespDto strategyAutoCheckRuleDetailRespDto = (StrategyAutoCheckRuleDetailRespDto)RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleQueryApi.queryById(id));
            if (Objects.isNull(strategyAutoCheckRuleDetailRespDto)) {
                throw new BizException("\u7b56\u7565\u4e0d\u5b58\u5728");
            }
            strategyAutoCheckRuleDetailRespDto.setSellerAutoRemarkKeyFlag("1");
            if (updateSellerAutoRemarkRequest.getSellerAutoRemarkKeyWords() != null && !updateSellerAutoRemarkRequest.getSellerAutoRemarkKeyWords().isEmpty()) {
                String keywordsString = String.join((CharSequence)";", updateSellerAutoRemarkRequest.getSellerAutoRemarkKeyWords());
                strategyAutoCheckRuleDetailRespDto.setSellerAutoRemarkKeyWords(keywordsString);
            }
            String sellerAutoRemarkKeyWords = strategyAutoCheckRuleDetailRespDto.getSellerAutoRemarkKeyWords();
            logger.info("\u5f53\u524d\u7b56\u7565ID\uff1a{}\uff0c\u539f\u5546\u5bb6\u81ea\u52a8\u5ba1\u6838\u5173\u952e\u8bcd\uff1a{}", (Object)id, (Object)sellerAutoRemarkKeyWords);
            logger.info("\u65b0\u4f20\u5165\u7684\u5546\u5bb6\u81ea\u52a8\u5ba1\u6838\u5173\u952e\u8bcd\uff1a{}", updateSellerAutoRemarkRequest.getSellerAutoRemarkKeyWords());
            BizStrategyAutoCheckRuleReqDto bizStrategyAutoCheckRuleReqDto = new BizStrategyAutoCheckRuleReqDto();
            BeanUtils.copyProperties((Object)strategyAutoCheckRuleDetailRespDto, (Object)bizStrategyAutoCheckRuleReqDto);
            bizStrategyAutoCheckRuleReqDto.setId(id);
            bizStrategyAutoCheckRuleReqDto.setType(Integer.valueOf(1));
            ChangeContentItemReqDto changeContentItemReqDto = new ChangeContentItemReqDto();
            ArrayList<String> allKeywords = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)sellerAutoRemarkKeyWords)) {
                String[] existingKeywords = sellerAutoRemarkKeyWords.split(";");
                for (String keyword : existingKeywords) {
                    if (!StringUtils.isNotBlank((CharSequence)keyword.trim())) continue;
                    allKeywords.add(keyword.trim());
                }
            }
            if (updateSellerAutoRemarkRequest.getSellerAutoRemarkKeyWords() != null) {
                for (String newKeyword : updateSellerAutoRemarkRequest.getSellerAutoRemarkKeyWords()) {
                    if (!StringUtils.isNotBlank((CharSequence)newKeyword.trim()) || allKeywords.contains(newKeyword.trim())) continue;
                    allKeywords.add(newKeyword.trim());
                }
            }
            String keywordsString = String.join((CharSequence)";", allKeywords);
            changeContentItemReqDto.setAdd(Collections.singletonList(keywordsString));
            changeContentItemReqDto.setSellerRemarkKeyFlag("1");
            bizStrategyAutoCheckRuleReqDto.setSellerAutoRemark(changeContentItemReqDto);
            logger.info("\u5408\u5e76\u540e\u7684\u5546\u5bb6\u81ea\u52a8\u5ba1\u6838\u5173\u952e\u8bcd\uff1a{}", allKeywords);
            logger.info("\u7b56\u7565\u66f4\u65b0\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)bizStrategyAutoCheckRuleReqDto));
            RestResponseHelper.extractData((RestResponse)this.strategyAutoCheckRuleApi.modifyStrategyAutoCheckRule(bizStrategyAutoCheckRuleReqDto));
            logger.info("\u7b56\u7565\u66f4\u65b0\u6210\u529f\uff0c\u7b56\u7565ID\uff1a{}", (Object)id);
            OrderOperationVO orderOperationVO = new OrderOperationVO();
            CompletableFuture.runAsync(() -> {
                try {
                    logger.info("\u5f00\u59cb\u5f02\u6b65\u6267\u884c\u7b56\u7565\u5ba1\u6838\uff0c\u7b56\u7565ID\uff1a{}", (Object)id);
                    this.orderCenterSaleOrderService.strategyAuditSaleOrder(orderOperationVO);
                    logger.info("\u5f02\u6b65\u6267\u884c\u7b56\u7565\u5ba1\u6838\u6210\u529f\uff0c\u7b56\u7565ID\uff1a{}", (Object)id);
                }
                catch (Exception e) {
                    logger.error("\u5f02\u6b65\u6267\u884c\u7b56\u7565\u5ba1\u6838\u5931\u8d25\uff0c\u7b56\u7565ID\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{id, e.getMessage(), e});
                }
            });
            logger.info("\u7b56\u7565\u5ba1\u6838\u5f02\u6b65\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u7b56\u7565ID\uff1a{}", (Object)id);
            return new RestResponse((Object)"\u4fee\u6539\u5546\u5bb6\u81ea\u52a8\u5ba1\u6838\u5173\u952e\u8bcd\u5e76\u6267\u884c\u7b56\u7565\u5ba1\u6838\u6210\u529f");
        }
        catch (BizException e) {
            logger.error("\u4fee\u6539\u5546\u5bb6\u81ea\u52a8\u5ba1\u6838\u5173\u952e\u8bcd\u5931\u8d25\uff0c\u7b56\u7565ID\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{id, e.getMessage(), e});
            throw e;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5546\u5bb6\u81ea\u52a8\u5ba1\u6838\u5173\u952e\u8bcd\u5f02\u5e38\uff0c\u7b56\u7565ID\uff1a{}", (Object)id, (Object)e);
            throw new BizException("\u4fee\u6539\u5546\u5bb6\u81ea\u52a8\u5ba1\u6838\u5173\u952e\u8bcd\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

