/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.WarehouseTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ChannelInventoryVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryTimeLimitParams;
import com.dtyunxi.cis.pms.biz.model.DeliveryTimeLimitVO;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInventoryQueryVO;
import com.dtyunxi.cis.pms.biz.model.GetChannelInventoryListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetInventoryQueryListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetLogicalInventoryListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetPhysicalInventoryListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetVirtualInventoryListPageParams;
import com.dtyunxi.cis.pms.biz.model.InventoryQueryVO;
import com.dtyunxi.cis.pms.biz.model.LogicalInventoryCountVO;
import com.dtyunxi.cis.pms.biz.model.LogicalInventoryVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalInventoryCountVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalInventoryVO;
import com.dtyunxi.cis.pms.biz.model.VirtualInventoryCountVO;
import com.dtyunxi.cis.pms.biz.model.VirtualInventoryVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterInquiryService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.InventoryUtil;
import com.dtyunxi.cis.search.api.dto.request.EsLogicInventoryListPageParams;
import com.dtyunxi.cis.search.api.dto.response.EsLogicInventoryCountVO;
import com.dtyunxi.cis.search.api.dto.response.EsLogicInventoryVO;
import com.dtyunxi.cis.search.api.query.inventory.EsChannelInventoryQueryApi;
import com.dtyunxi.cis.search.api.query.inventory.EsLogicInventoryQueryApi;
import com.dtyunxi.cis.search.api.query.inventory.EsPhysicsInventoryQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.DeliveryTimeLimitReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryQueryDto;
import com.dtyunxi.tcbj.api.dto.request.LockLogQueryDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.PhysicsInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.LockLogRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryCountDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicsInventoryCountDto;
import com.dtyunxi.tcbj.api.query.IChannelInventoryQueryApi;
import com.dtyunxi.tcbj.api.query.IInventoryReportQueryApi;
import com.dtyunxi.tcbj.api.query.ILockOrderQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.tcbj.api.query.IOutNoticeOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IPhysicsInventoryQueryApi;
import com.dtyunxi.tcbj.api.vo.ChannelInventoryReportRespVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsRealTimeInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualInventoryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.api.share.IDgChannelInventoryApi;
import com.yunxi.dg.base.center.report.api.share.IDgVirtualInventoryApi;
import com.yunxi.dg.base.center.report.dto.share.DgChannelInventoryPageReqDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualInventoryPageReqDto;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.InventorySummaryRespDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_inventory_query")
public class InventoryCenterInquiryServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements InventoryCenterInquiryService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterInquiryServiceServiceImpl.class);
    @Resource
    private EsLogicInventoryQueryApi esLogicInventoryQueryApi;
    @Resource
    private EsChannelInventoryQueryApi esChannelInventoryQueryApi;
    @Resource
    private EsPhysicsInventoryQueryApi esPhysicsInventoryQueryApi;
    @Resource
    private IVirtualInventoryApi iVirtualInventoryQueryApi;
    @Resource
    private IChannelInventoryQueryApi iChannelInventoryQueryApi;
    @Resource
    private IOutNoticeOrderQueryApi outNoticeOrderQueryApi;
    @Autowired
    IInventoryReportQueryApi inventoryReportQueryApi;
    @Autowired
    private IItemExtendQueryApi itemExtendQueryApi;
    @Autowired
    ILockOrderQueryApi lockOrderQueryApi;
    @Autowired
    ILogicInventoryQueryApi logicInventoryQueryApi;
    @Autowired
    IPhysicsInventoryQueryApi physicsInventoryQueryApi;
    @Autowired
    IDgChannelInventoryApi dgChannelInventoryApi;
    @Autowired
    IDgVirtualInventoryApi dgVirtualInventoryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    public static long millionSecondsOfDay = 86400000L;

    @Override
    public RestResponse<PageInfo<ChannelInventoryVO>> getChannelInventoryListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetChannelInventoryListPageParams getChannelInventoryListPageParams) {
        DgChannelInventoryPageReqDto pageReqDto = new DgChannelInventoryPageReqDto();
        pageReqDto.setSkuCode(getChannelInventoryListPageParams.getGoodsLongCode());
        pageReqDto.setSkuName(getChannelInventoryListPageParams.getGoodsName());
        pageReqDto.setWarehouseCode(getChannelInventoryListPageParams.getChannelWarehouseCode());
        pageReqDto.setWarehouseName(getChannelInventoryListPageParams.getChannelWarehouseName());
        pageReqDto.setNeZero(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)getChannelInventoryListPageParams.getIsExceedZero())));
        pageReqDto.setPageNum(getChannelInventoryListPageParams.getPageNum());
        pageReqDto.setPageSize(getChannelInventoryListPageParams.getPageSize());
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgChannelInventoryApi.page(pageReqDto));
        if (dtoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list"});
        List list = dtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList channelInventoryVOS = new ArrayList(list.size());
        list.forEach(p -> {
            ChannelInventoryVO channelInventoryVO = DtoExchangeUtils.createDtoBySource(p, ChannelInventoryVO.class);
            channelInventoryVO.setGoodsLongCode(p.getSkuCode());
            channelInventoryVO.setGoodsName(p.getSkuName());
            channelInventoryVO.setChannelWarehouseCode(p.getWarehouseCode());
            channelInventoryVO.setChannelWarehouseName(p.getWarehouseName());
            channelInventoryVO.setActualInventory(p.getBalance());
            channelInventoryVO.setPreoccupyInventory(p.getPreempt());
            channelInventoryVO.setAvailableInventory(p.getAvailable() != null ? p.getAvailable().setScale(0, 1).toString() : null);
            channelInventoryVOS.add(channelInventoryVO);
        });
        pageInfo.setList(channelInventoryVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<InventoryQueryVO>> getInventoryQueryListPage(GetInventoryQueryListPageParams getInventoryQueryListPageParams) {
        InventoryQueryDto inventoryQueryDto = new InventoryQueryDto();
        inventoryQueryDto.setWarehouseType(getInventoryQueryListPageParams.getWarehouseType());
        inventoryQueryDto.setBatch(getInventoryQueryListPageParams.getBatchNo());
        inventoryQueryDto.setCargoName(getInventoryQueryListPageParams.getGoodsName());
        inventoryQueryDto.setCargoCode(getInventoryQueryListPageParams.getGoodsLongCode());
        inventoryQueryDto.setOldLongCode(getInventoryQueryListPageParams.getOldLongCode());
        inventoryQueryDto.setWarehouseCode(getInventoryQueryListPageParams.getWarehouseCode());
        inventoryQueryDto.setWarehouseName(getInventoryQueryListPageParams.getWarehouseName());
        inventoryQueryDto.setIsExceedZero(getInventoryQueryListPageParams.getIsExceedZero());
        inventoryQueryDto.setPageNum(getInventoryQueryListPageParams.getPageNum());
        inventoryQueryDto.setPageSize(getInventoryQueryListPageParams.getPageSize());
        inventoryQueryDto.setOrganizationNames(getInventoryQueryListPageParams.getOrganizationNames());
        if (CollectionUtils.isEmpty((Collection)inventoryQueryDto.getWarehouseType())) {
            inventoryQueryDto.setWarehouseType((List)Lists.newArrayList((Object[])new String[]{WarehouseTypeEnum.LOGIC.getCode(), WarehouseTypeEnum.CHANNEL.getCode(), WarehouseTypeEnum.IN_TRANSIT.getCode(), WarehouseTypeEnum.VIRTUAL.getCode()}));
        }
        logger.info("inventoryQueryDto,\u4f20\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inventoryQueryDto));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryReportQueryApi.queryInventoryPage(inventoryQueryDto));
        logger.info("respDtoPageInfo,\u4f20\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
        if (respDtoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            InventoryQueryVO vo = new InventoryQueryVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsName(o.getCargoName());
            vo.setBatchNo(o.getBatch());
            vo.setWarehouseType(o.getClassify());
            vo.setActualInventory(ParamConverter.convertToBigDecimal((Object)o.getBalance()));
            vo.setAvailableInventory(ParamConverter.convertToBigDecimal((Object)o.getAvailable()));
            vo.setWaitInventory(ParamConverter.convertToBigDecimal((Object)o.getFutureIn()));
            vo.setPreoccupyInventory(ParamConverter.convertToBigDecimal((Object)o.getPreempt()));
            vo.setPreemptInventory(ParamConverter.convertToBigDecimal((Object)o.getLockInventory()));
            vo.setSaleInventory(ParamConverter.convertToBigDecimal((Object)o.getAllocate()));
            if (StringUtils.isNotBlank((CharSequence)o.getProduceTime())) {
                vo.setProduceTime(o.getProduceTime().substring(0, 10));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getExpireTime())) {
                vo.setExpireTime(o.getExpireTime().substring(0, 10));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<LogicalInventoryCountVO> getLogicalInventoryCount(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicalInventoryListPageParams getLogicalInventoryListPageParams) {
        EsLogicInventoryListPageParams pageQueryDto = DtoExchangeUtils.createDtoBySource(getLogicalInventoryListPageParams, EsLogicInventoryListPageParams.class);
        pageQueryDto.setItemLongCode(getLogicalInventoryListPageParams.getGoodsLongCode());
        pageQueryDto.setItemName(getLogicalInventoryListPageParams.getGoodsName());
        pageQueryDto.setBatch(getLogicalInventoryListPageParams.getBatchNo());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getIsExpire())) {
            pageQueryDto.setExpired(Integer.valueOf(getLogicalInventoryListPageParams.getIsExpire()));
        }
        pageQueryDto.setWarehouseCode(getLogicalInventoryListPageParams.getLogicalWarehouseCode());
        pageQueryDto.setWarehouseName(getLogicalInventoryListPageParams.getLogicalWarehouseName());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getExpireDateStart())) {
            pageQueryDto.setExpireBeginTime(getLogicalInventoryListPageParams.getExpireDateStart());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getExpireDateEnd())) {
            pageQueryDto.setExpireEndTime(getLogicalInventoryListPageParams.getExpireDateEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getIsExceedZero())) {
            pageQueryDto.setPositiveBalance(Integer.valueOf(getLogicalInventoryListPageParams.getIsExceedZero()));
        }
        pageQueryDto.setWarehouseProperty(getLogicalInventoryListPageParams.getLogicalWarehouseAttr());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getLogicalWarehouseQuality())) {
            pageQueryDto.setWarehouseQuality(getLogicalInventoryListPageParams.getLogicalWarehouseQuality());
        }
        pageQueryDto.setPhysicsWarehouseId(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseId());
        pageQueryDto.setPhysicsWarehouseName(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseName());
        EsLogicInventoryCountVO logicInventoryCountVO = (EsLogicInventoryCountVO)RestResponseHelper.extractData((RestResponse)this.esLogicInventoryQueryApi.queryLogicInventoryByCount(pageQueryDto));
        if (logicInventoryCountVO == null) {
            return new RestResponse();
        }
        LogicalInventoryCountVO logicalInventoryVO = DtoExchangeUtils.createDtoBySource(logicInventoryCountVO, LogicalInventoryCountVO.class);
        logicalInventoryVO.setActualInventory(logicInventoryCountVO.getCountBalance());
        logicalInventoryVO.setAvailableInventory(logicInventoryCountVO.getCountAvailable());
        logicalInventoryVO.setReceivedInventory(logicInventoryCountVO.getCountFutureIn());
        logicalInventoryVO.setMoveInventory(logicInventoryCountVO.getCountIntransit());
        logicalInventoryVO.setPreoccupyInventory(logicInventoryCountVO.getCountPreempt());
        logicalInventoryVO.setCountInventory(logicInventoryCountVO.getTotalCount());
        return new RestResponse((Object)logicalInventoryVO);
    }

    @Override
    public RestResponse<LogicalInventoryCountVO> getLogicalTotalInventoryCount(@Valid GetLogicalInventoryListPageParams getLogicalInventoryListPageParams) {
        EsLogicInventoryListPageParams pageQueryDto = DtoExchangeUtils.createDtoBySource(getLogicalInventoryListPageParams, EsLogicInventoryListPageParams.class);
        LogicInventoryReqDto logicInventoryReqDto = DtoExchangeUtils.createDtoBySource(getLogicalInventoryListPageParams, LogicInventoryReqDto.class);
        logicInventoryReqDto.setItemLongCode(getLogicalInventoryListPageParams.getGoodsLongCode());
        logicInventoryReqDto.setItemName(getLogicalInventoryListPageParams.getGoodsName());
        logicInventoryReqDto.setBatch(getLogicalInventoryListPageParams.getBatchNo());
        logicInventoryReqDto.setWarehouseCode(getLogicalInventoryListPageParams.getLogicalWarehouseCode());
        logicInventoryReqDto.setWarehouseName(getLogicalInventoryListPageParams.getLogicalWarehouseName());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getIsExceedZero())) {
            logicInventoryReqDto.setPositiveBalance(Integer.valueOf(getLogicalInventoryListPageParams.getIsExceedZero()));
        }
        logicInventoryReqDto.setWarehouseProperty(getLogicalInventoryListPageParams.getLogicalWarehouseAttr());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getLogicalWarehouseQuality())) {
            logicInventoryReqDto.setWarehouseQuality(getLogicalInventoryListPageParams.getLogicalWarehouseQuality());
        }
        logicInventoryReqDto.setWarehouseClassify(getLogicalInventoryListPageParams.getWarehouseClassify());
        logicInventoryReqDto.setPhysicsWarehouseId(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseId());
        logicInventoryReqDto.setPhysicsWarehouseName(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseName());
        logicInventoryReqDto.setPageNum(getLogicalInventoryListPageParams.getPageNum());
        logicInventoryReqDto.setPageSize(getLogicalInventoryListPageParams.getPageSize());
        LogicInventoryCountDto logicInventoryCountVO = (LogicInventoryCountDto)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryTotalByCount(logicInventoryReqDto));
        if (logicInventoryCountVO == null) {
            return new RestResponse();
        }
        LogicalInventoryCountVO logicalInventoryVO = DtoExchangeUtils.createDtoBySource(logicInventoryCountVO, LogicalInventoryCountVO.class);
        logicalInventoryVO.setActualInventory(logicInventoryCountVO.getCountBalance());
        logicalInventoryVO.setAvailableInventory(logicInventoryCountVO.getCountAvailable());
        logicalInventoryVO.setReceivedInventory(logicInventoryCountVO.getCountFutureIn());
        logicalInventoryVO.setMoveInventory(logicInventoryCountVO.getCountIntransit());
        logicalInventoryVO.setPreoccupyInventory(logicInventoryCountVO.getCountPreempt());
        logicalInventoryVO.setCountInventory(logicInventoryCountVO.getTotalCount());
        return new RestResponse((Object)logicalInventoryVO);
    }

    @Override
    public RestResponse<PageInfo<LogicalInventoryVO>> getLogicalInventoryListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicalInventoryListPageParams getLogicalInventoryListPageParams) {
        return this.getPageInfoRestResponse(getLogicalInventoryListPageParams);
    }

    @Override
    public RestResponse<PageInfo<LogicalInventoryVO>> getLogicalInventoryTotalListPage(@Valid GetLogicalInventoryListPageParams getLogicalInventoryListPageParams) {
        LogicInventoryReqDto logicInventoryReqDto = (LogicInventoryReqDto)BeanUtil.copyProperties((Object)getLogicalInventoryListPageParams, LogicInventoryReqDto.class, (String[])new String[0]);
        logicInventoryReqDto.setItemLongCode(getLogicalInventoryListPageParams.getGoodsLongCode());
        logicInventoryReqDto.setItemName(getLogicalInventoryListPageParams.getGoodsName());
        logicInventoryReqDto.setBatch(getLogicalInventoryListPageParams.getBatchNo());
        logicInventoryReqDto.setWarehouseCode(getLogicalInventoryListPageParams.getLogicalWarehouseCode());
        logicInventoryReqDto.setWarehouseName(getLogicalInventoryListPageParams.getLogicalWarehouseName());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getIsExceedZero())) {
            logicInventoryReqDto.setPositiveBalance(Integer.valueOf(getLogicalInventoryListPageParams.getIsExceedZero()));
        }
        logicInventoryReqDto.setWarehouseProperty(getLogicalInventoryListPageParams.getLogicalWarehouseAttr());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getLogicalWarehouseQuality())) {
            logicInventoryReqDto.setWarehouseQuality(getLogicalInventoryListPageParams.getLogicalWarehouseQuality());
        }
        logicInventoryReqDto.setWarehouseClassify(getLogicalInventoryListPageParams.getWarehouseClassify());
        logicInventoryReqDto.setPhysicsWarehouseId(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseId());
        logicInventoryReqDto.setPhysicsWarehouseName(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseName());
        logicInventoryReqDto.setPageNum(getLogicalInventoryListPageParams.getPageNum());
        logicInventoryReqDto.setPageSize(getLogicalInventoryListPageParams.getPageSize());
        PageInfo logicInventoryVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryTotalByPage(logicInventoryReqDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)logicInventoryVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = logicInventoryVoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList<LogicalInventoryVO> logicalInventoryVOS = new ArrayList<LogicalInventoryVO>(list.size());
        for (LogicInventoryRespDto p : list) {
            LogicalInventoryVO logicalInventoryVO = DtoExchangeUtils.createDtoBySource(p, LogicalInventoryVO.class);
            logicalInventoryVO.setGoodsLongCode(p.getItemLongCode());
            logicalInventoryVO.setGoodsName(p.getItemName());
            logicalInventoryVO.setLogicalWarehouseCode(p.getWarehouseCode());
            logicalInventoryVO.setLogicalWarehouseName(p.getWarehouseName());
            logicalInventoryVO.setLogicalWarehouseAttr(p.getWarehouseProperty());
            logicalInventoryVO.setLogicalWarehouseQuality(p.getWarehouseQuality());
            logicalInventoryVO.setOwnPhysicalWarehouseName(p.getPhysicsWarehouseName());
            logicalInventoryVO.setGoodsBarCode(p.getItemBarCode());
            logicalInventoryVO.setLockInventory(p.getLockInventory());
            logicalInventoryVO.setActualInventory(p.getBalance());
            logicalInventoryVO.setAvailableInventory(p.getAvailable());
            logicalInventoryVO.setMoveInventory(p.getIntransit());
            logicalInventoryVO.setReceivedInventory(p.getFutureIn());
            logicalInventoryVO.setPreoccupyInventory(p.getPreempt());
            logicalInventoryVOS.add(logicalInventoryVO);
        }
        pageInfo.setList(logicalInventoryVOS);
        return new RestResponse((Object)pageInfo);
    }

    private RestResponse<PageInfo<LogicalInventoryVO>> getPageInfoRestResponse(GetLogicalInventoryListPageParams getLogicalInventoryListPageParams) {
        LogicInventoryReqDto logicInventoryReqDto = DtoExchangeUtils.createDtoBySource(getLogicalInventoryListPageParams, LogicInventoryReqDto.class);
        logicInventoryReqDto.setItemLongCode(getLogicalInventoryListPageParams.getGoodsLongCode());
        logicInventoryReqDto.setItemName(getLogicalInventoryListPageParams.getGoodsName());
        logicInventoryReqDto.setBatch(getLogicalInventoryListPageParams.getBatchNo());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getIsExpire())) {
            logicInventoryReqDto.setExpired(Integer.valueOf(getLogicalInventoryListPageParams.getIsExpire()));
        }
        logicInventoryReqDto.setWarehouseCode(getLogicalInventoryListPageParams.getLogicalWarehouseCode());
        logicInventoryReqDto.setWarehouseName(getLogicalInventoryListPageParams.getLogicalWarehouseName());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getExpireDateStart())) {
            logicInventoryReqDto.setExpireBeginTime(DateUtil.parse((String)getLogicalInventoryListPageParams.getExpireDateStart()));
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getExpireDateEnd())) {
            logicInventoryReqDto.setExpireEndTime(DateUtil.parse((String)getLogicalInventoryListPageParams.getExpireDateEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getIsExceedZero())) {
            logicInventoryReqDto.setPositiveBalance(Integer.valueOf(getLogicalInventoryListPageParams.getIsExceedZero()));
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getLogicalWarehouseAttr())) {
            logicInventoryReqDto.setWarehouseProperty(getLogicalInventoryListPageParams.getLogicalWarehouseAttr());
            String warehousePropertyCHN = "";
            switch (logicInventoryReqDto.getWarehouseProperty()) {
                case "finished_product": {
                    warehousePropertyCHN = "\u4ea7\u6210\u54c1";
                    break;
                }
                case "semi_finished_product": {
                    warehousePropertyCHN = "\u534a\u6210\u54c1";
                    break;
                }
                case "shoppe": {
                    warehousePropertyCHN = "\u4e13\u67dc";
                    break;
                }
                case "third_party": {
                    warehousePropertyCHN = "\u7b2c\u4e09\u65b9";
                    break;
                }
                case "promotionp_boring": {
                    warehousePropertyCHN = "\u4fc3\u9500\u7269\u6599";
                    break;
                }
                default: {
                    warehousePropertyCHN = logicInventoryReqDto.getWarehouseProperty();
                }
            }
            logicInventoryReqDto.setWarehousePropertyCHN(warehousePropertyCHN);
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getLogicalWarehouseQuality())) {
            logicInventoryReqDto.setWarehouseQuality(getLogicalInventoryListPageParams.getLogicalWarehouseQuality());
        }
        if (getLogicalInventoryListPageParams.getOrganizationNames() != null && !getLogicalInventoryListPageParams.getOrganizationNames().isEmpty()) {
            logicInventoryReqDto.setOrganizationNames(getLogicalInventoryListPageParams.getOrganizationNames());
        }
        logicInventoryReqDto.setValidityLessThanNineMonths(getLogicalInventoryListPageParams.getValidityLessThanNineMonths());
        logicInventoryReqDto.setWarehouseClassify(getLogicalInventoryListPageParams.getWarehouseClassify());
        logicInventoryReqDto.setPhysicsWarehouseId(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseId());
        logicInventoryReqDto.setPhysicsWarehouseName(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseName());
        logicInventoryReqDto.setPageNum(getLogicalInventoryListPageParams.getPageNum());
        logicInventoryReqDto.setPageSize(getLogicalInventoryListPageParams.getPageSize());
        PageInfo logicInventoryVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryByPage(logicInventoryReqDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)logicInventoryVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = logicInventoryVoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList<LogicalInventoryVO> logicalInventoryVOS = new ArrayList<LogicalInventoryVO>(list.size());
        Map<Object, Object> itemExtendRespDtoMap = Maps.newHashMap();
        List itemCodes = list.stream().map(LogicInventoryRespDto::getItemLongCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemCodes)) {
            ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
            itemExtendReqDto.setItemCodeList(itemCodes);
            List itemExtendRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
            itemExtendRespDtoMap = itemExtendRespDtos.stream().collect(Collectors.toMap(ItemExtendRespDto::getItemCode, e -> e, (e1, e2) -> e1));
        }
        HashSet warehouseCodes = Sets.newHashSet();
        HashSet cargoCodes = Sets.newHashSet();
        HashSet batches = Sets.newHashSet();
        for (LogicInventoryRespDto esLogicInventoryVO : list) {
            warehouseCodes.add(esLogicInventoryVO.getWarehouseCode());
            cargoCodes.add(esLogicInventoryVO.getItemLongCode());
            batches.add(esLogicInventoryVO.getBatch());
        }
        LockLogQueryDto lockLogQueryDto = new LockLogQueryDto();
        lockLogQueryDto.setPageNum(Integer.valueOf(1));
        lockLogQueryDto.setPageSize(Integer.valueOf(1000));
        lockLogQueryDto.setWarehouseCodes((List)Lists.newArrayList((Iterable)warehouseCodes));
        lockLogQueryDto.setCargoCodes((List)Lists.newArrayList((Iterable)cargoCodes));
        lockLogQueryDto.setBatches((List)Lists.newArrayList((Iterable)batches));
        PageInfo lockLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.lockOrderQueryApi.queryLogByPage(lockLogQueryDto));
        List lockLogRespDtoList = Lists.newArrayList();
        if (null != lockLogRespDtoPageInfo && null == (lockLogRespDtoList = lockLogRespDtoPageInfo.getList())) {
            lockLogRespDtoList = Lists.newArrayList();
        }
        Map<Object, Object> finalItemExtendRespDtoMap = itemExtendRespDtoMap;
        Date nowDate = new Date();
        for (LogicInventoryRespDto p : list) {
            LockLogRespDto firstLockLog = lockLogRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)p.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getCargoCode(), (CharSequence)p.getItemLongCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)p.getBatch())).findFirst().orElse(null);
            LogicalInventoryVO logicalInventoryVO = DtoExchangeUtils.createDtoBySource(p, LogicalInventoryVO.class);
            logicalInventoryVO.setGoodsLongCode(p.getItemLongCode());
            logicalInventoryVO.setGoodsName(p.getItemName());
            logicalInventoryVO.setLogicalWarehouseCode(p.getWarehouseCode());
            logicalInventoryVO.setLogicalWarehouseName(p.getWarehouseName());
            logicalInventoryVO.setLogicalWarehouseAttr(p.getWarehouseProperty());
            logicalInventoryVO.setLogicalWarehouseQuality(p.getWarehouseQuality());
            logicalInventoryVO.setOwnPhysicalWarehouseName(p.getPhysicsWarehouseName());
            logicalInventoryVO.setGoodsBarCode(p.getItemBarCode());
            logicalInventoryVO.setBatchNo(p.getBatch());
            logicalInventoryVO.setLockInventory(p.getLockInventory());
            if (p.getProduceTime() != null) {
                logicalInventoryVO.setProductionDate(DateUtil.format((Date)p.getProduceTime()));
            }
            if (p.getExpireTime() != null) {
                logicalInventoryVO.setExpireDate(DateUtil.format((Date)p.getExpireTime()));
                Integer isExpire = InventoryUtil.isExpire(p.getExpireTime());
                logicalInventoryVO.setIsExpire(isExpire != null ? isExpire.toString() : null);
            }
            if (p.getCreateTime() != null) {
                int differDay = InventoryCenterInquiryServiceServiceImpl.getDifferDay(p.getCreateTime(), nowDate);
                logicalInventoryVO.setInventoryTime(differDay);
            }
            if (p.getExpiration() != null) {
                logicalInventoryVO.setExpiration(p.getExpiration());
            }
            logicalInventoryVO.setActualInventory(p.getBalance());
            logicalInventoryVO.setAvailableInventory(p.getAvailable());
            logicalInventoryVO.setMoveInventory(p.getIntransit());
            logicalInventoryVO.setReceivedInventory(p.getFutureIn());
            logicalInventoryVO.setPreoccupyInventory(p.getPreempt());
            logicalInventoryVO.setSaleInventory(p.getAllocate());
            ItemExtendRespDto itemExtendRespDto = (ItemExtendRespDto)finalItemExtendRespDtoMap.get(logicalInventoryVO.getGoodsLongCode());
            if (itemExtendRespDto != null) {
                logicalInventoryVO.setClaimPrice(itemExtendRespDto.getClaimPrice());
                logicalInventoryVO.setRecommendPrice(itemExtendRespDto.getRecommendPrice());
            }
            if (null != firstLockLog) {
                logicalInventoryVO.setLastLockLogRemark(firstLockLog.getRemark());
            }
            logicalInventoryVOS.add(logicalInventoryVO);
        }
        pageInfo.setList(logicalInventoryVOS);
        return new RestResponse((Object)pageInfo);
    }

    private static int getDifferDay(Date date1, Date date2) {
        Long d1 = date1.getTime();
        Long d2 = date2.getTime();
        return (int)((d2 - d1) / millionSecondsOfDay);
    }

    private RestResponse<PageInfo<LogicalInventoryVO>> getEsPageInfoRestResponse(GetLogicalInventoryListPageParams getLogicalInventoryListPageParams) {
        EsLogicInventoryListPageParams pageQueryDto = DtoExchangeUtils.createDtoBySource(getLogicalInventoryListPageParams, EsLogicInventoryListPageParams.class);
        pageQueryDto.setItemLongCode(getLogicalInventoryListPageParams.getGoodsLongCode());
        pageQueryDto.setItemName(getLogicalInventoryListPageParams.getGoodsName());
        pageQueryDto.setBatch(getLogicalInventoryListPageParams.getBatchNo());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getIsExpire())) {
            pageQueryDto.setExpired(Integer.valueOf(getLogicalInventoryListPageParams.getIsExpire()));
        }
        pageQueryDto.setWarehouseCode(getLogicalInventoryListPageParams.getLogicalWarehouseCode());
        pageQueryDto.setWarehouseName(getLogicalInventoryListPageParams.getLogicalWarehouseName());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getExpireDateStart())) {
            pageQueryDto.setExpireBeginTime(getLogicalInventoryListPageParams.getExpireDateStart());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getExpireDateEnd())) {
            pageQueryDto.setExpireEndTime(getLogicalInventoryListPageParams.getExpireDateEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getIsExceedZero())) {
            pageQueryDto.setPositiveBalance(Integer.valueOf(getLogicalInventoryListPageParams.getIsExceedZero()));
        }
        pageQueryDto.setWarehouseProperty(getLogicalInventoryListPageParams.getLogicalWarehouseAttr());
        if (StringUtils.isNotBlank((CharSequence)getLogicalInventoryListPageParams.getLogicalWarehouseQuality())) {
            pageQueryDto.setWarehouseQuality(getLogicalInventoryListPageParams.getLogicalWarehouseQuality());
        }
        pageQueryDto.setPhysicsWarehouseId(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseId());
        pageQueryDto.setPhysicsWarehouseName(getLogicalInventoryListPageParams.getOwnPhysicalWarehouseName());
        PageInfo logicInventoryVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esLogicInventoryQueryApi.queryLogicInventoryListPage(pageQueryDto));
        if (logicInventoryVoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)logicInventoryVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = logicInventoryVoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList<LogicalInventoryVO> logicalInventoryVOS = new ArrayList<LogicalInventoryVO>(list.size());
        Map<Object, Object> itemExtendRespDtoMap = Maps.newHashMap();
        List itemCodes = list.stream().map(EsLogicInventoryVO::getItemLongCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemCodes)) {
            ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
            itemExtendReqDto.setItemCodeList(itemCodes);
            List itemExtendRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
            itemExtendRespDtoMap = itemExtendRespDtos.stream().collect(Collectors.toMap(ItemExtendRespDto::getItemCode, e -> e, (e1, e2) -> e1));
        }
        HashSet warehouseCodes = Sets.newHashSet();
        HashSet cargoCodes = Sets.newHashSet();
        HashSet batches = Sets.newHashSet();
        for (EsLogicInventoryVO esLogicInventoryVO : list) {
            warehouseCodes.add(esLogicInventoryVO.getWarehouseCode());
            cargoCodes.add(esLogicInventoryVO.getItemLongCode());
            batches.add(esLogicInventoryVO.getBatch());
        }
        LockLogQueryDto lockLogQueryDto = new LockLogQueryDto();
        lockLogQueryDto.setPageNum(Integer.valueOf(1));
        lockLogQueryDto.setPageSize(Integer.valueOf(1000));
        lockLogQueryDto.setWarehouseCodes((List)Lists.newArrayList((Iterable)warehouseCodes));
        lockLogQueryDto.setCargoCodes((List)Lists.newArrayList((Iterable)cargoCodes));
        lockLogQueryDto.setBatches((List)Lists.newArrayList((Iterable)batches));
        PageInfo lockLogRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.lockOrderQueryApi.queryLogByPage(lockLogQueryDto));
        List lockLogRespDtoList = Lists.newArrayList();
        if (null != lockLogRespDtoPageInfo && null == (lockLogRespDtoList = lockLogRespDtoPageInfo.getList())) {
            lockLogRespDtoList = Lists.newArrayList();
        }
        Map<Object, Object> finalItemExtendRespDtoMap = itemExtendRespDtoMap;
        for (EsLogicInventoryVO p : list) {
            LockLogRespDto firstLockLog = lockLogRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)p.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getCargoCode(), (CharSequence)p.getItemLongCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)p.getBatch())).findFirst().orElse(null);
            LogicalInventoryVO logicalInventoryVO = DtoExchangeUtils.createDtoBySource(p, LogicalInventoryVO.class);
            logicalInventoryVO.setGoodsLongCode(p.getItemLongCode());
            logicalInventoryVO.setGoodsName(p.getItemName());
            logicalInventoryVO.setLogicalWarehouseCode(p.getWarehouseCode());
            logicalInventoryVO.setLogicalWarehouseName(p.getWarehouseName());
            logicalInventoryVO.setLogicalWarehouseAttr(p.getWarehouseProperty());
            logicalInventoryVO.setLogicalWarehouseQuality(p.getWarehouseQuality());
            logicalInventoryVO.setOwnPhysicalWarehouseName(p.getPhysicsWarehouseName());
            logicalInventoryVO.setGoodsBarCode(p.getItemBarCode());
            logicalInventoryVO.setBatchNo(p.getBatch());
            if (p.getProduceTime() != null) {
                logicalInventoryVO.setProductionDate(DateUtil.format((Date)p.getProduceTime()));
            }
            if (p.getExpireTime() != null) {
                logicalInventoryVO.setExpireDate(DateUtil.format((Date)p.getExpireTime()));
                Integer isExpire = InventoryUtil.isExpire(p.getExpireTime());
                logicalInventoryVO.setIsExpire(isExpire != null ? isExpire.toString() : null);
            }
            logicalInventoryVO.setActualInventory(p.getBalance());
            logicalInventoryVO.setAvailableInventory(p.getAvailable());
            logicalInventoryVO.setMoveInventory(p.getIntransit());
            logicalInventoryVO.setReceivedInventory(p.getFutureIn());
            logicalInventoryVO.setPreoccupyInventory(p.getPreempt());
            ItemExtendRespDto itemExtendRespDto = (ItemExtendRespDto)finalItemExtendRespDtoMap.get(logicalInventoryVO.getGoodsLongCode());
            if (itemExtendRespDto != null) {
                logicalInventoryVO.setClaimPrice(itemExtendRespDto.getClaimPrice());
                logicalInventoryVO.setRecommendPrice(itemExtendRespDto.getRecommendPrice());
            }
            if (null != firstLockLog) {
                logicalInventoryVO.setLastLockLogRemark(firstLockLog.getRemark());
            }
            logicalInventoryVOS.add(logicalInventoryVO);
        }
        pageInfo.setList(logicalInventoryVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<PhysicalInventoryVO>> getPhysicalInventoryListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetPhysicalInventoryListPageParams getPhysicalInventoryListPageParams) {
        PhysicsInventoryReqDto pageQueryDto = InventoryCenterInquiryServiceServiceImpl.getPhysicsInventoryReqDto(getPhysicalInventoryListPageParams);
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.physicsInventoryQueryApi.queryByPage(pageQueryDto));
        PageInfo voPageInfo = new PageInfo();
        if (null == dtoPageInfo) {
            return new RestResponse();
        }
        BeanUtils.copyProperties((Object)dtoPageInfo, (Object)voPageInfo, (String[])new String[]{"list"});
        if (dtoPageInfo.getTotal() == 0L) {
            return new RestResponse((Object)voPageInfo);
        }
        List dtoList = dtoPageInfo.getList();
        ArrayList voList = Lists.newArrayList();
        dtoList.forEach(dto -> {
            PhysicalInventoryVO physicalInventoryVO = DtoExchangeUtils.createDtoBySource(dto, PhysicalInventoryVO.class);
            physicalInventoryVO.setGoodsLongCode(dto.getItemLongCode());
            physicalInventoryVO.setGoodsName(dto.getItemName());
            physicalInventoryVO.setOwnPhysicalWarehouseName(dto.getWarehouseName());
            physicalInventoryVO.setGoodsBarCode(dto.getItemBarCode());
            physicalInventoryVO.setBatchNo(dto.getBatch());
            if (dto.getProduceTime() != null) {
                physicalInventoryVO.setProduceDate(DateUtil.format((Date)dto.getProduceTime()));
            }
            if (dto.getExpireTime() != null) {
                physicalInventoryVO.setExpireDate(DateUtil.format((Date)dto.getExpireTime()));
            }
            physicalInventoryVO.setIsExpire(InventoryUtil.isExpire(dto.getExpireTime()));
            physicalInventoryVO.setActualInventory(dto.getBalance());
            physicalInventoryVO.setAvailableInventory(dto.getAvailable());
            physicalInventoryVO.setMoveInventory(dto.getIntransit());
            physicalInventoryVO.setReceivedInventory(dto.getFutureIn());
            physicalInventoryVO.setPreoccupyInventory(dto.getPreempt());
            voList.add(physicalInventoryVO);
        });
        voPageInfo.setList((List)voList);
        return new RestResponse((Object)voPageInfo);
    }

    private static PhysicsInventoryReqDto getPhysicsInventoryReqDto(GetPhysicalInventoryListPageParams getPhysicalInventoryListPageParams) {
        PhysicsInventoryReqDto pageQueryDto = DtoExchangeUtils.createDtoBySource(getPhysicalInventoryListPageParams, PhysicsInventoryReqDto.class);
        pageQueryDto.setItemLongCode(getPhysicalInventoryListPageParams.getGoodsLongCode());
        pageQueryDto.setItemName(getPhysicalInventoryListPageParams.getGoodsName());
        pageQueryDto.setBatch(getPhysicalInventoryListPageParams.getBatchNo());
        pageQueryDto.setExpired(getPhysicalInventoryListPageParams.getIsExpire());
        if (StringUtils.isNotBlank((CharSequence)getPhysicalInventoryListPageParams.getStartTime())) {
            pageQueryDto.setExpireBeginTime(DateUtil.parse((String)getPhysicalInventoryListPageParams.getStartTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalInventoryListPageParams.getEndTime())) {
            pageQueryDto.setExpireEndTime(DateUtil.parse((String)getPhysicalInventoryListPageParams.getEndTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalInventoryListPageParams.getIsExceedZero())) {
            pageQueryDto.setPositiveBalance(Integer.valueOf(getPhysicalInventoryListPageParams.getIsExceedZero()));
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalInventoryListPageParams.getOwnPhysicalWarehouseId())) {
            pageQueryDto.setWarehouseId(Long.valueOf(getPhysicalInventoryListPageParams.getOwnPhysicalWarehouseId()));
        }
        if (StringUtils.isNotBlank((CharSequence)getPhysicalInventoryListPageParams.getOwnPhysicalWarehouseName())) {
            pageQueryDto.setWarehouseName(getPhysicalInventoryListPageParams.getOwnPhysicalWarehouseName());
        }
        return pageQueryDto;
    }

    @Override
    public RestResponse<PhysicalInventoryCountVO> getPhysicalInventoryCount(@ApiParam(value="") @Valid @RequestBody(required=false) GetPhysicalInventoryListPageParams getPhysicalInventoryListPageParams) {
        PhysicsInventoryReqDto pageQueryDto = InventoryCenterInquiryServiceServiceImpl.getPhysicsInventoryReqDto(getPhysicalInventoryListPageParams);
        PhysicsInventoryCountDto countDto = (PhysicsInventoryCountDto)RestResponseHelper.extractData((RestResponse)this.physicsInventoryQueryApi.queryByCount(pageQueryDto));
        if (countDto == null) {
            return new RestResponse();
        }
        PhysicalInventoryCountVO physicalInventoryCountVO = DtoExchangeUtils.createDtoBySource(countDto, PhysicalInventoryCountVO.class);
        physicalInventoryCountVO.setActualInventory(countDto.getCountBalance());
        physicalInventoryCountVO.setAvailableInventory(countDto.getCountAvailable());
        physicalInventoryCountVO.setReceivedInventory(countDto.getCountFutureIn());
        physicalInventoryCountVO.setMoveInventory(countDto.getCountIntransit());
        physicalInventoryCountVO.setPreoccupyInventory(countDto.getCountPreempt());
        physicalInventoryCountVO.setCountInventory(countDto.getTotalCount());
        return new RestResponse((Object)physicalInventoryCountVO);
    }

    @Override
    public RestResponse<VirtualInventoryCountVO> getVirtualInventoryCount(@ApiParam(value="") @Valid @RequestBody(required=false) GetVirtualInventoryListPageParams getVirtualInventoryListPageParams) {
        InventoryQueryReqDto inventoryQueryReqDto = new InventoryQueryReqDto();
        inventoryQueryReqDto.setCargoCode(getVirtualInventoryListPageParams.getGoodsSku());
        inventoryQueryReqDto.setCargoName(getVirtualInventoryListPageParams.getGoodsName());
        inventoryQueryReqDto.setWarehouseCode(getVirtualInventoryListPageParams.getVirtualWarehouseCode());
        inventoryQueryReqDto.setWarehouseName(getVirtualInventoryListPageParams.getVirtualWarehouseName());
        inventoryQueryReqDto.setIsExceedZero(getVirtualInventoryListPageParams.getIsExceedZero());
        inventoryQueryReqDto.setSearchDimension(getVirtualInventoryListPageParams.getInventoryDimension());
        inventoryQueryReqDto.setMinQuantity(getVirtualInventoryListPageParams.getMinQuantity());
        inventoryQueryReqDto.setMaxQuantity(getVirtualInventoryListPageParams.getMaxQuantity());
        logger.info("\u4f9b\u8d27\u4ed3\u5e93\u62a5\u8868\u603b\u6570\u67e5\u8be2\u5165\u53c2 :{}", (Object)JSON.toJSONString((Object)inventoryQueryReqDto));
        InventorySummaryRespDto inventorySummaryRespDto = (InventorySummaryRespDto)RestResponseHelper.extractData((RestResponse)this.iVirtualInventoryQueryApi.querySummary(inventoryQueryReqDto));
        logger.info("\u4f9b\u8d27\u4ed3\u5e93\u62a5\u8868\u603b\u6570\u67e5\u8be2\u51fa\u53c2 :{}", (Object)JSON.toJSONString((Object)inventorySummaryRespDto));
        if (inventorySummaryRespDto == null) {
            return new RestResponse();
        }
        VirtualInventoryCountVO inventoryCountVO = DtoExchangeUtils.createDtoBySource(inventorySummaryRespDto, VirtualInventoryCountVO.class);
        inventoryCountVO.setPreoccupyInventory(inventorySummaryRespDto.getPreemptSummary());
        inventoryCountVO.setAvailableInventory(inventorySummaryRespDto.getAvailableSummary());
        return new RestResponse((Object)inventoryCountVO);
    }

    @Override
    public RestResponse<PageInfo<DeliveryTimeLimitVO>> queryPageDeliveryTime(DeliveryTimeLimitParams deliveryTimeLimitParams) {
        DeliveryTimeLimitReqDto searchReqDto = this.queryParams(deliveryTimeLimitParams);
        logger.info("\u8c03\u7528\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)searchReqDto));
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.outNoticeOrderQueryApi.queryDeliveryTime(searchReqDto));
        logger.info("dtoPageInfo,\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)dtoPageInfo));
        if (CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = dtoPageInfo.getList();
        ArrayList DeliveryTimeLimitVOS = new ArrayList(list.size());
        list.forEach(p -> {
            DeliveryTimeLimitVO deliveryTimeLimitVO = DtoExchangeUtils.createDtoBySource(p, DeliveryTimeLimitVO.class);
            if (StringUtils.isNotEmpty((CharSequence)p.getPushTime()) && StringUtils.isNotEmpty((CharSequence)p.getWarehouseTime())) {
                try {
                    double date1 = InventoryCenterInquiryServiceServiceImpl.dateToStamp(p.getPushTime());
                    double date2 = InventoryCenterInquiryServiceServiceImpl.dateToStamp(p.getWarehouseTime());
                    double v = (date2 - date1) / 8.64E7;
                    String str = String.format("%.2f", v);
                    double deliveryTime = Double.parseDouble(str);
                    deliveryTimeLimitVO.setDeliveryTime(String.valueOf(deliveryTime));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            DeliveryTimeLimitVOS.add(deliveryTimeLimitVO);
        });
        pageInfo.setList(DeliveryTimeLimitVOS);
        logger.info("\u5217\u8868\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)pageInfo));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<ChannelInventoryReportRespVo>> queryChannelInventoryReportPage(ChannelInventoryReportQueryDto queryDto) {
        return this.inventoryReportQueryApi.queryChannelInventoryReportPage(queryDto);
    }

    public static long dateToStamp(String s) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = simpleDateFormat.parse(s);
        long res = date.getTime();
        return res;
    }

    private DeliveryTimeLimitReqDto queryParams(DeliveryTimeLimitParams deliveryTimeLimitParams) {
        DeliveryTimeLimitReqDto searchReqDto = new DeliveryTimeLimitReqDto();
        BeanUtils.copyProperties((Object)((Object)deliveryTimeLimitParams), (Object)searchReqDto);
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getBusinessType())) {
            searchReqDto.setBusinessType(deliveryTimeLimitParams.getBusinessType());
        }
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getOutPhysicsWarehouseName())) {
            searchReqDto.setOutPhysicsWarehouseName(deliveryTimeLimitParams.getOutPhysicsWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getRelevanceNo())) {
            searchReqDto.setRelevanceNo(deliveryTimeLimitParams.getRelevanceNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getStatisticalTimeStart())) {
            searchReqDto.setStatisticalTimeStart(deliveryTimeLimitParams.getStatisticalTimeStart());
        }
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getStatisticalTimeEnd())) {
            searchReqDto.setStatisticalTimeEnd(deliveryTimeLimitParams.getStatisticalTimeEnd());
        }
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getPushTimeStart())) {
            searchReqDto.setPushTimeStart(deliveryTimeLimitParams.getPushTimeStart());
        }
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getPushTimeEnd())) {
            searchReqDto.setPushTimeEnd(deliveryTimeLimitParams.getPushTimeEnd());
        }
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getWarehouseTimeStart())) {
            searchReqDto.setWarehouseTimeStart(deliveryTimeLimitParams.getWarehouseTimeStart());
        }
        if (StringUtils.isNotEmpty((CharSequence)deliveryTimeLimitParams.getWarehouseTimeEnd())) {
            searchReqDto.setWarehouseTimeEnd(deliveryTimeLimitParams.getWarehouseTimeEnd());
        }
        searchReqDto.setPageNum(deliveryTimeLimitParams.getPageNum());
        searchReqDto.setPageSize(deliveryTimeLimitParams.getPageSize());
        return searchReqDto;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetInventoryQueryListPageParams params = new GetInventoryQueryListPageParams();
        InventoryQueryDto queryDto = new InventoryQueryDto();
        BeanUtils.copyProperties((Object)params, (Object)queryDto);
        queryDto.setWarehouseType(params.getWarehouseType());
        queryDto.setBatch(params.getBatchNo());
        queryDto.setCargoName(params.getGoodsName());
        queryDto.setCargoCode(params.getGoodsLongCode());
        queryDto.setWarehouseCode(params.getWarehouseCode());
        queryDto.setWarehouseName(params.getWarehouseName());
        queryDto.setIsExceedZero(params.getIsExceedZero());
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        PageInfo inventoryRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryReportQueryApi.queryInventoryPage(queryDto));
        if (null == inventoryRespVoPageInfo || CollectionUtils.isEmpty((Collection)inventoryRespVoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)inventoryRespVoPageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetInventoryQueryListPageParams params = new GetInventoryQueryListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryQueryListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryQueryListPageParams.class);
        }
        InventoryQueryDto queryDto = new InventoryQueryDto();
        BeanUtils.copyProperties((Object)params, (Object)queryDto);
        queryDto.setWarehouseType(params.getWarehouseType());
        queryDto.setBatch(params.getBatchNo());
        queryDto.setCargoName(params.getGoodsName());
        queryDto.setCargoCode(params.getGoodsLongCode());
        queryDto.setWarehouseCode(params.getWarehouseCode());
        queryDto.setWarehouseName(params.getWarehouseName());
        queryDto.setIsExceedZero(params.getIsExceedZero());
        if (CollectionUtils.isEmpty((Collection)queryDto.getWarehouseType())) {
            queryDto.setWarehouseType((List)Lists.newArrayList((Object[])new String[]{WarehouseTypeEnum.LOGIC.getCode(), WarehouseTypeEnum.CHANNEL.getCode(), WarehouseTypeEnum.IN_TRANSIT.getCode(), WarehouseTypeEnum.VIRTUAL.getCode()}));
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo inventoryRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryReportQueryApi.queryInventoryPage(re));
            PageInfo resultPage = new PageInfo();
            BeanUtils.copyProperties((Object)inventoryRespVoPageInfo, (Object)resultPage);
            List list = inventoryRespVoPageInfo.getList().stream().map(o -> {
                ExportInventoryQueryVO vo = new ExportInventoryQueryVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setGoodsLongCode(o.getCargoCode());
                vo.setGoodsName(o.getCargoName());
                vo.setBatchNo(o.getBatch());
                CsWarehouseClassifyEnum classifyEnum = CsWarehouseClassifyEnum.getByCode((String)o.getClassify());
                if (null != classifyEnum) {
                    vo.setWarehouseType(classifyEnum.getDesc());
                }
                vo.setActualInventory(BigDecimalUtils.check((BigDecimal)o.getBalance()).intValue());
                vo.setAvailableInventory(BigDecimalUtils.check((BigDecimal)o.getAvailable()).intValue());
                vo.setWaitInventory(BigDecimalUtils.check((BigDecimal)o.getFutureIn()).intValue());
                vo.setPreoccupyInventory(BigDecimalUtils.check((BigDecimal)o.getPreempt()).intValue());
                vo.setPreemptInventory(BigDecimalUtils.check((BigDecimal)o.getLockInventory()).intValue());
                if (StringUtils.isNotBlank((CharSequence)o.getProduceTime())) {
                    vo.setProduceTime(DateUtil.parse((String)o.getProduceTime(), (String)"yyyy-MM-dd"));
                }
                if (StringUtils.isNotBlank((CharSequence)o.getExpireTime())) {
                    vo.setExpireTime(DateUtil.parse((String)o.getExpireTime(), (String)"yyyy-MM-dd"));
                }
                vo.setAllocate(o.getAllocate().intValue());
                return vo;
            }).collect(Collectors.toList());
            resultPage.setList(list);
            return resultPage;
        }, queryDto, ExportInventoryQueryVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    private void getParams(GetInventoryQueryListPageParams params, CsRealTimeInventoryQueryDto queryDto) {
        BeanUtils.copyProperties((Object)params, (Object)queryDto);
        queryDto.setWarehouseClassify(params.getWarehouseType());
        queryDto.setBatch(params.getBatchNo());
        queryDto.setCargoName(params.getGoodsName());
        queryDto.setLongCode(params.getGoodsLongCode());
        queryDto.setWarehouseCode(params.getWarehouseCode());
        queryDto.setWarehouseName(params.getWarehouseName());
        queryDto.setExpired(ParamConverter.convertToInteger((Object)params.getIsExpire()));
        queryDto.setGtBalance(params.getIsExceedZero());
    }

    private void getChannelParams(GetChannelInventoryListPageParams params, InventoryQueryReqDto pageParams) {
        pageParams.setCargoCode(params.getGoodsLongCode());
        pageParams.setCargoName(params.getGoodsName());
        pageParams.setWarehouseCode(params.getChannelWarehouseCode());
        pageParams.setWarehouseName(params.getChannelWarehouseName());
        pageParams.setPageNum(params.getPageNum());
        pageParams.setPageSize(params.getPageSize());
        pageParams.setSearchDimension(params.getInventoryDimension());
        pageParams.setMinQuantity(params.getMinQuantity());
        pageParams.setMaxQuantity(params.getMaxQuantity());
    }

    private void getVirtualParams(GetVirtualInventoryListPageParams params, InventoryQueryReqDto pageParams) {
        pageParams.setCargoCode(params.getGoodsSku());
        pageParams.setCargoName(params.getGoodsName());
        pageParams.setWarehouseCode(params.getVirtualWarehouseCode());
        pageParams.setWarehouseName(params.getVirtualWarehouseName());
        pageParams.setSearchDimension(params.getInventoryDimension());
        pageParams.setMinQuantity(params.getMinQuantity());
        pageParams.setMaxQuantity(params.getMaxQuantity());
    }

    @Override
    public RestResponse<PageInfo<VirtualInventoryVO>> getVirtualInventoryListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetVirtualInventoryListPageParams getVirtualInventoryListPageParams) {
        DgVirtualInventoryPageReqDto pageReqDto = new DgVirtualInventoryPageReqDto();
        pageReqDto.setSkuCode(getVirtualInventoryListPageParams.getGoodsSku());
        pageReqDto.setSkuName(getVirtualInventoryListPageParams.getGoodsName());
        pageReqDto.setWarehouseCode(getVirtualInventoryListPageParams.getVirtualWarehouseCode());
        pageReqDto.setWarehouseName(getVirtualInventoryListPageParams.getVirtualWarehouseName());
        pageReqDto.setNeZero(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)getVirtualInventoryListPageParams.getIsExceedZero())));
        pageReqDto.setPageNum(getVirtualInventoryListPageParams.getPageNum());
        pageReqDto.setPageSize(getVirtualInventoryListPageParams.getPageSize());
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgVirtualInventoryApi.page(pageReqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        BeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list"});
        List list = dtoPageInfo.getList().stream().map(vo -> {
            VirtualInventoryVO virtualInventoryVO = DtoExchangeUtils.createDtoBySource(vo, VirtualInventoryVO.class);
            virtualInventoryVO.setGoodsSku(vo.getSkuCode());
            virtualInventoryVO.setGoodsName(vo.getSkuName());
            virtualInventoryVO.setVirtualWarehouseCode(vo.getWarehouseCode());
            virtualInventoryVO.setVirtualWarehouseName(vo.getWarehouseName());
            virtualInventoryVO.setAvailableInventory(vo.getAvailable());
            virtualInventoryVO.setPreoccupyInventory(vo.getPreempt());
            return virtualInventoryVO;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }
}

