/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.annotation.OptLog;
import com.dtyunxi.cis.pms.biz.constant.OptLogTypeEnum;
import com.dtyunxi.cis.pms.biz.dto.request.OptLogReqDto;
import com.dtyunxi.cis.pms.biz.export.IExportExcelHelper;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetGoodsWarehousePalletNumListPageParams;
import com.dtyunxi.cis.pms.biz.model.GoodsExportVO;
import com.dtyunxi.cis.pms.biz.model.GoodsImportMsgVO;
import com.dtyunxi.cis.pms.biz.model.GoodsImportVO;
import com.dtyunxi.cis.pms.biz.model.GoodsVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.UpdateGoodsPalletNumParams;
import com.dtyunxi.cis.pms.biz.model.UpdateGoodsPriceParams;
import com.dtyunxi.cis.pms.biz.model.WarehousePalletNumVO;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterGoodsService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.service.opt.IOptLogService;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.IItemExtendApi;
import com.dtyunxi.yundt.cube.center.item.api.IPcpItemApi;
import com.dtyunxi.yundt.cube.center.item.api.IPcpPhysicalTrayApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpPhysicalTrayReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpPhysicalTrayRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpPhysicalTrayQueryApi;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_base_goods_data")
public class BasedataCenterGoodsServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements BasedataCenterGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(BasedataCenterGoodsServiceServiceImpl.class);
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private IPcpPhysicalTrayApi pcpPhysicalTrayApi;
    @Resource
    private IPcpPhysicalTrayQueryApi pcpPhysicalTrayQueryApi;
    @Resource
    private ICsPhysicsWarehouseQueryApi physicsWarehouseQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi physicsWarehouseExposedQueryApi;
    @Resource
    private IItemExtendApi iItemExtendApi;
    @Resource
    private IExportExcelHelper exportExcelHelper;
    @Resource
    private IPcpItemApi iPcpItemApi;
    @Resource
    private IItemExtendQueryApi extendQueryApi;
    @Autowired
    private IOptLogService optLogService;

    @Override
    public RestResponse<GoodsVO> getGoodsDetail(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        PcpItemRespDto csItemRespDto = (PcpItemRespDto)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryByPrimaryKey(Long.valueOf(id)));
        GoodsVO goodsVO = this.getGoodsVO(csItemRespDto);
        return new RestResponse((Object)goodsVO);
    }

    private GoodsVO getGoodsVO(PcpItemRespDto csItemRespDto) {
        GoodsVO goodsVO = DtoExchangeUtils.createDtoBySource(csItemRespDto, GoodsVO.class);
        if (!Objects.isNull(csItemRespDto.getId())) {
            goodsVO.setGoodsId(csItemRespDto.getId().toString());
        }
        goodsVO.setE3ItemCode(csItemRespDto.getE3ItemCode());
        goodsVO.setGoodsType(csItemRespDto.getItemType() != null ? csItemRespDto.getItemType().toString() : null);
        goodsVO.setGoodsCode(csItemRespDto.getCode());
        goodsVO.setGoodsLongCode(csItemRespDto.getItemCode());
        goodsVO.setOldLongCode(csItemRespDto.getOldLongCode());
        goodsVO.setGoodsName(csItemRespDto.getName());
        goodsVO.setGoodsBarCode(csItemRespDto.getBarCode());
        goodsVO.setGoodsPhysicalType(csItemRespDto.getItemDrug());
        goodsVO.setProduceFactory(csItemRespDto.getCfproducers());
        goodsVO.setOldItemName(csItemRespDto.getOldItemName());
        goodsVO.setDisableDate(csItemRespDto.getDisableDate());
        goodsVO.setEnableDate(csItemRespDto.getEnableDate());
        goodsVO.setGoodsSpec(csItemRespDto.getSpecification());
        if (ObjectUtil.isEmpty((Object)csItemRespDto.getRecommendPrice()) || csItemRespDto.getRecommendPrice().compareTo(BigDecimal.ZERO) == 0) {
            goodsVO.setGoodsRetailPrice(null);
        } else {
            goodsVO.setGoodsRetailPrice("**");
        }
        if (ObjectUtil.isEmpty((Object)csItemRespDto.getClaimPrice()) || csItemRespDto.getClaimPrice().compareTo(BigDecimal.ZERO) == 0) {
            goodsVO.setClaimPrice(null);
        } else {
            goodsVO.setClaimPrice("**");
        }
        goodsVO.setUnitName(csItemRespDto.getUnit());
        goodsVO.setLargePackageCoefficient(csItemRespDto.getBigRatio() != null ? BigDecimal.valueOf(csItemRespDto.getBigRatio()) : null);
        goodsVO.setMediumPackageCoefficient(csItemRespDto.getMiddleRatio() != null ? BigDecimal.valueOf(csItemRespDto.getMiddleRatio()) : null);
        goodsVO.setSmallPackageCoefficient(csItemRespDto.getSmallRatio() != null ? BigDecimal.valueOf(csItemRespDto.getSmallRatio()) : null);
        goodsVO.setVolume(csItemRespDto.getVolume());
        goodsVO.setLength(csItemRespDto.getLength());
        goodsVO.setWidth(csItemRespDto.getWidth());
        goodsVO.setHigh(csItemRespDto.getHeight());
        goodsVO.setNormalApproval(csItemRespDto.getStandardApproval());
        goodsVO.setPalletNumFromHZ(csItemRespDto.getZhTrayNum() != null ? BigDecimal.valueOf(csItemRespDto.getZhTrayNum()) : null);
        goodsVO.setIsExemption(csItemRespDto.getExemption());
        goodsVO.setExpiry(csItemRespDto.getExpirationDate());
        goodsVO.setSecurityCode(csItemRespDto.getSecurityCode());
        goodsVO.setExpiryUnit(csItemRespDto.getExpirationUnit());
        goodsVO.setWeight(csItemRespDto.getQuantity());
        goodsVO.setWeightUnitName(csItemRespDto.getQuantityUnit());
        goodsVO.setIsCodeManage(csItemRespDto.getImeiCodeFlag());
        goodsVO.setOldApproval(csItemRespDto.getOldApproval());
        goodsVO.setTotalWeight((csItemRespDto.getQuantity() != null ? csItemRespDto.getQuantity() : BigDecimal.ZERO).multiply(csItemRespDto.getBigRatio() != null ? BigDecimal.valueOf(csItemRespDto.getBigRatio()) : BigDecimal.ZERO).setScale(6, 1));
        goodsVO.setGoodsStatus(csItemRespDto.getItemStatus() != null ? csItemRespDto.getItemStatus().toString() : null);
        goodsVO.setGoodsSpec(csItemRespDto.getSpecification());
        goodsVO.setBrand(csItemRespDto.getBrandName());
        goodsVO.setCreateTime(DateUtil.formatDateTime((Date)csItemRespDto.getItemCreateTime()));
        return goodsVO;
    }

    @Override
    public RestResponse<PageInfo<GoodsVO>> getGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetGoodsListPageParams getGoodsListPageParams) {
        PcpItemQueryDto csItemQueryDto = DtoExchangeUtils.createDtoBySource(getGoodsListPageParams, PcpItemQueryDto.class);
        csItemQueryDto.setItemDrug(getGoodsListPageParams.getGoodsPhysicalType());
        csItemQueryDto.setItemStatus(CollectionUtils.isNotEmpty(getGoodsListPageParams.getGoodsStatus()) ? getGoodsListPageParams.getGoodsStatus() : null);
        csItemQueryDto.setItemType(StringUtils.isNotBlank((CharSequence)getGoodsListPageParams.getGoodsType()) ? Long.valueOf(getGoodsListPageParams.getGoodsType()) : null);
        csItemQueryDto.setLongCode(getGoodsListPageParams.getGoodsLongCode());
        csItemQueryDto.setOldLongCode(getGoodsListPageParams.getOldLongCode());
        csItemQueryDto.setName(getGoodsListPageParams.getGoodsName());
        logger.info("\u67e5\u8be2\u4f20\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)csItemQueryDto));
        PageInfo csItemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryByPage(csItemQueryDto));
        logger.info("csItemRespDtoPageInfo,\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)csItemRespDtoPageInfo));
        List list = csItemRespDtoPageInfo.getList();
        for (PcpItemRespDto pcpItemRespDto : list) {
            System.out.println("\u5f53\u524dPcpItemRespDto\u5bf9\u8c61" + pcpItemRespDto.toString() + " ItemCreateTime:" + pcpItemRespDto.getItemCreateTime());
        }
        PageInfo pageInfo = new PageInfo((List)Lists.newArrayList());
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csItemRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)csItemRespDtoPageInfo.getList())) {
            List goodsVOS = csItemRespDtoPageInfo.getList().stream().map(this::getGoodsVO).collect(Collectors.toList());
            pageInfo.setList(goodsVOS);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<WarehousePalletNumVO>> getGoodsWarehousePalletNumListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetGoodsWarehousePalletNumListPageParams getGoodsWarehousePalletNumListPageParams) {
        PcpPhysicalTrayReqDto reqDto = new PcpPhysicalTrayReqDto();
        reqDto.setItemId(Long.valueOf(getGoodsWarehousePalletNumListPageParams.getGoodsId()));
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo trayPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpPhysicalTrayQueryApi.queryByPage(reqDto));
        List trayList = trayPageInfo.getList();
        Map<Object, Object> trayMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)trayList)) {
            trayMap = trayList.stream().collect(Collectors.toMap(PcpPhysicalTrayRespDto::getPhysicalWarehouseCode, PcpPhysicalTrayRespDto::getTrayNum));
        }
        CsPhysicsWarehousePageQueryDto queryDto = new CsPhysicsWarehousePageQueryDto();
        queryDto.setWarehouseStatus("enable");
        queryDto.setPageNum(getGoodsWarehousePalletNumListPageParams.getPageNum());
        queryDto.setPageSize(getGoodsWarehousePalletNumListPageParams.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseExposedQueryApi.queryPageInfo(queryDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        Map<Object, Object> finalTrayMap = trayMap;
        List list = respDtoPageInfo.getList().stream().map(e -> {
            WarehousePalletNumVO warehousePalletNumVO = new WarehousePalletNumVO();
            warehousePalletNumVO.setId(e.getId());
            warehousePalletNumVO.setPhysicalWarehouseId(e.getId().toString());
            warehousePalletNumVO.setPhysicalWarehouseCode(e.getWarehouseCode());
            warehousePalletNumVO.setPhysicalWarehouseName(e.getWarehouseName());
            BigDecimal palletNum = Objects.isNull(finalTrayMap.get(e.getWarehouseCode())) ? BigDecimal.ZERO : new BigDecimal((Long)finalTrayMap.get(e.getWarehouseCode()));
            warehousePalletNumVO.setPalletNum(palletNum);
            return warehousePalletNumVO;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateGoodsPalletNum(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateGoodsPalletNumParams updateGoodsPalletNumParams) {
        PcpPhysicalTrayReqDto modifyReqDto = new PcpPhysicalTrayReqDto();
        modifyReqDto.setItemId(Long.valueOf(updateGoodsPalletNumParams.getGoodsId()));
        modifyReqDto.setTrayNum(Long.valueOf(updateGoodsPalletNumParams.getPalletNum().longValue()));
        modifyReqDto.setPhysicalWarehouseCode(updateGoodsPalletNumParams.getPhysicalWarehouseCode());
        modifyReqDto.setPhysicalWarehouseId(Long.valueOf(updateGoodsPalletNumParams.getPhysicalWarehouseId()));
        this.pcpPhysicalTrayApi.updateTrayNum(modifyReqDto);
        return new RestResponse();
    }

    @Override
    @OptLog(optOrderType=OptLogTypeEnum.PRODUCT_DATA_LOG, type=OptLogTypeEnum.UPD, optNo="#id")
    public RestResponse<Void> updateGoodsPrice(String id, UpdateGoodsPriceParams updateGoodsPriceParams) {
        ItemExtendReqDto modifyReqDto = new ItemExtendReqDto();
        modifyReqDto.setItemCode(updateGoodsPriceParams.getGoodsSku());
        modifyReqDto.setRecommendPrice(updateGoodsPriceParams.getRecommendPrice());
        modifyReqDto.setClaimPrice(updateGoodsPriceParams.getClaimPrice());
        modifyReqDto.setE3ItemCode(updateGoodsPriceParams.getE3ItemCode());
        this.iItemExtendApi.modifyPrice(modifyReqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> addGoodsLog(GetGoodsListPageParams getGoodsListPageParams) {
        getGoodsListPageParams.setPageNum(1);
        getGoodsListPageParams.setPageSize(100);
        PageInfo pageInfo = (PageInfo)this.getGoodsListPage(getGoodsListPageParams).getData();
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        GoodsVO goodsVO = (GoodsVO)pageInfo.getList().get(0);
        if (goodsVO.getId() == null) {
            return null;
        }
        GoodsVO data = (GoodsVO)this.getGoodsDetail(String.valueOf(goodsVO.getId())).getData();
        if (Objects.isNull(data)) {
            logger.info("\u5546\u54c1\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)goodsVO.getId());
            return null;
        }
        OptLogReqDto optLogReqDto = new OptLogReqDto();
        optLogReqDto.setSnapshot(JSON.toJSONString((Object)data));
        optLogReqDto.setOptNo(String.valueOf(goodsVO.getId()));
        optLogReqDto.setOptOrderType(OptLogTypeEnum.PRODUCT_DATA_LOG.getCode());
        optLogReqDto.setType(OptLogTypeEnum.UPD.getCode());
        optLogReqDto.setOptTime(new Date());
        optLogReqDto.setOptPerson(ServiceContext.getContext().getRequestUserCode());
        this.optLogService.addOptLog(optLogReqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> addItemLog(List<PcpItemRespDto> dtoList) {
        for (PcpItemRespDto dto : dtoList) {
            GoodsVO goodsVO = this.getGoodsVO(dto);
            OptLogReqDto optLogReqDto = new OptLogReqDto();
            optLogReqDto.setSnapshot(JSON.toJSONString((Object)goodsVO));
            optLogReqDto.setOptNo(String.valueOf(dto.getId()));
            optLogReqDto.setOptOrderType(OptLogTypeEnum.PRODUCT_DATA_LOG.getCode());
            optLogReqDto.setType(OptLogTypeEnum.UPD.getCode());
            optLogReqDto.setOptTime(new Date());
            optLogReqDto.setOptPerson(ServiceContext.getContext().getRequestUserCode());
            this.optLogService.addOptLog(optLogReqDto);
        }
        return new RestResponse();
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetGoodsListPageParams params = new GetGoodsListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetGoodsListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetGoodsListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo data = (PageInfo)this.getGoodsListPage((GetGoodsListPageParams)re).getData();
            PageInfo im = new PageInfo();
            BeanUtils.copyProperties((Object)data, (Object)im);
            im.setList(data.getList().stream().map(item -> {
                GoodsExportVO goodsExportVO = new GoodsExportVO();
                BeanUtils.copyProperties((Object)item, (Object)((Object)goodsExportVO));
                goodsExportVO.setGoodsStatus("\u6709\u6548");
                goodsExportVO.setGoodsType(Optional.ofNullable(item.getGoodsType()).filter(StringUtils::isNotBlank).map(type -> {
                    switch (type) {
                        case "1": {
                            return "\u4ea7\u54c1";
                        }
                        case "2": {
                            return "\u8d60\u54c1";
                        }
                        case "3": {
                            return "\u7269\u6599";
                        }
                    }
                    return "";
                }).orElse(""));
                return goodsExportVO;
            }).collect(Collectors.toList()));
            return im;
        }, params, GoodsExportVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetGoodsListPageParams params = new GetGoodsListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetGoodsListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetGoodsListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getGoodsListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("errorList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.iItemExtendApi.updateImportData(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            ArrayList errorList = new ArrayList();
            CubeBeanUtils.copyCollection(errorList, (Collection)msgList, GoodsImportMsgVO.class);
            String excelName = String.format("%s%s", "\u5546\u54c1\u8d44\u6599\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, GoodsImportMsgVO.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList errorList = Lists.newArrayList();
        ArrayList<ItemExtendImportDto> saveList = new ArrayList<ItemExtendImportDto>();
        for (ImportBaseModeDto importDto : result.getList()) {
            GoodsImportVO goodsImportVO = (GoodsImportVO)importDto;
            ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
            itemExtendReqDto.setItemCode(goodsImportVO.getItemCode());
            RestResponse listRestResponse = this.extendQueryApi.queryParam(itemExtendReqDto);
            List itemExtendRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            if (CollectionUtils.isEmpty((Collection)itemExtendRespDtos)) {
                goodsImportVO.setErrorMsg("\u5546\u54c1\u957f\u7f16\u7801\u9519\u8bef");
                errorList.add(goodsImportVO);
                continue;
            }
            String goodsType = goodsImportVO.getItemType();
            if (StringUtils.isNotBlank((CharSequence)goodsType)) {
                String subType = null;
                switch (goodsType) {
                    case "\u4ea7\u54c1": {
                        subType = "1";
                        break;
                    }
                    case "\u8d60\u54c1": {
                        subType = "2";
                        break;
                    }
                    case "\u4fc3\u9500\u7269\u6599": {
                        subType = "3";
                        break;
                    }
                    default: {
                        subType = null;
                    }
                }
                if (StringUtils.isBlank((CharSequence)subType)) {
                    goodsImportVO.setErrorMsg("\u5546\u54c1\u7c7b\u578b\u683c\u5f0f\u9519\u8bef");
                    errorList.add(goodsImportVO);
                    continue;
                }
                goodsImportVO.setItemType(subType);
            }
            if (goodsImportVO.getClaimPrice() != null && goodsImportVO.getClaimPrice().signum() <= 0) {
                goodsImportVO.setErrorMsg("\u5efa\u8bae\u96f6\u552e\u4ef7\u683c\u5f0f\u6709\u8bef");
                errorList.add(goodsImportVO);
                continue;
            }
            if (goodsImportVO.getRecommendPrice() != null && goodsImportVO.getRecommendPrice().signum() <= 0) {
                goodsImportVO.setErrorMsg("\u6295\u4fdd\u96f6\u552e\u4ef7\u683c\u5f0f\u6709\u8bef");
                errorList.add(goodsImportVO);
                continue;
            }
            if (goodsImportVO.getZhTrayNum() != null && goodsImportVO.getZhTrayNum() <= 0L) {
                goodsImportVO.setErrorMsg("\u73e0\u6d77\u4ed3\u7801\u62d6\u6570\u683c\u5f0f\u6709\u8bef");
                errorList.add(goodsImportVO);
                continue;
            }
            if (goodsImportVO.getBigBox() != null && goodsImportVO.getBigBox() <= 0L) {
                goodsImportVO.setErrorMsg("\u88c5\u7bb1\u6570\u683c\u5f0f\u6709\u8bef");
                errorList.add(goodsImportVO);
                continue;
            }
            if (goodsImportVO.getBigRatio() != null && goodsImportVO.getBigRatio() <= 0L) {
                goodsImportVO.setErrorMsg("\u5927\u5305\u7cfb\u6570\u683c\u5f0f\u6709\u8bef");
                errorList.add(goodsImportVO);
                continue;
            }
            if (goodsImportVO.getSmallBox() != null && goodsImportVO.getSmallBox() <= 0L) {
                goodsImportVO.setErrorMsg("\u5c0f\u7bb1\u74f6\u6570\u683c\u5f0f\u6709\u8bef");
                errorList.add(goodsImportVO);
                continue;
            }
            ItemExtendImportDto itemExtendImportDto = new ItemExtendImportDto();
            CubeBeanUtils.copyProperties((Object)itemExtendImportDto, (Object)((Object)goodsImportVO), (boolean)false, (String[])new String[0]);
            saveList.add(itemExtendImportDto);
        }
        logger.info("\u6b63\u5e38\u7ed3\u679c\u6570\u91cf\uff1a{}, \u5f02\u5e38\u7ed3\u679c\u6570\u91cf\uff1a{}\u3002", (Object)saveList.size(), (Object)errorList.size());
        HashMap<String, ArrayList<ItemExtendImportDto>> resultMap = new HashMap<String, ArrayList<ItemExtendImportDto>>();
        resultMap.put("errorList", errorList);
        resultMap.put("saveList", saveList);
        return resultMap;
    }
}

