/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.EnableEnum;
import com.dtyunxi.cis.pms.biz.export.IExportExcelHelper;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportReportCenterSaleOrderOutDetailVO;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderDetailReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.SaleOrderDetailReportVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSaleOrderOutDetailService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.request.SaleOrderContrastPageParams;
import com.dtyunxi.cis.search.api.query.trade.EsSaleOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.SaleOrderContrastPageEsParams;
import com.dtyunxi.tcbj.api.dto.response.es.SaleOrderItemRespEsVo;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_sale_order_out_detail")
public class ReportCenterSaleOrderOutDetailServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterSaleOrderOutDetailService {
    @Resource
    private EsSaleOrderQueryApi esSaleOrderQueryApi;
    @Resource
    private IExportExcelHelper exportExcelHelper;
    @Resource
    private TradeEsReportQueryApi tradeEsReportQueryApi;

    @Override
    public RestResponse<PageInfo<SaleOrderDetailReportVO>> getSaleOrderDetailOutPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleOrderDetailReportListPageParams getSaleOrderDetailReportListPageParams) {
        String[] orderNos;
        ArrayList<String> orderNoList;
        SaleOrderContrastPageParams params = new SaleOrderContrastPageParams();
        CubeBeanUtils.copyProperties((Object)params, (Object)getSaleOrderDetailReportListPageParams, (String[])new String[0]);
        params.setOrderNo(getSaleOrderDetailReportListPageParams.getOrderNo());
        params.setOrderStatus(getSaleOrderDetailReportListPageParams.getOrderStatus());
        params.setOrderSource(getSaleOrderDetailReportListPageParams.getOrderSource());
        params.setBatchNo(getSaleOrderDetailReportListPageParams.getBatchNo());
        params.setOrganizationCode(getSaleOrderDetailReportListPageParams.getCargoRightCode());
        params.setItemCode(getSaleOrderDetailReportListPageParams.getGoodsCode());
        params.setWarehouseCode(getSaleOrderDetailReportListPageParams.getDeliveryPhysicalWarehouse());
        params.setStartItemNum(getSaleOrderDetailReportListPageParams.getGoodsTotalNumStart());
        params.setEndItemNum(getSaleOrderDetailReportListPageParams.getGoodsTotalNumEnd());
        params.setStartOutItemNum(getSaleOrderDetailReportListPageParams.getOutWarehouseNumStart());
        params.setEndOutItemNum(getSaleOrderDetailReportListPageParams.getOutWarehouseNumEnd());
        params.setStartVolumeSum(getSaleOrderDetailReportListPageParams.getVolumeStart());
        params.setEndVolumeSum(getSaleOrderDetailReportListPageParams.getVolumeEnd());
        params.setLogicalWarehouse(getSaleOrderDetailReportListPageParams.getLogicalWarehouseName());
        params.setStartSalePrice(getSaleOrderDetailReportListPageParams.getTaxPriceStart());
        params.setEndSalePrice(getSaleOrderDetailReportListPageParams.getTaxPriceEnd());
        params.setStartLineAmount(getSaleOrderDetailReportListPageParams.getTaxTotalAmountStart());
        params.setEndLineAmount(getSaleOrderDetailReportListPageParams.getTaxTotalAmountEnd());
        params.setOrderTypeList(getSaleOrderDetailReportListPageParams.getOrderTypeList());
        params.setStartTime(getSaleOrderDetailReportListPageParams.getCreateTimeStart());
        params.setEndTime(getSaleOrderDetailReportListPageParams.getCreateTimeEnd());
        params.setUpdatePerson(getSaleOrderDetailReportListPageParams.getUpdatePerson());
        params.setPageNum(getSaleOrderDetailReportListPageParams.getPageNum());
        params.setPageSize(getSaleOrderDetailReportListPageParams.getPageSize());
        params.setCustomerName(getSaleOrderDetailReportListPageParams.getCustomerName());
        PageInfo respVoPageInfo = new PageInfo();
        SaleOrderContrastPageEsParams saleOrderContrastPageEsParams = new SaleOrderContrastPageEsParams();
        CubeBeanUtils.copyProperties((Object)saleOrderContrastPageEsParams, (Object)params, (String[])new String[0]);
        saleOrderContrastPageEsParams.setDeliveryStauts(getSaleOrderDetailReportListPageParams.getDeliveryStauts());
        saleOrderContrastPageEsParams.setWarehouseCodeList(getSaleOrderDetailReportListPageParams.getWarehouseCodeList());
        if (StringUtils.isNotEmpty((CharSequence)params.getOrderNo()) && (orderNoList = new ArrayList<String>(Arrays.asList(orderNos = RptUtil.regExSplit((String)params.getOrderNo())))).size() > 1) {
            saleOrderContrastPageEsParams.setOrderNoList(orderNoList);
            saleOrderContrastPageEsParams.setOrderNo(null);
        }
        if (Objects.nonNull(params.getOrderStatus())) {
            String[] orderStatuss = RptUtil.regExSplit((String)params.getOrderStatus());
            ArrayList<String> orderStatusList = new ArrayList<String>(Arrays.asList(orderStatuss));
            saleOrderContrastPageEsParams.setSaleOrderStatusList(orderStatusList);
            saleOrderContrastPageEsParams.setOrderStatus(null);
        }
        respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.queryOutSaleOrderDetail(saleOrderContrastPageEsParams));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respVoPageInfo.getList().stream().map(o -> {
            SaleOrderDetailReportVO vo = new SaleOrderDetailReportVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setPlatformOrderNo(o.getPlatformOrderNo());
            if (o.getDeliveryTime() != null) {
                vo.setDeliveryTime(o.getDeliveryTime());
            }
            vo.setPlatformOrderId(ParamConverter.convertToString((Object)o.getPlatformOrderId()));
            vo.setSaleOrderNo(o.getSaleOrderNo());
            vo.setOrderStatus(o.getOrderStatus());
            vo.setIntegral(o.getIntegralFlag());
            vo.setOrderSource(ParamConverter.convertToString((Object)o.getOrderSource()));
            vo.setCargoRightCode(o.getOrganizationCode());
            vo.setCargoRightName(o.getOrganizationName());
            vo.setDeliveryPhysicalWarehouseName(o.getPhysicsWarehouseName());
            vo.setBatchNo(o.getDeliveryOutBatchNo());
            vo.setGoodsTotalNum(o.getItemNum());
            vo.setVolume(o.getVolume());
            vo.setOutWarehouseNum(o.getOutItemNum());
            vo.setLogicalWarehouseName(o.getLogicalWarehouseName());
            vo.setTaxPrice(o.getTransactionPrice() == null ? "null" : o.getTransactionPrice().toString());
            if (ObjectUtils.isNotEmpty((Object)vo.getTaxPrice()) && !Objects.equals("null", vo.getTaxPrice()) && ObjectUtils.isNotEmpty((Object)vo.getOutWarehouseNum())) {
                vo.setTaxTotalAmount(new BigDecimal(vo.getTaxPrice()).multiply(vo.getOutWarehouseNum()).toString());
            }
            vo.setRemark(o.getRemark());
            if (StringUtils.isNotBlank((CharSequence)o.getSellerRemark()) && StringUtils.isNotBlank((CharSequence)o.getRemark())) {
                vo.setRemark(String.format("\u5546\u5bb6\u5907\u6ce8:\u3010%s\u3011,\u8ba2\u5355\u5907\u6ce8:\u3010%s\u3011", o.getSellerRemark(), o.getRemark()));
            } else if (StringUtils.isNotBlank((CharSequence)o.getRemark())) {
                vo.setRemark(String.format("\u8ba2\u5355\u5907\u6ce8:\u3010%s\u3011", o.getRemark()));
            } else if (StringUtils.isNotBlank((CharSequence)o.getSellerRemark())) {
                vo.setRemark(String.format("\u5546\u5bb6\u5907\u6ce8:\u3010%s\u3011", o.getSellerRemark()));
            } else {
                vo.setRemark(null);
            }
            vo.setGoodsCode(o.getSkuCode());
            vo.setEasOrderNo(o.getEasOrderNo());
            vo.setGoodsName(o.getItemName());
            vo.setId(o.getId());
            vo.setCreatePerson(o.getCreatePerson());
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (Objects.nonNull(vo.getIntegral())) {
                vo.setIsPointGoods(Objects.equals(vo.getIntegral(), 1) ? EnableEnum.ENABLE.getCode() : EnableEnum.DISABLE.getCode());
            }
            this.setOrderAddressDto((SaleOrderItemRespEsVo)o, vo);
            this.setDeliveryAddressDto((SaleOrderItemRespEsVo)o, vo);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    public void setDeliveryAddressDto(SaleOrderItemRespEsVo o, SaleOrderDetailReportVO vo) {
        AddressVO deliveryAddress = new AddressVO();
        deliveryAddress.setCity(o.getDeliveryCity());
        deliveryAddress.setCityCode(o.getDeliveryCityCode());
        deliveryAddress.setProvinceCode(o.getDeliveryProvinceCode());
        deliveryAddress.setProvince(o.getDeliveryProvince());
        deliveryAddress.setDistrict(o.getDeliveryDistrict());
        deliveryAddress.setDistrictCode(o.getDeliveryDistrictCode());
        deliveryAddress.setDetailAddress(o.getDeliveryDetailAddress());
        vo.setDeliveryAddress(deliveryAddress);
    }

    public void setOrderAddressDto(SaleOrderItemRespEsVo o, SaleOrderDetailReportVO vo) {
        AddressVO orderAddress = new AddressVO();
        orderAddress.setCity(o.getCity());
        orderAddress.setCityCode(o.getCityCode());
        orderAddress.setProvinceCode(o.getProvinceCode());
        orderAddress.setProvince(o.getProvince());
        orderAddress.setDistrict(o.getCounty());
        orderAddress.setDistrictCode(o.getCountyCode());
        orderAddress.setDetailAddress(o.getDetailAddress());
        orderAddress.setReceiveName(o.getDeliveryName());
        orderAddress.setReceivePhone(o.getDeliveryPhone());
        vo.setOrderAddress(orderAddress);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetSaleOrderDetailReportListPageParams params = new GetSaleOrderDetailReportListPageParams();
        SaleOrderContrastPageParams query = new SaleOrderContrastPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSaleOrderDetailReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderDetailReportListPageParams.class);
        }
        GetSaleOrderDetailReportListPageParams finalParams = params;
        return this.exportExcelHelper.doBigDataDivideDataExport(req -> {
            PageInfo saleOrderItemRespVoPageInfo = (PageInfo)RestResponseHelper.extractData(this.getSaleOrderDetailOutPage((GetSaleOrderDetailReportListPageParams)req));
            PageInfo re = new PageInfo();
            BeanUtils.copyProperties((Object)saleOrderItemRespVoPageInfo, (Object)re);
            if (CollectionUtils.isNotEmpty((Collection)saleOrderItemRespVoPageInfo.getList())) {
                re.setList(saleOrderItemRespVoPageInfo.getList().stream().map(o -> {
                    ExportReportCenterSaleOrderOutDetailVO vo = new ExportReportCenterSaleOrderOutDetailVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setSaleOrderNo(o.getSaleOrderNo());
                    try {
                        vo.setOrderStatus(SaleOrderStatusEnum.forCode((String)o.getOrderStatus()).getDesc());
                    }
                    catch (Exception e) {
                        vo.setOrderStatus(o.getOrderStatus());
                    }
                    vo.setOrderSource(SaleOrderSourceEnum.enumOf((Integer)Integer.valueOf(o.getOrderSource())).getDesc());
                    vo.setCargoRightCode(o.getCargoRightCode());
                    vo.setCargoRightName(o.getCargoRightName());
                    vo.setDeliveryPhysicalWarehouseName(o.getDeliveryPhysicalWarehouseName());
                    vo.setItemNum(o.getGoodsTotalNum() == null ? null : o.getGoodsTotalNum().setScale(0, 1));
                    vo.setOutWarehouseNum(o.getOutWarehouseNum() == null ? null : o.getOutWarehouseNum().setScale(0, 1));
                    vo.setLogicalWarehouseName(o.getLogicalWarehouseName());
                    vo.setBatchNo(o.getDeliveryOutBatchNo());
                    vo.setCreatePerson(o.getCreatePerson());
                    if (o.getCreateTime() != null) {
                        vo.setCreateTime(o.getCreateTime());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)o.getDeliveryTime())) {
                        vo.setDeliveryTime(o.getDeliveryTime());
                    }
                    if (o.getUpdateTime() != null) {
                        vo.setUpdateTime(o.getUpdateTime());
                    }
                    if (Objects.nonNull(o.getIntegral())) {
                        vo.setIsPointGoods(Objects.equals(o.getIntegral(), 1) ? "\u662f" : "\u5426");
                    }
                    vo.setDetailAddress(this.getAddress(o.getOrderAddress()));
                    if (Objects.nonNull(o.getDeliveryAddress())) {
                        vo.setDeliveryCityName(o.getDeliveryAddress().getCity());
                    }
                    if (Objects.nonNull(o.getOrderAddress())) {
                        vo.setOrderProvinceName(o.getOrderAddress().getProvince());
                        vo.setOrderCityName(o.getOrderAddress().getCity());
                    }
                    try {
                        vo.setOrderTypeStr(SaleOrderTypeEnum.enumOf((String)o.getOrderType()).getDesc());
                    }
                    catch (Exception e) {
                        vo.setOrderTypeStr(o.getOrderType());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)finalParams.getIsExportPrice())) {
                        vo.setTaxTotalAmount(finalParams.getIsExportPrice().equals("\u662f") ? o.getTaxTotalAmount() : "0");
                        vo.setTaxPrice(finalParams.getIsExportPrice().equals("\u662f") ? o.getTaxPrice() : "0");
                    }
                    return vo;
                }).collect(Collectors.toList()));
            } else {
                re.setList(new ArrayList(0));
            }
            return re;
        }, params, ExportReportCenterSaleOrderOutDetailVO.class, commonReqDto.getFileName()).stream().collect(Collectors.joining(","));
    }

    private String getAddress(AddressVO o) {
        String province = StringUtils.isNotEmpty((CharSequence)o.getProvince()) ? o.getProvince() : "";
        String city = StringUtils.isNotEmpty((CharSequence)o.getCity()) ? o.getCity() : "";
        String district = StringUtils.isNotEmpty((CharSequence)o.getDistrict()) ? o.getDistrict() : "";
        String detailAddress = StringUtils.isNotEmpty((CharSequence)o.getDetailAddress()) ? o.getDetailAddress() : "";
        return province + city + district + detailAddress;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }
}

