/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportFreightCostVO;
import com.dtyunxi.cis.pms.biz.model.FreightCostVO;
import com.dtyunxi.cis.pms.biz.model.GetFreightCostListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportFreightCostDto;
import com.dtyunxi.cis.pms.biz.model.ImportFreightCostMsgDto;
import com.dtyunxi.cis.pms.biz.service.SystemSettingFreightCostService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.center.source.api.IFreightCostApi;
import com.dtyunxi.cube.center.source.api.dto.request.FreightCostReqDto;
import com.dtyunxi.cube.center.source.api.query.IFreightCostQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_freight_cost")
public class SystemSettingFreightCostServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements SystemSettingFreightCostService {
    @Resource
    private IFreightCostApi freightCostApi;
    @Resource
    private IFreightCostQueryApi iFreightCostQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi iCsPhysicsWarehouseExposedQueryApi;
    @Resource
    private IPcpRegionQueryApi iPcpRegionQueryApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportFreightCostDto.class);
        HashSet araeCodes = Sets.newHashSet();
        HashSet whCodes = Sets.newHashSet();
        HashSet logisticsMerchantCodes = Sets.newHashSet();
        HashMap dataMap = Maps.newHashMap();
        HashSet codeSet = Sets.newHashSet();
        list.forEach(i -> {
            araeCodes.add(i.getRouteLoadCode());
            whCodes.add(i.getLogisticsWarehouseCode());
            logisticsMerchantCodes.add(i.getLogisticsMerchantCode());
            String code = String.format("%s_%s", i.getLogisticsWarehouseCode(), i.getRouteLoadCode());
            if (dataMap.containsKey(code)) {
                codeSet.add(code);
            } else {
                dataMap.put(code, i);
            }
        });
        Map<String, CsPhysicsWarehousePageRespDto> whMap = this.getWh(whCodes);
        Map<String, PcpRegionRespDto> araeMap = this.getRegion(araeCodes);
        Map<String, CsShipmenetEnterpriseRespDto> enterpriseMap = this.getShipmenetEnterprise();
        ArrayList msgList = Lists.newArrayList();
        HashMap saveMap = Maps.newHashMap();
        ArrayList saveList = Lists.newArrayList();
        list.stream().forEach(i -> {
            String whCode = i.getLogisticsWarehouseCode();
            String areaCode = i.getRouteLoadCode();
            String merchantCode = i.getLogisticsMerchantCode();
            ImportFreightCostMsgDto msgDto = new ImportFreightCostMsgDto();
            String code = String.format("%s_%s", whCode, areaCode);
            BeanUtils.copyProperties((Object)i, (Object)((Object)msgDto));
            FreightCostReqDto saveDto = new FreightCostReqDto();
            saveDto.setVolumeUnitPrice(new BigDecimal(i.getVolumeUnitPrice()));
            saveDto.setOperator(commonReqDto.getOperator());
            if (codeSet.contains(code)) {
                msgDto.setMsg("\u6570\u636e\u91cd\u590d");
            }
            this.checkWh(whMap, whCode, saveDto, msgDto);
            this.chechArea(araeMap, areaCode, saveDto, msgDto);
            this.chechEnterprise(enterpriseMap, merchantCode, saveDto, msgDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(saveDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.freightCostApi.batchSave(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u8fd0\u8d39\u6210\u672c\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportFreightCostMsgDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return (Integer)RestResponseHelper.extractData((RestResponse)this.iFreightCostQueryApi.queryByCount(commonReqDto.getFilter()));
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetFreightCostListPageParams getFreightCostListPageParams = (GetFreightCostListPageParams)JSON.parseObject((String)filter, GetFreightCostListPageParams.class);
        FreightCostReqDto freightCostReqDto = new FreightCostReqDto();
        if (getFreightCostListPageParams != null) {
            BeanUtils.copyProperties((Object)getFreightCostListPageParams, (Object)freightCostReqDto);
            freightCostReqDto.setLogisticsWarehouseCode(getFreightCostListPageParams.getPhysicalWarehouseCode());
        }
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iFreightCostQueryApi.queryByPage(JSON.toJSONString((Object)freightCostReqDto), commonReqDto.getPageNum(), commonReqDto.getPageSize()));
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            HashSet whCodes = Sets.newHashSet();
            HashSet areaCodes = Sets.newHashSet();
            page.getList().forEach(i -> {
                whCodes.add(i.getLogisticsWarehouseCode());
                areaCodes.add(i.getProvinceCode());
                areaCodes.add(i.getCityCode());
                areaCodes.add(i.getAreaCode());
            });
            CsPhysicsWarehouseParamQueryDto dto = new CsPhysicsWarehouseParamQueryDto();
            dto.setWarehouseCodeList(new ArrayList(whCodes));
            List whList = (List)RestResponseHelper.extractData((RestResponse)this.iCsPhysicsWarehouseExposedQueryApi.queryParam(dto));
            Map whMap = null;
            if (CollectionUtils.isNotEmpty((Collection)whList)) {
                whMap = whList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            }
            PcpRegionReqDto regionReqDto = new PcpRegionReqDto();
            List codes = areaCodes.stream().filter(Objects::nonNull).collect(Collectors.toList());
            regionReqDto.setCodes(codes);
            regionReqDto.setPageNum(Integer.valueOf(1));
            regionReqDto.setPageSize(Integer.valueOf(codes.size()));
            PageInfo areaPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iPcpRegionQueryApi.queryByPage(regionReqDto));
            Map araeMap = null;
            if (CollectionUtils.isNotEmpty((Collection)areaPage.getList())) {
                araeMap = areaPage.getList().stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            Map finalWhMap = whMap;
            Map finalAraeMap = araeMap;
            list = page.getList().stream().map(i -> {
                ExportFreightCostVO vo = new ExportFreightCostVO();
                BeanUtils.copyProperties((Object)i, (Object)((Object)vo));
                if (CollectionUtil.isNotEmpty((Map)finalWhMap) && finalWhMap.containsKey(i.getLogisticsWarehouseCode())) {
                    CsPhysicsWarehousePageRespDto wh = (CsPhysicsWarehousePageRespDto)finalWhMap.get(i.getLogisticsWarehouseCode());
                    vo.setPhysicalWarehouseName(wh.getWarehouseName());
                    vo.setPhysicalWarehouseCode(wh.getWarehouseCode());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getProvinceCode())) {
                    vo.setProvinceName(((PcpRegionRespDto)finalAraeMap.get(i.getProvinceCode())).getName());
                    vo.setReceiveAreaName(vo.getProvinceName());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getCityCode())) {
                    vo.setCityName(((PcpRegionRespDto)finalAraeMap.get(i.getCityCode())).getName());
                    vo.setReceiveAreaName(vo.getReceiveAreaName() + vo.getCityName());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getAreaCode())) {
                    vo.setAreaName(((PcpRegionRespDto)finalAraeMap.get(i.getAreaCode())).getName());
                    vo.setReceiveAreaName(vo.getReceiveAreaName() + vo.getAreaName());
                }
                vo.setCarrierName(i.getLogisticsMerchantName());
                vo.setCarrierCode(i.getLogisticsMerchantCode());
                vo.setVolumeUnitPrice(String.valueOf(i.getVolumeUnitPrice()));
                vo.setReceiveAreaCode(i.getRouteLoadCode());
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public RestResponse<Object> deleteFreightCost(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        RestResponseHelper.extractData((RestResponse)this.freightCostApi.removeFreightCost(id));
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<FreightCostVO>> getFreightCostListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetFreightCostListPageParams queryDto) {
        FreightCostReqDto freightCostReqDto = new FreightCostReqDto();
        if (queryDto != null) {
            BeanUtils.copyProperties((Object)queryDto, (Object)freightCostReqDto);
            freightCostReqDto.setLogisticsWarehouseCode(queryDto.getPhysicalWarehouseCode());
        }
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iFreightCostQueryApi.queryByPage(JSON.toJSONString((Object)freightCostReqDto), queryDto.getPageNum(), queryDto.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            HashSet whCodes = Sets.newHashSet();
            HashSet areaCodes = Sets.newHashSet();
            page.getList().forEach(i -> {
                whCodes.add(i.getLogisticsWarehouseCode());
                areaCodes.add(i.getProvinceCode());
                areaCodes.add(i.getCityCode());
                areaCodes.add(i.getAreaCode());
            });
            CsPhysicsWarehouseParamQueryDto dto = new CsPhysicsWarehouseParamQueryDto();
            dto.setWarehouseCodeList(new ArrayList(whCodes));
            List whList = (List)RestResponseHelper.extractData((RestResponse)this.iCsPhysicsWarehouseExposedQueryApi.queryParam(dto));
            Map whMap = null;
            if (CollectionUtils.isNotEmpty((Collection)whList)) {
                whMap = whList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            }
            PcpRegionReqDto regionReqDto = new PcpRegionReqDto();
            regionReqDto.setCodes(new ArrayList(areaCodes));
            PageInfo areaPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iPcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)regionReqDto), Integer.valueOf(1), Integer.valueOf(areaCodes.size())));
            Map araeMap = null;
            if (CollectionUtils.isNotEmpty((Collection)areaPage.getList())) {
                araeMap = areaPage.getList().stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            Map finalWhMap = whMap;
            Map finalAraeMap = araeMap;
            List voList = page.getList().stream().map(i -> {
                FreightCostVO vo = new FreightCostVO();
                BeanUtils.copyProperties((Object)i, (Object)vo);
                if (CollectionUtil.isNotEmpty((Map)finalWhMap) && finalWhMap.containsKey(i.getLogisticsWarehouseCode())) {
                    CsPhysicsWarehousePageRespDto wh = (CsPhysicsWarehousePageRespDto)finalWhMap.get(i.getLogisticsWarehouseCode());
                    vo.setPhysicalWarehouseName(wh.getWarehouseName());
                    vo.setPhysicalWarehouseId(String.valueOf(wh.getId()));
                    vo.setPhysicalWarehouseCode(wh.getWarehouseCode());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getProvinceCode())) {
                    vo.setProvinceName(((PcpRegionRespDto)finalAraeMap.get(i.getProvinceCode())).getName());
                    vo.setReceiveAreaName(vo.getProvinceName());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getCityCode())) {
                    vo.setCityName(((PcpRegionRespDto)finalAraeMap.get(i.getCityCode())).getName());
                    vo.setReceiveAreaName(vo.getReceiveAreaName() + vo.getCityName());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getAreaCode())) {
                    vo.setAreaName(((PcpRegionRespDto)finalAraeMap.get(i.getAreaCode())).getName());
                    vo.setReceiveAreaName(vo.getReceiveAreaName() + vo.getAreaName());
                }
                vo.setCarrierName(i.getLogisticsMerchantName());
                vo.setCarrierCode(i.getLogisticsMerchantCode());
                vo.setVolumeUnitPrice(String.valueOf(i.getVolumeUnitPrice()));
                vo.setReceiveAreaCode(i.getRouteLoadCode());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(voList);
        }
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Long> add(FreightCostReqDto addReqDto) {
        HashSet areaCodes = Sets.newHashSet();
        areaCodes.add(addReqDto.getProvinceCode());
        areaCodes.add(addReqDto.getCityCode());
        areaCodes.add(addReqDto.getAreaCode());
        PcpRegionReqDto regionReqDto = new PcpRegionReqDto();
        regionReqDto.setCodes(new ArrayList(areaCodes));
        String routeName = null;
        CsPhysicsWarehouseParamQueryDto dto = new CsPhysicsWarehouseParamQueryDto();
        dto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{addReqDto.getLogisticsWarehouseCode()}));
        List whList = (List)RestResponseHelper.extractData((RestResponse)this.iCsPhysicsWarehouseExposedQueryApi.queryParam(dto));
        Map whMap = null;
        if (CollectionUtils.isNotEmpty((Collection)whList)) {
            whMap = whList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            routeName = ((CsPhysicsWarehousePageRespDto)whMap.get(addReqDto.getLogisticsWarehouseCode())).getWarehouseName() + "-";
        }
        PageInfo areaPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iPcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)regionReqDto), Integer.valueOf(1), Integer.valueOf(areaCodes.size())));
        Map araeMap = null;
        if (CollectionUtils.isNotEmpty((Collection)areaPage.getList())) {
            araeMap = areaPage.getList().stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            String areaCode = addReqDto.getAreaCode();
            routeName = routeName + ((PcpRegionRespDto)araeMap.get(addReqDto.getProvinceCode())).getName() + ((PcpRegionRespDto)araeMap.get(addReqDto.getCityCode())).getName();
            if (StringUtils.isNotBlank((CharSequence)areaCode) && araeMap.get(areaCode) != null) {
                routeName = routeName + ((PcpRegionRespDto)araeMap.get(areaCode)).getName();
            }
        }
        addReqDto.setRouteName(routeName);
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getAreaCode())) {
            addReqDto.setRouteLoadCode(addReqDto.getAreaCode());
        } else if (StringUtils.isNotBlank((CharSequence)addReqDto.getCityCode())) {
            addReqDto.setRouteLoadCode(addReqDto.getCityCode());
        } else {
            addReqDto.setRouteLoadCode(addReqDto.getProvinceCode());
        }
        return this.freightCostApi.addFreightCost(addReqDto);
    }

    private Map<String, CsShipmenetEnterpriseRespDto> getShipmenetEnterprise() {
        CsShipmenetEnterpriseQueryDto queryDto = new CsShipmenetEnterpriseQueryDto();
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(100));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.queryByPage(queryDto));
        return respDtoPageInfo.getList().stream().collect(Collectors.toMap(CsShipmenetEnterpriseRespDto::getShipmentEnterpriseCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, PcpRegionRespDto> getRegion(Set<String> araeCodes) {
        if (CollectionUtils.isEmpty(araeCodes)) {
            return null;
        }
        PcpRegionReqDto regionReqDto = new PcpRegionReqDto();
        regionReqDto.setCodes(new ArrayList<String>(araeCodes));
        List list = (List)RestResponseHelper.extractData((RestResponse)this.iPcpRegionQueryApi.queryRegionDetail(regionReqDto));
        return list.stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsPhysicsWarehousePageRespDto> getWh(Set<String> whCodes) {
        if (CollectionUtils.isEmpty(whCodes)) {
            return null;
        }
        CsPhysicsWarehousePageQueryDto queryWhDto = new CsPhysicsWarehousePageQueryDto();
        queryWhDto.setWarehouseCodeList(new ArrayList<String>(whCodes));
        Integer pageSize = 100;
        if (whCodes.size() > pageSize) {
            pageSize = whCodes.size();
        }
        queryWhDto.setPageSize(pageSize);
        queryWhDto.setPageNum(Integer.valueOf(1));
        PageInfo whPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iCsPhysicsWarehouseExposedQueryApi.queryPageInfo(queryWhDto));
        return whPage.getList().stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k3) -> k1));
    }

    private void chechEnterprise(Map<String, CsShipmenetEnterpriseRespDto> enterpriseMap, String merchantCode, FreightCostReqDto saveDto, ImportFreightCostMsgDto msgDto) {
        if (CollectionUtil.isNotEmpty(enterpriseMap) && enterpriseMap.containsKey(merchantCode)) {
            saveDto.setLogisticsMerchantName(enterpriseMap.get(merchantCode).getShipmentEnterpriseName());
            saveDto.setLogisticsMerchantCode(merchantCode);
        } else if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
            msgDto.setMsg("\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u6b63\u786e");
        } else {
            msgDto.setMsg(msgDto.getMsg() + ";\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void chechArea(Map<String, PcpRegionRespDto> araeMap, String areaCode, FreightCostReqDto saveDto, ImportFreightCostMsgDto msgDto) {
        if (CollectionUtil.isNotEmpty(araeMap) && araeMap.containsKey(areaCode)) {
            PcpRegionRespDto area = araeMap.get(areaCode);
            saveDto.setRouteLoadCode(area.getCode());
            if (com.google.common.base.Objects.equal((Object)area.getLevelId(), (Object)2)) {
                saveDto.setAreaCode(area.getCode());
                saveDto.setCityCode(area.getParentCode());
                saveDto.setProvinceCode(area.getProvinceCode());
            }
            if (com.google.common.base.Objects.equal((Object)area.getLevelId(), (Object)1)) {
                saveDto.setCityCode(area.getCode());
                saveDto.setProvinceCode(area.getParentCode());
            }
            if (StringUtils.isNotBlank((CharSequence)area.getProvinceName())) {
                saveDto.setRouteName(saveDto.getRouteName() + area.getProvinceName());
            }
            if (StringUtils.isNotBlank((CharSequence)area.getParentName())) {
                saveDto.setRouteName(saveDto.getRouteName() + area.getParentName());
            }
            saveDto.setRouteName(saveDto.getRouteName() + area.getName());
            if (com.google.common.base.Objects.equal((Object)area.getLevelId(), (Object)0)) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("\u6536\u8d27\u5730\u533a\u4ee3\u7801\u5c42\u7ea7\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u4e3a\u7701\u7ea7");
                } else {
                    msgDto.setMsg(";\u6536\u8d27\u5730\u533a\u4ee3\u7801\u5c42\u7ea7\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u4e3a\u7701\u7ea7");
                }
            }
        } else if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
            msgDto.setMsg("\u6536\u8d27\u5730\u533a\u4ee3\u7801\u4e0d\u6b63\u786e");
        } else {
            msgDto.setMsg(msgDto.getMsg() + ";\u6536\u8d27\u5730\u533a\u4ee3\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void checkWh(Map<String, CsPhysicsWarehousePageRespDto> whMap, String whCode, FreightCostReqDto saveDto, ImportFreightCostMsgDto msgDto) {
        if (CollectionUtil.isNotEmpty(whMap) && whMap.containsKey(whCode)) {
            CsPhysicsWarehousePageRespDto wh = whMap.get(whCode);
            saveDto.setLogisticsWarehouseCode(wh.getWarehouseCode());
            saveDto.setRouteName(wh.getWarehouseName() + "-");
        } else if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
            msgDto.setMsg("\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u6b63\u786e");
        } else {
            msgDto.setMsg(msgDto.getMsg() + ";\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void checkHipmenetEnterprise(Map<String, CsShipmenetEnterpriseRespDto> enterpriseMap, String enterpriseCode, FreightCostReqDto saveDto, ImportFreightCostMsgDto msgDto) {
        if (CollectionUtil.isNotEmpty(enterpriseMap) && enterpriseMap.containsKey(enterpriseCode)) {
            CsShipmenetEnterpriseRespDto e = enterpriseMap.get(enterpriseCode);
            saveDto.setLogisticsMerchantCode(e.getShipmentEnterpriseCode());
            saveDto.setLogisticsMerchantName(e.getShipmentEnterpriseName());
        } else if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
            msgDto.setMsg("\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u6b63\u786e");
        } else {
            msgDto.setMsg(msgDto.getMsg() + ";\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u6b63\u786e");
        }
    }
}

