/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.BussinessOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.InventoryTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.WarehouseTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddInventoryCheckOrderParams;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetInventoryReadjustmentListParams;
import com.dtyunxi.cis.pms.biz.model.OutInventoryCheckOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryInventoryCheckOrderService;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryInventoryReadjustmentOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.TakeStockBizTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.TakeStockOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.TakeStockTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.TakeStockWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTakeStockOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTakeStockOrderReqDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_inventory_check_order")
public class FinishedGoodsInventoryInventoryCheckOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryInventoryCheckOrderService {
    @Resource
    private FinishedGoodsInventoryInventoryReadjustmentOrderService service;

    private void getInventoryCheckOrder(AddInventoryCheckOrderParams addInventoryCheckOrderParams, CsInventoryTakeStockOrderReqDto reqDto) {
        if (WarehouseTypeEnum.PHYSICS.getCode().equals(addInventoryCheckOrderParams.getWarehouseType())) {
            reqDto.setWarehouseType(TakeStockWarehouseTypeEnum.PHYSICAL_WAREHOUSE.getCode());
        }
        if (WarehouseTypeEnum.LOGIC.getCode().equals(addInventoryCheckOrderParams.getWarehouseType())) {
            reqDto.setWarehouseType(TakeStockWarehouseTypeEnum.LOGIC_WAREHOUSE.getCode());
        }
        if (BussinessOrderTypeEnum.INVENTORY_CHECK_ALL.getCode().equals(addInventoryCheckOrderParams.getBussinessOrderType())) {
            reqDto.setBizType(TakeStockBizTypeEnum.OVERALL.getCode());
        }
        if (BussinessOrderTypeEnum.INVENTORY_CHECK_PART.getCode().equals(addInventoryCheckOrderParams.getBussinessOrderType())) {
            reqDto.setBizType(TakeStockBizTypeEnum.DRAWING.getCode());
        }
        reqDto.setOrderStatus(TakeStockOrderStatusEnum.WAIT_SUBMIT.getCode());
        if (YesOrNoEnum.YES.getCode().equals(addInventoryCheckOrderParams.getSubmitType())) {
            reqDto.setOrderStatus(TakeStockOrderStatusEnum.WAIT_AUDIT.getCode());
        }
        reqDto.setAccountTime(addInventoryCheckOrderParams.getBookTime());
        if (CollectionUtils.isNotEmpty(addInventoryCheckOrderParams.getGoodsList())) {
            List list = addInventoryCheckOrderParams.getGoodsList().stream().map(o -> {
                CsInventoryTakeStockOrderItemReqDto dto = new CsInventoryTakeStockOrderItemReqDto();
                dto.setCargoName(o.getGoodsName());
                dto.setCargoCode(o.getGoodsCode());
                dto.setLongCode(o.getGoodsLongCode());
                dto.setBatch(o.getBatchNo());
                dto.setCargoId(ParamConverter.convertToLong((Object)o.getGoodsId()));
                if (StringUtils.isNotBlank((CharSequence)o.getEffectiveTime())) {
                    dto.setProduceTime(DateUtil.parse((String)(o.getEffectiveTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (StringUtils.isNotBlank((CharSequence)o.getInvalidTime())) {
                    dto.setExpireTime(DateUtil.parse((String)(o.getInvalidTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                dto.setAccountNum(o.getBookQuantity());
                dto.setFirmOfferNum(o.getCheckQuantity());
                dto.setDifferenceNum(o.getDifferentQuantity());
                dto.setTakeStockType(TakeStockTypeEnum.NOT_HANDLE.getCode());
                if (InventoryTypeEnum.INVENTORY_LOSS.getCode().equals(o.getInventoryType())) {
                    dto.setTakeStockType(TakeStockTypeEnum.DISH.getCode());
                }
                if (InventoryTypeEnum.INVENTORY_PROFIT.getCode().equals(o.getInventoryType())) {
                    dto.setTakeStockType(TakeStockTypeEnum.SURPLUS.getCode());
                }
                return dto;
            }).collect(Collectors.toList());
            reqDto.setTakeStockOrderItemReqDtoList(list);
        }
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetInventoryReadjustmentListParams params = new GetInventoryReadjustmentListParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryReadjustmentListParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryReadjustmentListParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.service.getInventoryReadjustmentOrderList((GetInventoryReadjustmentListParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutInventoryCheckOrderVO vo = new OutInventoryCheckOrderVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBussinessOrderStatus(Optional.ofNullable(o.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "audit_failed": {
                            return "\u5df2\u9a73\u56de";
                        }
                    }
                    return o.getBussinessOrderStatus();
                }).orElse(""));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutInventoryCheckOrderVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetInventoryReadjustmentListParams params = new GetInventoryReadjustmentListParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryReadjustmentListParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryReadjustmentListParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.service.getInventoryReadjustmentOrderList(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }
}

