/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.GetSourcingOperateListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetSourcingOrderLogDetailParams;
import com.dtyunxi.cis.pms.biz.model.GetSourcingOrderLogListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetSourcingOrderLogTestParams;
import com.dtyunxi.cis.pms.biz.model.ReplenishmentSourcingOrderItemVO;
import com.dtyunxi.cis.pms.biz.model.ReplenishmentSourcingOrderVO;
import com.dtyunxi.cis.pms.biz.model.SourcingOperateLogVO;
import com.dtyunxi.cis.pms.biz.model.SourcingOperateVo;
import com.dtyunxi.cis.pms.biz.model.SourcingOrderFailResultVO;
import com.dtyunxi.cis.pms.biz.model.SourcingOrderLogVO;
import com.dtyunxi.cis.pms.biz.model.SourcingOrderResultVO;
import com.dtyunxi.cis.pms.biz.service.SaleTransferService;
import com.dtyunxi.cis.pms.biz.service.SystemSettingSourcingOrderLogService;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.SnowFlakeGenerator;
import com.dtyunxi.cube.center.source.api.IOrderOptApi;
import com.dtyunxi.cube.center.source.api.constant.SourceLinkOrderTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.request.OrderItemReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderAddrRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemResultRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceLogSpecificRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderTestResultRespDto;
import com.dtyunxi.cube.center.source.api.query.ISourceLogQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SgSourceLogReqDto;
import com.dtyunxi.tcbj.api.query.ISgSourceLogQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.IWarehouseAreaMappingApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseAreaMappingReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseAreaMappingRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferLackDetailRestDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderAddrQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleTransferOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.api.entity.IMaiyouWarehouseAreaMappingApi;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingRespDto;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class SystemSettingSourcingOrderLogServiceServiceImpl
implements SystemSettingSourcingOrderLogService {
    private static Logger logger = LoggerFactory.getLogger(SystemSettingSourcingOrderLogServiceServiceImpl.class);
    @Resource
    private ISgSourceLogQueryApi sgSourceLogQueryApi;
    @Resource
    private ISourceLogQueryApi sourceLogQueryApi;
    @Resource
    private IOrderOptApi orderOptApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleTransferOrderQueryApi saleTransferOrderQueryApi;
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private SaleTransferService saleTransferService;
    @Resource
    private ISaleOrderItemQueryApi saleOrderItemQueryApi;
    @Resource
    private ISaleOrderAddrQueryApi saleOrderAddrQueryApi;
    @Resource
    private IWarehouseAreaMappingApi warehouseAreaMappingQueryApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Resource
    private IMaiyouWarehouseAreaMappingApi maiyouWarehouseAreaMappingApi;
    @Value(value="${yundt.com.source.saleOrder.maxNum:5}")
    private Integer sourceSaleOrderNumMaxNum = 5;

    @Override
    public RestResponse<SourcingOperateVo> getSourcingOperateListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSourcingOperateListPageParams getSourcingOperateListPageParams) {
        String sourcingOrderId = getSourcingOperateListPageParams.getSourcingOrderId();
        String sourcingOrderLogId = getSourcingOperateListPageParams.getSourcingOrderLogId();
        SourceLogSpecificRespDto sourceLogSpecificRespDto = null;
        sourceLogSpecificRespDto = StringUtils.isNotBlank((CharSequence)sourcingOrderId) ? (SourceLogSpecificRespDto)RestResponseHelper.extractData((RestResponse)this.sourceLogQueryApi.querySpecificByOrderId(ParamConverter.convertToLong((Object)sourcingOrderId))) : (SourceLogSpecificRespDto)RestResponseHelper.extractData((RestResponse)this.sourceLogQueryApi.querySpecificById(ParamConverter.convertToLong((Object)sourcingOrderLogId)));
        List sourceLogDetailRespDtoList = sourceLogSpecificRespDto.getSourceLogDetailRespDtoList();
        SourcingOperateVo sourcingOperateVo = new SourcingOperateVo();
        List<SourcingOperateLogVO> operateLogList = new ArrayList<SourcingOperateLogVO>();
        if (CollectionUtil.isNotEmpty((Collection)sourceLogDetailRespDtoList)) {
            operateLogList = sourceLogDetailRespDtoList.stream().map(o -> {
                SourcingOperateLogVO sourcingOperateLogVO = new SourcingOperateLogVO();
                BeanUtils.copyProperties((Object)o, (Object)sourcingOperateLogVO);
                sourcingOperateLogVO.setOperateDesc(o.getSgFindOptResult());
                sourcingOperateLogVO.setExecutionTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                return sourcingOperateLogVO;
            }).collect(Collectors.toList());
        }
        sourcingOperateVo.setList(operateLogList);
        return new RestResponse((Object)sourcingOperateVo);
    }

    @Override
    public RestResponse<SourcingOrderLogVO> getSourcingOrderLogDetail(@ApiParam(value="") @Valid @RequestBody(required=false) GetSourcingOrderLogDetailParams getSourcingOrderLogDetailParams) {
        String sourcingOrderId = getSourcingOrderLogDetailParams.getSourcingOrderId();
        String sourcingOrderLogId = getSourcingOrderLogDetailParams.getSourcingOrderLogId();
        SourceLogSpecificRespDto sourceLogSpecificRespDto = null;
        sourceLogSpecificRespDto = StringUtils.isNotBlank((CharSequence)sourcingOrderId) ? (SourceLogSpecificRespDto)RestResponseHelper.extractData((RestResponse)this.sourceLogQueryApi.querySpecificByOrderId(ParamConverter.convertToLong((Object)sourcingOrderId))) : (SourceLogSpecificRespDto)RestResponseHelper.extractData((RestResponse)this.sourceLogQueryApi.querySpecificById(ParamConverter.convertToLong((Object)sourcingOrderLogId)));
        BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(sourceLogSpecificRespDto.getLinkOrderNo()));
        SourcingOrderLogVO sourcingOrderLogVO = new SourcingOrderLogVO();
        sourcingOrderLogVO.setId(sourceLogSpecificRespDto.getId());
        sourcingOrderLogVO.setCreatePerson(sourceLogSpecificRespDto.getCreatePerson());
        sourcingOrderLogVO.setCreateTime(DateUtil.format((Date)sourceLogSpecificRespDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        sourcingOrderLogVO.setSaleOrderNo(sourceLogSpecificRespDto.getLinkOrderNo());
        sourcingOrderLogVO.setResultType(sourceLogSpecificRespDto.getSgStatus());
        sourcingOrderLogVO.setSourcingOrderCode(sourceLogSpecificRespDto.getSgVoucherNo());
        sourcingOrderLogVO.setSourcingOrderNo(sourceLogSpecificRespDto.getSgOrderNo());
        sourcingOrderLogVO.setSourcingOrderId(ParamConverter.convertToString((Object)sourceLogSpecificRespDto.getSgOrderId()));
        sourcingOrderLogVO.setSourcingResult(sourceLogSpecificRespDto.getSgSourceResult());
        sourcingOrderLogVO.setUpdatePerson(sourceLogSpecificRespDto.getUpdatePerson());
        sourcingOrderLogVO.setUpdateTime(DateUtil.format((Date)sourceLogSpecificRespDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        if (Objects.nonNull(bizSaleOrderRespDto)) {
            sourcingOrderLogVO.setChannelWarehouseCode(bizSaleOrderRespDto.getChannelWarehouseCode());
            sourcingOrderLogVO.setChannelWarehouseId(bizSaleOrderRespDto.getChannelWarehouseId());
            sourcingOrderLogVO.setChannelWarehouseName(bizSaleOrderRespDto.getChannelWarehouseName());
            sourcingOrderLogVO.setStoragePlace(bizSaleOrderRespDto.getStoragePlace());
            sourcingOrderLogVO.setStoragePlaceId(bizSaleOrderRespDto.getStoragePlaceId());
            sourcingOrderLogVO.setStoragePlaceName(bizSaleOrderRespDto.getStoragePlaceName());
            sourcingOrderLogVO.setOrderAddrRespDto(bizSaleOrderRespDto.getOrderAddrRespDto());
        }
        return new RestResponse((Object)sourcingOrderLogVO);
    }

    @Override
    public RestResponse<PageInfo<SourcingOrderLogVO>> getSourcingOrderLogListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSourcingOrderLogListPageParams getSourcingOrderLogListPageParams) {
        SgSourceLogReqDto reqDto = new SgSourceLogReqDto();
        BeanUtils.copyProperties((Object)getSourcingOrderLogListPageParams, (Object)reqDto);
        reqDto.setSgOrderNo(getSourcingOrderLogListPageParams.getSourcingOrderNo());
        reqDto.setSgStatus(getSourcingOrderLogListPageParams.getResultType());
        if (StringUtils.isNotBlank((CharSequence)getSourcingOrderLogListPageParams.getStartTime())) {
            reqDto.setBeginTime(DateUtil.parse((String)(getSourcingOrderLogListPageParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSourcingOrderLogListPageParams.getEndTime())) {
            reqDto.setEndTime(DateUtil.parse((String)(getSourcingOrderLogListPageParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sgSourceLogQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), getSourcingOrderLogListPageParams.getPageNum(), getSourcingOrderLogListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            SourcingOrderLogVO vo = new SourcingOrderLogVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setSourcingOrderCode(o.getSgVoucherNo());
            vo.setSourcingOrderNo(o.getSgOrderNo());
            vo.setSourcingOrderId(ParamConverter.convertToString((Object)o.getSgOrderId()));
            vo.setSaleOrderNo(o.getLinkOrderNo());
            vo.setSourcingResult(o.getSgSourceResult());
            vo.setResultType(o.getSgStatus());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<SourcingOperateVo> getSourcingOrderLogTest(@ApiParam(value="") @Valid @RequestBody(required=false) GetSourcingOrderLogTestParams getSourcingOrderLogTestParams) {
        OrderDetailRespDto orderDetailRespDto = new OrderDetailRespDto();
        OrderAddrRespDto orderAddrRespDto = new OrderAddrRespDto();
        orderAddrRespDto.setCountyCode(getSourcingOrderLogTestParams.getDistrictCode());
        orderAddrRespDto.setProvinceCode(getSourcingOrderLogTestParams.getProvinceCode());
        orderAddrRespDto.setCityCode(getSourcingOrderLogTestParams.getCityCode());
        orderAddrRespDto.setReceiveAddress(getSourcingOrderLogTestParams.getReceiveAddress());
        orderDetailRespDto.setOrderAddrRespDto(orderAddrRespDto);
        ArrayList<OrderItemRespDto> orderItemRespDtoList = new ArrayList<OrderItemRespDto>();
        OrderItemRespDto orderItemRespDto = new OrderItemRespDto();
        orderItemRespDto.setItemSkuCode(getSourcingOrderLogTestParams.getGoodsLongCode());
        orderItemRespDto.setItemNum(getSourcingOrderLogTestParams.getGoodsNum());
        orderItemRespDtoList.add(orderItemRespDto);
        orderDetailRespDto.setOrderItemRespDtoList(orderItemRespDtoList);
        orderDetailRespDto.setLinkOrderNo("-");
        orderDetailRespDto.setLinkOrderType(getSourcingOrderLogTestParams.getBillType());
        orderDetailRespDto.setLinkOrderCustomerId(ParamConverter.convertToLong((Object)getSourcingOrderLogTestParams.getCustomerId()));
        orderDetailRespDto.setLinkOrderChannelCode(getSourcingOrderLogTestParams.getOrderChannelCode());
        orderDetailRespDto.setLinkOrderChannelId(ParamConverter.convertToLong((Object)getSourcingOrderLogTestParams.getOrderChannelId()));
        orderDetailRespDto.setLinkOrderLogicWarehouseCode(getSourcingOrderLogTestParams.getLogicalWarehouseCode());
        orderDetailRespDto.setLinkOrderLogicWarehouseId(ParamConverter.convertToLong((Object)getSourcingOrderLogTestParams.getLogicalWarehouseId()));
        orderDetailRespDto.setLinkOrderChannelWarehouseId(getSourcingOrderLogTestParams.getOrderChannelWarehouseId());
        orderDetailRespDto.setLinkOrderChannelWarehouseCode(getSourcingOrderLogTestParams.getOrderChannelWarehouseCode());
        orderDetailRespDto.setIsOnline(getSourcingOrderLogTestParams.getIsOnline());
        SnowFlakeGenerator snowFlakeGenerator = new SnowFlakeGenerator(11L, 11L);
        SourceOrderTestResultRespDto sourceOrderTestResultRespDto = (SourceOrderTestResultRespDto)RestResponseHelper.extractData((RestResponse)this.orderOptApi.sourceOptCheck(orderDetailRespDto));
        SourcingOperateVo sourcingOperateVo = new SourcingOperateVo();
        List sourceLogDetailRespDtos = Optional.ofNullable(sourceOrderTestResultRespDto).map(SourceOrderTestResultRespDto::getSourceLogDetailRespDtoList).orElse(null);
        List<SourcingOperateLogVO> list = new ArrayList<SourcingOperateLogVO>();
        if (CollectionUtil.isNotEmpty((Collection)sourceLogDetailRespDtos)) {
            list = sourceLogDetailRespDtos.stream().map(o -> {
                SourcingOperateLogVO sourcingOrderLogVO = new SourcingOperateLogVO();
                BeanUtils.copyProperties((Object)o, (Object)sourcingOrderLogVO);
                sourcingOrderLogVO.setOperateDesc(o.getSgFindOptResult());
                sourcingOrderLogVO.setId(snowFlakeGenerator.nextId());
                sourcingOrderLogVO.setExecutionTime(DateUtil.format((Date)o.getSgFindOptTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                return sourcingOrderLogVO;
            }).collect(Collectors.toList());
        }
        sourcingOperateVo.setList(list);
        return new RestResponse((Object)sourcingOperateVo);
    }

    @Override
    public SourcingOrderResultVO replenishmentSource(List<String> saleOrderNoList) {
        logger.info("\u8d27\u8865\u5bfb\u6e90\u5165\u53c2:{}", (Object)JSON.toJSONString(saleOrderNoList));
        AssertUtil.assertNotCollection(saleOrderNoList, "\u9500\u552e\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List lackDetailRestDtoList = (List)RestResponseHelper.extractData(this.saleTransferService.querySaleTransferLackDetail(saleOrderNoList));
        SourcingOrderResultVO resultVO = this.initResultVo(saleOrderNoList.size(), 0);
        if (CollectionUtils.isEmpty((Collection)lackDetailRestDtoList)) {
            logger.info("\u9500\u552e\u5355\u5bf9\u5e94\u7f3a\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728");
            List<SourcingOrderFailResultVO> failList = resultVO.getFailList();
            saleOrderNoList.stream().forEach(saleOrderNo -> {
                SourcingOrderFailResultVO vo = new SourcingOrderFailResultVO();
                vo.setSaleOrderNo((String)saleOrderNo);
                vo.setErrorMsg("\u5bf9\u5e94\u7f3a\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728");
                failList.add(vo);
            });
            resultVO.setFailList(failList);
            return resultVO;
        }
        ExecutorService executorService = Executors.newWorkStealingPool(10);
        ArrayList resultList = Lists.newArrayList();
        Map<String, List<SaleTransferLackDetailRestDto>> lackDetailMap = lackDetailRestDtoList.stream().collect(Collectors.groupingBy(SaleTransferLackDetailRestDto::getSaleOrderNo));
        ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>(saleOrderNoList.size());
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        for (String saleOrderNo2 : saleOrderNoList) {
            if (!lackDetailMap.containsKey(saleOrderNo2)) {
                this.setFailList(resultVO, saleOrderNo2, "\u5bf9\u5e94\u7f3a\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728");
                continue;
            }
            try {
                logger.info("\u9500\u552e\u5355\uff1a{}\u5f00\u59cb\u8d27\u8865\u5bfb\u6e90", (Object)saleOrderNo2);
                futureList.add(CompletableFuture.supplyAsync(() -> this.addSaleOrderSource(saleOrderNo2, (List)lackDetailMap.get(saleOrderNo2), resultVO, reqId), executorService));
            }
            catch (Exception e) {
                this.setFailList(resultVO, saleOrderNo2, "\u8865\u8d27\u5bfb\u6e90\u5f02\u5e38:" + e.getMessage());
                logger.info("\u8865\u8d27\u5bfb\u6e90\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            }
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        futureList.forEach(r -> {
            try {
                List replenishmentSourcingOrderVOS = (List)r.get();
                if (replenishmentSourcingOrderVOS != null) {
                    resultList.addAll(replenishmentSourcingOrderVOS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setFailList(resultVO, "", "\u8865\u8d27\u5bfb\u6e90\u5f02\u5e38:" + e.getMessage());
                logger.info("\u8865\u8d27\u5bfb\u6e90\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            }
        });
        resultVO.setFailNum(resultVO.getFailList().size());
        resultVO.setSuccessNum(resultVO.getTotalNum() - resultVO.getFailNum());
        resultVO.setSuccessList(resultList);
        return resultVO;
    }

    public void setFailList(SourcingOrderResultVO resultVO, String saleOrderNo, String s) {
        List<SourcingOrderFailResultVO> failList = resultVO.getFailList();
        SourcingOrderFailResultVO failResultVO = new SourcingOrderFailResultVO();
        failResultVO.setSaleOrderNo(saleOrderNo);
        failResultVO.setErrorMsg(s);
        failList.add(failResultVO);
        resultVO.setFailList(failList);
    }

    private SourcingOrderResultVO initResultVo(Integer tottalNum, Integer successNum) {
        SourcingOrderResultVO resultVO = new SourcingOrderResultVO();
        resultVO.setSuccessNum(successNum);
        resultVO.setFailNum(tottalNum - successNum);
        resultVO.setTotalNum(tottalNum);
        resultVO.setCompleteNum(0);
        resultVO.setChildNum(0);
        resultVO.setSplitNum(0);
        return resultVO;
    }

    private List<ReplenishmentSourcingOrderVO> addSaleOrderSource(String saleOrderNo, List<SaleTransferLackDetailRestDto> lackDetailRestDtos, SourcingOrderResultVO resultVO, String reqId) {
        MDC.put((String)"yes.req.requestId", (String)reqId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        List<ReplenishmentSourcingOrderVO> list = null;
        BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(saleOrderNo));
        String logicalWarehouseCode = bizSaleOrderRespDto.getLogicalWarehouseCode();
        String cargoEscheatageCode = null;
        if (StringUtils.isNotEmpty((CharSequence)logicalWarehouseCode)) {
            DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
            logicWarehousePageReqDto.setWarehouseCode(logicalWarehouseCode);
            DgLogicWarehouseDto csLogicWarehouseRespDto = ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(logicWarehousePageReqDto))).get()).stream().findFirst().orElse(null);
            if (Objects.nonNull(csLogicWarehouseRespDto)) {
                cargoEscheatageCode = csLogicWarehouseRespDto.getCargoEscheatageId();
            }
        }
        OrderDetailRespDto sourceOrderResultReqDto = new OrderDetailRespDto();
        sourceOrderResultReqDto.setCargoEscheatageCode(cargoEscheatageCode);
        sourceOrderResultReqDto.setLinkOrderNo(bizSaleOrderRespDto.getSaleOrderNo());
        sourceOrderResultReqDto.setLinkOrderType(bizSaleOrderRespDto.getOrderType());
        sourceOrderResultReqDto.setLinkOrderChannelCode(bizSaleOrderRespDto.getChannelCode());
        sourceOrderResultReqDto.setLinkOrderChannelId(bizSaleOrderRespDto.getChannelId());
        sourceOrderResultReqDto.setLinkOrderCustomerId(bizSaleOrderRespDto.getCustomerId());
        sourceOrderResultReqDto.setLinkOrderCustomerName(bizSaleOrderRespDto.getCustomerName());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseId(bizSaleOrderRespDto.getLogicalWarehouseId());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(bizSaleOrderRespDto.getLogicalWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(bizSaleOrderRespDto.getLogicalWarehouseName());
        sourceOrderResultReqDto.setLinkPlatformOrderNo(bizSaleOrderRespDto.getPlatformOrderNo());
        sourceOrderResultReqDto.setLinkOrderChannelName(bizSaleOrderRespDto.getChannelName());
        sourceOrderResultReqDto.setSgSourceCanSplit(bizSaleOrderRespDto.getAllowSplitFlag());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseId(bizSaleOrderRespDto.getChannelWarehouseId());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseCode(bizSaleOrderRespDto.getChannelWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseName(bizSaleOrderRespDto.getChannelWarehouseName());
        sourceOrderResultReqDto.setStoragePlace(bizSaleOrderRespDto.getStoragePlace());
        sourceOrderResultReqDto.setOrganizationId(bizSaleOrderRespDto.getOrganizationId());
        sourceOrderResultReqDto.setOrganizationCode(bizSaleOrderRespDto.getOrganizationCode());
        sourceOrderResultReqDto.setOrganizationName(bizSaleOrderRespDto.getOrganizationName());
        sourceOrderResultReqDto.setSourceType(SourceTypeEnum.REPLENISHMENT.code);
        sourceOrderResultReqDto.setIsOnline(bizSaleOrderRespDto.getIsOnline());
        OrderAddrRespDto orderAddrReqDto = new OrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)bizSaleOrderRespDto.getOrderAddrRespDto(), (String[])new String[0]);
        sourceOrderResultReqDto.setOrderAddrRespDto(orderAddrReqDto);
        sourceOrderResultReqDto.setLinkOrderSnapshot(JSON.toJSONString((Object)sourceOrderResultReqDto));
        ArrayList orderItemReqDtoList = Lists.newArrayList();
        Map saleOrderItemMap = bizSaleOrderRespDto.getItemList().stream().collect(Collectors.toMap(SaleOrderItemRespDto::getSkuCode, Function.identity(), (k1, k2) -> {
            k1.setItemNum(k1.getItemNum().add(k2.getItemNum()));
            return k1;
        }));
        BigDecimal orderTotalItemNum = BigDecimal.ZERO;
        HashMap<String, ReplenishmentSourcingOrderItemVO> itemInfoMap = new HashMap<String, ReplenishmentSourcingOrderItemVO>();
        for (SaleTransferLackDetailRestDto lackDetailRestDto : lackDetailRestDtos) {
            SaleOrderItemExtRespDto saleOrderItemExtRespDto = (SaleOrderItemExtRespDto)saleOrderItemMap.get(lackDetailRestDto.getSkuCode());
            OrderItemReqDto orderItemReqDto = this.setSaleOrderSourceItem((SaleOrderRespDto)bizSaleOrderRespDto, (SaleOrderItemRespDto)saleOrderItemExtRespDto, lackDetailRestDto.getLackQuantity());
            orderItemReqDtoList.add(orderItemReqDto);
            orderTotalItemNum = orderTotalItemNum.add(lackDetailRestDto.getLackQuantity());
            ReplenishmentSourcingOrderItemVO itemVO = this.setSourcingOrderItemMap((SaleOrderItemRespDto)saleOrderItemExtRespDto, lackDetailRestDto.getTotalWeight(), lackDetailRestDto.getLackQuantity(), lackDetailRestDto.getTotalVolume());
            itemInfoMap.put(saleOrderItemExtRespDto.getSkuCode(), itemVO);
        }
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(orderTotalItemNum);
        ArrayList orderItemRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItemRespDtoList, (Collection)orderItemReqDtoList, OrderItemRespDto.class);
        sourceOrderResultReqDto.setOrderItemRespDtoList((List)orderItemRespDtoList);
        logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u8865\u8d27\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderNo, (Object)JSON.toJSONString((Object)sourceOrderResultReqDto));
        SourceOrderResultRespDto sourceOrderResultRespDto = (SourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)this.orderOptApi.sourceOptCheck(sourceOrderResultReqDto));
        logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u8865\u8d27\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrderNo, (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            list = this.setReplenishmentResult(itemInfoMap, sourceOrderResultRespDto, null);
        } else {
            this.setFailList(resultVO, sourceOrderResultRespDto.getLinkOrderNo(), sourceOrderResultRespDto.getSgFailResultDesc());
        }
        return list;
    }

    private List<ReplenishmentSourcingOrderVO> setReplenishmentResult(Map<String, ReplenishmentSourcingOrderItemVO> itemInfoMap, SourceOrderResultRespDto sourceOrderResultRespDto, SaleOrderRespDto saleOrder) {
        ArrayList list = Lists.newArrayList();
        List orderItemResultRespDtoList = sourceOrderResultRespDto.getOrderItemResultRespDtoList();
        Map<String, List<OrderItemResultRespDto>> sourceingBylogicGroupMap = orderItemResultRespDtoList.stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseCode));
        Set<String> warehouseCodeSet = sourceingBylogicGroupMap.keySet();
        Map<Object, Object> logicWarehouseMap = new HashMap(warehouseCodeSet.size() * 4 / 3 + 2);
        Map<String, Object> warehouseAreaMappingMap = new HashMap<String, WarehouseAreaMappingRespDto>(warehouseCodeSet.size() * 4 / 3 + 2);
        List channelWarehouseRespDtoList = null;
        Map<Object, Object> maiyouLogicMappingMap = new HashMap(warehouseCodeSet.size() * 4 / 3 + 2);
        Map<Object, Object> maiyouPhysicsMappingMap = new HashMap();
        if (Objects.nonNull(saleOrder)) {
            DgLogicWarehousePageReqDto csLogicWarehouseParamQueryDto = new DgLogicWarehousePageReqDto();
            csLogicWarehouseParamQueryDto.setWarehouseCodes((List)Lists.newArrayList(warehouseCodeSet));
            List csLogicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(csLogicWarehouseParamQueryDto));
            if (CollectionUtils.isNotEmpty((Collection)csLogicWarehousePageRespDtos)) {
                logicWarehouseMap = csLogicWarehousePageRespDtos.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity()));
                Set physicsWarehouseCodeSet = csLogicWarehousePageRespDtos.stream().map(DgLogicWarehouseDto::getPhysicsWarehouseCode).collect(Collectors.toSet());
                if (Objects.equals(saleOrder.getAllotType(), AllotTypeEnum.MAIYOU_BC_ALLOT.getType())) {
                    MaiyouWarehouseAreaMappingPageReqDto maiyouMappingPageDto = new MaiyouWarehouseAreaMappingPageReqDto();
                    maiyouMappingPageDto.setPageNum(Integer.valueOf(1));
                    maiyouMappingPageDto.setStatus(YesOrNoEnum.YES.getType());
                    maiyouMappingPageDto.setPageSize(Integer.valueOf(warehouseCodeSet.size()));
                    maiyouMappingPageDto.setTransferInLogicalWarehouseCode(saleOrder.getAllotInWarehouseCode());
                    maiyouMappingPageDto.setTransferOutLogicalWarehouseCodeList(new ArrayList<String>(warehouseCodeSet));
                    PageInfo maiyouLogicMappingPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.maiyouWarehouseAreaMappingApi.page(maiyouMappingPageDto));
                    if (CollectionUtils.isNotEmpty((Collection)maiyouLogicMappingPage.getList())) {
                        maiyouLogicMappingMap = maiyouLogicMappingPage.getList().stream().collect(Collectors.toMap(MaiyouWarehouseAreaMappingRespDto::getTransferOutLogicalWarehouseCode, Function.identity(), (k1, k2) -> k1));
                    }
                    maiyouMappingPageDto.setPageSize(Integer.valueOf(physicsWarehouseCodeSet.size()));
                    maiyouMappingPageDto.setTransferOutLogicalWarehouseCodeList(null);
                    maiyouMappingPageDto.setDeliveryPhysicalWarehouseCodeList(new ArrayList(physicsWarehouseCodeSet));
                    PageInfo maiyouPhysicsMappingPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.maiyouWarehouseAreaMappingApi.page(maiyouMappingPageDto));
                    if (CollectionUtils.isNotEmpty((Collection)maiyouPhysicsMappingPage.getList())) {
                        maiyouPhysicsMappingMap = maiyouPhysicsMappingPage.getList().stream().collect(Collectors.toMap(MaiyouWarehouseAreaMappingRespDto::getDeliveryPhysicalWarehouseCode, Function.identity(), (k1, k2) -> k1));
                    }
                } else {
                    OrderAddrRespDto orderAddrRespDto = sourceOrderResultRespDto.getOrderAddrRespDto();
                    String provinceCode = orderAddrRespDto.getProvinceCode();
                    WarehouseAreaMappingReqDto warehouseAreaMappingReqDto = new WarehouseAreaMappingReqDto();
                    warehouseAreaMappingReqDto.setPageNum(Integer.valueOf(1));
                    warehouseAreaMappingReqDto.setPageSize(Integer.valueOf(warehouseCodeSet.size()));
                    warehouseAreaMappingReqDto.setProvinceCode(provinceCode);
                    warehouseAreaMappingReqDto.setStatus(Integer.valueOf(1));
                    warehouseAreaMappingReqDto.setSourceWarehouseCodeList(new ArrayList(physicsWarehouseCodeSet));
                    logger.info("\u8ba2\u5355\u5bfb\u6e90\u67e5\u8be2\u4ed3\u5e93\u914d\u7f6e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)warehouseAreaMappingReqDto));
                    PageInfo warehouseAreaMappingRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseAreaMappingQueryApi.queryByPage(warehouseAreaMappingReqDto));
                    logger.info("\u8ba2\u5355\u5bfb\u6e90\u67e5\u8be2\u4ed3\u5e93\u914d\u7f6e\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)warehouseAreaMappingRespDtoPageInfo));
                    if (CollectionUtils.isNotEmpty((Collection)warehouseAreaMappingRespDtoPageInfo.getList())) {
                        warehouseAreaMappingMap = warehouseAreaMappingRespDtoPageInfo.getList().stream().collect(Collectors.toMap(WarehouseAreaMappingRespDto::getSourceWarehouseCode, Function.identity(), (k1, k2) -> k1));
                        channelWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByCodes((Set)Sets.newHashSet((Object[])new String[]{saleOrder.getChannelWarehouseCode()})));
                    }
                }
            }
        }
        for (String logicWarehouseCode : sourceingBylogicGroupMap.keySet()) {
            Map sgSourceSkuMap;
            List<OrderItemResultRespDto> orderItemResultRespDtos = sourceingBylogicGroupMap.get(logicWarehouseCode);
            ReplenishmentSourcingOrderVO vo = this.getReplenishmentSourcingOrderVO(sourceOrderResultRespDto, orderItemResultRespDtos);
            OrderAddrRespDto orderAddrRespDto = sourceOrderResultRespDto.getOrderAddrRespDto();
            AddressVO orderAddress = new AddressVO();
            CubeBeanUtils.copyProperties((Object)orderAddress, (Object)orderAddrRespDto, (String[])new String[0]);
            orderAddress.setDetailAddress(orderAddrRespDto.getReceiveAddress());
            orderAddress.setDistrict(orderAddrRespDto.getCounty());
            orderAddress.setDistrictCode(orderAddrRespDto.getCountyCode());
            vo.setOrderAddress(orderAddress);
            this.setOrderOtherInfo(saleOrder, vo);
            if (logicWarehouseMap.containsKey(vo.getSgSourceLogicalWarehouseCode())) {
                DgLogicWarehouseDto csLogicWarehousePageRespDto = (DgLogicWarehouseDto)logicWarehouseMap.get(vo.getSgSourceLogicalWarehouseCode());
                vo.setSgOrganizationCode(String.valueOf(csLogicWarehousePageRespDto.getCargoEscheatageId()));
                vo.setSgSourcePhysicsWarehouseCode(csLogicWarehousePageRespDto.getPhysicsWarehouseCode());
                vo.setSgSourcePhysicsWarehouseName(csLogicWarehousePageRespDto.getPhysicsWarehouseName());
                if (Objects.equals(saleOrder.getAllotType(), AllotTypeEnum.MAIYOU_BC_ALLOT.getType())) {
                    vo.setDeliveryType(AllotTypeEnum.MAIYOU_BC_ALLOT.getType());
                    vo.setOutLogicWarehouseId(vo.getSgSourceLogicalWarehouseId());
                    vo.setOutLogicWarehouseCode(vo.getSgSourceLogicalWarehouseCode());
                    vo.setOutLogicWarehouseName(vo.getSgSourceLogicalWarehouseName());
                    if (maiyouLogicMappingMap.containsKey(vo.getSgSourceLogicalWarehouseCode())) {
                        this.setMaiyouDeliveryWarehouseInfo((MaiyouWarehouseAreaMappingRespDto)maiyouLogicMappingMap.get(vo.getSgSourceLogicalWarehouseCode()), vo, channelWarehouseRespDtoList);
                    } else if (maiyouPhysicsMappingMap.containsKey(vo.getSgSourcePhysicsWarehouseCode())) {
                        this.setMaiyouDeliveryWarehouseInfo((MaiyouWarehouseAreaMappingRespDto)maiyouPhysicsMappingMap.get(vo.getSgSourcePhysicsWarehouseCode()), vo, channelWarehouseRespDtoList);
                    }
                } else if (warehouseAreaMappingMap.containsKey(vo.getSgSourcePhysicsWarehouseCode())) {
                    this.setDeliveryWarehouseInfo(warehouseAreaMappingMap, vo, channelWarehouseRespDtoList);
                }
            }
            ArrayList itemVOList = Lists.newArrayList();
            if (Objects.isNull(saleOrder)) {
                sgSourceSkuMap = orderItemResultRespDtos.stream().collect(Collectors.toMap(OrderItemResultRespDto::getLinkItemSkuCode, Function.identity(), (v1, v2) -> {
                    v1.setDeliveryItemNum(v1.getDeliveryItemNum().add(v2.getDeliveryItemNum()));
                    v1.setZtWarehouseItemNum(this.ofNullBigDecimal(v1.getZtWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getZtWarehouseItemNum())));
                    v1.setZtDeliveryWarehouseItemNum(this.ofNullBigDecimal(v1.getZtDeliveryWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getZtDeliveryWarehouseItemNum())));
                    v1.setWarehouseItemNum(this.ofNullBigDecimal(v1.getWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getWarehouseItemNum())));
                    return v1;
                }));
                orderItemResultRespDtos = new ArrayList(sgSourceSkuMap.values());
            } else {
                sgSourceSkuMap = orderItemResultRespDtos.stream().collect(Collectors.toMap(OrderItemResultRespDto::getLinkOrderItemId, Function.identity(), (v1, v2) -> {
                    v1.setDeliveryItemNum(v1.getDeliveryItemNum().add(v2.getDeliveryItemNum()));
                    v1.setZtWarehouseItemNum(this.ofNullBigDecimal(v1.getZtWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getZtWarehouseItemNum())));
                    v1.setZtDeliveryWarehouseItemNum(this.ofNullBigDecimal(v1.getZtDeliveryWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getZtDeliveryWarehouseItemNum())));
                    v1.setWarehouseItemNum(this.ofNullBigDecimal(v1.getWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getWarehouseItemNum())));
                    return v1;
                }));
                orderItemResultRespDtos = new ArrayList(sgSourceSkuMap.values());
            }
            for (OrderItemResultRespDto orderItemResultRespDto : orderItemResultRespDtos) {
                ReplenishmentSourcingOrderItemVO itemVO = new ReplenishmentSourcingOrderItemVO();
                CubeBeanUtils.copyProperties((Object)itemVO, (Object)orderItemResultRespDto, (String[])new String[0]);
                itemVO.setSaleOrderNo(orderItemResultRespDto.getLinkOrderNo());
                itemVO.setDeliveryItemNum(orderItemResultRespDto.getDeliveryItemNum());
                itemVO.setOrderItemId(orderItemResultRespDto.getLinkOrderItemId());
                ReplenishmentSourcingOrderItemVO orderItemVO = itemInfoMap.get(orderItemResultRespDto.getLinkItemSkuCode());
                if (Objects.nonNull(orderItemVO)) {
                    itemVO.setItemId(orderItemVO.getItemId());
                    itemVO.setItemName(orderItemVO.getItemName());
                    itemVO.setItemCode(orderItemVO.getItemCode());
                    itemVO.setItemSkuCode(orderItemVO.getItemSkuCode());
                    itemVO.setOrderId(orderItemVO.getOrderId());
                    BigDecimal weightTotal = orderItemVO.getWeight().multiply(itemVO.getDeliveryItemNum()).setScale(6);
                    itemVO.setWeight(weightTotal);
                    BigDecimal volumeTotal = orderItemVO.getVolume().multiply(itemVO.getDeliveryItemNum()).setScale(6);
                    itemVO.setVolume(volumeTotal);
                    vo.setSgSourceItemNum(vo.getSgSourceItemNum().add(itemVO.getDeliveryItemNum()));
                    vo.setWeight(vo.getWeight().add(itemVO.getWeight()));
                    vo.setVolume(vo.getVolume().add(itemVO.getVolume()));
                    vo.setOrderId(orderItemVO.getOrderId());
                }
                itemVOList.add(itemVO);
            }
            vo.setItemList(itemVOList);
            list.add(vo);
        }
        return list;
    }

    private BigDecimal ofNullBigDecimal(BigDecimal val) {
        return val == null ? BigDecimal.ZERO : val;
    }

    private void setDeliveryWarehouseInfo(Map<String, WarehouseAreaMappingRespDto> warehouseAreaMappingMap, ReplenishmentSourcingOrderVO vo, List<ChannelWarehouseRespDto> channelWarehouseRespDtoList) {
        DgLogicWarehouseDto csLogicWarehouseRespDto;
        List centerLogicList;
        WarehouseAreaMappingRespDto warehouseAreaMappingRespDto = warehouseAreaMappingMap.get(vo.getSgSourcePhysicsWarehouseCode());
        vo.setDeliveryType(warehouseAreaMappingRespDto.getType());
        vo.setTransferPhysicsWarehouseCode(warehouseAreaMappingRespDto.getCenterWarehouseCode());
        vo.setTransferPhysicsWarehouseName(warehouseAreaMappingRespDto.getCenterWarehouse());
        vo.setInPhysicsWarehouseCode(warehouseAreaMappingRespDto.getInWarehouseCode());
        vo.setInPhysicsWarehouseName(warehouseAreaMappingRespDto.getInWarehouse());
        if (StringUtils.isEmpty((CharSequence)warehouseAreaMappingRespDto.getCenterWarehouseCode()) && StringUtils.isEmpty((CharSequence)warehouseAreaMappingRespDto.getInWarehouseCode())) {
            return;
        }
        if (CollectionUtils.isEmpty(channelWarehouseRespDtoList)) {
            logger.info("\u83b7\u53d6\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728:{}", (Object)vo.getChannelWarehouseCode());
            return;
        }
        ChannelWarehouseRespDto channelWarehouseRespDto = channelWarehouseRespDtoList.get(0);
        if (CollectionUtils.isEmpty((Collection)channelWarehouseRespDto.getLogicWarehouseList())) {
            logger.info("\u83b7\u53d6\u6e20\u9053\u4ed3\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728:{}", (Object)vo.getChannelWarehouseCode());
            return;
        }
        Set warehouseCodeSet = channelWarehouseRespDto.getLogicWarehouseList().stream().map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toSet());
        DgLogicWarehousePageReqDto csLogicWarehouseParamQueryDto = new DgLogicWarehousePageReqDto();
        csLogicWarehouseParamQueryDto.setWarehouseCodes((List)Lists.newArrayList(warehouseCodeSet));
        csLogicWarehouseParamQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        csLogicWarehouseParamQueryDto.setWarehouseQuality(CsLogicWarehouseQualityEnum.QUALIFIED.getCode());
        List logicWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(csLogicWarehouseParamQueryDto));
        logicWarehouseRespDtoList = logicWarehouseRespDtoList.stream().filter(dto -> Objects.equals(vo.getSgOrganizationCode(), dto.getCargoEscheatageId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(logicWarehouseRespDtoList)) {
            logger.info("\u6e20\u9053\u4ed3\u5173\u8054\u7684\u903b\u8f91\u4ed3\u672a\u6709\u5408\u683c\u4e14\u975e\u5728\u9014\u903b\u8f91\u4ed3:{}", (Object)vo.getChannelWarehouseCode());
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseAreaMappingRespDto.getCenterWarehouseCode()) && CollectionUtils.isNotEmpty(centerLogicList = logicWarehouseRespDtoList.stream().filter(dto -> Objects.equals(dto.getPhysicsWarehouseCode(), warehouseAreaMappingRespDto.getCenterWarehouseCode())).collect(Collectors.toList()))) {
            csLogicWarehouseRespDto = (DgLogicWarehouseDto)centerLogicList.get(0);
            vo.setTransferLogicWarehouseId(csLogicWarehouseRespDto.getId());
            vo.setTransferLogicWarehouseCode(csLogicWarehouseRespDto.getWarehouseCode());
            vo.setTransferLogicWarehouseName(csLogicWarehouseRespDto.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseAreaMappingRespDto.getInWarehouseCode()) && CollectionUtils.isNotEmpty(centerLogicList = logicWarehouseRespDtoList.stream().filter(dto -> Objects.equals(dto.getPhysicsWarehouseCode(), warehouseAreaMappingRespDto.getInWarehouseCode())).collect(Collectors.toList()))) {
            csLogicWarehouseRespDto = (DgLogicWarehouseDto)centerLogicList.get(0);
            vo.setInLogicWarehouseId(csLogicWarehouseRespDto.getId());
            vo.setInLogicWarehouseCode(csLogicWarehouseRespDto.getWarehouseCode());
            vo.setInLogicWarehouseName(csLogicWarehouseRespDto.getWarehouseName());
        }
    }

    private void setMaiyouDeliveryWarehouseInfo(MaiyouWarehouseAreaMappingRespDto warehouseAreaMappingRespDto, ReplenishmentSourcingOrderVO vo, List<ChannelWarehouseRespDto> channelWarehouseRespDtoList) {
        List centerLogicList;
        vo.setTransferLogicWarehouseCode(warehouseAreaMappingRespDto.getTransitLogicalWarehouseCode());
        vo.setTransferLogicWarehouseName(warehouseAreaMappingRespDto.getTransferInLogicalWarehouse());
        if (CollectionUtils.isEmpty(channelWarehouseRespDtoList)) {
            logger.info("\u83b7\u53d6\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728:{}", (Object)vo.getChannelWarehouseCode());
            return;
        }
        ChannelWarehouseRespDto channelWarehouseRespDto = channelWarehouseRespDtoList.get(0);
        if (CollectionUtils.isEmpty((Collection)channelWarehouseRespDto.getLogicWarehouseList())) {
            logger.info("\u83b7\u53d6\u6e20\u9053\u4ed3\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728:{}", (Object)vo.getChannelWarehouseCode());
            return;
        }
        Set warehouseCodeSet = channelWarehouseRespDto.getLogicWarehouseList().stream().map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toSet());
        DgLogicWarehousePageReqDto csLogicWarehouseParamQueryDto = new DgLogicWarehousePageReqDto();
        csLogicWarehouseParamQueryDto.setWarehouseCodes((List)Lists.newArrayList(warehouseCodeSet));
        csLogicWarehouseParamQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        csLogicWarehouseParamQueryDto.setWarehouseQuality(CsLogicWarehouseQualityEnum.QUALIFIED.getCode());
        List logicWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(csLogicWarehouseParamQueryDto));
        logicWarehouseRespDtoList = logicWarehouseRespDtoList.stream().filter(dto -> Objects.equals(vo.getSgOrganizationCode(), dto.getCargoEscheatageId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(logicWarehouseRespDtoList)) {
            logger.info("\u6e20\u9053\u4ed3\u5173\u8054\u7684\u903b\u8f91\u4ed3\u672a\u6709\u5408\u683c\u4e14\u975e\u5728\u9014\u903b\u8f91\u4ed3:{}", (Object)vo.getChannelWarehouseCode());
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseAreaMappingRespDto.getTransitLogicalWarehouseCode()) && CollectionUtils.isNotEmpty(centerLogicList = logicWarehouseRespDtoList.stream().filter(dto -> Objects.equals(dto.getWarehouseCode(), warehouseAreaMappingRespDto.getTransitLogicalWarehouseCode())).collect(Collectors.toList()))) {
            DgLogicWarehouseDto csLogicWarehouseRespDto = (DgLogicWarehouseDto)centerLogicList.get(0);
            vo.setTransferLogicWarehouseId(csLogicWarehouseRespDto.getId());
            vo.setTransferLogicWarehouseCode(csLogicWarehouseRespDto.getWarehouseCode());
            vo.setTransferLogicWarehouseName(csLogicWarehouseRespDto.getWarehouseName());
        }
    }

    private ReplenishmentSourcingOrderVO getReplenishmentSourcingOrderVO(SourceOrderResultRespDto sourceOrderResultRespDto, List<OrderItemResultRespDto> orderItemResultRespDtos) {
        ReplenishmentSourcingOrderVO vo = new ReplenishmentSourcingOrderVO();
        vo.setPrimaryKey(SystemSettingSourcingOrderLogServiceServiceImpl.getId().toString());
        vo.setSaleOrderNo(sourceOrderResultRespDto.getLinkOrderNo());
        vo.setSgSourceLogicalWarehouseCode(orderItemResultRespDtos.get(0).getDeliveryLogicWarehouseCode());
        vo.setSgSourceLogicalWarehouseId(orderItemResultRespDtos.get(0).getDeliveryLogicWarehouseId());
        vo.setSgSourceLogicalWarehouseName(orderItemResultRespDtos.get(0).getDeliveryLogicWarehouseName());
        vo.setLogicalWarehouseCode(sourceOrderResultRespDto.getLinkOrderLogicWarehouseCode());
        vo.setLogicalWarehouseId(sourceOrderResultRespDto.getLinkOrderChannelWarehouseId());
        vo.setLogicalWarehouseName(sourceOrderResultRespDto.getLinkOrderLogicWarehouseName());
        vo.setSgSourceItemNum(BigDecimal.ZERO);
        vo.setWeight(BigDecimal.ZERO);
        vo.setVolume(BigDecimal.ZERO);
        vo.setIntransitPreemptFlag(sourceOrderResultRespDto.getIntransitPreemptFlag());
        return vo;
    }

    private void setOrderOtherInfo(SaleOrderRespDto saleOrder, ReplenishmentSourcingOrderVO vo) {
        if (Objects.nonNull(saleOrder)) {
            vo.setPlatformOrderId(saleOrder.getPlatformOrderId());
            vo.setPlatformOrderNo(saleOrder.getPlatformOrderNo());
            vo.setEasOrderNo(saleOrder.getEasOrderNo());
            vo.setOrderLevel(saleOrder.getOrderLevel());
            vo.setChannelWarehouseId(saleOrder.getChannelWarehouseId());
            vo.setChannelWarehouseCode(saleOrder.getChannelWarehouseCode());
            vo.setChannelWarehouseName(saleOrder.getChannelWarehouseName());
            vo.setOrganizationId(saleOrder.getOrganizationId());
            vo.setOrganizationCode(saleOrder.getOrganizationCode());
            vo.setOrganizationName(saleOrder.getOrganizationName());
            vo.setCustomerId(saleOrder.getCustomerId());
            vo.setCustomerCode(saleOrder.getCustomerCode());
            vo.setCustomerName(saleOrder.getCustomerName());
            vo.setAllowSplitFlag(saleOrder.getAllowSplitFlag());
            vo.setStoragePlace(saleOrder.getStoragePlace());
            vo.setStoragePlaceId(saleOrder.getStoragePlaceId());
            vo.setStoragePlaceName(saleOrder.getStoragePlaceName());
            if (Objects.equals(saleOrder.getAllotType(), AllotTypeEnum.MAIYOU_BC_ALLOT.getType())) {
                vo.setInLogicWarehouseCode(saleOrder.getAllotInWarehouseCode());
                vo.setInLogicWarehouseName(saleOrder.getAllotInWarehouseName());
            }
        }
    }

    public static Long getId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = IdGenrator.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }

    @Override
    public SourcingOrderResultVO saleOrderSource(List<String> saleOrderNoList) {
        logger.info("\u8ba2\u5355\u5bfb\u6e90\u5165\u53c2:{}", (Object)JSON.toJSONString(saleOrderNoList));
        if (CollectionUtils.isEmpty(saleOrderNoList)) {
            return this.initResultVo(0, 0);
        }
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setSaleOrderNoList(saleOrderNoList);
        saleOrderQueryReqDto.setOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
        saleOrderQueryReqDto.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode());
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
        ArrayList resultList = Lists.newArrayList();
        ArrayList splitOrderList = Lists.newArrayList();
        ArrayList notSplitOrderList = Lists.newArrayList();
        SourcingOrderResultVO resultVO = this.initResultVo(saleOrderNoList.size(), 0);
        if (CollectionUtils.isEmpty((Collection)saleOrderRespDtos)) {
            logger.info("\u6839\u636e\u9500\u552e\u5355\u53f7\u672a\u67e5\u8be2\u5f85\u914d\u8d27\u672a\u9501\u5b9a\u72b6\u6001\u7684\u8ba2\u5355");
            List<SourcingOrderFailResultVO> failList = resultVO.getFailList();
            saleOrderNoList.stream().forEach(saleOrderNo -> {
                SourcingOrderFailResultVO vo = new SourcingOrderFailResultVO();
                vo.setSaleOrderNo((String)saleOrderNo);
                vo.setErrorMsg("\u8ba2\u5355\u72b6\u6001\u5df2\u53d8\u66f4");
                failList.add(vo);
            });
            resultVO.setFailList(failList);
            return resultVO;
        }
        Map saleOrderMap = saleOrderRespDtos.stream().collect(Collectors.toMap(SaleOrderRespDto::getSaleOrderNo, Function.identity()));
        List orderIdList = saleOrderRespDtos.stream().map(SaleOrderRespDto::getId).collect(Collectors.toList());
        List saleOrderItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryNormalItemsByOrderIds(orderIdList));
        Map<Long, List<SaleOrderItemRespDto>> saleOrderItemMap = saleOrderItemRespDtos.stream().collect(Collectors.groupingBy(SaleOrderItemRespDto::getOrderId));
        List saleOrderAddrRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderAddrQueryApi.queryAddressByOrderIdList(orderIdList));
        Map saleOrderAddrMap = saleOrderAddrRespDtos.stream().collect(Collectors.toMap(SaleOrderAddrRespDto::getOrderId, Function.identity()));
        ExecutorService executorService = Executors.newWorkStealingPool(12);
        ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>(saleOrderNoList.size());
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        for (String saleOrderNo2 : saleOrderNoList) {
            if (!saleOrderMap.containsKey(saleOrderNo2)) {
                this.setFailList(resultVO, saleOrderNo2, "\u8ba2\u5355\u72b6\u6001\u5df2\u53d8\u66f4");
                continue;
            }
            SaleOrderRespDto saleOrder = (SaleOrderRespDto)saleOrderMap.get(saleOrderNo2);
            String orderType = saleOrder.getOrderType();
            if (SaleOrderTypeEnum.CLAIM_POSTING.getType().equals(orderType) || SaleOrderTypeEnum.CLAIM_REISSUE.getType().equals(orderType)) {
                this.setFailList(resultVO, saleOrderNo2, "\u8ba2\u5355\u672a\u627e\u5230\u6e20\u9053\u4ed3\uff0c\u65e0\u6cd5\u5bfb\u6e90\u914d\u8d27\u3002\u8bf7\u64cd\u4f5c\u3010\u6307\u5b9a\u53d1\u8d27\u4ed3\u3011\u8fdb\u884c\u914d\u8d27\u3002");
                continue;
            }
            if (SaleOrderTypeEnum.MAIYOU_ALLOT.getType().equals(orderType) && !AllotTypeEnum.MAIYOU_BC_ALLOT.getType().equals(saleOrder.getAllotType())) {
                this.setFailList(resultVO, saleOrderNo2, "\u8ba2\u5355\u8c03\u62e8\u7c7b\u578b\u4e3aCC\u8de8\u7ec4\u7ec7\u8c03\u62e8\u4e0d\u80fd\u5bfb\u6e90\u914d\u8d27\u3002");
                continue;
            }
            try {
                logger.info("\u9500\u552e\u5355\uff1a{}\u5f00\u59cb\u8ba2\u5355\u5bfb\u6e90", (Object)saleOrder.getSaleOrderNo());
                futureList.add(CompletableFuture.supplyAsync(() -> this.addSaleOrderSourcing(saleOrderItemMap, saleOrderAddrMap, saleOrder, resultVO, reqId), executorService));
            }
            catch (Exception e) {
                this.setFailList(resultVO, saleOrderNo2, "\u8ba2\u5355\u5bfb\u6e90\u5f02\u5e38:" + e.getMessage());
                logger.info("\u8ba2\u5355\u5bfb\u6e90\u5f02\u5e38111:{},{}", (Object)e.getMessage(), (Object)e);
            }
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        futureList.forEach(r -> {
            try {
                List replenishmentSourcingOrderVOS = (List)r.get();
                if (replenishmentSourcingOrderVOS != null) {
                    if (replenishmentSourcingOrderVOS.size() == 1) {
                        notSplitOrderList.addAll(replenishmentSourcingOrderVOS);
                    } else {
                        splitOrderList.addAll(replenishmentSourcingOrderVOS);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setFailList(resultVO, "", "\u8ba2\u5355\u5bfb\u6e90\u5f02\u5e38:" + e.getMessage());
                logger.info("\u8ba2\u5355\u5bfb\u6e90\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)notSplitOrderList)) {
            resultList.addAll(notSplitOrderList);
        }
        if (CollectionUtils.isNotEmpty((Collection)splitOrderList)) {
            resultList.addAll(splitOrderList);
        }
        resultVO.setFailNum(resultVO.getFailList().size());
        resultVO.setSuccessNum(resultVO.getTotalNum() - resultVO.getFailNum());
        resultVO.setSuccessList(resultList);
        Map<String, List<ReplenishmentSourcingOrderVO>> sourceResultGroup = resultList.stream().collect(Collectors.groupingBy(ReplenishmentSourcingOrderVO::getSaleOrderNo));
        for (String saleOrderNo3 : sourceResultGroup.keySet()) {
            List<ReplenishmentSourcingOrderVO> sourceResultList = sourceResultGroup.get(saleOrderNo3);
            if (sourceResultList.size() == 1) {
                resultVO.setCompleteNum(resultVO.getCompleteNum() + 1);
                continue;
            }
            resultVO.setSplitNum(resultVO.getSplitNum() + 1);
            resultVO.setChildNum(resultVO.getChildNum() + sourceResultList.size());
        }
        return resultVO;
    }

    public List<ReplenishmentSourcingOrderVO> addSaleOrderSourcing(Map<Long, List<SaleOrderItemRespDto>> saleOrderItemMap, Map<Long, SaleOrderAddrRespDto> saleOrderAddrMap, SaleOrderRespDto saleOrder, SourcingOrderResultVO resultVO, String reqId) {
        MDC.put((String)"yes.req.requestId", (String)reqId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        List<SaleOrderItemRespDto> saleOrderItemList = saleOrderItemMap.get(saleOrder.getId());
        OrderDetailRespDto sourceOrderResultReqDto = this.setSaleOrderSourceInfo(saleOrder);
        SaleOrderAddrRespDto saleOrderAddrRespDto = saleOrderAddrMap.get(saleOrder.getId());
        OrderAddrRespDto orderAddrReqDto = new OrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)saleOrderAddrRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setOrderAddrRespDto(orderAddrReqDto);
        sourceOrderResultReqDto.setLinkOrderSnapshot(JSON.toJSONString((Object)sourceOrderResultReqDto));
        ArrayList orderItemReqDtoList = Lists.newArrayList();
        HashMap<String, ReplenishmentSourcingOrderItemVO> itemInfoMap = new HashMap<String, ReplenishmentSourcingOrderItemVO>();
        for (SaleOrderItemRespDto item : saleOrderItemList) {
            OrderItemReqDto orderItemReqDto = this.setSaleOrderSourceItem(saleOrder, item, item.getItemNum());
            orderItemReqDtoList.add(orderItemReqDto);
            ReplenishmentSourcingOrderItemVO itemVO = this.setSourcingOrderItemMap(item, item.getWeight(), item.getItemNum(), item.getVolume());
            itemInfoMap.put(item.getSkuCode(), itemVO);
        }
        ArrayList orderItemRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItemRespDtoList, (Collection)orderItemReqDtoList, OrderItemRespDto.class);
        sourceOrderResultReqDto.setOrderItemRespDtoList((List)orderItemRespDtoList);
        List<Object> list = Lists.newArrayList();
        logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrder.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultReqDto));
        SourceOrderResultRespDto sourceOrderResultRespDto = (SourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)this.orderOptApi.sourceOptCheck(sourceOrderResultReqDto));
        logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrder.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            list = this.setReplenishmentResult(itemInfoMap, sourceOrderResultRespDto, saleOrder);
        } else {
            this.setFailList(resultVO, sourceOrderResultRespDto.getLinkOrderNo(), sourceOrderResultRespDto.getSgFailResultDesc());
        }
        return list;
    }

    public OrderDetailRespDto setSaleOrderSourceInfo(SaleOrderRespDto saleOrder) {
        OrderDetailRespDto sourceOrderResultReqDto = new OrderDetailRespDto();
        sourceOrderResultReqDto.setLinkOrderNo(saleOrder.getSaleOrderNo());
        sourceOrderResultReqDto.setLinkOrderType(saleOrder.getOrderType());
        sourceOrderResultReqDto.setLinkOrderChannelCode(saleOrder.getChannelCode());
        sourceOrderResultReqDto.setLinkOrderChannelId(saleOrder.getChannelId());
        sourceOrderResultReqDto.setLinkOrderCustomerId(saleOrder.getCustomerId());
        sourceOrderResultReqDto.setLinkOrderCustomerName(saleOrder.getCustomerName());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseId(saleOrder.getLogicalWarehouseId());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(saleOrder.getLogicalWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(saleOrder.getLogicalWarehouseName());
        sourceOrderResultReqDto.setLinkPlatformOrderNo(saleOrder.getPlatformOrderNo());
        sourceOrderResultReqDto.setLinkOrderChannelName(saleOrder.getChannelName());
        sourceOrderResultReqDto.setSgSourceCanSplit(saleOrder.getAllowSplitFlag());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseId(saleOrder.getChannelWarehouseId());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseCode(saleOrder.getChannelWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseName(saleOrder.getChannelWarehouseName());
        sourceOrderResultReqDto.setStoragePlace(saleOrder.getStoragePlace());
        sourceOrderResultReqDto.setOrganizationId(saleOrder.getOrganizationId());
        sourceOrderResultReqDto.setOrganizationCode(saleOrder.getOrganizationCode());
        sourceOrderResultReqDto.setOrganizationName(saleOrder.getOrganizationName());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(saleOrder.getGoodsTotalNum());
        sourceOrderResultReqDto.setSourceType(SourceTypeEnum.ORDER.code);
        sourceOrderResultReqDto.setIsOnline(saleOrder.getIsOnline());
        return sourceOrderResultReqDto;
    }

    public OrderItemReqDto setSaleOrderSourceItem(SaleOrderRespDto saleOrder, SaleOrderItemRespDto item, BigDecimal itemNum) {
        OrderItemReqDto orderItemReqDto = new OrderItemReqDto();
        CubeBeanUtils.copyProperties((Object)orderItemReqDto, (Object)item, (String[])new String[0]);
        orderItemReqDto.setLinkOrderItemId(orderItemReqDto.getId());
        orderItemReqDto.setLinkOrderType(SourceLinkOrderTypeEnum.SALE_ORDER.getCode());
        orderItemReqDto.setItemSkuCode(item.getSkuCode());
        orderItemReqDto.setItemBatchNo(null);
        orderItemReqDto.setItemGiftType(item.getGift());
        orderItemReqDto.setLinkOrderNo(saleOrder.getSaleOrderNo());
        orderItemReqDto.setItemNum(itemNum);
        return orderItemReqDto;
    }

    public ReplenishmentSourcingOrderItemVO setSourcingOrderItemMap(SaleOrderItemRespDto item, BigDecimal weight, BigDecimal itemNum, BigDecimal volume) {
        ReplenishmentSourcingOrderItemVO itemVO = new ReplenishmentSourcingOrderItemVO();
        itemVO.setItemId(item.getItemId());
        itemVO.setItemName(item.getItemName());
        itemVO.setItemCode(item.getItemCode());
        itemVO.setItemSkuCode(item.getSkuCode());
        itemVO.setOrderId(item.getOrderId());
        BigDecimal totalWeight = Objects.isNull(weight) ? BigDecimal.ZERO : weight;
        BigDecimal itemWeight = totalWeight.divide(itemNum, RoundingMode.HALF_UP).setScale(6);
        itemVO.setWeight(itemWeight);
        BigDecimal totalVolume = Objects.isNull(volume) ? BigDecimal.ZERO : volume;
        BigDecimal itemVolume = totalVolume.divide(itemNum, RoundingMode.HALF_UP).setScale(6);
        itemVO.setVolume(itemVolume);
        return itemVO;
    }
}

