/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.model.AddLogicWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.DeleteLogicWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetLogicWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.LogicWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.UpdateLogicWarehouseStatusParams;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterWarehouseBaseLogicService;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InventoryCenterWarehouseBaseLogicServiceServiceImpl
implements InventoryCenterWarehouseBaseLogicService {
    @Resource
    private ICsLogicWarehouseApi csLogicWarehouseApi;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Autowired
    IChannelWarehouseApi channelWarehouseQueryApi;
    @Autowired
    IDgLogicWarehouseApi dgLogicWarehouseApi;

    @Override
    public RestResponse<Object> addLogicWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) AddLogicWarehouseParams addLogicWarehouseParams) {
        CsLogicWarehouseAddReqDto csLogicWarehouseAddReqDto = DtoExchangeUtils.createDtoBySource(addLogicWarehouseParams, CsLogicWarehouseAddReqDto.class);
        return new RestResponse((Object)this.csLogicWarehouseApi.addLogicWarehouse(csLogicWarehouseAddReqDto));
    }

    @Override
    public RestResponse<Object> deleteLogicWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteLogicWarehouseParams deleteLogicWarehouseParams) {
        for (String id : deleteLogicWarehouseParams.getWarehouseIds()) {
            RestResponse restResponse = this.csLogicWarehouseApi.delete(Long.valueOf(id));
            RestResponseHelper.extractData((RestResponse)restResponse);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<LogicWarehouseVO> getLogicWarehouseById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        RestResponse restResponse = this.csLogicWarehouseQueryApi.queryByPrimaryKey(Long.valueOf(id));
        CsLogicWarehouseRespDto csLogicWarehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (csLogicWarehouseRespDto != null) {
            LogicWarehouseVO logicWarehouseVO = DtoExchangeUtils.createDtoBySource(csLogicWarehouseRespDto, LogicWarehouseVO.class);
            return new RestResponse((Object)logicWarehouseVO);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<LogicWarehouseVO>> getLogicWarehouseListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicWarehouseListPageParams getLogicWarehouseListPageParams) {
        CsLogicWarehouseQueryDto csLogicWarehouseQueryDto = DtoExchangeUtils.createDtoBySource(getLogicWarehouseListPageParams, CsLogicWarehouseQueryDto.class);
        RestResponse pageInfoRestResponse = this.csLogicWarehouseQueryApi.queryByPage(csLogicWarehouseQueryDto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (respDtoPageInfo != null) {
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List<LogicWarehouseVO> dtoList = DtoExchangeUtils.createDtoListBySource(respDtoPageInfo.getList(), LogicWarehouseVO.class);
            dtoPageInfo.setList(dtoList);
            return new RestResponse((Object)dtoPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateLogicWarehouseStatus(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateLogicWarehouseStatusParams updateLogicWarehouseStatusParams) {
        CsLogicWarehouseUpdateReqDto csLogicWarehouseUpdateReqDto = DtoExchangeUtils.createDtoBySource(updateLogicWarehouseStatusParams, CsLogicWarehouseUpdateReqDto.class);
        for (String id : updateLogicWarehouseStatusParams.getWarehouseIds()) {
            RestResponse restResponse = this.csLogicWarehouseApi.update(Long.valueOf(id), csLogicWarehouseUpdateReqDto);
            RestResponseHelper.extractData((RestResponse)restResponse);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<List<CsLogicWarehouseRespDto>> queryByChannelCode(String channelCode) {
        AssertUtil.assertNotBlank(channelCode, "\u6e20\u9053\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List channelWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByCodes((Set)Sets.newHashSet((Object[])new String[]{channelCode})));
        if (CollectionUtils.isEmpty((Collection)channelWarehouseRespDtoList)) {
            return new RestResponse((Object)Lists.newArrayList());
        }
        ChannelWarehouseRespDto channelWarehouseRespDto = (ChannelWarehouseRespDto)channelWarehouseRespDtoList.get(0);
        List logicWarehouseList = channelWarehouseRespDto.getLogicWarehouseList();
        if (CollectionUtils.isEmpty((Collection)logicWarehouseList)) {
            return new RestResponse((Object)Lists.newArrayList());
        }
        List logicWarehouseCodes = logicWarehouseList.stream().map(CsLogicWarehouseRespDto::getWarehouseCode).distinct().collect(Collectors.toList());
        DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCodes(logicWarehouseCodes);
        List dgLogicWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(logicWarehousePageReqDto));
        if (CollectionUtils.isEmpty((Collection)dgLogicWarehouseDtoList)) {
            return new RestResponse((Object)Lists.newArrayList());
        }
        Map logicWarehouseDtoMap = dgLogicWarehouseDtoList.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity()));
        for (CsLogicWarehouseRespDto respDto : logicWarehouseList) {
            DgLogicWarehouseDto dto = (DgLogicWarehouseDto)logicWarehouseDtoMap.get(respDto.getWarehouseCode());
            if (null == dto) continue;
            respDto.setIsLogistics(dto.getIsLogistics());
        }
        return new RestResponse((Object)logicWarehouseList);
    }
}

