/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.express.ExpressCostReportBackRemakeImportDto;
import com.dtyunxi.cis.pms.biz.service.ExpressCostOrderBackRemakeService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterDailyDeliveryReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IExpressCostDetailApi;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDetailRespDto;
import com.dtyunxi.tcbj.api.query.IExpressCostDetailQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_express_cost_report_back_remake_order")
public class ExpressCostOrderBackRemakeServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExpressCostOrderBackRemakeService {
    private static final Logger logger = LoggerFactory.getLogger(HandlerFileOperationCommonServiceImpl.class);
    @Resource
    private IExpressCostDetailQueryApi expressCostDetailQueryApi;
    @Resource
    private IExpressCostDetailApi expressCostDetailApi;
    @Resource
    private ReportCenterDailyDeliveryReportService deliveryReportService;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        logger.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\uff0c\u5feb\u9012\u56de\u4f20\u91cd\u91cf\u5bfc\u5165verifyImportFileOperationCommon");
        List expressCostReportBackRemakeImportDtoList = BeanUtil.copyToList((Collection)result.getList(), ExpressCostReportBackRemakeImportDto.class);
        List expressNoList = expressCostReportBackRemakeImportDtoList.stream().map(ExpressCostReportBackRemakeImportDto::getExpressNo).collect(Collectors.toList());
        ExpressCostDetailReqDto reqDto = new ExpressCostDetailReqDto();
        reqDto.setExpressNoList(expressNoList);
        List expressCostDetailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.expressCostDetailQueryApi.queryList(reqDto));
        Map expressCodeGroupMap = Optional.ofNullable(expressCostDetailRespDtoList).map(m -> m.stream().collect(Collectors.groupingBy(ExpressCostDetailRespDto::getExpressNo))).orElse(new HashMap());
        Map outboundCodeGroupMap = Optional.ofNullable(expressCostDetailRespDtoList).map(m -> m.stream().collect(Collectors.toMap(f -> f.getExpressNo() + f.getOutboundCode(), Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        Map e3CodeGroupMap = Optional.ofNullable(expressCostDetailRespDtoList).map(m -> m.stream().collect(Collectors.toMap(f -> f.getExpressNo() + f.getE3No(), Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        expressCostReportBackRemakeImportDtoList.forEach(dto -> {
            ExpressCostDetailRespDto detailRespDto;
            StringBuffer errorMsg = new StringBuffer();
            if (StringUtils.isBlank((CharSequence)dto.getOutboundCode()) && expressCodeGroupMap.containsKey(dto.getExpressNo())) {
                List expressCostDetailRespList = (List)expressCodeGroupMap.get(dto.getExpressNo());
                if (expressCostDetailRespList.size() > 1) {
                    errorMsg.append("\u5339\u914d\u5230\u591a\u6761\u6570\u636e");
                } else {
                    ExpressCostDetailRespDto detailRespDto2 = (ExpressCostDetailRespDto)expressCostDetailRespList.get(0);
                    dto.setId(detailRespDto2.getId());
                    dto.setReportId(detailRespDto2.getReportId());
                    dto.setBookkeepingMonth(detailRespDto2.getBookkeepingMonth());
                }
            } else if (StringUtils.isNotBlank((CharSequence)dto.getOutboundCode()) && outboundCodeGroupMap.containsKey(dto.getExpressNo() + dto.getOutboundCode())) {
                detailRespDto = (ExpressCostDetailRespDto)outboundCodeGroupMap.get(dto.getExpressNo() + dto.getOutboundCode());
                dto.setId(detailRespDto.getId());
                dto.setReportId(detailRespDto.getReportId());
                dto.setBookkeepingMonth(detailRespDto.getBookkeepingMonth());
            } else if (StringUtils.isNotBlank((CharSequence)dto.getOutboundCode()) && e3CodeGroupMap.containsKey(dto.getExpressNo() + dto.getOutboundCode())) {
                detailRespDto = (ExpressCostDetailRespDto)e3CodeGroupMap.get(dto.getExpressNo() + dto.getOutboundCode());
                dto.setId(detailRespDto.getId());
                dto.setReportId(detailRespDto.getReportId());
                dto.setBookkeepingMonth(detailRespDto.getBookkeepingMonth());
            } else {
                errorMsg.append("\u5355\u53f7\u4e0d\u5b58\u5728");
            }
            BigDecimal roundedValue = dto.getExpressBackRemake().setScale(6, RoundingMode.HALF_UP);
            if (roundedValue.compareTo(dto.getExpressBackRemake()) != 0) {
                errorMsg.append("\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg.toString())) {
                dto.setErrorMsg(errorMsg.toString());
            }
        });
        return expressCostReportBackRemakeImportDtoList;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        logger.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\uff0c\u5feb\u9012\u56de\u4f20\u91cd\u91cf\u5bfc\u5165executeImportFileOperationCommon\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        List importDtoList = (List)obj;
        importDtoList.forEach(save -> {
            try {
                if (StringUtils.isEmpty((CharSequence)save.getErrorMsg())) {
                    ExpressCostDetailReqDto reqDto = new ExpressCostDetailReqDto();
                    reqDto.setId(save.getId());
                    reqDto.setReportId(save.getReportId());
                    reqDto.setExpressBackRemake(save.getExpressBackRemake());
                    RestResponseHelper.extractData((RestResponse)this.expressCostDetailApi.updateExpressBackRemake((List)Lists.newArrayList((Object[])new ExpressCostDetailReqDto[]{reqDto})));
                }
            }
            catch (Exception e) {
                logger.error("\u5feb\u9012\u8d39\u7528\u62a5\u8868\uff0c\u5feb\u9012\u56de\u4f20\u91cd\u91cf\u5bfc\u5165\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)save), (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
                save.setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff1a" + (e.getMessage().contains("\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c") ? "\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c" : e.getMessage()));
            }
        });
        String errorMsgUrl = null;
        List errorList = importDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorList)) {
            String excelName = String.format("%s%s", "\u5feb\u9012\u56de\u4f20\u91cd\u91cf\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, ExpressCostReportBackRemakeImportDto.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

