/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.annotation.RegenerateTasks;
import com.dtyunxi.cis.pms.biz.enums.ImportExportStatusEnum;
import com.dtyunxi.cis.pms.biz.model.DailyDeliveryReportDetailUpdateDto;
import com.dtyunxi.cis.pms.biz.model.ExportDailyDeliveryReportReqDto;
import com.dtyunxi.cis.pms.biz.model.GetDailyDeliveryReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.ExpressCostReportService;
import com.dtyunxi.cis.pms.biz.service.IRegenerateTasksService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterDailyDeliveryReportService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterInsurancePremiumBillService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterLogisticsFreightLogisticsFreightReportListService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSortingReportSortingCostReportService;
import com.dtyunxi.cis.pms.biz.service.operation.AbstractFileOperationCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.FileOperationCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.RateLimiter;
import com.dtyunxi.cis.pms.biz.utils.TasksUtils;
import com.dtyunxi.cis.pms.dao.das.BdImportExportTaskDas;
import com.dtyunxi.cis.pms.dao.eo.BdImportExportTaskEo;
import com.dtyunxi.cis.search.api.dto.request.InPlannedOrderPageParams;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IFeeCommonApi;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailCombineDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailPageNewReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.entity.SynchronousDayDataDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import com.yunxi.dg.base.center.report.dto.report.WmsDailyDeliveryReportQueryDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class ReportCenterDailyDeliveryReportServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterDailyDeliveryReportService {
    private static final Logger logger = LoggerFactory.getLogger(FileOperationCommonService.class);
    @Resource
    private IDailyDeliveryReportApi reportApi;
    @Resource
    private BdImportExportTaskDas bdImportExportTaskDas;
    private static final String MAP_SERVICE_NAME = "abstractFileOperationCommonService";
    @Autowired
    private Map<String, AbstractFileOperationCommonService> mapService;
    @Resource
    private ReportCenterSortingReportSortingCostReportService reportCenterSortingReportSortingCostReportService;
    @Resource
    private ReportCenterInsurancePremiumBillService reportCenterInsurancePremiumBillService;
    @Resource
    private ReportCenterLogisticsFreightLogisticsFreightReportListService reportCenterLogisticsFreightLogisticsFreightReportListService;
    @Resource
    private ExpressCostReportService expressCostReportService;
    @Resource
    private IRegenerateTasksService tasksService;
    @Resource
    private IFeeCommonApi feeCommonApi;

    @Override
    public RestResponse<PageInfo<DailyDeliveryReportDto>> queryByPage(DailyDeliveryReportListQueryDto listQueryDto, Integer pageNum, Integer pageSize) {
        if (pageNum <= 0 || pageSize <= 0) {
            return new RestResponse("100000", "\u9875\u7801\u6216\u9875\u9762\u5927\u5c0f\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        return this.reportApi.queryByPage(listQueryDto, pageNum, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestResponse<String> importFileOperationCommon(ImportFileOperationCommonReqDto commonReqDto) {
        logger.info("commonReqDto=\u300b{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        long importStartTime = System.currentTimeMillis();
        BdImportExportTaskEo taskEo = (BdImportExportTaskEo)((ExtQueryChainWrapper)this.bdImportExportTaskDas.filter().eq((Object)"task_code", (Object)commonReqDto.getTaskCode())).one();
        String taskCode = commonReqDto.getTaskCode();
        AbstractFileOperationCommonService commonService = this.getCommonService(commonReqDto.getKey());
        ImportFileOperationCommonRespDto respDto = new ImportFileOperationCommonRespDto();
        try {
            long startTime = System.currentTimeMillis();
            logger.info("\u89e3\u6790\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)startTime);
            ExcelImportResult<ImportBaseModeDto> result = commonService.parseExcelDataResult(commonReqDto, respDto);
            long endTime = System.currentTimeMillis();
            logger.info("\u89e3\u6790\u65f6\u95f4\uff1a{}", (Object)(endTime - startTime));
            logger.info("\u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)result.getList());
            commonReqDto.setOperator(taskEo.getCreatePerson());
            ServiceContext.getContext().setAttachment("yes.req.userCode", taskEo.getCreatePerson());
            Object object = commonService.verifyImportFileOperationCommon(result, commonReqDto, respDto);
            String errorMsgUrl = commonService.executeImportFileOperationCommon(result, commonReqDto, respDto, object);
            if (StringUtils.isNotBlank((CharSequence)errorMsgUrl)) {
                taskEo.setStatus(ImportExportStatusEnum.PART_SUCCESS.getCode());
                taskEo.setErrorMsgUrl(errorMsgUrl);
                taskEo.setCompleteTime(new Date());
            } else {
                taskEo.setCompleteTime(new Date());
                taskEo.setStatus(ImportExportStatusEnum.SUCCESS.getCode());
            }
            this.bdImportExportTaskDas.updateSelective((BaseEo)taskEo);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25\uff1a", (Throwable)e);
            taskEo.setStatus(ImportExportStatusEnum.FAIL.getCode());
            taskEo.setErrorMsg(e.toString());
            this.bdImportExportTaskDas.updateSelective((BaseEo)taskEo);
        }
        finally {
            ServiceContext.removeContext();
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u5bfc\u5165\u65f6\u6240\u7528\u65f6\u95f4\uff1a{}", (Object)(endTime - importStartTime));
        return new RestResponse((Object)taskCode);
    }

    @Override
    public String exportListData(ExportDailyDeliveryReportReqDto commonReqDto) {
        GetDailyDeliveryReportListPageParams params = new GetDailyDeliveryReportListPageParams();
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getProductOrderListPage((GetDailyDeliveryReportListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            return voPageInfo;
        }, params, GetDailyDeliveryReportListPageParams.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public RestResponse<Void> synchronousMonthData(Long userId) {
        RateLimiter r = RateLimiter.getInstance();
        logger.info("\u7528\u6237ID:{}", (Object)userId.toString());
        boolean result = r.tryRequest(userId.toString());
        logger.info("{}\u7528\u6237\u662f\u5426\u53ef\u64cd\u4f5c{}", (Object)userId, (Object)result);
        if (result) {
            logger.info("\u5141\u8bb8{}\u7528\u6237\u64cd\u4f5c", (Object)userId);
            return this.reportApi.synchronousMonthData();
        }
        logger.info("{}\u7528\u6237\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41", (Object)userId);
        return new RestResponse("100000", "\u4e0d\u53ef\u9891\u7e41\u64cd\u4f5c,\u66f4\u65b0\u540e\u8bf73\u4e2a\u5c0f\u65f6\u540e\u518d\u91cd\u8bd5");
    }

    @Override
    public RestResponse<Void> updateWMSData(List<Long> ids) {
        if (ids.size() == 0) {
            return new RestResponse("100000", "\u672a\u9009\u4e2d\u6709\u6548\u6570\u636e");
        }
        RestResponse result = new RestResponse("0", "success");
        for (Long id : ids) {
            RestResponse<DailyDeliveryReportDto> dto = this.queryById(id);
            if (dto.getData() != null && ((DailyDeliveryReportDto)dto.getData()).getDifferentFlag() == 0) {
                WmsDailyDeliveryReportQueryDto queryDto = new WmsDailyDeliveryReportQueryDto();
                queryDto.setOrderNumber(((DailyDeliveryReportDto)dto.getData()).getWmsOrderNo());
                this.reportApi.queryWmsDailyDeliveryReport(queryDto);
                continue;
            }
            result = new RestResponse("100000", "\u90e8\u5206\u6570\u636e\u672a\u627e\u5230\u6216\u5df2\u7ecf\u4eba\u4e3a\u4fee\u6539");
        }
        return result;
    }

    @Override
    public RestResponse<Void> updateDateDailyDeliveryReport(Integer date) {
        if (date <= 0 || date > 31) {
            return new RestResponse("100000", "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u65e5\u671f");
        }
        return this.reportApi.updatedDateDailyDeliveryReport(date);
    }

    @Override
    public RestResponse<Integer> queryDateDailyDeliveryReport() {
        return this.reportApi.queryDateDailyDeliveryReport();
    }

    @Override
    public RestResponse<DailyDeliveryReportDto> queryById(Long id) {
        if (id == null || id <= 0L) {
            return new RestResponse("100000", "\u8bf7\u8f93\u5165\u6b63\u786e\u7684ID");
        }
        return this.reportApi.queryById(id);
    }

    @Override
    public RestResponse<Void> logicDeleteDailyDeliveryReport(List<Long> ids) {
        if (ids.size() <= 0) {
            return new RestResponse("100000", "\u672a\u9009\u4e2d\u6709\u6548\u6570\u636e");
        }
        return this.reportApi.logicDeleteDailyDeliveryReport(ids);
    }

    @Override
    public RestResponse<Void> modifyDailyDeliveryReport(DailyDeliveryReportDto dailyDeliveryReportDto) {
        if (dailyDeliveryReportDto == null) {
            return new RestResponse("100000", "\u8bf7\u52ff\u8f93\u5165\u7a7a\u5bf9\u8c61");
        }
        Integer i = 0;
        BigDecimal totalCartons = dailyDeliveryReportDto.getTotalCartons();
        BigDecimal totalQuantity = dailyDeliveryReportDto.getTotalQuantity();
        BigDecimal billingCartons = dailyDeliveryReportDto.getBillingCartons();
        i = i + this.validateIntNumber(totalCartons, "\u603b\u7bb1\u6570");
        i = i + this.validateIntNumber(totalQuantity, "\u603b\u91cf");
        i = i + this.validateIntNumber(billingCartons, "\u8ba1\u8d39\u7bb1\u6570");
        BigDecimal totalVolume = dailyDeliveryReportDto.getTotalVolume();
        BigDecimal totalWeight = dailyDeliveryReportDto.getTotalWeight();
        BigDecimal billingVolume = dailyDeliveryReportDto.getBillingVolume();
        BigDecimal billingWeight = dailyDeliveryReportDto.getBillingWeight();
        i = i + this.validateNumber(totalVolume, "\u603b\u4f53\u79ef");
        i = i + this.validateNumber(totalWeight, "\u603b\u91cd\u91cf");
        i = i + this.validateNumber(billingVolume, "\u8ba1\u8d39\u4f53\u79ef");
        if ((i = Integer.valueOf(i + this.validateNumber(billingWeight, "\u8ba1\u8d39\u91cd\u91cf"))) > 0) {
            return new RestResponse("100000", "\u5b58\u5728\u6570\u636e\u4e0d\u5408\u6cd5");
        }
        return this.reportApi.modifyDailyDeliveryReport(dailyDeliveryReportDto);
    }

    @Override
    public RestResponse<Long> addDailyDeliveryReport(DailyDeliveryReportDto dailyDeliveryReportDto) {
        if (dailyDeliveryReportDto == null) {
            return new RestResponse("100000", "\u8bf7\u52ff\u8f93\u5165\u7a7a\u5bf9\u8c61");
        }
        BigDecimal totalCartons = dailyDeliveryReportDto.getTotalCartons();
        BigDecimal totalQuantity = dailyDeliveryReportDto.getTotalQuantity();
        BigDecimal billingCartons = dailyDeliveryReportDto.getBillingCartons();
        this.validateIntNumber(totalCartons, "\u603b\u7bb1\u6570");
        this.validateIntNumber(totalQuantity, "\u603b\u91cf");
        this.validateIntNumber(billingCartons, "\u8ba1\u8d39\u7bb1\u6570");
        BigDecimal totalVolume = dailyDeliveryReportDto.getTotalVolume();
        BigDecimal totalWeight = dailyDeliveryReportDto.getTotalWeight();
        BigDecimal billingVolume = dailyDeliveryReportDto.getBillingVolume();
        BigDecimal billingWeight = dailyDeliveryReportDto.getBillingWeight();
        this.validateNumber(totalVolume, "\u603b\u4f53\u79ef");
        this.validateNumber(totalWeight, "\u603b\u91cd\u91cf");
        this.validateNumber(billingVolume, "\u8ba1\u8d39\u4f53\u79ef");
        this.validateNumber(billingWeight, "\u8ba1\u8d39\u91cd\u91cf");
        return this.reportApi.addDailyDeliveryReport(dailyDeliveryReportDto);
    }

    @Override
    public RestResponse<DailyDeliveryReportDetailCombineDto> queryDetailById(Long id) {
        if (id == null || id <= 0L) {
            throw new BizException("100000", "\u8bf7\u8f93\u5165\u6b63\u786e\u7684ID");
        }
        DailyDeliveryReportDetailPageNewReqDto r = new DailyDeliveryReportDetailPageNewReqDto();
        r.setId(id);
        return new RestResponse(((PageInfo)this.reportApi.queryDetailByPage(r).getData()).getList().get(0));
    }

    @Override
    public RestResponse<Void> updateDetailById(DailyDeliveryReportDetailUpdateDto updateDto) {
        if (updateDto != null) {
            DailyDeliveryReportDto reDto = new DailyDeliveryReportDto();
            BeanUtils.copyProperties((Object)((Object)updateDto), (Object)reDto);
            return this.reportApi.modifyDailyDeliveryReport(reDto);
        }
        return new RestResponse(null);
    }

    @Override
    public RestResponse<PageInfo<DailyDeliveryReportDetailCombineDto>> queryDetailByPage(DailyDeliveryReportDetailPageNewReqDto listQueryDto) {
        return this.reportApi.queryDetailByPage(listQueryDto);
    }

    @Override
    @RegenerateTasks(apiExplained="\u751f\u6210\u8d39\u7528\u660e\u7ec6", menuModule="\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868")
    public RestResponse<Void> generateDetail(String generateDate, String moduleEnum) {
        logger.info("\u751f\u6210\u8d39\u7528\u660e\u7ec6\uff1a{}\uff0c{}", (Object)generateDate, (Object)moduleEnum);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        YearMonth yearMonthObject = YearMonth.parse(generateDate);
        LocalDateTime startOfMonth = yearMonthObject.atDay(1).atStartOfDay();
        LocalDateTime endOfMonth = yearMonthObject.atEndOfMonth().atTime(23, 59, 59);
        Date startDate = Date.from(startOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(endOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        String startDateStr = sdf.format(startDate);
        String endDateStr = sdf.format(endDate);
        logger.info("\u5f00\u59cb\u65f6\u95f4:{},{}", (Object)startDate, (Object)startDate.toString());
        logger.info("\u7ed3\u675f\u65f6\u95f4:{},{}", (Object)endDate, (Object)endDate.toString());
        String requestUserCode = ServiceContext.getContext().getRequestUserCode();
        String tasksId = TasksUtils.getTasksId();
        logger.info("generateDetail \u672c\u6b21\u4efb\u52a1ID\uff1a{} {}", (Object)tasksId, (Object)requestUserCode);
        if (null != moduleEnum) {
            LogisticStatisticReqDto reqDto;
            DailyDeliveryFeeModuleEnum feeModuleEnum = DailyDeliveryFeeModuleEnum.getByCode((String)moduleEnum);
            if (Objects.nonNull(feeModuleEnum)) {
                this.tasksService.modify(tasksId, generateDate, feeModuleEnum.getDesc(), null);
            }
            if (moduleEnum.equals(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode())) {
                this.reportCenterInsurancePremiumBillService.generateInsuranceReport(startDate, endDate);
                this.tasksService.successModify(tasksId);
            }
            if (moduleEnum.equals(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode())) {
                this.reportCenterSortingReportSortingCostReportService.generateSortingExpense(generateDate);
                this.tasksService.successModify(tasksId);
            }
            if (moduleEnum.equals(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode())) {
                reqDto = new LogisticStatisticReqDto();
                reqDto.setStartTime(startDateStr);
                reqDto.setEndTime(endDateStr);
                RestResponseHelper.extractData(this.reportCenterLogisticsFreightLogisticsFreightReportListService.generateForDailyDeliveryReport(reqDto));
                this.tasksService.successModify(tasksId);
            }
            if (moduleEnum.equals(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode())) {
                reqDto = new LogisticStatisticReqDto();
                reqDto.setStartTime(startDateStr);
                reqDto.setEndTime(endDateStr);
                RestResponseHelper.extractData(this.expressCostReportService.generateExpressCostData(reqDto));
            }
        }
        return new RestResponse("0", "\u66f4\u65b0\u6210\u529f");
    }

    @Override
    @RegenerateTasks(apiExplained="\u751f\u6210\u8d39\u7528\u660e\u7ec6", menuModule="\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868")
    public void generateInsurance(FeeGenerateReqDto reqDto) {
        logger.info("\u6839\u636e\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u8d39\u7528\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        String tasksId = TasksUtils.getTasksId();
        logger.info("generateDetail \u672c\u6b21\u4efb\u52a1ID\uff1a{} ", (Object)tasksId);
        try {
            String bookkeepingMonth = reqDto.getBookkeepingMonth();
            AssertUtil.assertNotBlank(bookkeepingMonth, "\u8bb0\u8d26\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
            String menuModule = reqDto.getMenuModule();
            AssertUtil.assertNotBlank(menuModule, "\u83dc\u5355\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
            DailyDeliveryFeeModuleEnum feeModuleEnum = DailyDeliveryFeeModuleEnum.getByCode((String)reqDto.getFeeType());
            AssertUtil.assertNotNull(feeModuleEnum, "\u8d39\u7528\u6a21\u5757\u4e0d\u5b58\u5728\uff1a" + reqDto.getFeeType());
            YearMonth yearMonthObject = YearMonth.parse(bookkeepingMonth);
            LocalDateTime startOfMonth = yearMonthObject.atDay(1).atStartOfDay();
            LocalDateTime endOfMonth = yearMonthObject.atEndOfMonth().atTime(23, 59, 59);
            Date startDate = Date.from(startOfMonth.atZone(ZoneId.systemDefault()).toInstant());
            Date endDate = Date.from(endOfMonth.atZone(ZoneId.systemDefault()).toInstant());
            reqDto.setStartDate(startDate);
            reqDto.setEndDate(endDate);
            reqDto.setTaskId(tasksId);
            this.tasksService.modify(tasksId, bookkeepingMonth, feeModuleEnum.getFeeModule(), menuModule);
            logger.info("\u751f\u6210\u8d39\u7528\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            String requestReqId = TasksUtils.getRequestReqId();
            String requestUserCode = TasksUtils.getRequestUserCode();
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            executorService.execute(() -> {
                TasksUtils.setRequestReqId(requestReqId);
                TasksUtils.setRequestUserCode(requestUserCode);
                try {
                    this.feeCommonApi.generateInsurance(reqDto);
                }
                catch (Exception e) {
                    logger.error("\u751f\u6210\u8d39\u7528\u660e\u7ec6\u5931\u8d25Prams:{}", (Object)JSON.toJSONString((Object)reqDto));
                    logger.error("\u751f\u6210\u8d39\u7528\u660e\u7ec6\u5931\u8d25", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            this.tasksService.errorModify(tasksId, e.getMessage());
            throw e;
        }
    }

    @Override
    public RestResponse<Void> del(List<Long> ids) {
        logger.info("\u5220\u9664\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(ids));
        return this.reportApi.del(ids);
    }

    @Override
    public RestResponse<Void> synchronousDayDataByDate(String startDate, String endDate) {
        return this.reportApi.synchronousDayDataByDate(startDate, endDate);
    }

    @Override
    public RestResponse<Void> synchronousDayData(SynchronousDayDataDto synchronousDayDataDto) {
        return this.reportApi.synchronousDayData(synchronousDayDataDto);
    }

    @Override
    public RestResponse<Void> dataVerify(DailyDeliveryReportDto dto) {
        RestResponseHelper.extractData((RestResponse)this.reportApi.dataVerify(dto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DailyDeliveryReportDto> queryFlagCount(DailyDeliveryReportListQueryDto listQueryDto) {
        return this.reportApi.queryFlagCount(listQueryDto);
    }

    Integer validateIntNumber(BigDecimal number, String fieldName) {
        if (number.signum() < 0) {
            return 1;
        }
        if (number.scale() > 0) {
            return 1;
        }
        String numberStr = number.toPlainString();
        int length = numberStr.length();
        if (length < 1 || length > 9) {
            return 1;
        }
        return 0;
    }

    Integer validateNumber(BigDecimal number, String fieldName) {
        if (number == null || number.compareTo(BigDecimal.ZERO) <= 0) {
            return 1;
        }
        BigDecimal integerPart = number.setScale(0, 1);
        if (integerPart.precision() > 9) {
            return 1;
        }
        if (number.scale() > 6) {
            return 1;
        }
        return 0;
    }

    public RestResponse<PageInfo<GetDailyDeliveryReportListPageParams>> getProductOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetDailyDeliveryReportListPageParams getProductOrderListPageParams) {
        InPlannedOrderPageParams params = new InPlannedOrderPageParams();
        BeanUtils.copyProperties((Object)getProductOrderListPageParams, (Object)params);
        params.setOrderNo(getProductOrderListPageParams.getDocumentNo());
        params.setOrdeType(CsPlannedOrderTypeEnum.PRODUCTION.getCode());
        params.setWarehouseCode(getProductOrderListPageParams.getInventoryOrganizationName());
        params.setWarehouseName(getProductOrderListPageParams.getInventoryOrganizationName());
        params.setOrderStatus(getProductOrderListPageParams.getDocumentType());
        PageInfo pageInfo = new PageInfo();
        PageInfo respDtoPageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            GetDailyDeliveryReportListPageParams vo = new GetDailyDeliveryReportListPageParams();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            vo.setId(o.getId());
            vo.setDocumentNo(o.getDocumentNo());
            vo.setTransportNo(o.getTransportNo());
            vo.setInventoryOrganizationName(o.getInventoryOrganizationName());
            vo.setTotalQuantity(o.getTotalQuantity());
            vo.setTotalCartons(o.getTotalCartons());
            vo.setTotalVolume(o.getTotalVolume());
            vo.setTotalWeight(o.getTotalWeight());
            vo.setRemark(o.getRemark());
            try {
                vo.setOrderCreateTime(sdf.parse(o.getOrderCreateTime()));
                vo.setOrderShippingTime(sdf.parse(o.getOrderShippingTime()));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            vo.setPickingOrderNo(o.getPickingOrderNo());
            vo.setReceivingCustomer(o.getReceivingCustomer());
            vo.setReceivingAddress(o.getReceivingAddress());
            vo.setReceivingPerson(o.getReceivingPerson());
            vo.setReceivingPersonPhone(o.getReceivingPersonPhone());
            vo.setReceivingAddressProvince(o.getReceivingAddressProvince());
            vo.setReceivingAddressCity(o.getReceivingAddressCity());
            vo.setReceivingAddressDistrict(o.getReceivingAddressDistrict());
            vo.setVehicleNumber(o.getVehicleNumber());
            vo.setConsignmentNo(o.getConsignmentNo());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    private AbstractFileOperationCommonService getCommonService(String module) {
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(module);
        AbstractFileOperationCommonService commonService = this.mapService.get(String.format("%s_%s", MAP_SERVICE_NAME, anEnum.getModeTypeCode()));
        logger.info("-----------key:", (Object)String.format("%s_%s", MAP_SERVICE_NAME, anEnum.getModeTypeCode()));
        Set<Map.Entry<String, AbstractFileOperationCommonService>> entries = this.mapService.entrySet();
        logger.info("\u83b7\u53d6\u5230\u7684commonService:{}", (Object)commonService);
        if (Objects.isNull(commonService)) {
            commonService = this.mapService.get(MAP_SERVICE_NAME);
        }
        return commonService;
    }
}

