/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.model.AddCarrierParams;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.CarrierVO;
import com.dtyunxi.cis.pms.biz.model.GetCarrierListPageParams;
import com.dtyunxi.cis.pms.biz.model.UpdateCarrierParams;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterCarrierService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class BasedataCenterCarrierServiceServiceImpl
implements BasedataCenterCarrierService {
    private static final Logger log = LoggerFactory.getLogger(BasedataCenterCarrierServiceServiceImpl.class);
    @Resource
    private IcsShipmenetEnterpriseApi csShipmenetEnterpriseApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;
    @Resource
    private IPCPCustomerQueryApi ipcpCustomerQueryApi;

    @Override
    public RestResponse<Object> addCarrier(@ApiParam(value="") @Valid @RequestBody(required=false) AddCarrierParams addCarrierParams) {
        if (Objects.isNull(addCarrierParams)) {
            throw new com.dtyunxi.exceptions.BizException("\u65b0\u589e\u7269\u6d41\u5546\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        CsShipmenetEnterpriseAddReqDto addReqDto = new CsShipmenetEnterpriseAddReqDto();
        if (CollectionUtils.isNotEmpty(addCarrierParams.getCustomerNameList())) {
            addReqDto.setCustomerName(String.join((CharSequence)",", addCarrierParams.getCustomerNameList()));
        }
        if (CollectionUtils.isNotEmpty(addCarrierParams.getCustomerCodeList())) {
            addReqDto.setCustomerCode(String.join((CharSequence)",", addCarrierParams.getCustomerCodeList()));
        }
        addReqDto.setShipmentEnterpriseCode(addCarrierParams.getCarrierCode());
        addReqDto.setShipmentEnterpriseName(addCarrierParams.getCarrierName());
        addReqDto.setShipmentEnterpriseReduceName(addCarrierParams.getCarrierShortName());
        if (StringUtils.isNumeric((CharSequence)addCarrierParams.getCarrierType())) {
            addReqDto.setShipmentEnterpriseType(Long.valueOf(addCarrierParams.getCarrierType()));
        }
        if (CollectionUtils.isNotEmpty(addCarrierParams.getLogisticsType())) {
            addReqDto.setLogisticsType(String.join((CharSequence)",", addCarrierParams.getLogisticsType()));
        }
        if (StringUtils.isNumeric((CharSequence)addCarrierParams.getCarrierPrintType())) {
            addReqDto.setPrintType(Long.valueOf(addCarrierParams.getCarrierPrintType()));
        }
        addReqDto.setAssistCode(addCarrierParams.getCarrierAuxiliaryCode());
        addReqDto.setVolumeRatio(addCarrierParams.getCarrierVolumeWeightCoefficient());
        addReqDto.setContact(addCarrierParams.getCarrierContact());
        addReqDto.setContactPhone(addCarrierParams.getCarrierTel());
        addReqDto.setEmail(addCarrierParams.getCarrierEmail());
        if (StringUtils.isNumeric((CharSequence)addCarrierParams.getCarrierStatus())) {
            addReqDto.setShipmentEnterpriseStatus(Long.valueOf(addCarrierParams.getCarrierStatus()));
        }
        addReqDto.setRemark(addCarrierParams.getCarrierRemark());
        AddressVO carrierAddress = addCarrierParams.getCarrierAddress();
        if (Objects.nonNull(carrierAddress)) {
            addReqDto.setProvince(carrierAddress.getProvince());
            addReqDto.setProvinceCode(carrierAddress.getProvinceCode());
            addReqDto.setCity(carrierAddress.getCity());
            addReqDto.setCityCode(carrierAddress.getCityCode());
            addReqDto.setCounty(carrierAddress.getDistrict());
            addReqDto.setCountyCode(carrierAddress.getDistrictCode());
            addReqDto.setContactAddress(carrierAddress.getDetailAddress());
        }
        this.csShipmenetEnterpriseApi.add(addReqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<CarrierVO> getCarrierDetail(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        CsShipmenetEnterpriseRespDto respDto = (CsShipmenetEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.queryByPrimaryKey(Long.valueOf(id)));
        CarrierVO carrierVO = new CarrierVO();
        if (respDto != null) {
            this.getCarrierVO(respDto, carrierVO);
        }
        return new RestResponse((Object)carrierVO);
    }

    private String checkCustomerInfo(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        PCPCustomerRespDto pcpCustomerRespDto = (PCPCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.ipcpCustomerQueryApi.queryPCPCustomerDetailByCode(customerCode));
        if (pcpCustomerRespDto == null) {
            throw new BizException("\u5ba2\u6237\u7f16\u7801\u4e0d\u6b63\u786e");
        }
        return pcpCustomerRespDto.getCustomerName();
    }

    private void getCarrierVO(CsShipmenetEnterpriseRespDto respDto, CarrierVO carrierVO) {
        BeanUtils.copyProperties((Object)respDto, (Object)carrierVO);
        carrierVO.setCarrierCode(respDto.getShipmentEnterpriseCode());
        carrierVO.setCarrierName(respDto.getShipmentEnterpriseName());
        carrierVO.setCarrierShortName(respDto.getShipmentEnterpriseReduceName());
        carrierVO.setCarrierType(respDto.getShipmentEnterpriseType() != null ? String.valueOf(respDto.getShipmentEnterpriseType()) : null);
        carrierVO.setCarrierPrintType(respDto.getPrintType() != null ? String.valueOf(respDto.getPrintType()) : null);
        carrierVO.setCarrierAuxiliaryCode(respDto.getAssistCode());
        carrierVO.setCarrierVolumeWeightCoefficient(respDto.getVolumeRatio());
        carrierVO.setCarrierContact(respDto.getContact());
        carrierVO.setCarrierTel(respDto.getContactPhone());
        carrierVO.setCarrierEmail(respDto.getEmail());
        carrierVO.setCarrierStatus(respDto.getShipmentEnterpriseStatus() != null ? String.valueOf(respDto.getShipmentEnterpriseStatus()) : null);
        carrierVO.setCarrierRemark(respDto.getRemark());
        AddressVO addressVO = new AddressVO();
        addressVO.setProvince(respDto.getProvince());
        addressVO.setProvinceCode(respDto.getProvinceCode());
        addressVO.setCity(respDto.getCity());
        addressVO.setCityCode(respDto.getCityCode());
        addressVO.setDistrict(respDto.getCounty());
        addressVO.setDistrictCode(respDto.getCountyCode());
        addressVO.setDetailAddress(respDto.getContactAddress());
        if (StringUtils.isNotEmpty((CharSequence)respDto.getLogisticsType())) {
            carrierVO.setLogisticsType(Arrays.asList(respDto.getLogisticsType().split(",")));
        }
        if (StringUtils.isNotEmpty((CharSequence)respDto.getCustomerName())) {
            carrierVO.setCustomerNameList(Arrays.asList(respDto.getCustomerName().split(",")));
        }
        if (StringUtils.isNotEmpty((CharSequence)respDto.getCustomerCode())) {
            carrierVO.setCustomerCodeList(Arrays.asList(respDto.getCustomerCode().split(",")));
        }
        carrierVO.setCarrierAddress(addressVO);
        carrierVO.setCarrierId(respDto.getId().toString());
    }

    @Override
    public RestResponse<PageInfo<CarrierVO>> getCarrierListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetCarrierListPageParams getCarrierListPageParams) {
        CsShipmenetEnterpriseQueryDto queryDto = new CsShipmenetEnterpriseQueryDto();
        BeanUtils.copyProperties((Object)getCarrierListPageParams, (Object)queryDto);
        queryDto.setShipmentEnterpriseCode(getCarrierListPageParams.getCarrierCode());
        queryDto.setShipmentEnterpriseName(getCarrierListPageParams.getCarrierName());
        queryDto.setShipmentEnterpriseReduceName(getCarrierListPageParams.getCarrierShortName());
        queryDto.setShipmentEnterpriseType(getCarrierListPageParams.getCarrierType() != null ? Long.valueOf(getCarrierListPageParams.getCarrierType()) : null);
        queryDto.setShipmentEnterpriseStatus(getCarrierListPageParams.getCarrierStatus() != null ? Long.valueOf(getCarrierListPageParams.getCarrierStatus()) : null);
        log.info("\u7269\u6d41\u5546\u5165\u53c2{}", (Object)queryDto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.queryByPage(queryDto));
        log.info("\u7269\u6d41\u5546\u67e5\u8be2\u7ed3\u679c{}", (Object)respDtoPageInfo);
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                CarrierVO carrierVO = new CarrierVO();
                this.getCarrierVO((CsShipmenetEnterpriseRespDto)o, carrierVO);
                return carrierVO;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateCarrier(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateCarrierParams updateCarrierParams) {
        if (Objects.isNull(updateCarrierParams) || StringUtils.isEmpty((CharSequence)updateCarrierParams.getCarrierId())) {
            throw new com.dtyunxi.exceptions.BizException("\u7f16\u8f91\u7269\u6d41\u5546\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        CsShipmenetEnterpriseUpdateReqDto updateReqDto = new CsShipmenetEnterpriseUpdateReqDto();
        if (CollectionUtils.isNotEmpty(updateCarrierParams.getCustomerNameList())) {
            updateReqDto.setCustomerName(String.join((CharSequence)",", updateCarrierParams.getCustomerNameList()));
        }
        if (CollectionUtils.isNotEmpty(updateCarrierParams.getCustomerCodeList())) {
            updateReqDto.setCustomerCode(String.join((CharSequence)",", updateCarrierParams.getCustomerCodeList()));
        }
        updateReqDto.setShipmentEnterpriseCode(updateCarrierParams.getCarrierCode());
        updateReqDto.setShipmentEnterpriseName(updateCarrierParams.getCarrierName());
        updateReqDto.setShipmentEnterpriseReduceName(updateCarrierParams.getCarrierShortName());
        if (StringUtils.isNumeric((CharSequence)updateCarrierParams.getCarrierType())) {
            updateReqDto.setShipmentEnterpriseType(Long.valueOf(updateCarrierParams.getCarrierType()));
        }
        if (CollectionUtils.isNotEmpty(updateCarrierParams.getLogisticsType())) {
            updateReqDto.setLogisticsType(String.join((CharSequence)",", updateCarrierParams.getLogisticsType()));
        }
        if (StringUtils.isNumeric((CharSequence)updateCarrierParams.getCarrierPrintType())) {
            updateReqDto.setPrintType(Long.valueOf(updateCarrierParams.getCarrierPrintType()));
        }
        updateReqDto.setAssistCode(updateCarrierParams.getCarrierAuxiliaryCode());
        updateReqDto.setVolumeRatio(updateCarrierParams.getCarrierVolumeWeightCoefficient());
        updateReqDto.setContact(updateCarrierParams.getCarrierContact());
        updateReqDto.setContactPhone(updateCarrierParams.getCarrierTel());
        updateReqDto.setEmail(updateCarrierParams.getCarrierEmail());
        if (StringUtils.isNumeric((CharSequence)updateCarrierParams.getCarrierStatus())) {
            updateReqDto.setShipmentEnterpriseStatus(Long.valueOf(updateCarrierParams.getCarrierStatus()));
        }
        updateReqDto.setRemark(updateCarrierParams.getCarrierRemark());
        AddressVO carrierAddress = updateCarrierParams.getCarrierAddress();
        if (Objects.nonNull(carrierAddress)) {
            updateReqDto.setProvince(carrierAddress.getProvince());
            updateReqDto.setProvinceCode(carrierAddress.getProvinceCode());
            updateReqDto.setCity(carrierAddress.getCity());
            updateReqDto.setCityCode(carrierAddress.getCityCode());
            updateReqDto.setCounty(carrierAddress.getDistrict());
            updateReqDto.setCountyCode(carrierAddress.getDistrictCode());
            updateReqDto.setContactAddress(carrierAddress.getDetailAddress());
        }
        this.csShipmenetEnterpriseApi.update(Long.valueOf(updateCarrierParams.getCarrierId()), updateReqDto);
        return new RestResponse();
    }
}

