/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cis.pms.biz.constant.PmsCsShipmentLogisticsTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportInsurancePremiumReportVO;
import com.dtyunxi.cis.pms.biz.service.IImportCostReportDataCheckCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IReInsurancePremiumApi;
import com.dtyunxi.tcbj.api.dto.InsuranceItemVo;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import com.dtyunxi.tcbj.api.query.IReInsurancePremiumQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEasCostOrgQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportDetailApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_insurance_premium_report")
public class ImportInsurancePremiumReportImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ImportInsurancePremiumReportImpl.class);
    private final String ADD = "\u65b0\u589e";
    private final String UPD = "\u8986\u76d6";
    @Resource
    private IImportCostReportDataCheckCommonService dataCheckCommonService;
    @Resource
    private IDailyDeliveryReportDetailApi deliveryReportDetailApi;
    @Resource
    private IEasCostOrgQueryApi easCostOrgQueryApi;
    @Resource
    private IReInsurancePremiumQueryApi reInsurancePremiumQueryApi;
    @Resource
    private IReInsurancePremiumApi reInsurancePremiumApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportInsurancePremiumReportVO.class);
        log.info("\u4fdd\u8d39\u660e\u7ec6\u5bfc\u5165verifyImportFileOperationCommon\uff1a{}", (Object)list);
        this.addListCheck(list);
        this.updListCheck(list);
        return list;
    }

    private void addListCheck(List<ImportInsurancePremiumReportVO> list) {
        List addList = list.stream().filter(f -> f.getImportType().equals("\u65b0\u589e")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(addList)) {
            log.info("\u65e0\u65b0\u589e\u6570\u636e\u6821\u9a8c");
            return;
        }
        Map<String, EasCostOrgRespDto> costOrg = this.dataCheckCommonService.getCostOrg();
        Map<String, CsPhysicsWarehouseRespDto> physicsWarehouse = this.dataCheckCommonService.getPhysicsWarehouse();
        List<String> logicalWarehouseNameList = addList.stream().flatMap(vo -> Stream.of(vo.getInLogicWarehouseName(), vo.getOutLogicWarehouseName())).distinct().collect(Collectors.toList());
        Map<String, LogicWarehouseRespDto> logicalWarehouse = this.dataCheckCommonService.getLogicalWarehouse(logicalWarehouseNameList);
        Map<String, CsShipmenetEnterpriseRespDto> carrierMap = this.dataCheckCommonService.getCarrier();
        List<String> itemCodes = addList.stream().map(ImportInsurancePremiumReportVO::getLongCode).distinct().collect(Collectors.toList());
        Map<String, InsuranceItemVo> itemMap = this.dataCheckCommonService.getItemExt(itemCodes);
        for (ImportInsurancePremiumReportVO vo2 : list) {
            if (!vo2.getImportType().equals("\u65b0\u589e")) continue;
            EasCostOrgRespDto easCostOrgRespDto = costOrg.get(vo2.getBillOrgName());
            if (ObjectUtil.isNotEmpty((Object)easCostOrgRespDto)) {
                vo2.setBillOrgCode(easCostOrgRespDto.getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutOrganizationName()) && ObjectUtil.isNotEmpty((Object)costOrg.get(vo2.getOutOrganizationName()))) {
                vo2.setOutOrganizationCode(costOrg.get(vo2.getOutOrganizationName()).getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getInOrganizationName()) && ObjectUtil.isNotEmpty((Object)costOrg.get(vo2.getInOrganizationName()))) {
                vo2.setInOrganizationCode(costOrg.get(vo2.getInOrganizationName()).getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutPhysicsWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)physicsWarehouse.get(vo2.getOutPhysicsWarehouseName()))) {
                    vo2.setErrorMsg("\u51fa\u5e93\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setOutPhysicsWarehouseCode(physicsWarehouse.get(vo2.getOutPhysicsWarehouseName()).getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutLogicWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)logicalWarehouse.get(vo2.getOutLogicWarehouseName()))) {
                    vo2.setErrorMsg("\u51fa\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setOutLogicWarehouseCode(logicalWarehouse.get(vo2.getOutLogicWarehouseName()).getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getInLogicWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)logicalWarehouse.get(vo2.getInLogicWarehouseName()))) {
                    vo2.setErrorMsg("\u5165\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setInLogicWarehouseCode(logicalWarehouse.get(vo2.getInLogicWarehouseName()).getWarehouseCode());
            }
            if (!ObjectUtil.isNotEmpty((Object)carrierMap.get(vo2.getShippingCompany()))) {
                vo2.setErrorMsg("\u7269\u6d41\u5546\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            vo2.setShippingCompanyCode(carrierMap.get(vo2.getShippingCompany()).getShipmentEnterpriseCode());
            vo2.setShippingCompanyLogisticsType(carrierMap.get(vo2.getShippingCompany()).getLogisticsType());
            Integer shippingTypeCode = PmsCsShipmentLogisticsTypeEnum.getTypeByDesc(vo2.getShippingType());
            if (ObjectUtil.isEmpty((Object)shippingTypeCode)) {
                vo2.setErrorMsg("\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            vo2.setShippingTypeCode(shippingTypeCode.toString());
            if (!vo2.getShippingCompanyLogisticsType().contains(vo2.getShippingTypeCode())) {
                vo2.setErrorMsg("\u8be5\u7269\u6d41\u5546\u4e0b\u4e0d\u5b58\u5728\u8be5\u627f\u8fd0\u65b9\u5f0f\uff1b");
                continue;
            }
            if (ObjectUtil.isEmpty((Object)itemMap.get(vo2.getLongCode()))) {
                vo2.setErrorMsg("\u5546\u54c1\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            InsuranceItemVo item = itemMap.get(vo2.getLongCode());
            vo2.setClaimPrice(item.getClaimPrice());
            vo2.setRecommendPrice(item.getRecommendPrice());
            if (!ObjectUtils.isNotEmpty((Object)item.getItemType())) continue;
            if (Objects.equals(SubTypeEnum.GIFT.getType(), item.getItemType())) {
                vo2.setItemType(SubTypeEnum.PRODUCT.getType());
                continue;
            }
            vo2.setItemType(item.getItemType());
        }
    }

    private void updListCheck(List<ImportInsurancePremiumReportVO> list) {
        List updList = list.stream().filter(f -> f.getImportType().equals("\u8986\u76d6")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(updList)) {
            log.info("\u65e0\u7f16\u8f91\u6570\u636e\u6821\u9a8c");
            return;
        }
        ArrayList respDtoList = new ArrayList();
        List consignmentNoList = updList.stream().map(ImportInsurancePremiumReportVO::getConsignmentNo).collect(Collectors.toList());
        ReInsurancePremiumReqDto reqDto = new ReInsurancePremiumReqDto();
        reqDto.setWmsConsignmentNoList(consignmentNoList);
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.reInsurancePremiumQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), reqDto.getPageNum(), reqDto.getPageNum()));
        while (ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList()) && ObjectUtil.isNotEmpty(pageInfo.getList().get(0))) {
            respDtoList.addAll(pageInfo.getList());
            reqDto.setPageNum(Integer.valueOf(reqDto.getPageNum() + 1));
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.reInsurancePremiumQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), reqDto.getPageNum(), reqDto.getPageNum()));
        }
        if (CollectionUtil.isEmpty(respDtoList)) {
            log.info("\u65e0\u5e93\u5185\u4fdd\u8d39\u660e\u7ec6\u6570\u636e");
            list.forEach(vo -> {
                if (vo.getImportType().equals("\u8986\u76d6")) {
                    vo.setErrorMsg("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff1b");
                }
            });
            return;
        }
        log.info("\u67e5\u8be2\u5e93\u5185\u4fdd\u8d39\u660e\u7ec6\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(respDtoList));
        Map<String, List<ReInsurancePremiumRespDto>> premiumRespDtoMap = respDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getWmsConsignmentNo())).collect(Collectors.groupingBy(ReInsurancePremiumRespDto::getConsignmentNo));
        for (ImportInsurancePremiumReportVO vo2 : list) {
            if (!vo2.getImportType().equals("\u8986\u76d6")) continue;
            List<ReInsurancePremiumRespDto> premiumRespDtoList = premiumRespDtoMap.get(vo2.getConsignmentNo());
            if (CollectionUtil.isEmpty(premiumRespDtoList)) {
                vo2.setErrorMsg("\u65e0\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            ReInsurancePremiumRespDto respDto = null;
            int i = 0;
            for (ReInsurancePremiumRespDto premiumRespDto : premiumRespDtoList) {
                if (!vo2.getLongCode().equals(premiumRespDto.getLongCode()) || StringUtils.isNotBlank((CharSequence)vo2.getBatch()) && !vo2.getBatch().equals(premiumRespDto.getBatch()) || StringUtils.isNotBlank((CharSequence)vo2.getOutDocumentNo()) && !vo2.getOutDocumentNo().equals(premiumRespDto.getOutDocumentNo()) || StringUtils.isNotBlank((CharSequence)vo2.getTransportNo()) && !vo2.getTransportNo().equals(premiumRespDto.getTransportNo())) continue;
                ++i;
                respDto = premiumRespDto;
            }
            if (ObjectUtil.isEmpty(respDto)) {
                vo2.setErrorMsg("\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            if (i > 1) {
                vo2.setErrorMsg("\u627e\u4e0d\u5230\u552f\u4e00\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            vo2.setId(respDto.getId());
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        log.info("\u4fdd\u8d39\u660e\u7ec6\u5bfc\u5165executeImportFileOperationCommon\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        List list = (List)obj;
        for (ImportInsurancePremiumReportVO vo : list) {
            if (StringUtils.isNotBlank((CharSequence)vo.getErrorMsg())) continue;
            if (vo.getImportType().equals("\u8986\u76d6")) {
                try {
                    ReInsurancePremiumReqDto reqDto = new ReInsurancePremiumReqDto();
                    reqDto.setId(vo.getId());
                    reqDto.setBillOrgCode(vo.getBillOrgCode());
                    reqDto.setBillOrgName(vo.getBillOrgName());
                    reqDto.setOrderRemark(vo.getRemark());
                    RestResponseHelper.extractData((RestResponse)this.reInsurancePremiumApi.updateBillOrg(reqDto));
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)((Object)vo)), (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    vo.setErrorMsg("\u66f4\u65b0\u5f02\u5e38" + e.getMessage());
                }
                continue;
            }
            try {
                ReInsuranceBillReqDto billReqDto = (ReInsuranceBillReqDto)BeanUtil.copyProperties((Object)((Object)vo), ReInsuranceBillReqDto.class, (String[])new String[0]);
                billReqDto.setWmsConsignmentNo(vo.getConsignmentNo());
                billReqDto.setOrderRemark(vo.getRemark());
                billReqDto.setOutOrganizationId(StringUtils.isNotBlank((CharSequence)vo.getOutOrganizationCode()) ? Long.valueOf(vo.getOutOrganizationCode()) : null);
                billReqDto.setInOrganizationId(StringUtils.isNotBlank((CharSequence)vo.getInOrganizationCode()) ? Long.valueOf(vo.getInOrganizationCode()) : null);
                billReqDto.setReason(null);
                billReqDto.setPlacedFlag(Integer.valueOf(0));
                billReqDto.setExternalOrderNo(vo.getEasOrder());
                if (StringUtils.isNotBlank((CharSequence)vo.getBillOrgName())) {
                    billReqDto.setBillOrgName(vo.getBillOrgName());
                    log.info("\u8bbe\u7f6ebillOrgName: {}", (Object)vo.getBillOrgName());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getBillOrgCode())) {
                    billReqDto.setBillOrgCode(vo.getBillOrgCode());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getEasOrder())) {
                    billReqDto.setOrderNo(vo.getEasOrder());
                    log.info("\u8bbe\u7f6eOrderNo (EAS\u8ba2\u5355\u53f7): {}", (Object)vo.getEasOrder());
                }
                billReqDto.setOutDocumentNo(vo.getOutDocumentNo());
                billReqDto.setOutPhysicsWarehouseCode(vo.getOutPhysicsWarehouseCode());
                billReqDto.setOutPhysicsWarehouseName(vo.getOutPhysicsWarehouseName());
                billReqDto.setTransportNo(vo.getTransportNo());
                billReqDto.setReceivingPerson(vo.getReceivingPerson());
                billReqDto.setInsureTotalPrice(vo.getInsureAmount());
                billReqDto.setWmsMergeDocumentNo(vo.getWmsMergeDocumentNo());
                ReInsurancePremiumReqDto premiumReqDto = (ReInsurancePremiumReqDto)BeanUtil.copyProperties((Object)((Object)vo), ReInsurancePremiumReqDto.class, (String[])new String[0]);
                premiumReqDto.setOrderRemark(billReqDto.getOrderRemark());
                premiumReqDto.setOutOrganizationId(billReqDto.getOutOrganizationId());
                premiumReqDto.setInOrganizationId(billReqDto.getInOrganizationId());
                premiumReqDto.setPlacedFlag(Integer.valueOf(0));
                if (StringUtils.isNotBlank((CharSequence)vo.getBillOrgName())) {
                    premiumReqDto.setBillOrgName(vo.getBillOrgName());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getBillOrgCode())) {
                    premiumReqDto.setBillOrgCode(vo.getBillOrgCode());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getEasOrder())) {
                    premiumReqDto.setOrderNo(vo.getEasOrder());
                    log.info("\u8bbe\u7f6epremiumReqDto\u7684OrderNo (EAS\u8ba2\u5355\u53f7): {}", (Object)vo.getEasOrder());
                }
                premiumReqDto.setOutDocumentNo(vo.getOutDocumentNo());
                premiumReqDto.setWmsConsignmentNo(vo.getConsignmentNo());
                premiumReqDto.setOutPhysicsWarehouseCode(vo.getOutPhysicsWarehouseCode());
                premiumReqDto.setOutPhysicsWarehouseName(vo.getOutPhysicsWarehouseName());
                premiumReqDto.setReceivingPerson(vo.getReceivingPerson());
                premiumReqDto.setClaimPrice(vo.getClaimPrice());
                premiumReqDto.setInsureUnitPrice(vo.getInsureUnitPrice());
                premiumReqDto.setInsureTotalPrice(vo.getInsureAmount());
                premiumReqDto.setTransportNo(vo.getTransportNo());
                premiumReqDto.setBatch(vo.getBatch());
                premiumReqDto.setCargoName(vo.getCargoName());
                premiumReqDto.setItemType(vo.getItemType());
                billReqDto.setPremiumReqDtoList((List)Lists.newArrayList((Object[])new ReInsurancePremiumReqDto[]{premiumReqDto}));
                log.info("generateInsuranceReportImport\uff1a{}", (Object)JSON.toJSONString((Object)billReqDto));
                this.reInsurancePremiumApi.generateInsuranceReportImport(billReqDto);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)((Object)vo)), (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                vo.setErrorMsg("\u65b0\u589e\u5f02\u5e38" + e.getMessage());
            }
        }
        String errorMsgUrl = null;
        List errorList = list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorList)) {
            log.info("\u4fdd\u8d39\u660e\u7ec6\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString(errorList));
            String excelName = String.format("%s%s", "\u4fdd\u8d39\u660e\u7ec6\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, ImportInsurancePremiumReportVO.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

