/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddMaterialsReturnParams;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportMaterialsReturnVO;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsInventoryGoodsVO;
import com.dtyunxi.cis.pms.biz.model.GetMaterialsReturnOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.MaterialsOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryMaterialsReturnService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.request.InPlannedOrderPageParams;
import com.dtyunxi.cis.search.api.query.inventory.EsPlannedOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.MaterialsOrderLisReq;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_materials_return")
public class FinishedGoodsInventoryMaterialsReturnServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryMaterialsReturnService {
    @Resource
    private EsPlannedOrderQueryApi esPlannedOrderQueryApi;
    @Resource
    private ICsInPlannedOrderApi csInPlannedOrderApi;
    @Resource
    private ICsInPlannedOrderQueryApi csInPlannedOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;

    @Override
    public RestResponse<Object> addMaterialsReturn(@ApiParam(value="") @Valid @RequestBody(required=false) AddMaterialsReturnParams addMaterialsReturnParams) {
        CsInPlannedOrderGenerateReqDto reqDto = new CsInPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addMaterialsReturnParams, (Object)reqDto);
        this.getAddMaterialsReturnOrder(addMaterialsReturnParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.generatePlannedOrder(reqDto)));
    }

    private void getAddMaterialsReturnOrder(AddMaterialsReturnParams addMaterialsReturnParams, CsInPlannedOrderGenerateReqDto reqDto) {
        Integer submitType = addMaterialsReturnParams.getSubmitType();
        reqDto.setOperateFlag(CsPlannedOrderOperateEnum.DRAFT.getCode());
        if (YesOrNoEnum.YES.getCode().equals(submitType)) {
            reqDto.setOperateFlag(CsPlannedOrderOperateEnum.SUBMIT.getCode());
        }
        reqDto.setOrderType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS_RETURN.getCode());
        reqDto.setBusinessType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS_RETURN.getCode());
        reqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        reqDto.setWarehouseCode(addMaterialsReturnParams.getReceiveLogicalWarehouseCode());
        reqDto.setWarehouseName(addMaterialsReturnParams.getReceiveLogicalWarehouseName());
        reqDto.setRemark(addMaterialsReturnParams.getRemark());
        reqDto.setEstimatedTime(StringUtils.isNotBlank((CharSequence)addMaterialsReturnParams.getArrivalTime()) ? DateUtil.parse((String)addMaterialsReturnParams.getArrivalTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
        List<FinishedGoodsInventoryGoodsVO> goodsList = addMaterialsReturnParams.getGoodsList();
        List list = goodsList.stream().map(o -> {
            CsInPlannedOrderGenerateDetailReqDto dto = new CsInPlannedOrderGenerateDetailReqDto();
            BeanUtils.copyProperties((Object)o, (Object)dto);
            dto.setLongCode(o.getGoodsLongCode());
            dto.setBatch(o.getBatchNo());
            dto.setCargoName(o.getGoodsName());
            dto.setCargoCode(o.getGoodsCode());
            dto.setCargoId(ParamConverter.convertToLong((Object)o.getGoodsId()));
            if (StringUtils.isNotBlank((CharSequence)o.getEffectiveTime())) {
                dto.setProduceTime(DateUtil.parse((String)o.getEffectiveTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getInvalidTime())) {
                dto.setExpireTime(DateUtil.parse((String)o.getInvalidTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            dto.setPlanQuantity(ParamConverter.convertToBigDecimal((Object)o.getPlanQuantity()));
            return dto;
        }).collect(Collectors.toList());
        reqDto.setItemDetailList(list);
    }

    @Override
    public RestResponse<MaterialsOrderVO> getMaterialsReturnDetail(@NotNull @ApiParam(value="\u5355\u636e\u7f16\u53f7", required=true) @Valid @RequestParam(value="bussinessOrderNo", required=true) String bussinessOrderNo) {
        List<AssociatedDocumentVO> list;
        List relOrderInfoList;
        CsInPlannedOrderDetailQueryInfoRespDto respDto = (CsInPlannedOrderDetailQueryInfoRespDto)RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderQueryApi.queryDetailByOrderNo(bussinessOrderNo));
        MaterialsOrderVO vo = new MaterialsOrderVO();
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getOrderNo());
        vo.setBussinessOrderType(respDto.getOrderType());
        vo.setBussinessOrderStatus(respDto.getOrderStatus());
        vo.setExternalOrderNo(respDto.getPlatformOrderNo());
        vo.setReceiveLogicalWarehouseCode(respDto.getReceiveWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getReceiveWarehouseName());
        vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        if (respDto.getEstimatedTime() != null) {
            vo.setArrivalTime(DateUtil.format((Date)respDto.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(relOrderInfoList = respDto.getRelOrderInfoList()))) {
            list = relOrderInfoList.stream().map(o -> {
                AssociatedDocumentVO associatedDocumentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)associatedDocumentVO);
                associatedDocumentVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                return associatedDocumentVO;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)) {
                Collections.sort(list, (o2, o1) -> o2.getCreateTime().compareTo(o1.getCreateTime()));
            }
            vo.setAssociatedDocumentList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)respDto.getAuditRespDtoList())) {
            list = respDto.getAuditRespDtoList().stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setAuditRemark(o.getRemark());
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<MaterialsOrderVO>> getMaterialsReturnListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetMaterialsReturnOrderListPageParams getMaterialsReturnOrderListPageParams) {
        InPlannedOrderPageParams params = new InPlannedOrderPageParams();
        BeanUtils.copyProperties((Object)getMaterialsReturnOrderListPageParams, (Object)params);
        params.setOrderNo(getMaterialsReturnOrderListPageParams.getBussinessOrderNo());
        params.setOrdeType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS_RETURN.getCode());
        params.setWarehouseCode(getMaterialsReturnOrderListPageParams.getReceiveLogicalWarehouseCode());
        params.setWarehouseName(getMaterialsReturnOrderListPageParams.getReceiveLogicalWarehouseName());
        params.setOrderStatus(getMaterialsReturnOrderListPageParams.getBussinessOrderStatus());
        PageInfo pageInfo = new PageInfo();
        PageInfo respDtoPageInfo = new PageInfo();
        ArrayList materialsReturnVOList = new ArrayList();
        MaterialsOrderLisReq getMaterialsReturnListPageParams = new MaterialsOrderLisReq();
        BeanUtils.copyProperties((Object)getMaterialsReturnOrderListPageParams, (Object)getMaterialsReturnListPageParams);
        getMaterialsReturnListPageParams.setOrderType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS_RETURN.getCode());
        PageInfo materialsReturnVOPageInfo = (PageInfo)this.inventoryEsReportQueryApi.queryMaterialsOrderListPage(getMaterialsReturnListPageParams).getData();
        if (CollectionUtils.isEmpty((Collection)materialsReturnVOPageInfo.getList())) {
            return new RestResponse();
        }
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)materialsReturnVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList resList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resList, (Collection)materialsReturnVOPageInfo.getList(), MaterialsOrderVO.class);
        CubeBeanUtils.copyCollection(materialsReturnVOList, (Collection)materialsReturnVOPageInfo.getList(), MaterialsOrderVO.class);
        respDtoPageInfo.setList((List)resList);
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        AtomicInteger i = new AtomicInteger();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            MaterialsOrderVO vo = new MaterialsOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setBussinessOrderType(o.getOrderType());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            vo.setLongCode(o.getCargoCode());
            vo.setExternalOrderNo(o.getPlatformOrderNo());
            vo.setTotalNum(BigDecimalUtils.check((BigDecimal)o.getTotalQuantity()).intValue());
            vo.setSupplierName(o.getSupplierName());
            vo.setReceiveLogicalWarehouseCode(o.getReceiveWarehouseCode());
            vo.setReceiveLogicalWarehouseName(o.getReceiveWarehouseName());
            MaterialsOrderVO materialsReturnVO = (MaterialsOrderVO)materialsReturnVOList.get(i.getAndIncrement());
            vo.setProductionWarehouseCode(materialsReturnVO.getProductionWarehouseCode());
            vo.setProductionWarehouseName(materialsReturnVO.getProductionWarehouseName());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<InPlannedOrderStatusCountRespDto>> materialsReturnStatusCount(@Valid GetMaterialsReturnOrderListPageParams getMaterialsReturnOrderListPageParams) {
        MaterialsOrderLisReq materialsOrderLisReq = new MaterialsOrderLisReq();
        BeanUtils.copyProperties((Object)getMaterialsReturnOrderListPageParams, (Object)materialsOrderLisReq);
        materialsOrderLisReq.setOrderType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS_RETURN.getCode());
        return this.inventoryEsReportQueryApi.materialsOrderStatusCount(materialsOrderLisReq);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetMaterialsReturnOrderListPageParams params = new GetMaterialsReturnOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetMaterialsReturnOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetMaterialsReturnOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getMaterialsReturnListPage((GetMaterialsReturnOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                ExportMaterialsReturnVO vo = new ExportMaterialsReturnVO();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setProductionWorkshop(item.getProductionWorkshop());
                vo.setBussinessOrderStatus(Optional.ofNullable(item.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return item.getBussinessOrderStatus();
                }).orElse(""));
                vo.setBussinessOrderType("\u751f\u4ea7\u9000\u6599");
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportMaterialsReturnVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetMaterialsReturnOrderListPageParams params = new GetMaterialsReturnOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetMaterialsReturnOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetMaterialsReturnOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getMaterialsReturnListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> updateMaterialsReturn(@ApiParam(value="") @Valid @RequestBody(required=false) AddMaterialsReturnParams addMaterialsReturnParams) {
        CsInPlannedOrderGenerateReqDto reqDto = new CsInPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addMaterialsReturnParams, (Object)reqDto);
        reqDto.setOrderNo(addMaterialsReturnParams.getBussinessOrderNo());
        this.getAddMaterialsReturnOrder(addMaterialsReturnParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.editPlannedOrder(reqDto)));
    }
}

