/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterAreaService;
import com.dtyunxi.cis.pms.biz.service.IImportCostReportDataCheckCommonService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IReInsurancePremiumApi;
import com.dtyunxi.tcbj.api.dto.InsuranceItemVo;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EasCostOrgReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEasCostOrgQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailDtEo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImportCostReportDataCheckCommonServiceImpl
implements IImportCostReportDataCheckCommonService {
    private final Logger logger = LoggerFactory.getLogger(ImportCostReportDataCheckCommonServiceImpl.class);
    @Resource
    private IEasCostOrgQueryApi easCostOrgQueryApi;
    @Resource
    private ICsPhysicsWarehouseQueryApi physicsWarehouseQueryApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;
    @Resource
    private IReInsurancePremiumApi reInsurancePremiumApi;
    @Resource
    private BasedataCenterAreaService centerAreaService;

    @Override
    public Map<String, EasCostOrgRespDto> getCostOrg() {
        this.logger.info("\u67e5\u8be2\u8ba1\u8d39\u7ec4\u7ec7\u4fe1\u606f");
        EasCostOrgReqDto reqDto = new EasCostOrgReqDto();
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.easCostOrgQueryApi.queryListByPage(reqDto));
        return Optional.ofNullable(pageInfo.getList()).map(m -> m.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getOrgName())).collect(Collectors.toMap(EasCostOrgRespDto::getOrgName, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
    }

    @Override
    public Map<String, CsPhysicsWarehouseRespDto> getPhysicsWarehouse() {
        this.logger.info("\u67e5\u8be2\u7269\u7406\u4ed3\u4fe1\u606f");
        CsPhysicsWarehouseQueryDto queryDto = new CsPhysicsWarehouseQueryDto();
        queryDto.setWarehouseStatus("enable");
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseQueryApi.queryByPage(queryDto));
        return Optional.ofNullable(pageInfo.getList()).map(m -> m.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getWarehouseName())).collect(Collectors.toMap(CsPhysicsWarehouseRespDto::getWarehouseName, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
    }

    @Override
    public Map<String, LogicWarehouseRespDto> getLogicalWarehouse(List<String> nameList) {
        this.logger.info("\u67e5\u8be2\u903b\u8f91\u4ed3\u4fe1\u606f\uff1a{}", nameList);
        List list = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryWarehouseByName(nameList));
        return Optional.ofNullable(list).map(m -> m.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getWarehouseName())).collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseName, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
    }

    @Override
    public Map<String, CsShipmenetEnterpriseRespDto> getCarrier() {
        this.logger.info("\u67e5\u8be2\u7269\u6d41\u5546\u4fe1\u606f");
        CsShipmenetEnterpriseQueryDto queryDto = new CsShipmenetEnterpriseQueryDto();
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.queryByPage(queryDto));
        return Optional.ofNullable(pageInfo.getList()).map(m -> m.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getShipmentEnterpriseName())).collect(Collectors.toMap(CsShipmenetEnterpriseRespDto::getShipmentEnterpriseName, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
    }

    @Override
    public Map<String, DailyDeliveryReportDetailDtEo> getItem(List<String> longCodeList) {
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\uff1a{}", longCodeList);
        return (Map)RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.getItemByLongCode(longCodeList));
    }

    @Override
    public Map<String, InsuranceItemVo> getItemExt(List<String> longCodeList) {
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606fgetItemExt\uff1a{}", (Object)JSON.toJSONString(longCodeList));
        List insuranceItemVos = (List)RestResponseHelper.extractData((RestResponse)this.reInsurancePremiumApi.getPcpItemByLongCode(longCodeList));
        Map stringInsuranceItemVoMap = Optional.ofNullable(insuranceItemVos).map(m -> m.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getLongCode())).collect(Collectors.toMap(InsuranceItemVo::getLongCode, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606fgetItemExt\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)stringInsuranceItemVoMap));
        return stringInsuranceItemVoMap;
    }

    @Override
    public Map<String, BaseAreaVO> getAreaMap() {
        return this.centerAreaService.getAreaList().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public String checkArea(Map<String, BaseAreaVO> areaMap, String province, String city, String region) {
        if (StringUtils.isNotBlank((CharSequence)province)) {
            BaseAreaVO provinceVo = areaMap.get(province);
            if (ObjectUtils.isEmpty((Object)provinceVo)) {
                return "\u7701\u540d\u79f0\u4e0d\u6b63\u786e";
            }
            if (StringUtils.isNotBlank((CharSequence)city)) {
                if (CollectionUtil.isEmpty(provinceVo.getChildren())) {
                    return "\u8be5\u7701\u4efd\u4e0b\u4e0d\u5b58\u5728\u5e02";
                }
                Map cityMap = provinceVo.getChildren().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
                BaseAreaVO cityVO = (BaseAreaVO)cityMap.get(city);
                if (ObjectUtils.isEmpty((Object)cityVO)) {
                    return "\u57ce\u5e02\u540d\u79f0\u4e0d\u6b63\u786e";
                }
                if (StringUtils.isNotBlank((CharSequence)region)) {
                    if (CollectionUtil.isEmpty(cityVO.getChildren())) {
                        return "\u8be5\u57ce\u5e02\u4e0b\u4e0d\u5b58\u5728\u533a";
                    }
                    Map regionMap = cityVO.getChildren().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
                    BaseAreaVO regionVO = (BaseAreaVO)regionMap.get(region);
                    if (ObjectUtils.isEmpty((Object)regionVO)) {
                        return "\u533a\u540d\u79f0\u4e0d\u6b63\u786e";
                    }
                }
            }
        }
        return null;
    }
}

