/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportSortingExpenseOrderReportVO;
import com.dtyunxi.cis.pms.biz.service.IImportCostReportDataCheckCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SortingCostReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingExpenseReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.SortingCostReportRespDto;
import com.dtyunxi.tcbj.api.query.ISortingExpenseQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_sorting_expense_order_report")
public class ImportSortingExpenseOrderReportImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ImportSortingExpenseOrderReportImpl.class);
    private final String ADD = "\u65b0\u589e";
    private final String UPD = "\u8986\u76d6";
    @Resource
    private IImportCostReportDataCheckCommonService dataCheckCommonService;
    @Resource
    private ISortingExpenseQueryApi sortingExpenseQueryApi;
    @Resource
    private IContext context;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportSortingExpenseOrderReportVO.class);
        log.info("\u5206\u62e3\u8d39\u7528\u5355\u636e\u5bfc\u5165verifyImportFileOperationCommon\uff1a{}", (Object)list);
        this.addListCheck(list);
        this.updListCheck(list);
        return list;
    }

    private void addListCheck(List<ImportSortingExpenseOrderReportVO> list) {
        List addList = list.stream().filter(f -> f.getImportType().equals("\u65b0\u589e")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(addList)) {
            log.info("\u65e0\u65b0\u589e\u6570\u636e\u6821\u9a8c");
            return;
        }
        Map<String, EasCostOrgRespDto> costOrg = this.dataCheckCommonService.getCostOrg();
        Map<String, CsPhysicsWarehouseRespDto> physicsWarehouse = this.dataCheckCommonService.getPhysicsWarehouse();
        List<String> logicalWarehouseNameList = addList.stream().flatMap(vo -> Stream.of(vo.getOutWarehouse(), vo.getInWarehouse())).distinct().collect(Collectors.toList());
        Map<String, LogicWarehouseRespDto> logicalWarehouse = this.dataCheckCommonService.getLogicalWarehouse(logicalWarehouseNameList);
        Map<String, CsShipmenetEnterpriseRespDto> carrierMap = this.dataCheckCommonService.getCarrier();
        for (ImportSortingExpenseOrderReportVO vo2 : list) {
            if (!vo2.getImportType().equals("\u65b0\u589e")) continue;
            EasCostOrgRespDto easCostOrgRespDto = costOrg.get(vo2.getCostAttribution());
            if (ObjectUtil.isNotEmpty((Object)easCostOrgRespDto)) {
                vo2.setCostAttributionCode(easCostOrgRespDto.getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutOrgName()) && ObjectUtil.isNotEmpty((Object)costOrg.get(vo2.getOutOrgName()))) {
                vo2.setOutOrgCode(costOrg.get(vo2.getOutOrgName()).getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getInOrgName()) && ObjectUtil.isNotEmpty((Object)costOrg.get(vo2.getInOrgName()))) {
                vo2.setInOrgCode(costOrg.get(vo2.getInOrgName()).getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutPhysicsWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)physicsWarehouse.get(vo2.getOutPhysicsWarehouseName()))) {
                    vo2.setErrorMsg("\u51fa\u5e93\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setOutPhysicsWarehouseCode(physicsWarehouse.get(vo2.getOutPhysicsWarehouseName()).getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutWarehouse())) {
                if (ObjectUtil.isEmpty((Object)logicalWarehouse.get(vo2.getOutWarehouse()))) {
                    vo2.setErrorMsg("\u51fa\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setOutWarehouseCode(logicalWarehouse.get(vo2.getOutWarehouse()).getWarehouseCode());
            }
            if (!StringUtils.isNotBlank((CharSequence)vo2.getInWarehouse())) continue;
            if (ObjectUtil.isEmpty((Object)logicalWarehouse.get(vo2.getInWarehouse()))) {
                vo2.setErrorMsg("\u5165\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            vo2.setInWarehouseCode(logicalWarehouse.get(vo2.getInWarehouse()).getWarehouseCode());
        }
    }

    private void updListCheck(List<ImportSortingExpenseOrderReportVO> list) {
        List updList = list.stream().filter(f -> f.getImportType().equals("\u8986\u76d6")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(updList)) {
            log.info("\u65e0\u7f16\u8f91\u6570\u636e\u6821\u9a8c");
            return;
        }
        ArrayList respDtoList = new ArrayList();
        List outDocumentNoList = updList.stream().map(ImportSortingExpenseOrderReportVO::getOutDocumentNo).collect(Collectors.toList());
        SortingCostReportListPageReqDto pageReqDto = new SortingCostReportListPageReqDto();
        pageReqDto.setPageNum(Integer.valueOf(1));
        pageReqDto.setPageSize(Integer.valueOf(1000));
        pageReqDto.setOutDocumentNoList(outDocumentNoList);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sortingExpenseQueryApi.getSortingCostReportListPage(pageReqDto));
        if (CollectionUtil.isNotEmpty((Collection)pageInfo.getList()) && ObjectUtil.isNotEmpty((Object)((SortingCostReportRespDto)pageInfo.getList().get(0)).getId())) {
            respDtoList.addAll(pageInfo.getList());
            pageReqDto.setPageNum(Integer.valueOf(pageReqDto.getPageNum() + 1));
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sortingExpenseQueryApi.getSortingCostReportListPage(pageReqDto));
        }
        if (CollectionUtil.isEmpty(respDtoList)) {
            log.info("\u65e0\u5e93\u5185\u5206\u62e3\u660e\u7ec6\u6570\u636e");
            list.forEach(vo -> {
                if (vo.getImportType().equals("\u8986\u76d6")) {
                    vo.setErrorMsg("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff1b");
                }
            });
            return;
        }
        log.info("\u67e5\u8be2\u5e93\u5185\u5206\u62e3\u660e\u7ec6\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(respDtoList));
        Map<String, List<SortingCostReportRespDto>> respDtoMap = respDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getOutDocumentNo())).collect(Collectors.groupingBy(SortingCostReportRespDto::getOutDocumentNo));
        for (ImportSortingExpenseOrderReportVO vo2 : list) {
            if (!vo2.getImportType().equals("\u8986\u76d6")) continue;
            List<SortingCostReportRespDto> costDetailRespDtoList = respDtoMap.get(vo2.getOutDocumentNo());
            if (CollectionUtil.isEmpty(costDetailRespDtoList)) {
                vo2.setErrorMsg("\u65e0\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            SortingCostReportRespDto respDto = null;
            int i = 0;
            for (SortingCostReportRespDto detailRespDto : costDetailRespDtoList) {
                if (StringUtils.isNotBlank((CharSequence)vo2.getOutDocumentNo()) && !vo2.getOutDocumentNo().equals(detailRespDto.getOutDocumentNo())) continue;
                ++i;
                respDto = detailRespDto;
            }
            if (ObjectUtil.isEmpty(respDto)) {
                vo2.setErrorMsg("\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            if (i > 1) {
                vo2.setErrorMsg("\u627e\u4e0d\u5230\u552f\u4e00\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            vo2.setId(respDto.getId());
            vo2.setImportUpdatePerson(this.context.userName());
            vo2.setImportUpdateTime(new Date());
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        log.info("\u5206\u62e3\u8d39\u7528\u5355\u636e\u5bfc\u5165executeImportFileOperationCommon\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        List list = (List)obj;
        for (ImportSortingExpenseOrderReportVO vo : list) {
            SortingExpenseReqDto reqDto;
            if (StringUtils.isNotBlank((CharSequence)vo.getErrorMsg())) continue;
            if (vo.getImportType().equals("\u8986\u76d6")) {
                try {
                    reqDto = new SortingExpenseReqDto();
                    reqDto.setId(vo.getId());
                    reqDto.setOutWarehouseTime(vo.getOutWarehouseTime());
                    reqDto.setConsignmentNo(vo.getWmsConsignmentNo());
                    reqDto.setWmsMergeDocumentNo(vo.getWmsMergeDocumentNo());
                    reqDto.setWmsOrderNo(vo.getWmsDocumentNo());
                    reqDto.setDocumentNo(vo.getDocumentNo());
                    reqDto.setOutDocumentNo(vo.getOutDocumentNo());
                    reqDto.setRelevanceNo(vo.getRelevanceNo());
                    reqDto.setBusinessType(vo.getBusinessType());
                    reqDto.setOutPhysicsWarehouseCode(vo.getOutPhysicsWarehouseCode());
                    reqDto.setOutPhysicsWarehouseName(vo.getOutPhysicsWarehouseName());
                    reqDto.setOutLogicWarehouseCode(vo.getOutWarehouseCode());
                    reqDto.setOutLogicWarehouseName(vo.getOutWarehouse());
                    reqDto.setInLogicWarehouseCode(vo.getInWarehouseCode());
                    reqDto.setInLogicWarehouseName(vo.getInWarehouse());
                    reqDto.setExpenseOrganizationId(vo.getCostAttributionCode());
                    reqDto.setExpenseOrganizationName(vo.getCostAttribution());
                    reqDto.setLongCode(vo.getGoodsLongCode());
                    reqDto.setCargoName(vo.getGoodsName());
                    reqDto.setDoneQuantity(vo.getOutQuantity());
                    reqDto.setBigRatio(vo.getPackageNum());
                    reqDto.setSmallBoxNum(vo.getSmallPackageNum());
                    reqDto.setBigBoxNum(vo.getLargeBox());
                    reqDto.setSmallRatio(vo.getSmallBox());
                    reqDto.setBoxNum(vo.getNumber());
                    if (StringUtils.isNotBlank((CharSequence)vo.getAdjustTypeStr())) {
                        reqDto.setAdjustType(Long.valueOf(vo.getAdjustTypeStr().equals("\u589e\u52a0") ? 1L : 2L));
                    }
                    reqDto.setAdjustNum(vo.getPlatformAdjustAmount());
                    reqDto.setAdjustRemarks(vo.getRemark());
                    reqDto.setSortingNum(vo.getTotalSortingFee());
                    reqDto.setCustomerName(vo.getCustomerName());
                    reqDto.setEndProvince(vo.getEndProvince());
                    reqDto.setEndProvinceCode(null);
                    reqDto.setPlacedFlag(Integer.valueOf(0));
                    reqDto.setBillingFeeFlag(Integer.valueOf(1));
                    reqDto.setAbnormal(Integer.valueOf(0));
                    reqDto.setImportUpdatePerson(vo.getImportUpdatePerson());
                    reqDto.setImportUpdateTime(vo.getImportUpdateTime());
                    RestResponseHelper.extractData((RestResponse)this.sortingExpenseQueryApi.editByImport(reqDto));
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)((Object)vo)), (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    vo.setErrorMsg("\u66f4\u65b0\u5f02\u5e38" + e.getMessage());
                }
                continue;
            }
            try {
                reqDto = (SortingExpenseReqDto)BeanUtil.copyProperties((Object)((Object)vo), SortingExpenseReqDto.class, (String[])new String[0]);
                reqDto.setOutWarehouseTime(vo.getOutWarehouseTime());
                reqDto.setConsignmentNo(vo.getWmsConsignmentNo());
                reqDto.setWmsMergeDocumentNo(vo.getWmsMergeDocumentNo());
                reqDto.setWmsOrderNo(vo.getWmsDocumentNo());
                reqDto.setDocumentNo(vo.getDocumentNo());
                reqDto.setOutDocumentNo(vo.getOutDocumentNo());
                reqDto.setRelevanceNo(vo.getRelevanceNo());
                reqDto.setBusinessType(vo.getBusinessType());
                reqDto.setOutPhysicsWarehouseCode(vo.getOutPhysicsWarehouseCode());
                reqDto.setOutPhysicsWarehouseName(vo.getOutPhysicsWarehouseName());
                reqDto.setOutLogicWarehouseCode(vo.getOutWarehouseCode());
                reqDto.setOutLogicWarehouseName(vo.getOutWarehouse());
                reqDto.setInLogicWarehouseCode(vo.getInWarehouseCode());
                reqDto.setInLogicWarehouseName(vo.getInWarehouse());
                reqDto.setExpenseOrganizationId(vo.getCostAttributionCode());
                reqDto.setExpenseOrganizationName(vo.getCostAttribution());
                reqDto.setLongCode(vo.getGoodsLongCode());
                reqDto.setCargoName(vo.getGoodsName());
                reqDto.setDoneQuantity(vo.getOutQuantity());
                reqDto.setBigRatio(vo.getPackageNum());
                reqDto.setSmallBoxNum(vo.getSmallPackageNum());
                reqDto.setBigBoxNum(vo.getLargeBox());
                reqDto.setSmallRatio(vo.getSmallBox());
                reqDto.setBoxNum(vo.getNumber());
                if (StringUtils.isNotBlank((CharSequence)vo.getAdjustTypeStr())) {
                    reqDto.setAdjustType(Long.valueOf(vo.getAdjustTypeStr().equals("\u589e\u52a0") ? 1L : 2L));
                }
                reqDto.setAdjustNum(vo.getPlatformAdjustAmount());
                reqDto.setAdjustRemarks(vo.getRemark());
                reqDto.setSortingNum(vo.getTotalSortingFee());
                reqDto.setCustomerName(vo.getCustomerName());
                reqDto.setEndProvince(vo.getEndProvince());
                reqDto.setEndProvinceCode(null);
                reqDto.setPlacedFlag(Integer.valueOf(0));
                reqDto.setBillingFeeFlag(Integer.valueOf(1));
                reqDto.setAbnormal(Integer.valueOf(0));
                RestResponseHelper.extractData((RestResponse)this.sortingExpenseQueryApi.addByImport((List)Lists.newArrayList((Object[])new SortingExpenseReqDto[]{reqDto})));
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)((Object)vo)), (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                vo.setErrorMsg("\u65b0\u589e\u5f02\u5e38" + e.getMessage());
            }
        }
        String errorMsgUrl = null;
        List errorList = list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorList)) {
            log.info("\u5206\u62e3\u8d39\u7528\u5355\u636e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString(errorList));
            String excelName = String.format("%s%s", "\u5206\u62e3\u8d39\u7528\u5355\u636e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, ImportSortingExpenseOrderReportVO.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

