/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.enums.ImportExportStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportFileSourceVO;
import com.dtyunxi.cis.pms.biz.model.ExportItemVO;
import com.dtyunxi.cis.pms.biz.model.ExportListParams;
import com.dtyunxi.cis.pms.biz.model.GetExportListPageParams;
import com.dtyunxi.cis.pms.biz.model.PlaceExportListParams;
import com.dtyunxi.cis.pms.biz.service.ExportCenterExportListService;
import com.dtyunxi.cis.pms.biz.service.IBdImportExportTaskService;
import com.dtyunxi.cis.pms.biz.service.operation.FileOperationCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.CodeGenerateUtil;
import com.dtyunxi.cis.pms.dao.das.BdImportExportTaskDas;
import com.dtyunxi.cis.pms.dao.eo.BdImportExportTaskEo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.api.entity.IFilePlaceRecordApi;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.entity.FilePlaceRecordDto;
import com.yunxi.dg.base.center.report.dto.entity.FilePlaceRecordPageReqDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class ExportCenterExportListServiceServiceImpl
implements ExportCenterExportListService {
    private static final Logger logger = LoggerFactory.getLogger(ExportCenterExportListServiceServiceImpl.class);
    @Resource
    private IBdImportExportTaskService bdImportExportTaskService;
    @Resource
    private BdImportExportTaskDas bdImportExportTaskDas;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private FileOperationCommonService fileOperationCommonService;
    @Resource
    private IFilePlaceRecordApi filePlaceRecordApi;

    @Override
    public RestResponse<Object> exportList(@ApiParam(value="") @Valid @RequestBody(required=false) ExportListParams exportListParams) {
        logger.info("\u5bfc\u51fa\u5165\u53c2=\u300b{}", (Object)JSON.toJSONString((Object)exportListParams));
        if (exportListParams == null || StringUtils.isBlank((CharSequence)exportListParams.getKey())) {
            throw new BizException("\u5bfc\u51fakey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer page = 1;
        Integer pageSize = 50000;
        Integer fileTotal = this.getFileTotal(exportListParams, pageSize);
        if (Objects.equals(fileTotal, 0)) {
            throw new BizException("\u5bfc\u51fa\u6570\u636e\u4e3a\u7a7a");
        }
        String taskCode = this.codeGenerateUtil.generateNo("EX", 4);
        for (int i = 0; i < fileTotal; ++i) {
            this.saveTaskAndSendMessage(this.assembleBdImportExportTaskEo(i, exportListParams, taskCode));
        }
        return new RestResponse((Object)taskCode);
    }

    @Override
    public RestResponse<Object> placeExportList(@ApiParam(value="") @Valid @RequestBody(required=true) PlaceExportListParams placeExportListParams) {
        logger.info("\u5f52\u6863\u5bfc\u51fa\u64cd\u4f5c\uff1a{}", (Object)JSON.toJSONString((Object)placeExportListParams));
        if (StringUtils.isBlank((CharSequence)placeExportListParams.getPlaceModuleCode())) {
            throw new BizException("\u5f52\u6863\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (placeExportListParams.getExportListParams() == null || StringUtils.isBlank((CharSequence)placeExportListParams.getExportListParams().getKey())) {
            throw new BizException("\u5bfc\u51fakey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer page = 1;
        Integer pageSize = 50000;
        Integer fileTotal = this.getFileTotal(placeExportListParams.getExportListParams(), pageSize);
        if (Objects.equals(fileTotal, 0)) {
            throw new BizException("\u5bfc\u51fa\u6570\u636e\u4e3a\u7a7a");
        }
        String taskCode = this.codeGenerateUtil.generateNo("GD", 6);
        String params = placeExportListParams.getExportListParams().getParams();
        if (StringUtils.isBlank((CharSequence)params)) {
            throw new BizException("\u5bfc\u51fa\u7684\u5f52\u6863\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject jsonObject = JSON.parseObject((String)params);
        String placedFlagDate = (String)jsonObject.get((Object)"placedFlagDate");
        AssertUtil.isFalse(StringUtils.isBlank((CharSequence)placedFlagDate), "\u5f52\u6863\u8d39\u7528\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        FilePlaceRecordPageReqDto logicDel = new FilePlaceRecordPageReqDto();
        logicDel.setPlaceCostMonth(placedFlagDate);
        logicDel.setPlaceModuleCode(placeExportListParams.getPlaceModuleCode());
        logger.info("\u5220\u9664\u540c\u6a21\u5757\u540c\u5f52\u6863\u8d39\u7528\u5e74\u6708\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)logicDel));
        RestResponseHelper.extractData((RestResponse)this.filePlaceRecordApi.logicDeleteHistory(logicDel));
        for (int i = 0; i < fileTotal; ++i) {
            this.saveTaskAndSendMessage(this.assemblePlaceExportTaskEo(i, placeExportListParams, taskCode, placedFlagDate));
        }
        return new RestResponse((Object)taskCode);
    }

    @Override
    public RestResponse<Object> placeExportCallBack(String taskCode, Integer status, List<Long> placeIdList) {
        return null;
    }

    @Override
    public RestResponse<Object> exportListSync(@ApiParam(value="") @Valid @RequestBody(required=false) ExportListParams exportListParams) {
        logger.info("\u5bfc\u51fa\u5165\u53c2=\u300b{}", (Object)JSON.toJSONString((Object)exportListParams));
        if (exportListParams == null || StringUtils.isBlank((CharSequence)exportListParams.getKey())) {
            throw new BizException("\u5bfc\u51fakey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer page = 1;
        Integer pageSize = 50000;
        Integer fileTotal = this.getFileTotal(exportListParams, pageSize);
        if (Objects.equals(fileTotal, 0)) {
            throw new BizException("\u5bfc\u51fa\u6570\u636e\u4e3a\u7a7a");
        }
        String taskCode = this.codeGenerateUtil.generateNo("EX", 4);
        for (int i = 0; i < fileTotal; ++i) {
            BdImportExportTaskEo importExportTaskEo = this.assembleBdImportExportTaskEo(i, exportListParams, taskCode);
            this.bdImportExportTaskDas.insert((BaseEo)importExportTaskEo);
            String reqId = ServiceContext.getContext().getRequestId();
            Map objs = ServiceContext.getContext().getAttachments();
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            CompletableFuture.runAsync(() -> {
                try {
                    MDC.put((String)"yes.req.requestId", (String)reqId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                    ServiceContext.getContext().setAttachment("reqId", reqId);
                    if (objs != null) {
                        ServiceContext serviceContext = ServiceContext.getContext();
                        objs.forEach((arg_0, arg_1) -> ((ServiceContext)serviceContext).setAttachment(arg_0, arg_1));
                    }
                    this.fileOperationCommonService.exportFileOperationCommon(importExportTaskEo.getId());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    RequestContextHolder.resetRequestAttributes();
                    ServiceContext.getContext().remove("reqId");
                    MDC.remove((String)"yes.req.requestId");
                    ServiceContext.getContext().removeAttachment("yes.req.requestId");
                    ServiceContext.getContext().removeAttachmentContext();
                }
            });
        }
        return new RestResponse((Object)taskCode);
    }

    @Override
    public RestResponse<PageInfo<ExportItemVO>> getExportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetExportListPageParams getExportListPageParams) {
        return new RestResponse(this.bdImportExportTaskService.queryByPage(getExportListPageParams));
    }

    @Override
    public RestResponse<List<ExportFileSourceVO>> getExportFileSourceEnum() {
        ModeTypeEnum[] values;
        ArrayList list = Lists.newArrayList();
        for (ModeTypeEnum anEnum : values = ModeTypeEnum.values()) {
            ExportFileSourceVO vo = new ExportFileSourceVO();
            if (!StringUtils.isNotBlank((CharSequence)anEnum.getModeTypeCode())) continue;
            vo.setFileSource(anEnum.getModeTypeCode());
            vo.setFileSourceName(anEnum.getName());
            list.add(vo);
        }
        return new RestResponse((Object)list);
    }

    private BdImportExportTaskEo assembleBdImportExportTaskEo(int i, ExportListParams exportListParams, String taskCode) {
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(exportListParams.getKey());
        JSONObject pageParam = new JSONObject();
        pageParam.put("pageNum", (Object)(i + 1));
        String fileName = null;
        if (i > 0) {
            fileName = String.format("%s-%s-%s", anEnum.getName(), taskCode, i);
            pageParam.put("pageSize", (Object)(exportListParams.getPageSize() - i * 50000));
        } else {
            fileName = String.format("%s-%s", anEnum.getName(), taskCode);
            pageParam.put("pageSize", (Object)(exportListParams.getPageSize() == 0 ? 1 : exportListParams.getPageSize()));
        }
        BdImportExportTaskEo taskEo = new BdImportExportTaskEo();
        taskEo.setModule(anEnum.getName());
        taskEo.setModuleKey(anEnum.getKey());
        taskEo.setFileName(fileName);
        taskEo.setType(Integer.valueOf(2));
        taskEo.setSource(anEnum.getModeTypeCode());
        taskEo.setStatus(ImportExportStatusEnum.CONDUCT.getCode());
        taskEo.setTaskCode(taskCode);
        taskEo.setParam(exportListParams.getParams());
        pageParam.putAll(ServiceContext.getContext().getAttachments());
        taskEo.setExtension(pageParam.toJSONString());
        return taskEo;
    }

    private BdImportExportTaskEo assemblePlaceExportTaskEo(int i, PlaceExportListParams placeExportListParams, String taskCode, String placedFlagDate) {
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(placeExportListParams.getExportListParams().getKey());
        JSONObject pageParam = new JSONObject();
        pageParam.put("pageNum", (Object)(i + 1));
        String fileName = this.placeExportFileName(i, placeExportListParams, placedFlagDate);
        if (i > 0) {
            pageParam.put("pageSize", (Object)(placeExportListParams.getExportListParams().getPageSize() - i * 50000));
        } else {
            pageParam.put("pageSize", (Object)(placeExportListParams.getExportListParams().getPageSize() == 0 ? 1 : placeExportListParams.getExportListParams().getPageSize()));
        }
        BdImportExportTaskEo taskEo = new BdImportExportTaskEo();
        taskEo.setModule(anEnum.getName());
        taskEo.setModuleKey(anEnum.getKey());
        taskEo.setFileName(fileName);
        taskEo.setType(Integer.valueOf(2));
        taskEo.setSource(anEnum.getModeTypeCode());
        taskEo.setStatus(ImportExportStatusEnum.CONDUCT.getCode());
        taskEo.setTaskCode(taskCode);
        taskEo.setParam(JSON.toJSONString((Object)placeExportListParams.getExportListParams()));
        pageParam.putAll(ServiceContext.getContext().getAttachments());
        taskEo.setExtension(pageParam.toJSONString());
        FilePlaceRecordDto filePlaceRecordDto = new FilePlaceRecordDto();
        filePlaceRecordDto.setPlaceModuleCode(placeExportListParams.getPlaceModuleCode());
        filePlaceRecordDto.setPlaceCostMonth(placedFlagDate);
        filePlaceRecordDto.setPlaceLinkFileTaskCode(taskCode);
        filePlaceRecordDto.setPlaceTaskCode(this.codeGenerateUtil.generateNo("GD", 6));
        filePlaceRecordDto.setStatus(Integer.valueOf(0));
        filePlaceRecordDto.setPlaceFileName(fileName);
        filePlaceRecordDto.setPlaceDataCount(new BigDecimal(placeExportListParams.getExportListParams().getPageSize()));
        filePlaceRecordDto.setRemark(placeExportListParams.getExportListParams().getPlacedFlagRemark());
        logger.info("\u4fdd\u5b58\u5f52\u6863\u4efb\u52a1\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)filePlaceRecordDto));
        this.filePlaceRecordApi.insert(filePlaceRecordDto);
        return taskEo;
    }

    private String placeExportFileName(int i, PlaceExportListParams placeExportListParams, String placedFlagDate) {
        String moduleName = DailyDeliveryFeeModuleEnum.getDescByCode((String)placeExportListParams.getPlaceModuleCode());
        String[] split = placedFlagDate.toString().split("-");
        if (i > 0) {
            return String.format("%s%s\u5e74%s\u6708\u5f52\u6863-%s", moduleName, split[0], split[1], i + 1);
        }
        return String.format("%s%s\u5e74%s\u6708\u5f52\u6863", moduleName, split[0], split[1]);
    }

    @Transactional(rollbackFor={Exception.class})
    private void saveTaskAndSendMessage(BdImportExportTaskEo taskEo) {
        this.bdImportExportTaskDas.insert((BaseEo)taskEo);
        logger.info("\u5bfc\u51fa\u5f00\u59cb\u53d1\u9001MQ\uff1a{}", (Object)JSON.toJSONString((Object)taskEo));
        this.commonsMqService.sendSingleMessage("EXPORT_TAG", (Object)taskEo.getId().toString());
        logger.info("\u5bfc\u51fa\u53d1\u9001MQ\u6210\u529f");
    }

    private Integer getFileTotal(ExportListParams exportListParams, Integer pageSize) {
        ExportFileOperationCommonReqDto commonReqDto = new ExportFileOperationCommonReqDto();
        commonReqDto.setFilter(exportListParams.getParams());
        commonReqDto.setKey(exportListParams.getKey());
        Integer totalCount = (Integer)RestResponseHelper.extractData(this.fileOperationCommonService.exportTotal(commonReqDto));
        exportListParams.setPageSize(totalCount);
        Integer pages = 0;
        logger.info("totalCount:{}", (Object)totalCount);
        logger.info("pageSize:{}", (Object)pageSize);
        pages = totalCount <= pageSize ? Integer.valueOf(1) : (totalCount % pageSize > 0 ? Integer.valueOf(totalCount / pageSize + 1) : Integer.valueOf(totalCount / pageSize));
        return pages;
    }
}

