/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.express.ExpressCostOtherFeeImportDto;
import com.dtyunxi.cis.pms.biz.service.ExpressCostOtherFeeService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IExpressCostDetailApi;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDetailRespDto;
import com.dtyunxi.tcbj.api.query.IExpressCostDetailQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_express_cost_report_other")
public class ExpressCostOtherFeeServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExpressCostOtherFeeService {
    private static final Logger logger = LoggerFactory.getLogger(ExpressCostOtherFeeServiceImpl.class);
    @Resource
    private IExpressCostDetailQueryApi expressCostDetailQueryApi;
    @Resource
    private IExpressCostDetailApi expressCostDetailApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ExpressCostOtherFeeImportDto.class);
        logger.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\u5bfc\u5165\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)list));
        Map<String, List<ExpressCostOtherFeeImportDto>> groupByList = list.stream().collect(Collectors.groupingBy(ExpressCostOtherFeeImportDto::getOutboundCode));
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.expressCostDetailQueryApi.queryListByOrders(list.stream().map(ExpressCostOtherFeeImportDto::getOutboundCode).collect(Collectors.toList())));
        Map<Object, Object> map = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)respDtos)) {
            map = respDtos.stream().collect(Collectors.toMap(ExpressCostDetailRespDto::getOutboundCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        for (ExpressCostOtherFeeImportDto dto : list) {
            List<ExpressCostOtherFeeImportDto> importDtoList = groupByList.get(dto.getOutboundCode());
            if (CollectionUtil.isNotEmpty(importDtoList) && importDtoList.size() > 1) {
                this.setMsg(dto, "\u6570\u636e\u91cd\u590d");
                msgList.add(dto);
                continue;
            }
            ExpressCostDetailRespDto detailRespDto = (ExpressCostDetailRespDto)map.get(dto.getOutboundCode());
            if (ObjectUtils.isEmpty((Object)detailRespDto)) {
                this.setMsg(dto, "\u8be5\u51fa\u5e93\u7ed3\u679c\u5355\u4e0d\u5b58\u5728");
                msgList.add(dto);
                continue;
            }
            ExpressCostDetailReqDto reqDto = new ExpressCostDetailReqDto();
            reqDto.setOutboundCode(dto.getOutboundCode());
            reqDto.setExpressNo(dto.getExpressNo());
            if (ObjectUtils.isNotEmpty((Object)dto.getExpressWeight())) {
                reqDto.setExpressWeight(new BigDecimal(dto.getExpressWeight()).setScale(5, RoundingMode.HALF_UP));
            }
            if (ObjectUtils.isNotEmpty((Object)dto.getReturnFee())) {
                reqDto.setReturnFee(new BigDecimal(dto.getReturnFee()));
            }
            if (ObjectUtils.isNotEmpty((Object)dto.getIncrementFreight())) {
                reqDto.setIncrementFreight(new BigDecimal(dto.getIncrementFreight()));
            }
            reqDto.setAdjustmentType(dto.getAdjustmentType());
            if (ObjectUtils.isNotEmpty((Object)dto.getAdjustmentAmount())) {
                reqDto.setAdjustmentAmount(new BigDecimal(dto.getAdjustmentAmount()));
            }
            reqDto.setRemark(dto.getRemarks());
            saveList.add(reqDto);
        }
        HashMap returnMap = Maps.newHashMap();
        returnMap.put("saveList", saveList);
        returnMap.put("msgList", msgList);
        return returnMap;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        logger.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\u5bfc\u5165\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.expressCostDetailApi.importBatchUpdate(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5feb\u9012\u8d39\u5bfc\u5165\u5176\u4ed6\u8d39\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ExpressCostOtherFeeImportDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    public void setMsg(ExpressCostOtherFeeImportDto msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
            msgDto.setMsg(errorMsg);
        } else {
            msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), errorMsg));
        }
    }
}

