/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.CommonCreateVO;
import com.dtyunxi.cis.pms.biz.model.DeliverWarehouseThresholdVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetSystemSettingDeliverWarehouseThresholdParams;
import com.dtyunxi.cis.pms.biz.model.OutDeliverWarehouseThresholdVO;
import com.dtyunxi.cis.pms.biz.service.SystemSettingDeliverWarehouseThresholdService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cube.center.source.api.IWarehouseDeliveryThresholdApi;
import com.dtyunxi.cube.center.source.api.dto.request.WarehouseDeliveryThresholdReqDto;
import com.dtyunxi.cube.center.source.api.query.IWarehouseDeliveryThresholdQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_deliver_warehouse_threshold")
public class SystemSettingDeliverWarehouseThresholdServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements SystemSettingDeliverWarehouseThresholdService {
    @Resource
    private IWarehouseDeliveryThresholdApi warehouseDeliveryThresholdApi;
    @Resource
    private IWarehouseDeliveryThresholdQueryApi warehouseDeliveryThresholdQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedApi;

    @Override
    public RestResponse<CommonCreateVO> addSystemSettingDeliverWarehouseThreshold(@ApiParam(value="") @Valid @RequestBody(required=false) DeliverWarehouseThresholdVO addReqDto) {
        if (addReqDto == null || StringUtils.isBlank((CharSequence)addReqDto.getWarehouseCode()) || addReqDto.getThreshold() == null) {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u548c\u9608\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addReqDto.getThreshold() < 0L) {
            throw new BizException("\u9608\u503c\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        CsPhysicsWarehouseParamQueryDto queryDto = new CsPhysicsWarehouseParamQueryDto();
        queryDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{addReqDto.getWarehouseCode()}));
        List whList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryParam(queryDto));
        if (CollectionUtils.isEmpty((Collection)whList)) {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u4e0d\u6b63\u786e");
        }
        WarehouseDeliveryThresholdReqDto reqDto = new WarehouseDeliveryThresholdReqDto();
        reqDto.setPhysicsWarehouseCode(addReqDto.getWarehouseCode());
        reqDto.setThreshold(BigDecimal.valueOf(addReqDto.getThreshold()));
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.warehouseDeliveryThresholdApi.addWarehouseDeliveryThreshold(reqDto));
        CommonCreateVO vo = new CommonCreateVO();
        vo.setId(id);
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<Object> deleteSystemSettingDeliverWarehouseThreshold(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        RestResponseHelper.extractData((RestResponse)this.warehouseDeliveryThresholdApi.removeWarehouseDeliveryThreshold(id));
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<DeliverWarehouseThresholdVO>> getSystemSettingDeliverWarehouseThreshold(@ApiParam(value="") @Valid @RequestBody(required=false) GetSystemSettingDeliverWarehouseThresholdParams getSystemSettingDeliverWarehouseThresholdParams) {
        PageInfo respDtoPageInfo;
        PageInfo pageInfo = new PageInfo();
        WarehouseDeliveryThresholdReqDto reqDto = new WarehouseDeliveryThresholdReqDto();
        reqDto.setPhysicsWarehouseCode(getSystemSettingDeliverWarehouseThresholdParams.getWarehouseCode());
        if (StringUtils.isNotBlank((CharSequence)getSystemSettingDeliverWarehouseThresholdParams.getWarehouseName())) {
            CsPhysicsWarehousePageQueryDto pageQueryDto = new CsPhysicsWarehousePageQueryDto();
            pageQueryDto.setWarehouseName(getSystemSettingDeliverWarehouseThresholdParams.getWarehouseName());
            pageQueryDto.setPageNum(Integer.valueOf(1));
            pageQueryDto.setPageSize(Integer.valueOf(1000));
            PageInfo physicsWarehousePageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryPageInfo(pageQueryDto));
            if (CollectionUtils.isEmpty((Collection)physicsWarehousePageRespDtoPageInfo.getList())) {
                return new RestResponse((Object)pageInfo);
            }
            List physicsWarehouseCodes = physicsWarehousePageRespDtoPageInfo.getList().stream().map(CsPhysicsWarehousePageRespDto::getWarehouseCode).collect(Collectors.toList());
            reqDto.setPhysicsWarehouseCodes(physicsWarehouseCodes);
        }
        if (CollectionUtils.isEmpty((Collection)(respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseDeliveryThresholdQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), getSystemSettingDeliverWarehouseThresholdParams.getPageNum(), getSystemSettingDeliverWarehouseThresholdParams.getPageSize()))).getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        HashSet whCodes = Sets.newHashSet();
        respDtoPageInfo.getList().forEach(i -> whCodes.add(i.getPhysicsWarehouseCode()));
        CsPhysicsWarehouseParamQueryDto dto = new CsPhysicsWarehouseParamQueryDto();
        dto.setWarehouseCodeList(new ArrayList(whCodes));
        List whList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryParam(dto));
        Map whMap = null;
        if (CollectionUtils.isNotEmpty((Collection)whList)) {
            whMap = whList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        Map finalWhMap = whMap;
        List list = respDtoPageInfo.getList().stream().map(respDto -> {
            DeliverWarehouseThresholdVO vo = new DeliverWarehouseThresholdVO();
            BeanUtils.copyProperties((Object)respDto, (Object)vo);
            vo.setWarehouseCode(respDto.getPhysicsWarehouseCode());
            if (finalWhMap != null && finalWhMap.containsKey(respDto.getPhysicsWarehouseCode())) {
                vo.setWarehouseName(((CsPhysicsWarehousePageRespDto)finalWhMap.get(respDto.getPhysicsWarehouseCode())).getWarehouseName());
            }
            vo.setThreshold(respDto.getThreshold() != null ? Long.valueOf(respDto.getThreshold().setScale(0, 1).toString()) : 0L);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetSystemSettingDeliverWarehouseThresholdParams params = new GetSystemSettingDeliverWarehouseThresholdParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSystemSettingDeliverWarehouseThresholdParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSystemSettingDeliverWarehouseThresholdParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getSystemSettingDeliverWarehouseThreshold((GetSystemSettingDeliverWarehouseThresholdParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutDeliverWarehouseThresholdVO vo = new OutDeliverWarehouseThresholdVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutDeliverWarehouseThresholdVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetSystemSettingDeliverWarehouseThresholdParams params = new GetSystemSettingDeliverWarehouseThresholdParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSystemSettingDeliverWarehouseThresholdParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSystemSettingDeliverWarehouseThresholdParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getSystemSettingDeliverWarehouseThreshold(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> updateSystemSettingDeliverWarehouseThreshold(@ApiParam(value="") @Valid @RequestBody(required=false) DeliverWarehouseThresholdVO addReqDto) {
        if (addReqDto.getId() == null || addReqDto.getId() <= 0L) {
            throw new BizException("\u7f16\u8f91id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addReqDto == null || StringUtils.isBlank((CharSequence)addReqDto.getWarehouseCode()) || addReqDto.getThreshold() == null) {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u548c\u9608\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addReqDto.getThreshold() < 0L) {
            throw new BizException("\u9608\u503c\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        CsPhysicsWarehouseParamQueryDto queryDto = new CsPhysicsWarehouseParamQueryDto();
        queryDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{addReqDto.getWarehouseCode()}));
        List whList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryParam(queryDto));
        if (CollectionUtils.isEmpty((Collection)whList)) {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u4e0d\u6b63\u786e");
        }
        WarehouseDeliveryThresholdReqDto reqDto = new WarehouseDeliveryThresholdReqDto();
        reqDto.setPhysicsWarehouseCode(addReqDto.getWarehouseCode());
        reqDto.setThreshold(BigDecimal.valueOf(addReqDto.getThreshold()));
        reqDto.setId(addReqDto.getId());
        RestResponseHelper.extractData((RestResponse)this.warehouseDeliveryThresholdApi.modifyWarehouseDeliveryThreshold(reqDto));
        return new RestResponse();
    }
}

