/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetLogicalChangeFlowListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutLogicalChangeFlowVO;
import com.dtyunxi.cis.pms.biz.service.ExportChannelFlowService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterFlowService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_logical_flow")
public class ExportLogicalFlowServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportChannelFlowService {
    @Resource
    private InventoryCenterFlowService inventoryCenterFlowService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetLogicalChangeFlowListPageParams params = new GetLogicalChangeFlowListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetLogicalChangeFlowListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetLogicalChangeFlowListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.inventoryCenterFlowService.getLogicalFlowListPage((GetLogicalChangeFlowListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutLogicalChangeFlowVO vo = new OutLogicalChangeFlowVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBusinessType(Optional.ofNullable(o.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    if (ObjectUtils.isNotEmpty((Object)CsInventorySourceTypeEnum.getByCode((String)o.getBusinessType()))) {
                        return String.valueOf(CsInventorySourceTypeEnum.getByCode((String)o.getBusinessType()).getDesc());
                    }
                    if (ObjectUtils.isNotEmpty((Object)ExpressBusinessTypeEnum.getNameByType(o.getBusinessType()))) {
                        return String.valueOf(ExpressBusinessTypeEnum.getNameByType(o.getBusinessType()));
                    }
                    return o.getBusinessType();
                }).orElse(""));
                vo.setInventoryType(Optional.ofNullable(o.getInventoryType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    switch (Type2) {
                        case "available": {
                            return "\u53ef\u7528\u5e93\u5b58";
                        }
                        case "balance": {
                            return "\u5373\u65f6\u5e93\u5b58";
                        }
                        case "preempt": {
                            return "\u9884\u5360\u5e93\u5b58";
                        }
                        case "moveInventory": {
                            return "\u5728\u9014\u5e93\u5b58";
                        }
                        case "received": {
                            return "\u5f85\u6536\u5e93\u5b58";
                        }
                        case "allocate": {
                            return "\u9500\u552e\u5e93\u5b58";
                        }
                        case "future_in": {
                            return "\u5f85\u6536\u5e93\u5b58";
                        }
                        case "intransit": {
                            return "\u5728\u9014\u5e93\u5b58";
                        }
                        case "lock_inventory": {
                            return "\u9501\u5b9a\u5e93\u5b58";
                        }
                    }
                    return o.getInventoryType();
                }).orElse(""));
                vo.setChangeQuantity(Optional.ofNullable(o.getChangeQuantity()).orElse(BigDecimal.ZERO).intValue());
                vo.setAfterChangeIInventory(Optional.ofNullable(o.getAfterChangeIInventory()).orElse(BigDecimal.ZERO).intValue());
                vo.setBeforeChangeInventory(Optional.ofNullable(o.getBeforeChangeInventory()).orElse(BigDecimal.ZERO).intValue());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutLogicalChangeFlowVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }
}

