/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.GetChannelWarehouseAssociatedListV2Params;
import com.dtyunxi.cis.pms.biz.model.GoodsVO;
import com.dtyunxi.cis.pms.biz.model.OrderChannelVO;
import com.dtyunxi.cis.pms.biz.model.SubmitChannelWarehouseAssociatedGoodsV2Params;
import com.dtyunxi.cis.pms.biz.model.SubmitChannelWarehouseAssociatedV2Params;
import com.dtyunxi.cis.pms.biz.model.VirtualWarehouseShareRatioVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseChannelWarehouseV2Service;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseItemApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IRelVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IRelWarehouseChannelApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseItemAddListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseItemAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelVirtualWarehouseBatchAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelWarehouseChannelAddListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelWarehouseChannelAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.WarehouseRelationReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.RelWarehouseChannelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.WarehouseRelationRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPcpOrderChannelQueryApi;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InventoryCenterBaseWarehouseChannelWarehouseV2ServiceServiceImpl
implements InventoryCenterBaseWarehouseChannelWarehouseV2Service {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterBaseWarehouseChannelWarehouseV2ServiceServiceImpl.class);
    @Resource
    private IChannelWarehouseApi channelWarehouseApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Resource
    private IRelVirtualWarehouseApi relVirtualWarehouseQueryApi;
    @Resource
    private IRelVirtualWarehouseApi relVirtualWarehouseApi;
    @Resource
    private IChannelWarehouseItemApi channelWarehouseItemQueryApi;
    @Resource
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Resource
    private IRelWarehouseChannelApi relWarehouseChannelApi;
    @Resource
    private IChannelWarehouseItemApi channelWarehouseItemApi;
    @Resource
    private IPcpOrderChannelQueryApi pcpOrderChannelQueryApi;

    @Override
    public RestResponse<Void> addRelVirtualWarehouseBatch(RelVirtualWarehouseBatchAddReqDto addReqDto) {
        return this.relVirtualWarehouseApi.addRelVirtualWarehouseBatch(addReqDto);
    }

    @Override
    public RestResponse<Object> addChannelWarehouseAssociatedV2(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitChannelWarehouseAssociatedV2Params channelWarehouseAssociatedV2Params) {
        List<String> associatedList = channelWarehouseAssociatedV2Params.getAssociatedList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(associatedList), "\u5173\u8054\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
        Long channelWarehouseId = ParamConverter.convertToLong((Object)channelWarehouseAssociatedV2Params.getChannelWarehouseId());
        List list = associatedList.stream().map(o -> {
            RelWarehouseChannelAddReqDto relWarehouseChannelAddReqDto = new RelWarehouseChannelAddReqDto();
            relWarehouseChannelAddReqDto.setChannelCode(o);
            relWarehouseChannelAddReqDto.setShareRatio(new BigDecimal("100"));
            relWarehouseChannelAddReqDto.setWarehouseId(ParamConverter.convertToLong((Object)channelWarehouseAssociatedV2Params.getChannelWarehouseId()));
            return relWarehouseChannelAddReqDto;
        }).collect(Collectors.toList());
        RelWarehouseChannelAddListReqDto channelAddListReqDto = new RelWarehouseChannelAddListReqDto(channelWarehouseId, list);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.relWarehouseChannelApi.addRelWarehouseChannelList(channelAddListReqDto)));
    }

    @Override
    public RestResponse<Void> deleteChannelWarehouseAssociatedV2(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitChannelWarehouseAssociatedV2Params channelWarehouseAssociatedV2Params) {
        List<String> associatedList = channelWarehouseAssociatedV2Params.getAssociatedList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(associatedList), "\u5173\u8054ID\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.equals((CharSequence)"warehouse", (CharSequence)channelWarehouseAssociatedV2Params.getAssociatedType())) {
            RestResponseHelper.extractData((RestResponse)this.relVirtualWarehouseApi.removeRelVirtualWarehouse(StringUtils.join(associatedList, (String)","), channelWarehouseAssociatedV2Params.getChannelWarehouseId()));
        } else if (StringUtils.equals((CharSequence)"orderChannel", (CharSequence)channelWarehouseAssociatedV2Params.getAssociatedType())) {
            RestResponseHelper.extractData((RestResponse)this.relWarehouseChannelApi.removeRelWarehouseChannel(StringUtils.join(associatedList, (String)",")));
        } else {
            throw new CsInventoryException("\u5220\u9664\u7c7b\u578b\u4e0d\u5b58\u5728 \u6216\u8005 \u4e0d\u7b26\u5408\u5f53\u524d\u5b9a\u4e49\uff0c \u8bf7\u4f20\u503c[warehouse, orderChannel]", new Object[0]);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<PageInfo<OrderChannelVO>> getAssociatedOrderChannelListPageV2(@ApiParam(value="") @Valid @RequestBody(required=false) GetChannelWarehouseAssociatedListV2Params getChannelWarehouseAssociatedListV2Params) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)getChannelWarehouseAssociatedListV2Params.getChannelWarehouseId()), "\u6e20\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
        PageInfo channelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.relWarehouseChannelApi.queryByPage(ParamConverter.convertToLong((Object)getChannelWarehouseAssociatedListV2Params.getChannelWarehouseId()), getChannelWarehouseAssociatedListV2Params.getPageNum(), getChannelWarehouseAssociatedListV2Params.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        List dtoPageInfoList = channelRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)dtoPageInfoList)) {
            return new RestResponse((Object)pageInfo);
        }
        BeanUtils.copyProperties((Object)channelRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list"});
        List channelCodes = dtoPageInfoList.stream().map(RelWarehouseChannelRespDto::getChannelCode).distinct().collect(Collectors.toList());
        String queryOrderChannel = getChannelWarehouseAssociatedListV2Params.getQueryOrderChannel();
        PcpOrderChannelReqDto reqDto = new PcpOrderChannelReqDto();
        reqDto.setChannelCodes(channelCodes);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), Integer.valueOf(1), Integer.valueOf(100)));
        List pcpOrderChannnelList = respDtoPageInfo.getList();
        List list = dtoPageInfoList.stream().map(o -> {
            PcpOrderChannelRespDto channelRespDto;
            OrderChannelVO orderChannelVO = new OrderChannelVO();
            BeanUtils.copyProperties((Object)o, (Object)orderChannelVO);
            orderChannelVO.setOrderChannelId(ParamConverter.convertToString((Object)o.getId()));
            orderChannelVO.setOrderChannelCode(o.getChannelCode());
            orderChannelVO.setOrderChannelName(o.getChannelName());
            if (StringUtils.isNotBlank((CharSequence)o.getChannelCode()) && null != (channelRespDto = (PcpOrderChannelRespDto)pcpOrderChannnelList.stream().filter(channel -> StringUtils.equals((CharSequence)o.getChannelCode(), (CharSequence)channel.getChannelCode())).findFirst().orElse(null))) {
                orderChannelVO.setOrderChannelStatus(channelRespDto.getStatus());
                orderChannelVO.setOrderChannelName(channelRespDto.getChannelName());
            }
            orderChannelVO.setShareRatio(o.getShareRatio() != null ? o.getShareRatio().setScale(0, 1).toString() : null);
            return orderChannelVO;
        }).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)queryOrderChannel)) {
            list = list.stream().filter(o -> StringUtils.contains((CharSequence)o.getOrderChannelCode(), (CharSequence)queryOrderChannel) || StringUtils.contains((CharSequence)o.getOrderChannelName(), (CharSequence)queryOrderChannel)).collect(Collectors.toList());
        }
        pageInfo.setList(list);
        pageInfo.setTotal((long)list.size());
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<VirtualWarehouseShareRatioVO>> getAssociatedVirtualWarehouseListPageV2(@ApiParam(value="") @Valid @RequestBody(required=false) GetChannelWarehouseAssociatedListV2Params getChannelWarehouseAssociatedListV2Params) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)getChannelWarehouseAssociatedListV2Params.getChannelWarehouseId()), "\u865a\u4ed3id\u4e0d\u80fd\u4e3a\u7a7a");
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.relVirtualWarehouseQueryApi.queryByPage(ParamConverter.convertToLong((Object)getChannelWarehouseAssociatedListV2Params.getChannelWarehouseId()), getChannelWarehouseAssociatedListV2Params.getPageNum(), getChannelWarehouseAssociatedListV2Params.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            VirtualWarehouseShareRatioVO vo = new VirtualWarehouseShareRatioVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setWarehouseId(ParamConverter.convertToString((Object)o.getVirtualWarehouseId()));
            vo.setWarehouseName(o.getVirtualWarehouseName());
            vo.setWarehouseCode(o.getVirtualWarehouseCode());
            vo.setWarehouseStatus(o.getVirtualWarehouseStatus());
            vo.setShareRatio(o.getShareRatio() != null ? o.getShareRatio().setScale(0, 1) : null);
            vo.setApplicableGoodsType(ParamConverter.convertToString((Object)o.getRelItemType()));
            vo.setIsMainVirtualWarehouse(ParamConverter.convertToString((Object)o.getVirtualWarehouseType()));
            vo.setPriority(ParamConverter.convertToString((Object)o.getPriority()));
            List warehouseItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.channelWarehouseItemQueryApi.queryByList(ParamConverter.convertToLong((Object)o.getId())));
            if (CollectionUtils.isNotEmpty((Collection)warehouseItemRespDtos)) {
                List<GoodsVO> goodsVOS = warehouseItemRespDtos.stream().map(i -> {
                    GoodsVO goodsVO = new GoodsVO();
                    BeanUtils.copyProperties((Object)i, (Object)goodsVO);
                    goodsVO.setGoodsName(i.getItemName());
                    goodsVO.setGoodsCode(i.getItemCode());
                    goodsVO.setGoodsSku(i.getItemCode());
                    return goodsVO;
                }).collect(Collectors.toList());
                vo.setApplicableGoodsList(goodsVOS);
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> submitChannelWarehouseAssociatedGoodsV2(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitChannelWarehouseAssociatedGoodsV2Params submitChannelWarehouseAssociatedGoodsV2Params) {
        AssertUtil.isTrue(submitChannelWarehouseAssociatedGoodsV2Params.getId() != null, "id\u4e0d\u80fd\u4e3a\u7a7a");
        ChannelWarehouseItemAddListReqDto reqDto = new ChannelWarehouseItemAddListReqDto();
        reqDto.setRelItemType(ParamConverter.convertToInteger((Object)submitChannelWarehouseAssociatedGoodsV2Params.getApplicableGoodsType()));
        reqDto.setRelVirtualWarehouseId(submitChannelWarehouseAssociatedGoodsV2Params.getId());
        List<GoodsVO> goodsList = submitChannelWarehouseAssociatedGoodsV2Params.getApplicableGoodsList();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            List channelWarehouseItemAddReqDtos = goodsList.stream().map(o -> {
                ChannelWarehouseItemAddReqDto itemAddReqDto = new ChannelWarehouseItemAddReqDto();
                itemAddReqDto.setItemCode(o.getGoodsLongCode());
                return itemAddReqDto;
            }).collect(Collectors.toList());
            reqDto.setChannelWarehouseItemAddReqDtos(channelWarehouseItemAddReqDtos);
        }
        logger.info("\u7f16\u8f91\u5173\u8054\u865a\u4ed3\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)reqDto));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.channelWarehouseItemApi.addChannelWarehouseItem(reqDto)));
    }

    @Override
    public RestResponse<PageInfo<WarehouseRelationRespDto>> queryWarehouseRelation(WarehouseRelationReqDto queryDto) {
        return this.channelWarehouseApi.queryWarehouseRelation(queryDto);
    }
}

