/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cis.pms.biz.enums.PlatformOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.SaleOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BusinessOrderInfoVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.DeliveryResultOrderVO;
import com.dtyunxi.cis.pms.biz.model.GetDeliveryResultOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.RelateBillInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillDeliveryResultOrderService;
import com.dtyunxi.cis.search.api.dto.request.EsDeliveryResultOrderListPageParams;
import com.dtyunxi.cis.search.api.query.delivery.EsDeliveryResultOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.IDeliveryResultOrderQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterBillDeliveryResultOrderServiceServiceImpl
implements InventoryCenterBillDeliveryResultOrderService {
    @Resource
    IDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;
    @Resource
    private ICsDeliveryResultOrderQueryApi csDeliveryResultOrderQueryApi;
    @Resource
    private EsDeliveryResultOrderQueryApi esDeliveryResultOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private ICsLogisticsInfoQueryApi iCsLogisticsInfoQueryApi;

    @Override
    public RestResponse<DeliveryResultOrderVO> getDeliveryResultOrderDetail(@ApiParam(value="\u53d1\u8d27\u7ed3\u679c\u8ba2\u53f7") @Valid @RequestParam(value="deliveryResultNo", required=false) String deliveryResultNo) {
        CsDeliveryResultOrderRespDto respDto = (CsDeliveryResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryVersionSecondByDocumentNo(deliveryResultNo));
        DeliveryResultOrderVO vo = new DeliveryResultOrderVO();
        if (respDto != null) {
            List respDtos;
            BeanUtils.copyProperties((Object)respDto, (Object)vo);
            ContactDto contactDto = respDto.getContactDto();
            if (Objects.nonNull(contactDto)) {
                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                BeanUtils.copyProperties((Object)contactDto, (Object)businessOrderInfo);
                businessOrderInfo.setBunchCode(contactDto.getImeiCode());
                vo.setBusinessOrderInfo(businessOrderInfo);
            }
            if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCsLogisticsInfoQueryApi.queryTakeDeliveryResultInformation(deliveryResultNo))))) {
                List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                    DeliveryInfoVo documentVO = new DeliveryInfoVo();
                    BeanUtils.copyProperties((Object)o, (Object)documentVO);
                    if (o.getConsignmentType() != null) {
                        documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                    }
                    return documentVO;
                }).collect(Collectors.toList());
                vo.setDeliveryInfoList(list);
            }
            this.getRelateBillInfo(respDto, vo);
            if (respDto.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setDocumentStatus(respDto.getOrderStatus());
            vo.setDeliveryLogicalWarehouseCode(respDto.getWarehouseCode());
            vo.setDeliveryLogicalWarehouseName(respDto.getWarehouseName());
            vo.setDeliveryPhysicalWarehouseCode(respDto.getDeliveryPhysicsWarehouseCode());
            vo.setDeliveryPhysicalWarehouseName(respDto.getDeliveryPhysicsWarehouseName());
            vo.setReceiveLogicalWarehouseCode(respDto.getReceiveWarehouseCode());
            vo.setReceiveLogicalWarehouseName(respDto.getReceiveWarehouseName());
            vo.setReceivePhysicalWarehouseCode(respDto.getReceivePhysicsWarehouseCode());
            vo.setReceivePhysicalWarehouseName(respDto.getReceivePhysicsWarehouseName());
            vo.setSummary(respDto.getTotalQuantity() == null ? BigDecimal.ZERO : respDto.getTotalQuantity());
            vo.setTotalBoxesNum(respDto.getTotalCartons() == null ? BigDecimal.ZERO : respDto.getTotalCartons());
            vo.setMixBoxesNum(respDto.getMergeQuantity() == null ? BigDecimal.ZERO : respDto.getMergeQuantity());
            vo.setTotalSku(respDto.getSkuNum() == null ? BigDecimal.ZERO : respDto.getSkuNum());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)respDto.getBizDate()) ? DateUtil.format((Date)respDto.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        }
        return new RestResponse((Object)vo);
    }

    private void getRelateBillInfo(CsDeliveryResultOrderRespDto respDto, DeliveryResultOrderVO vo) {
        List relOrderInfoList = respDto.getRelOrderInfoList();
        if (CollectionUtils.isNotEmpty((Collection)relOrderInfoList)) {
            List<RelateBillInfoVO> list = relOrderInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                RelateBillInfoVO relateBillInfoVO = new RelateBillInfoVO();
                if (PlatformOrderTypeEnum.PLATFORM_ORDER_NO.getCode().equals(o.getOrderType())) {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setIsExternalOrder(true);
                } else if (SaleOrderTypeEnum.getStatusByCode(o.getOrderType()) != null) {
                    if (SaleOrderTypeEnum.ORDER_SALES_REFUND.getCode().equals(o.getOrderType())) {
                        BizSaleRefundRespDto bizSaleRefundRespDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(o.getOrderNo()));
                        if (bizSaleRefundRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(bizSaleRefundRespDto.getRefundStatus());
                            SaleRefundAddrRespDto saleRefundAddrRespDto = bizSaleRefundRespDto.getSaleRefundAddrRespDto();
                            if (saleRefundAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(saleRefundAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(saleRefundAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(saleRefundAddrRespDto.getProvince() + saleRefundAddrRespDto.getCity() + saleRefundAddrRespDto.getCounty() + saleRefundAddrRespDto.getReceiveAddress());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    } else {
                        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(o.getOrderNo()));
                        if (saleOrderRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(saleOrderRespDto.getOrderStatus());
                            SaleOrderAddrRespDto orderAddrRespDto = saleOrderRespDto.getOrderAddrRespDto();
                            if (orderAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(orderAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(orderAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(orderAddrRespDto.getProvince() + orderAddrRespDto.getCity() + orderAddrRespDto.getCounty() + orderAddrRespDto.getReceiveAddress());
                                businessOrderInfo.setRemark(saleOrderRespDto.getRemark());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setLogisticsCompany(o.getShippingCompany());
                    relateBillInfoVO.setLogisticsNo(o.getShippingCode());
                    relateBillInfoVO.setDeliveryWay(o.getShippingType());
                    relateBillInfoVO.setWmsNo(o.getWmsOrderNo());
                    if (o.getEstimatedTime() != null) {
                        relateBillInfoVO.setExpectedArriveTime(DateUtil.format((Date)o.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                }
                return relateBillInfoVO;
            }).collect(Collectors.toList());
            vo.setRelateBillInfoList(list);
        }
    }

    @Override
    public RestResponse<PageInfo<DeliveryResultOrderVO>> getDeliveryResultOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetDeliveryResultOrderListPageParams getDeliveryResultOrderListPageParams) {
        PageInfo respDtoPageInfo = new PageInfo();
        PageInfo pageInfo = new PageInfo();
        if (!this.esQuery.booleanValue()) {
            DeliveryResultOrderReqDto deliveryResultOrderReqDto = new DeliveryResultOrderReqDto();
            BeanUtil.copyProperties((Object)getDeliveryResultOrderListPageParams, (Object)deliveryResultOrderReqDto, (boolean)false);
            deliveryResultOrderReqDto.setOrderNo(getDeliveryResultOrderListPageParams.getDocumentNo());
            deliveryResultOrderReqDto.setBusinessTypeList(getDeliveryResultOrderListPageParams.getBusinessTypeList());
            deliveryResultOrderReqDto.setWarehouseName(getDeliveryResultOrderListPageParams.getDeliveryLogicalWarehouseName());
            deliveryResultOrderReqDto.setReceiveWarehouseName(getDeliveryResultOrderListPageParams.getReceiveLogicalWarehouseName());
            deliveryResultOrderReqDto.setOrderStatus(getDeliveryResultOrderListPageParams.getDocumentStatus());
            deliveryResultOrderReqDto.setOrderType("delivery");
            deliveryResultOrderReqDto.setPageNum(getDeliveryResultOrderListPageParams.getPageNum());
            deliveryResultOrderReqDto.setPageSize(getDeliveryResultOrderListPageParams.getPageSize());
            respDtoPageInfo = (PageInfo)this.deliveryResultOrderQueryApi.queryByPage(deliveryResultOrderReqDto).getData();
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse();
            }
        } else {
            EsDeliveryResultOrderListPageParams pageQueryDto = new EsDeliveryResultOrderListPageParams();
            BeanUtils.copyProperties((Object)getDeliveryResultOrderListPageParams, (Object)pageQueryDto);
            PageInfo esDeliveryResultOrderVOPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esDeliveryResultOrderQueryApi.queryDeliveryResultOrderPage(pageQueryDto));
            CubeBeanUtils.copyProperties((Object)esDeliveryResultOrderVOPageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse();
            }
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(p -> {
            DeliveryResultOrderVO vo = new DeliveryResultOrderVO();
            BeanUtils.copyProperties((Object)p, (Object)vo);
            vo.setNoticeNo(p.getNoticeNo());
            vo.setDocumentNo(p.getDocumentNo());
            vo.setBusinessType(p.getBusinessType());
            vo.setDocumentStatus(p.getOrderStatus());
            vo.setTotalQuantity(p.getTotalQuantity());
            vo.setTotalSku(p.getTotalSku());
            vo.setTotalBoxesNum(p.getTotalCartons() == null ? new BigDecimal(0) : p.getTotalCartons());
            vo.setMixBoxesNum(p.getMergeQuantity() == null ? new BigDecimal(0) : p.getMergeQuantity());
            vo.setWmsNo(p.getWmsOrderNo());
            vo.setPreOrderNo(p.getPreOrderNo());
            vo.setExternalOrderNo(p.getExternalOrderNo());
            vo.setBusinessOrderNo(p.getRelevanceNo());
            vo.setCreateTime(DateUtil.format((Date)p.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setDeliveryLogicalWarehouseName(p.getDeliveryLogicWarehouseName());
            vo.setDeliveryLogicalWarehouseCode(p.getDeliveryLogicWarehouseCode());
            vo.setReceiveLogicalWarehouseName(p.getReceiveLogicWarehouseName());
            vo.setReceiveLogicalWarehouseCode(p.getReceiveLogicWarehouseCode());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)p.getBizDate()) ? DateUtil.format((Date)p.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }
}

